/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressPanel {
    private static final int MINIMUM_DEFAULT_SIZE = 400;
    private Component _component;
    private String _message;
    private Component _messageComponent;
    private JProgressBar _progressBar;
    private String _note;
    private JLabel _noteLabel;
    private Component _southContent;

    public ProgressPanel(Object object, String string) {
        if (object instanceof Component) {
            this._messageComponent = (Component)object;
        } else {
            this.setMessage((String)object);
        }
        this.setNote(string);
    }

    public Component getGUI() {
        if (this._component == null) {
            this._component = this.createComponent();
        }
        return this._component;
    }

    public void setNote(String string) {
        String string2 = this._note = string != null && string.equals("") ? " " : string;
        if (this._noteLabel != null) {
            this._noteLabel.setText(this._note);
        }
    }

    public String getNote() {
        return this._note;
    }

    public void setMessage(String string) {
        String string2 = this._message = string == null || string.equals("") ? " " : string;
        if (this._messageComponent instanceof JLabel) {
            ((JLabel)this._messageComponent).setText(this._message);
        }
    }

    public void setSouthContent(Component component) {
        this._southContent = component;
    }

    public Component getSouthContent() {
        return this._southContent;
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this._progressBar = jProgressBar;
    }

    public JProgressBar getProgressBar() {
        return this._progressBar;
    }

    private Component createComponent() {
        if (this._progressBar != null) {
            Dimension dimension = new Dimension(350, this._progressBar.getPreferredSize().height);
            this._progressBar.setPreferredSize(dimension);
        }
        this._noteLabel = new JLabel(this._note == null ? "" : this._note);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        if (this._messageComponent == null) {
            this._messageComponent = new JLabel(this._message == null ? "" : this._message);
        }
        int n = 400;
        if (this._messageComponent != null) {
            jPanel.add(this._messageComponent, gridBagConstraints);
            n = Math.max(n, this._messageComponent.getPreferredSize().width);
        }
        if (this._progressBar != null) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this._progressBar, gridBagConstraints);
            n = Math.max(n, this._progressBar.getPreferredSize().width);
        }
        if (this._noteLabel != null) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this._noteLabel, gridBagConstraints);
            n = Math.max(n, this._noteLabel.getPreferredSize().width);
        }
        if (this._southContent != null) {
            ++gridBagConstraints.gridy;
            jPanel.add(this._southContent, gridBagConstraints);
            n = Math.max(n, this._southContent.getPreferredSize().width);
        }
        if (this._progressBar != null) {
            Dimension dimension = new Dimension(n, this._progressBar.getPreferredSize().height);
            this._progressBar.setPreferredSize(dimension);
            this._progressBar.setMaximumSize(dimension);
        }
        if (this._noteLabel != null) {
            Dimension dimension = new Dimension(n, this._noteLabel.getPreferredSize().height);
            this._noteLabel.setPreferredSize(dimension);
            this._noteLabel.setMaximumSize(dimension);
        }
        return jPanel;
    }
}

