/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;

public class DndUtils {
    public static final DataFlavor FLAVOR_TRIGGER_EVENT = TransferUtils.createLocalJvmFlavor(InputEvent.class);

    public static void addTriggerEvent(AugmentableTransferable augmentableTransferable, InputEvent inputEvent) {
        augmentableTransferable.augment(TransferUtils.createDataInfo(FLAVOR_TRIGGER_EVENT, inputEvent, 0.0f, null));
    }

    public static InputEvent getTriggerEvent(Transferable transferable) {
        return (InputEvent)TransferUtils.getDataIfAvailable(transferable, FLAVOR_TRIGGER_EVENT, InputEvent.class);
    }

    public static Transferable getTransferable(DropTargetEvent dropTargetEvent) {
        DropTargetDropEvent dropTargetDropEvent = dropTargetEvent instanceof DropTargetDropEvent ? (DropTargetDropEvent)dropTargetEvent : new DropTargetDropEvent(dropTargetEvent.getDropTargetContext(), new Point(0, 0), 1, 1);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable == null) {
            throw new IllegalStateException("null transferable for " + dropTargetEvent);
        }
        ExtendedTransferable extendedTransferable = ExtendedTransferable.getExtendedTransferable(transferable);
        if (extendedTransferable != null) {
            return extendedTransferable;
        }
        return transferable;
    }

    public static boolean isDataFlavorSupported(DropTargetEvent dropTargetEvent, DataFlavor dataFlavor) {
        if (dropTargetEvent instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(dataFlavor);
        }
        if (dropTargetEvent instanceof DropTargetDropEvent) {
            return ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(dataFlavor);
        }
        return false;
    }

    private DndUtils() {
    }
}

