/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.TextAction;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.SmartIndentProvider;

public abstract class BasicAction
extends TextAction {
    private static final int MESSAGE_DELAY = 3000;
    private static final String LAST_ACTION = "*last-action-executed*";
    private static String spacesCache = "                ";
    private static String tabsCache = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public BasicAction(String string) {
        super(string);
    }

    public abstract void actionPerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3);

    public void actionPerformed(ActionEvent actionEvent) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getTextComponent(actionEvent);
        if (basicEditorPane != null) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            basicDocument.readLock();
            try {
                try {
                    this.actionPerformed(actionEvent, basicEditorPane, basicDocument);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Warning, runtime exception caught: " + runtimeException);
                    runtimeException.printStackTrace();
                }
            }
            finally {
                basicDocument.readUnlock();
            }
            this.setLastAction(basicEditorPane, this);
        }
    }

    protected final String getName() {
        return this.getValue("Name").toString();
    }

    public final BasicAction getLastAction(BasicEditorPane basicEditorPane) {
        Object object = basicEditorPane.getProperty(LAST_ACTION);
        return object == null ? null : (BasicAction)object;
    }

    private void setLastAction(BasicEditorPane basicEditorPane, BasicAction basicAction) {
        basicEditorPane.putProperty(LAST_ACTION, basicAction);
    }

    public static Point getMagicCaretPosition(BasicEditorPane basicEditorPane) throws BadLocationException {
        Caret caret = basicEditorPane.getCaret();
        int n = caret.getDot();
        Point point = caret.getMagicCaretPosition();
        if (point == null) {
            Rectangle rectangle = basicEditorPane.modelToView(n);
            point = new Point(rectangle.x, rectangle.y);
        }
        return point;
    }

    public static void setMagicCaretPosition(BasicEditorPane basicEditorPane, Point point) {
        Caret caret = basicEditorPane.getCaret();
        caret.setMagicCaretPosition(point);
    }

    public static boolean isEditable(BasicEditorPane basicEditorPane, boolean bl) {
        if (basicEditorPane.isEditable() && basicEditorPane.isEnabled()) {
            return true;
        }
        if (bl) {
            BasicAction.beep(basicEditorPane);
        }
        return false;
    }

    public static void beep(BasicEditorPane basicEditorPane) {
        basicEditorPane.getToolkit().beep();
    }

    public static int getFontHeight(BasicEditorPane basicEditorPane) {
        Font font = basicEditorPane.getFont();
        FontMetrics fontMetrics = basicEditorPane.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        return n;
    }

    public static Rectangle getVisibleRect(BasicEditorPane basicEditorPane) {
        Rectangle rectangle = new Rectangle();
        basicEditorPane.computeVisibleRect(rectangle);
        return rectangle;
    }

    public static void showMessage(BasicEditorPane basicEditorPane, String string) {
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(basicEditorPane, string, 3000);
        }
    }

    public static int getIndentSizeProperty(BasicEditorPane basicEditorPane) {
        Integer n = (Integer)basicEditorPane.getProperty("indent-size");
        return n;
    }

    public static int getTabSizeProperty(BasicEditorPane basicEditorPane) {
        Integer n = (Integer)basicEditorPane.getProperty("tab-size");
        return n;
    }

    public static boolean getUseAutoIndentProperty(BasicEditorPane basicEditorPane) {
        Boolean bl = (Boolean)basicEditorPane.getProperty("use-auto-indent");
        return bl;
    }

    public static SmartIndentProvider getSmartIndentProvider(BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
        boolean bl;
        SmartIndentProvider smartIndentProvider;
        LanguageSupport languageSupport = basicDocument.getLanguageSupport();
        if (languageSupport != null && (smartIndentProvider = languageSupport.getSmartIndentProvider()) != null && (bl = smartIndentProvider.isSmartIndentEnabled(basicEditorPane))) {
            return smartIndentProvider;
        }
        return null;
    }

    public static boolean getUseTabsProperty(BasicEditorPane basicEditorPane) {
        Boolean bl = (Boolean)basicEditorPane.getProperty("use-tabs");
        return bl;
    }

    public static String getTab(boolean bl, int n) {
        String string = bl ? "\t" : BasicAction.getSpaces(n);
        return string;
    }

    public static String buildIndent(boolean bl, int n, int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (!bl) {
            return BasicAction.getSpaces(n2);
        }
        int n3 = n2 / n;
        int n4 = n2 % n;
        return BasicAction.getTabs(n3) + BasicAction.getSpaces(n4);
    }

    public static int skipLeadingIndent(TextBuffer textBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = textBuffer.getChar(n3);
            if (!Character.isWhitespace(c)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpaces(int n) {
        String string = LAST_ACTION;
        synchronized (LAST_ACTION) {
            while (spacesCache.length() < n) {
                spacesCache = spacesCache + spacesCache;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return spacesCache.substring(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTabs(int n) {
        String string = LAST_ACTION;
        synchronized (LAST_ACTION) {
            while (tabsCache.length() < n) {
                tabsCache = tabsCache + tabsCache;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tabsCache.substring(0, n);
        }
    }

    static boolean makeEditable(BasicEditorPane basicEditorPane) {
        return basicEditorPane.makeEditable();
    }
}

