/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.resource.BundleHelper;

public class BasicCaret
extends DefaultCaret
implements TextBufferListener,
PropertyChangeListener {
    public static final int CARET_VERTICAL_BAR = 1;
    public static final int CARET_DOUBLE_VERTICAL_BAR = 2;
    public static final int CARET_TRIPLE_VERTICAL_BAR = 7;
    public static final int CARET_QUAD_VERTICAL_BAR = 8;
    public static final int CARET_UNDER_BAR = 3;
    public static final int CARET_DOUBLE_UNDER_BAR = 4;
    public static final int CARET_TRIPLE_UNDER_BAR = 9;
    public static final int CARET_QUAD_UNDER_BAR = 10;
    public static final int CARET_OUTLINE_BOX = 5;
    public static final int CARET_SOLID_BOX = 6;
    public static final String CARET_SHAPE_INSERT = "caret-shape-insert";
    public static final String CARET_SHAPE_OVERWRITE = "caret-shape-overwrite";
    public static final String CARET_ENABLE_BLINK = "caret-enable-blink";
    public static final String CARET_BLINK_RATE = "caret-blink-rate";
    public static final String CARET_COLOR = "caret-color";
    public static final String CARET_XOR_PAINTING = "caret-xor-painting";
    public static final String CARET_RIGHT_CLICK_SELECTION = "caret-right-click-selection";
    protected int lastClickCount;
    protected int lastClickOffset;
    private boolean inInsertMode;
    private int fontHeight;
    private int fontWidth;
    private Scroller scroller;
    private HighlightedText selectionHighlight;
    private HighlightLayer selectionLayer;
    private static HighlightStyle caretStyle;
    public static final String HIGHLIGHT_SELECTION_NAME = "highlight-selection";
    private int savedDot;
    private Rectangle savedRect;

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("ACTIVE_SELECTION_HIGHLIGHT");
        caretStyle = highlightRegistry.createStyle(HIGHLIGHT_SELECTION_NAME, string, 100, Color.white, Color.blue);
    }

    public BasicCaret() {
        this.$init$();
        this.inInsertMode = true;
        this.fontWidth = -1;
        this.scroller = new Scroller(null);
    }

    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        BasicEditorPane basicEditorPane = (BasicEditorPane)jTextComponent;
        basicEditorPane.addPropertyChangeListener(this);
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        if (basicDocument != null) {
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.addTextBufferListener(this);
        }
    }

    public void deinstall(JTextComponent jTextComponent) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)jTextComponent;
        basicEditorPane.removePropertyChangeListener(this);
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        if (basicDocument != null) {
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.removeTextBufferListener(this);
        }
        if (this.selectionLayer != null) {
            basicEditorPane.destroyHighlightLayer(this.selectionLayer);
            this.selectionLayer = null;
            this.selectionHighlight = null;
        }
        super.deinstall(jTextComponent);
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (this.getEditorPane().hasFocus()) {
            Scroller.mav$adjustVisibility(this.scroller, rectangle);
        }
    }

    public void setDot(int n) {
        int n2 = this.getDot();
        int n3 = this.getMark();
        this.setMagicCaretPosition(null);
        super.setDot(n);
        if (n2 == n && n2 != n3) {
            this.fireStateChanged();
        }
    }

    public void moveDot(int n) {
        this.setMagicCaretPosition(null);
        super.moveDot(n);
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n2 = this.getMark();
        EmacsAction.setMark(basicEditorPane, n2);
    }

    protected void fireStateChanged() {
        this.updateSelectionHighlight();
        super.fireStateChanged();
    }

    private void updateSelectionHighlight() {
        int n;
        int n2 = this.getDot();
        if (n2 == (n = this.getMark()) && this.selectionHighlight != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            highlightLayer.removeHighlight(this.selectionHighlight);
            this.selectionHighlight = null;
        }
        if (n2 != n) {
            int n3 = Math.min(n2, n);
            int n4 = Math.max(n2, n);
            HighlightLayer highlightLayer = this.getHighlightLayer();
            if (this.selectionHighlight != null) {
                highlightLayer.changeHighlight(this.selectionHighlight, caretStyle, n3, n4);
            } else {
                this.selectionHighlight = highlightLayer.addHighlight(caretStyle, n3, n4);
            }
        }
    }

    public ActionInvoker getActionInvoker() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getActionInvoker();
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        int n = this.getOffsetForMouseEvent(mouseEvent);
        if (n >= 0) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            basicEditorPane.beginNavigation();
            this.moveDot(n);
            basicEditorPane.endNavigation();
            int n2 = this.getMark();
            EmacsAction.setMark(basicEditorPane, n2);
        }
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        int n = this.getOffsetForMouseEvent(mouseEvent);
        if (n >= 0) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            basicEditorPane.beginNavigation();
            this.setDot(n);
            basicEditorPane.endNavigation();
        }
    }

    protected void adjustCaretPosition(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    protected int getOffsetForMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        JTextComponent jTextComponent = this.getComponent();
        int n = jTextComponent.getUI().viewToModel(jTextComponent, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0 && (bl = this.getInsertMode())) {
            n = this.adjustInsertOffset(n, point, biasArray[0]);
        }
        return n;
    }

    protected boolean isPressInSelection(MouseEvent mouseEvent) {
        Point point;
        int n = this.getDot();
        int n2 = this.getMark();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = 5;
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n6 = basicEditorPane.viewToModel(point = mouseEvent.getPoint());
        if (n3 <= n6 && n6 < n4) {
            return true;
        }
        Point[] pointArray = null;
        if (n6 < n3) {
            pointArray = new Point[]{new Point(point.x + n5, point.y), new Point(point.x + n5, point.y + n5), new Point(point.x, point.y + n5), new Point(point.x - n5, point.y + n5)};
        } else if (n6 >= n4) {
            pointArray = new Point[]{new Point(point.x - n5, point.y), new Point(point.x - n5, point.y - n5), new Point(point.x, point.y - n5), new Point(point.x + n5, point.y - n5)};
        }
        int n7 = pointArray != null ? pointArray.length : 0;
        int n8 = 0;
        while (n8 < n7) {
            int n9 = basicEditorPane.viewToModel((Point)pointArray[n8]);
            if (n3 <= n9 && n9 < n4) {
                return true;
            }
            ++n8;
        }
        return false;
    }

    private boolean isPointInPaddedRect(Point point, Rectangle rectangle, int n, int n2) {
        rectangle.x -= n;
        rectangle.width += n * 2;
        rectangle.y -= n2;
        rectangle.height += n2 * 2;
        if (rectangle.x < 0) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.height += rectangle.y;
            rectangle.y = 0;
        }
        return rectangle.contains(point);
    }

    private int adjustInsertOffset(int n, Point point, Position.Bias bias) {
        if (n < 0) {
            return n;
        }
        JTextComponent jTextComponent = this.getComponent();
        Document document = jTextComponent.getDocument();
        int n2 = document.getLength();
        if (n < n2 - 1) {
            try {
                int n3;
                int n4;
                int n5;
                Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, n, bias);
                Rectangle rectangle2 = jTextComponent.getUI().modelToView(jTextComponent, n + 1, bias);
                if (rectangle.y == rectangle2.y && (n5 = (n4 = (int)point.getX()) - rectangle.x) > (n3 = rectangle2.x - n4)) {
                    ++n;
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println("Exception: " + badLocationException.toString());
            }
        }
        return n;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        this.updateMetrics();
        if (rectangle != null) {
            this.x = rectangle.x - 4;
            this.y = rectangle.y;
            this.updateCaretSize();
            this.repaint();
        }
    }

    private void updateCaretSize() {
        this.width = this.fontWidth * 2 + 8;
        this.height = this.fontHeight;
    }

    public void paint(Graphics graphics) {
        this.updateMetrics();
        if (!this.isVisible()) {
            return;
        }
        BasicEditorPane basicEditorPane = this.getEditorPane();
        boolean bl = this.getInsertMode();
        String string = bl ? CARET_SHAPE_INSERT : CARET_SHAPE_OVERWRITE;
        int n = basicEditorPane.getIntegerProperty(string);
        try {
            TextBuffer textBuffer;
            char c;
            int n2;
            TextUI textUI = basicEditorPane.getUI();
            int n3 = this.getDot();
            Rectangle rectangle = textUI.modelToView(basicEditorPane, n3);
            Color color = (Color)basicEditorPane.getProperty(CARET_COLOR);
            if (color == null) {
                color = basicEditorPane.getCaretColor();
            }
            FontMetrics fontMetrics = null;
            Font font = null;
            Color color2 = null;
            FontHelper fontHelper = basicEditorPane.getFontHelper();
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            DocumentRenderer documentRenderer = basicDocument.getDocumentRenderer();
            int n4 = basicEditorPane.getLineFromOffset(n3);
            StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n4, n4);
            int n5 = styledFragmentsList.size();
            int n6 = 0;
            while (n6 < n5) {
                StyledFragment styledFragment = styledFragmentsList.get(n6);
                if (styledFragment.startOffset <= n3 && n3 < styledFragment.endOffset) {
                    StyleRegistry styleRegistry = basicEditorPane.getStyleRegistry();
                    BaseStyle baseStyle = styleRegistry.lookupStyle(styledFragment.styleName);
                    int n7 = baseStyle.getFontStyle();
                    font = fontHelper.getFont(n7);
                    fontMetrics = fontHelper.getFontMetrics(n7, (Component)basicEditorPane);
                    color2 = baseStyle.getBackgroundColor();
                    break;
                }
                ++n6;
            }
            if (fontMetrics == null || font == null) {
                font = fontHelper.getFont(0);
                fontMetrics = fontHelper.getFontMetrics(0, (Component)basicEditorPane);
            }
            if (color2 == null) {
                color2 = basicEditorPane.getBackground();
            }
            if (styledFragmentsList != null) {
                styledFragmentsList.clear();
                documentRenderer.recycleFragmentsList(styledFragmentsList);
            }
            if ((n2 = fontMetrics.charWidth(c = n3 < (textBuffer = basicDocument.getTextBuffer()).getLength() ? (char)textBuffer.getChar(n3) : (char)'\n')) == 0) {
                n2 = this.fontWidth;
            }
            int n8 = fontMetrics.getAscent();
            int n9 = fontMetrics.getDescent();
            int n10 = rectangle.y + n8 + n9 - 1;
            graphics.setColor(color);
            boolean bl2 = basicEditorPane.getBooleanProperty(CARET_XOR_PAINTING);
            if (bl2) {
                graphics.setXORMode(color2);
            }
            boolean bl3 = basicEditorPane.getBooleanProperty("editor-antialiasing");
            switch (n) {
                case 1: {
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + this.fontHeight - 1);
                    break;
                }
                case 2: {
                    graphics.fillRect(rectangle.x, rectangle.y, 2, this.fontHeight - 1);
                    break;
                }
                case 7: {
                    graphics.fillRect(rectangle.x, rectangle.y, 3, this.fontHeight - 1);
                    break;
                }
                case 8: {
                    graphics.fillRect(rectangle.x, rectangle.y, 4, this.fontHeight - 1);
                    break;
                }
                case 3: {
                    graphics.drawLine(rectangle.x, n10, rectangle.x + n2, n10);
                    break;
                }
                case 4: {
                    graphics.fillRect(rectangle.x, n10 - 1, n2, 2);
                    break;
                }
                case 9: {
                    graphics.fillRect(rectangle.x, n10 - 2, n2, 3);
                    break;
                }
                case 10: {
                    graphics.fillRect(rectangle.x, n10 - 3, n2, 4);
                    break;
                }
                case 5: {
                    graphics.drawRect(rectangle.x, rectangle.y, n2, this.fontHeight - 1);
                    break;
                }
                case 6: {
                    graphics.fillRect(rectangle.x, rectangle.y, n2, this.fontHeight - 1);
                    if (bl2 || Character.isWhitespace(c)) break;
                    graphics.setColor(color2);
                    graphics.setFont(font);
                    Object object = null;
                    Graphics2D graphics2D = null;
                    if (bl3 && graphics2D instanceof Graphics2D && (graphics2D = (Graphics2D)graphics) != null) {
                        object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    graphics.drawString("" + c, rectangle.x, rectangle.y + n8);
                    if (graphics2D == null || object == null) break;
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
            }
            if (bl2) {
                graphics.setPaintMode();
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    public boolean getInsertMode() {
        return this.inInsertMode;
    }

    public void setInsertMode(boolean bl) {
        boolean bl2 = bl != this.inInsertMode;
        this.inInsertMode = bl;
        if (bl2) {
            this.updateCaretSize();
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void toggleInsertMode() {
        this.setInsertMode(this.inInsertMode ^ true);
    }

    private void updateMetrics() {
        JTextComponent jTextComponent;
        Font font;
        if (this.fontWidth == -1 && (font = (jTextComponent = this.getComponent()).getFont()) != null) {
            FontMetrics fontMetrics = jTextComponent.getFontMetrics(font);
            this.fontWidth = fontMetrics.charWidth('m');
            this.fontHeight = fontMetrics.getHeight();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Toolkit toolkit;
        Clipboard clipboard;
        BasicEditorPane basicEditorPane;
        if (SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && (basicEditorPane = this.getEditorPane()) != null && (clipboard = (toolkit = basicEditorPane.getToolkit()).getSystemSelection()) != null) {
            this.adjustCaretPosition(mouseEvent);
            basicEditorPane.pasteFromClipboard(toolkit, clipboard);
        }
    }

    void $init$() {
        this.lastClickCount = 0;
        this.lastClickOffset = 0;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.lastClickCount == 2) {
                int n = this.getOffsetForMouseEvent(mouseEvent);
                BasicEditorPane basicEditorPane = this.getEditorPane();
                BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
                n = Math.max(0, n);
                n = Math.min(n, basicDocument.getLength());
                int n2 = Math.min(n, this.lastClickOffset);
                int n3 = Math.max(n, this.lastClickOffset);
                int n4 = Utilities.getWordStart(basicDocument, n2);
                int n5 = Utilities.getWordEnd(basicDocument, n3);
                boolean bl = n > this.lastClickOffset;
                int n6 = bl ? n4 : n5;
                int n7 = bl ? n5 : n4;
                this.setDot(n6);
                this.moveDot(n7);
            } else if (this.lastClickCount == 3) {
                int n;
                int n8;
                int n9 = this.getOffsetForMouseEvent(mouseEvent);
                BasicEditorPane basicEditorPane = this.getEditorPane();
                BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
                n9 = Math.max(0, n9);
                n9 = Math.min(n9, basicDocument.getLength());
                int n10 = Math.min(n9, this.lastClickOffset);
                int n11 = Math.max(n9, this.lastClickOffset);
                try {
                    Rectangle rectangle = basicEditorPane.modelToView(n10);
                    Point point = new Point(0, rectangle.y);
                    n8 = basicEditorPane.viewToModel(point);
                    Rectangle rectangle2 = basicEditorPane.modelToView(n11);
                    Point point2 = new Point(0, rectangle2.y + this.fontHeight);
                    n = basicEditorPane.viewToModel(point2);
                }
                catch (BadLocationException badLocationException) {
                    n8 = n10;
                    n = n11;
                }
                boolean bl = n9 > this.lastClickOffset;
                int n12 = bl ? n8 : n;
                int n13 = bl ? n : n8;
                this.setDot(n12);
                this.moveDot(n13);
            } else {
                int n = this.getOffsetForMouseEvent(mouseEvent);
                this.moveDot(n);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastClickCount = (mouseEvent.getClickCount() - 1) % 3 + 1;
            if (this.lastClickCount == 1) {
                this.adjustCaretPosition(mouseEvent);
                JTextComponent jTextComponent = this.getComponent();
                if (jTextComponent != null && !jTextComponent.hasFocus() && jTextComponent.isEnabled()) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    jTextComponent.requestFocus();
                }
                this.lastClickOffset = this.getDot();
            } else if (this.lastClickCount == 2) {
                this.getActionInvoker().invokeAction("select-word");
            } else if (this.lastClickCount == 3) {
                this.getActionInvoker().invokeAction("select-line");
            }
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n;
            BasicEditorPane basicEditorPane = this.getEditorPane();
            int n2 = this.getDot();
            if (n2 == (n = this.getMark())) {
                this.positionCaret(mouseEvent);
            } else if (basicEditorPane.getBooleanProperty(CARET_RIGHT_CLICK_SELECTION) && !this.isPressInSelection(mouseEvent)) {
                this.positionCaret(mouseEvent);
            }
            if (basicEditorPane != null && basicEditorPane.isEnabled()) {
                basicEditorPane.requestFocus();
            }
        }
        this.checkIsPopupTrigger(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.checkIsPopupTrigger(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastClickCount = 0;
        }
    }

    private void checkIsPopupTrigger(MouseEvent mouseEvent) {
        BasicEditorPane basicEditorPane;
        PopupManager popupManager;
        if (mouseEvent.isPopupTrigger() && (popupManager = (basicEditorPane = this.getEditorPane()).getPopupManager()) != null) {
            popupManager.showPopup(basicEditorPane, mouseEvent);
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.selectionLayer == null) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            this.selectionLayer = basicEditorPane.createHighlightLayer();
        }
        return this.selectionLayer;
    }

    private BasicEditorPane getEditorPane() {
        return (BasicEditorPane)this.getComponent();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editor-font")) {
            this.fontWidth = -1;
            this.updateMetrics();
            this.repaint();
        } else if (string.equals(CARET_ENABLE_BLINK) || string.equals(CARET_BLINK_RATE)) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            boolean bl = basicEditorPane.getBooleanProperty(CARET_ENABLE_BLINK);
            int n = bl ? basicEditorPane.getIntegerProperty(CARET_BLINK_RATE) : 0;
            this.setBlinkRate(n);
        } else if (string.equals(CARET_SHAPE_INSERT) || string.equals(CARET_SHAPE_OVERWRITE) || string.equals(CARET_COLOR)) {
            this.repaint();
        } else if (string.equals("document")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof BasicDocument) {
                BasicDocument basicDocument = (BasicDocument)object2;
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                textBuffer.removeTextBufferListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof BasicDocument) {
                BasicDocument basicDocument = (BasicDocument)object;
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                textBuffer.addTextBufferListener(this);
            }
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        switch (n) {
            case 3: {
                this.savedDot = this.getDot();
                if (!SwingUtilities.isEventDispatchThread()) break;
                try {
                    this.savedRect = new Rectangle();
                    basicEditorPane.computeVisibleRect(this.savedRect);
                }
                catch (Exception exception) {
                    this.savedRect = null;
                }
                break;
            }
            case 4: {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (this.savedRect != null) {
                        basicEditorPane.scrollRectToVisible(this.savedRect);
                    }
                    this.savedRect = null;
                }
                BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
                int n2 = basicDocument.getLength();
                this.savedDot = Math.min(this.savedDot, n2);
                this.setDot(this.savedDot);
                break;
            }
        }
    }

    protected Rectangle getCaretInsets(Rectangle rectangle) {
        if (this.useJumpScrolling()) {
            return rectangle;
        }
        this.updateMetrics();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = this.fontWidth > 0 ? this.fontWidth : 10;
        int n2 = this.fontHeight > 0 ? this.fontHeight : 15;
        int n3 = n * this.getColumnInsets();
        int n4 = n2 * this.getRowInsets();
        rectangle2.x -= n3;
        rectangle2.y -= n4;
        rectangle2.width += n3 * 2;
        rectangle2.height += n4 * 2;
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n5 = basicEditorPane.getHeight();
        int n6 = basicEditorPane.getWidth();
        rectangle2.x = Math.max(rectangle2.x, 0);
        rectangle2.y = Math.max(rectangle2.y, 0);
        rectangle2.width = Math.min(rectangle2.width, n6 - rectangle2.x);
        rectangle2.height = Math.min(rectangle2.height, n5 - rectangle2.y);
        return rectangle2;
    }

    private boolean useJumpScrolling() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getBooleanProperty("use-jump-scroll");
    }

    private int getRowInsets() {
        if (this.useJumpScrolling()) {
            return 0;
        }
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getIntegerProperty("caret-inset-rows");
    }

    private int getColumnInsets() {
        if (this.useJumpScrolling()) {
            return 0;
        }
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getIntegerProperty("caret-inset-columns");
    }

    static BasicEditorPane mav$getEditorPane(BasicCaret basicCaret) {
        return basicCaret.getEditorPane();
    }

    static boolean mav$useJumpScrolling(BasicCaret basicCaret) {
        return basicCaret.useJumpScrolling();
    }

    private class Scroller
    implements Runnable {
        private Rectangle rect = null;
        private boolean isScheduled = false;

        private Scroller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustVisibility(Rectangle rectangle) {
            Scroller scroller = this;
            synchronized (scroller) {
                this.rect = rectangle;
                if (!this.isScheduled) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.run();
                    } else {
                        this.isScheduled = true;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Scroller scroller = this;
            synchronized (scroller) {
                this.isScheduled = false;
                BasicEditorPane basicEditorPane = BasicCaret.mav$getEditorPane(BasicCaret.this);
                if (basicEditorPane != null) {
                    if (BasicCaret.mav$useJumpScrolling(BasicCaret.this)) {
                        basicEditorPane.ensureVisibleAndCentered(this.rect);
                    } else {
                        Rectangle rectangle = BasicCaret.this.getCaretInsets(this.rect);
                        basicEditorPane.scrollRectToVisible(rectangle);
                    }
                }
            }
        }

        static void mav$adjustVisibility(Scroller scroller, Rectangle rectangle) {
            scroller.adjustVisibility(rectangle);
        }

        Scroller(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

