/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.SafeArrayList;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;

public class BasicDocument
implements PropertyChangeListener,
TextBufferListener,
Document {
    private Element[] rootElements;
    private TextBuffer textBuffer;
    private HashMap properties;
    private SafeArrayList docListenerList;
    private SafeArrayList undoListenerList;
    private LanguageSupport support;
    private DocumentRenderer renderer;
    private WeakPropertyChangeSupport changeSupport;
    private OffsetMark startComposedMark;
    private OffsetMark endComposedMark;
    private NumberRange composedRange;
    private boolean isComposedTextInput;
    private static final String REUSE_UNDOABLE_EDIT = "reuse-undoable-edit";
    private UndoEvent freeUndoEvent;
    private boolean reuseUndoEvent;
    private static final String REUSE_DOCUMENT_EVENT = "reuse-document-event";
    private DocEvent freeDocEvent;
    private boolean reuseDocEvent;
    public static final String readOnlyPropertyName = "read-only-mode";
    public static final String eolTypePropertyName = "eol-type";
    private SafeArrayList prePostListenerList;

    public BasicDocument() {
        this((TextBuffer)null);
    }

    public BasicDocument(String string) {
        this(string, null);
    }

    public BasicDocument(String string, TextBuffer textBuffer) {
        this(textBuffer);
        this.setLanguageSupport(string);
    }

    public BasicDocument(TextBuffer textBuffer) {
        if (textBuffer == null) {
            textBuffer = TextBufferFactory.createTextBuffer();
        }
        this.textBuffer = textBuffer;
        this.textBuffer.addTextBufferListener(this);
        this.rootElements = new Element[]{new RootElement(null)};
        this.properties = new HashMap(5);
        this.docListenerList = new SafeArrayList();
        this.prePostListenerList = new SafeArrayList();
        this.undoListenerList = new SafeArrayList();
        this.isComposedTextInput = false;
        EditorProperties editorProperties = EditorProperties.getProperties();
        editorProperties.addPropertyChangeListener(this);
        this.changeSupport = new WeakPropertyChangeSupport(this);
        Object object = this.getProperty(REUSE_UNDOABLE_EDIT);
        this.reuseUndoEvent = object == null || object.equals(Boolean.TRUE);
        object = this.getProperty(REUSE_DOCUMENT_EVENT);
        this.reuseDocEvent = object == null || object.equals(Boolean.TRUE);
        this.setLanguageSupport(LanguageModule.createDefaultSupport());
    }

    protected NumberRange getComposedTextRange() {
        if (this.startComposedMark == null) {
            return null;
        }
        int n = this.startComposedMark.getOffset();
        int n2 = this.endComposedMark.getOffset();
        if (this.composedRange == null) {
            this.composedRange = new NumberRange(n, n2);
            return this.composedRange;
        }
        this.composedRange.start = n;
        this.composedRange.end = n2;
        return this.composedRange;
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public void setLanguageSupport(String string) {
        LanguageSupport languageSupport = LanguageModule.createSupportForFileType(string);
        this.setLanguageSupport(languageSupport);
    }

    public void setLanguageSupport(LanguageSupport languageSupport) {
        LanguageSupport languageSupport2 = this.support;
        if (languageSupport2 != null) {
            languageSupport2.deinstall();
        }
        this.renderer = null;
        this.support = languageSupport;
        this.support.install(this);
        this.firePropertyChange("language-support", languageSupport2, languageSupport);
    }

    public LanguageSupport getLanguageSupport() {
        return this.support;
    }

    public DocumentRenderer getDocumentRenderer() {
        if (this.renderer == null) {
            this.renderer = this.getLanguageSupport().getDocumentRenderer();
        }
        return this.renderer;
    }

    public void beginEdit() {
        this.textBuffer.beginEdit();
    }

    public void endEdit() {
        UndoableEdit undoableEdit = this.textBuffer.endEdit();
        this.fireUndoableEditEvent(undoableEdit);
    }

    public void readLock() {
        this.textBuffer.readLock();
    }

    public void readUnlock() {
        this.textBuffer.readUnlock();
    }

    public void writeLock() {
        this.textBuffer.writeLock();
    }

    public void writeUnlock() {
        this.textBuffer.writeUnlock();
    }

    public int getLineCount() {
        int n;
        this.readLock();
        try {
            n = this.getLineMap().getLineCount();
        }
        finally {
            this.readUnlock();
        }
        return n;
    }

    public int getLineFromOffset(int n) {
        int n2;
        this.readLock();
        try {
            n2 = this.getLineMap().getLineFromOffset(n);
        }
        finally {
            this.readUnlock();
        }
        return n2;
    }

    public int getLineStartOffset(int n) {
        int n2;
        this.readLock();
        try {
            n2 = this.getLineMap().getLineStartOffset(n);
        }
        finally {
            this.readUnlock();
        }
        return n2;
    }

    public int getLineEndOffset(int n) {
        int n2;
        this.readLock();
        try {
            n2 = this.getLineMap().getLineEndOffset(n);
        }
        finally {
            this.readUnlock();
        }
        return n2;
    }

    public Element getParagraphElement(int n) {
        return this.rootElements[0];
    }

    public Element getDefaultRootElement() {
        return this.rootElements[0];
    }

    public LineMap getLineMap() {
        return this.textBuffer.getLineMap();
    }

    public int getLength() {
        return this.textBuffer.getLength();
    }

    public void remove(int n, int n2) throws BadLocationException {
        UndoableEdit undoableEdit = this.textBuffer.remove(n, n2);
        this.fireUndoableEditEvent(undoableEdit);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        UndoableEdit undoableEdit = null;
        this.textBuffer.writeLock();
        try {
            if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                this.isComposedTextInput = true;
            }
            undoableEdit = this.textBuffer.insert(n, string.toCharArray());
        }
        finally {
            this.textBuffer.writeUnlock();
        }
        this.fireUndoableEditEvent(undoableEdit);
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.textBuffer.getString(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.textBuffer.getText(n, n2, segment);
    }

    public Position getStartPosition() {
        return new BoundaryPosition(1, null);
    }

    public Position getEndPosition() {
        return new BoundaryPosition(2, null);
    }

    public Position createPosition(int n) throws BadLocationException {
        return new StickyPosition(this.textBuffer, n, null);
    }

    public Element[] getRootElements() {
        return this.rootElements;
    }

    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnlock();
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.docListenerList.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.docListenerList.remove(documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoListenerList.add(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoListenerList.remove(undoableEditListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public Object getProperty(Object object) {
        Object object2 = null;
        object2 = this.properties.get(object);
        if (object2 == null && object != null && object instanceof String) {
            String string = object.toString();
            LanguageSupport languageSupport = this.getLanguageSupport();
            if (languageSupport != null) {
                object2 = languageSupport.getProperty(string);
            }
            if (object2 == null) {
                object2 = EditorProperties.getProperties().getProperty(string);
            }
        }
        return object2;
    }

    public void putProperty(Object object, Object object2) {
        Object object3 = this.properties.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
    }

    protected void fireUndoableEditEvent(UndoableEdit undoableEdit) {
        if (!this.undoListenerList.isEmpty() && undoableEdit != null && undoableEdit.canUndo()) {
            UndoableEditEvent undoableEditEvent = this.allocUndoEvent(undoableEdit);
            for (UndoableEditListener undoableEditListener : this.undoListenerList) {
                undoableEditListener.undoableEditHappened(undoableEditEvent);
            }
            this.freeUndoEvent(undoableEditEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoableEditEvent allocUndoEvent(UndoableEdit undoableEdit) {
        if (this.reuseUndoEvent) {
            UndoEvent undoEvent;
            BasicDocument basicDocument = this;
            synchronized (basicDocument) {
                undoEvent = this.freeUndoEvent;
                this.freeUndoEvent = null;
            }
            if (undoEvent == null) {
                undoEvent = new UndoEvent(null);
            }
            UndoEvent.mav$setEdit(undoEvent, undoableEdit);
            return undoEvent;
        }
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
        return undoableEditEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeUndoEvent(UndoableEditEvent undoableEditEvent) {
        if (this.reuseUndoEvent && undoableEditEvent instanceof UndoEvent) {
            BasicDocument basicDocument = this;
            synchronized (basicDocument) {
                this.freeUndoEvent = (UndoEvent)undoableEditEvent;
                UndoEvent.mav$clear(this.freeUndoEvent);
            }
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        if (this.isComposedTextInput) {
            this.isComposedTextInput = false;
            this.startComposedMark = this.textBuffer.addOffsetMark(n);
            this.endComposedMark = this.textBuffer.addOffsetMark(n + n2);
        }
        if (!this.docListenerList.isEmpty() || !this.prePostListenerList.isEmpty() || this.renderer != null) {
            DocEvent docEvent = this.allocDocEvent(n, n2, cArray, true);
            this.fireEvent(docEvent);
            this.freeDocEvent(docEvent);
        }
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        int n3;
        int n4;
        if (this.isComposedTextInput) {
            throw new IllegalStateException("composed text input in remove");
        }
        if (this.startComposedMark != null && (n4 = this.startComposedMark.getOffset()) == (n3 = this.endComposedMark.getOffset())) {
            this.textBuffer.removeOffsetMark(this.startComposedMark);
            this.textBuffer.removeOffsetMark(this.endComposedMark);
            this.startComposedMark = null;
            this.endComposedMark = null;
        }
        if (!this.docListenerList.isEmpty() || !this.prePostListenerList.isEmpty() || this.renderer != null) {
            DocEvent docEvent = this.allocDocEvent(n, n2, cArray, false);
            this.fireEvent(docEvent);
            this.freeDocEvent(docEvent);
        }
    }

    private void fireEvent(DocEvent docEvent) {
        if (this.renderer != null) {
            try {
                this.renderer.notifyUpdate(docEvent);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        Iterator iterator = this.prePostListenerList.iterator();
        while (iterator.hasNext()) {
            try {
                PrePostDocumentListener prePostDocumentListener = (PrePostDocumentListener)iterator.next();
                prePostDocumentListener.preNotify(docEvent);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        Iterator iterator2 = this.docListenerList.iterator();
        while (iterator2.hasNext()) {
            try {
                DocumentListener documentListener = (DocumentListener)iterator2.next();
                if (DocEvent.ra$isInsert(docEvent)) {
                    documentListener.insertUpdate(docEvent);
                    continue;
                }
                documentListener.removeUpdate(docEvent);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        for (PrePostDocumentListener prePostDocumentListener : this.prePostListenerList) {
            try {
                prePostDocumentListener.postNotify(docEvent);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    private DocEvent allocDocEvent(int n, int n2, char[] cArray, boolean bl) {
        DocEvent docEvent;
        if (this.reuseDocEvent && (docEvent = this.freeDocEvent) != null) {
            this.freeDocEvent = null;
            DocEvent.mav$setValues(docEvent, n, n2, cArray, bl);
            return docEvent;
        }
        DocEvent docEvent2 = new DocEvent(n, n2, cArray, bl, null);
        return docEvent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeDocEvent(DocEvent docEvent) {
        if (this.reuseDocEvent && docEvent instanceof DocEvent) {
            BasicDocument basicDocument = this;
            synchronized (basicDocument) {
                this.freeDocEvent = docEvent;
                DocEvent.mav$clear(this.freeDocEvent);
            }
        }
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        switch (n) {
            case 1: {
                String string = this.textBuffer.getEOLType();
                this.firePropertyChange(eolTypePropertyName, null, string);
                break;
            }
            case 2: {
                Boolean bl = this.textBuffer.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
                this.firePropertyChange(readOnlyPropertyName, null, bl);
                break;
            }
        }
    }

    public void addPrePostDocumentListener(PrePostDocumentListener prePostDocumentListener) {
        this.prePostListenerList.add(prePostDocumentListener);
    }

    public void removePrePostDocumentListener(PrePostDocumentListener prePostDocumentListener) {
        this.prePostListenerList.remove(prePostDocumentListener);
    }

    static TextBuffer ra$textBuffer(BasicDocument basicDocument) {
        return basicDocument.textBuffer;
    }

    private final class UndoEvent
    extends UndoableEditEvent {
        private UndoableEdit undoableEdit;

        private UndoEvent() {
            super(BasicDocument.this, null);
        }

        public UndoableEdit getEdit() {
            return this.undoableEdit;
        }

        private void setEdit(UndoableEdit undoableEdit) {
            this.undoableEdit = undoableEdit;
        }

        private void clear() {
            this.undoableEdit = null;
        }

        static void mav$clear(UndoEvent undoEvent) {
            undoEvent.clear();
        }

        UndoEvent(1 var2_2) {
            this();
        }

        static void mav$setEdit(UndoEvent undoEvent, UndoableEdit undoableEdit) {
            undoEvent.setEdit(undoableEdit);
        }

        public final class 1 {
        }
    }

    private final class DocEvent
    implements BasicDocumentEvent {
        private int offset;
        private int length;
        private char[] data;
        private boolean isInsert;

        private DocEvent(int n, int n2, char[] cArray, boolean bl) {
            this.setValues(n, n2, cArray, bl);
        }

        private void setValues(int n, int n2, char[] cArray, boolean bl) {
            this.offset = n;
            this.length = n2;
            this.data = cArray;
            this.isInsert = bl;
        }

        private void clear() {
            this.offset = 0;
            this.length = 0;
            this.data = null;
            this.isInsert = true;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public Document getDocument() {
            return BasicDocument.this;
        }

        public DocumentEvent.EventType getType() {
            return this.isInsert ? DocumentEvent.EventType.INSERT : DocumentEvent.EventType.REMOVE;
        }

        public char[] getData() {
            return this.data;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return null;
        }

        static void mav$clear(DocEvent docEvent) {
            docEvent.clear();
        }

        static void mav$setValues(DocEvent docEvent, int n, int n2, char[] cArray, boolean bl) {
            docEvent.setValues(n, n2, cArray, bl);
        }

        DocEvent(int n, int n2, char[] cArray, boolean bl, 1 var6_6) {
            this(n, n2, cArray, bl);
        }

        static boolean ra$isInsert(DocEvent docEvent) {
            return docEvent.isInsert;
        }

        public final class 1 {
        }
    }

    private final class BoundaryPosition
    implements Position {
        private static final int START = 1;
        private static final int END = 2;
        private int position;

        private BoundaryPosition(int n) {
            this.position = n;
        }

        public int getOffset() {
            return this.position == 1 ? 0 : BasicDocument.ra$textBuffer(BasicDocument.this).getLength();
        }

        BoundaryPosition(int n, 1 var3_3) {
            this(n);
        }

        public final class 1 {
        }
    }

    private final class RootElement
    implements Element {
        public Document getDocument() {
            return BasicDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "BD.RootElement";
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return BasicDocument.this.getLength();
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        private RootElement() {
        }

        RootElement(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class StickyPosition
    implements Position {
        private OffsetMark offsetMark;
        private TextBuffer textBuffer;

        private StickyPosition(TextBuffer textBuffer, int n) {
            this.textBuffer = textBuffer;
            this.offsetMark = textBuffer.addOffsetMark(n);
        }

        public int getOffset() {
            return this.offsetMark.getOffset();
        }

        protected void finalize() throws Throwable {
            this.textBuffer.removeOffsetMark(this.offsetMark);
            this.offsetMark = null;
            this.textBuffer = null;
        }

        StickyPosition(TextBuffer textBuffer, int n, 1 var3_3) {
            this(textBuffer, n);
        }

        public final class 1 {
        }
    }

    public static interface PrePostDocumentListener
    extends EventListener {
        public void preNotify(DocumentEvent var1);

        public void postNotify(DocumentEvent var1);
    }
}

