/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicView;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.keys.KeyRecorder;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.resource.BundleHelper;

public class BasicEditorKit
extends DefaultEditorKit
implements ViewFactory {
    private static Action[] augmentedActions = null;
    private static ActionMap actionMap = null;
    private static final String MERGE_TYPED_INSERT = "merge-typed-insert";
    private static final String MERGE_TYPED_REPLACE = "merge-typed-replace";
    private static final String MERGE_DELETE_NEXT = "merge-delete-next";
    private static final String MERGE_DELETE_PREVIOUS = "merge-delete-previous";
    private static boolean MAC_OS_X = System.getProperty("os.name").indexOf("Mac OS X") != 1;

    public BasicEditorKit() {
        this.initializeActionMap();
    }

    public String getContentType() {
        return "text/plain";
    }

    public Object clone() {
        return new BasicEditorKit();
    }

    public Caret createCaret() {
        return new BasicCaret();
    }

    public Document createDefaultDocument() {
        return new BasicDocument();
    }

    public final ViewFactory getViewFactory() {
        return this;
    }

    public View create(Element element) {
        return new BasicView(element);
    }

    public Action[] getActions() {
        return augmentedActions;
    }

    private void initializeActionMap() {
        if (actionMap == null) {
            Action[] actionArray = new Action[]{new CutAction(), new CopyAction(), new PasteAction(), new ExtendedPasteAction(), new NOPAction("cancel"), new NOPAction("completion-insight"), new NOPAction("smart-completion-insight"), new NOPAction("tooltip-insight"), new BlockIndentOutdentAction("block-indent", true), new BlockIndentOutdentAction("block-outdent", false), new ConvertSelectionCaseAction("upcase-selection", true), new ConvertSelectionCaseAction("downcase-selection", false), new DefaultKeyTypedAction(), new DeleteLineAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new DeleteUntilEOLAction(), new DeleteNextWordAction("delete-next-word-start", 1), new DeleteNextWordAction("delete-next-word-end", 2), new DeleteNextWordAction("delete-next-word-break", 3), new DeletePreviousWordAction("delete-previous-word-start", 1), new DeletePreviousWordAction("delete-previous-word-end", 2), new DeletePreviousWordAction("delete-previous-word-break", 3), new InsertBreakAction(), new InsertTabAction(), new OpenLineAction(), new ReverseTabAction(), new SortSelectedLines(), new TabifyAction(), new ToggleCommentsAction(), new TransposeCharsAction(), new UntabifyAction(), new BeepAction(), new SetLocalTabSizeAction("set-local-tabsize-2", 2), new SetLocalTabSizeAction("set-local-tabsize-4", 4), new SetLocalTabSizeAction("set-local-tabsize-8", 8), new ReadOnlyAction(), new WritableAction(), new ToggleInsertModeAction(), new MacroRecorderAction("playback-macro", true), new MacroRecorderAction("toggle-macro-recording", false), new GotoMatchingBraceAction("goto-matching-brace", false), new GotoMatchingBraceAction("selection-matching-brace", true), new NOPAction("show-matching-brace"), new PageUpAction("page-up", false), new PageUpAction("selection-page-up", true), new PageDownAction("page-down", false), new PageDownAction("selection-page-down", true), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new UpAction("caret-up", false), new UpAction("selection-up", true), new DownAction("caret-down", false), new DownAction("selection-down", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word-start", 1, false), new PreviousWordAction("caret-previous-word-end", 2, false), new PreviousWordAction("caret-previous-word-break", 3, false), new PreviousWordAction("selection-previous-word-start", 1, true), new PreviousWordAction("selection-previous-word-end", 2, true), new PreviousWordAction("selection-previous-word-break", 3, true), new NextWordAction("caret-next-word-start", 1, false), new NextWordAction("caret-next-word-end", 2, false), new NextWordAction("caret-next-word-break", 3, false), new NextWordAction("selection-next-word-start", 1, true), new NextWordAction("selection-next-word-end", 2, true), new NextWordAction("selection-next-word-break", 3, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new UnselectAction(), new RecenterLineAction(), new ScrollLineUpAction(), new ScrollLineDownAction(), new ScrollPageUpAction(), new ScrollPageDownAction(), new EmacsSetMarkAction(), new EmacsExchangePointMarkAction(), new EmacsBeginAction(), new EmacsEndAction(), new EmacsMarkBufferAction(), new EmacsKillWordAction(), new EmacsBackwardKillWordAction(), new EmacsKillLineAction(), new EmacsKillRegionAction("emacs-kill-region", false), new EmacsKillRegionAction("emacs-kill-ring-save", true), new EmacsAppendNextKillAction(), new EmacsYankAction("emacs-yank", true), new EmacsYankAction("emacs-yank-pop", false), new EmacsCapitalizeWordAction(), new EmacsDowncaseWordAction(), new EmacsUpcaseWordAction(), new EmacsCaseRegionAction("emacs-upcase-region", true), new EmacsCaseRegionAction("emacs-downcase-region", false), new EmacsDeleteHorizontalSpaceAction()};
            Action[] actionArray2 = TextAction.augmentList(super.getActions(), actionArray);
            actionMap = new ActionMap();
            int n = actionArray2.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray2[n2];
                String string = (String)action.getValue("Name");
                actionMap.put(string, action);
                ++n2;
            }
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(actionMap.get("default-typed"));
            n = arrayList.size();
            augmentedActions = new Action[n];
            int n3 = 0;
            while (n3 < n) {
                BasicEditorKit.augmentedActions[n3] = (Action)arrayList.get(n3);
                ++n3;
            }
        }
    }

    public Action findAction(String string) {
        return actionMap.get(string);
    }

    static boolean ra$MAC_OS_X() {
        return MAC_OS_X;
    }

    public static class CutAction
    extends BasicAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            CutAction.makeEditable(basicEditorPane);
            basicEditorPane.cut();
        }
    }

    public static class CopyAction
    extends BasicAction {
        public CopyAction() {
            super("copy-to-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.copy();
        }
    }

    public static class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            PasteAction.makeEditable(basicEditorPane);
            basicEditorPane.paste();
        }
    }

    public static class ExtendedPasteAction
    extends BasicAction {
        public ExtendedPasteAction() {
            super("extended-paste-from-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            if (ClipboardStack.adjustCurrentClipboard()) {
                ExtendedPasteAction.makeEditable(basicEditorPane);
                basicEditorPane.paste();
            }
        }
    }

    public static class NOPAction
    extends BasicAction {
        public NOPAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
        }
    }

    public static class BlockIndentOutdentAction
    extends BasicAction {
        private boolean doIndent;
        private static EditDescriptor indentDescriptor;
        private static EditDescriptor outdentDescriptor;

        protected boolean shouldPerformBlockOperation(BasicEditorPane basicEditorPane) {
            int n;
            int n2 = basicEditorPane.getSelectionStart();
            if (n2 != (n = basicEditorPane.getSelectionEnd())) {
                Boolean bl = (Boolean)basicEditorPane.getProperty("do-block-indents-on-selection");
                boolean bl2 = bl;
                return bl2;
            }
            return false;
        }

        public BlockIndentOutdentAction(String string, boolean bl) {
            super(string);
            this.doIndent = bl;
            if (indentDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_BLOCK_INDENT");
                indentDescriptor = new EditDescriptor(string2);
                String string3 = bundleHelper.getString("UNDO_BLOCK_OUTDENT");
                outdentDescriptor = new EditDescriptor(string3);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            BlockIndentOutdentAction.makeEditable(basicEditorPane);
            if (!BlockIndentOutdentAction.isEditable(basicEditorPane, true)) {
                return;
            }
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            LineMap lineMap = basicDocument.getLineMap();
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            boolean bl = basicEditorPane.getCaretPosition() == n2;
            int n3 = lineMap.getLineFromOffset(n);
            int n4 = lineMap.getLineFromOffset(n2);
            if (n != n2 && n2 == lineMap.getLineStartOffset(n4)) {
                --n4;
            }
            int n5 = BlockIndentOutdentAction.getIndentSizeProperty(basicEditorPane);
            int n6 = BlockIndentOutdentAction.getTabSizeProperty(basicEditorPane);
            boolean bl2 = BlockIndentOutdentAction.getUseTabsProperty(basicEditorPane);
            int n7 = this.doIndent ? n5 : -n5;
            EditDescriptor editDescriptor = this.doIndent ? indentDescriptor : outdentDescriptor;
            basicEditorPane.beginEdit(editDescriptor);
            try {
                Rectangle rectangle = BlockIndentOutdentAction.getVisibleRect(basicEditorPane);
                basicEditorPane.setCaretPosition(0);
                int n8 = n3;
                while (n8 <= n4) {
                    int n9;
                    int n10 = lineMap.getLineStartOffset(n8);
                    int n11 = BlockIndentOutdentAction.skipLeadingIndent(textBuffer, n10, n9 = lineMap.getLineEndOffset(n8));
                    if (n11 == -1) {
                        n11 = n9 == textBuffer.getLength() ? n9 : n9 - 1;
                    }
                    int n12 = Utilities.getColumnFromOffset(textBuffer, n8, n11, n6);
                    int n13 = Math.max(n12 + n7, 0);
                    String string = BlockIndentOutdentAction.buildIndent(bl2, n6, n13);
                    try {
                        basicDocument.remove(n10, n11 - n10);
                        basicDocument.insertString(n10, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ++n8;
                }
                int n14 = lineMap.getLineStartOffset(n3);
                int n15 = lineMap.getLineEndOffset(n4);
                if (bl) {
                    basicEditorPane.setCaretPosition(n14);
                    basicEditorPane.moveCaretPosition(n15);
                } else {
                    basicEditorPane.setCaretPosition(n15);
                    basicEditorPane.moveCaretPosition(n14);
                }
                if (rectangle != null) {
                    basicEditorPane.scrollRectToVisible(rectangle);
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class ConvertSelectionCaseAction
    extends BasicAction {
        private boolean doUpcase;
        private static EditDescriptor upcaseDescriptor;
        private static EditDescriptor downcaseDescriptor;

        public ConvertSelectionCaseAction(String string, boolean bl) {
            super(string);
            this.doUpcase = bl;
            if (upcaseDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_CONVERT_SELECTION_UPCASE");
                upcaseDescriptor = new EditDescriptor(string2);
                String string3 = bundleHelper.getString("UNDO_CONVERT_SELECTION_DOWNCASE");
                downcaseDescriptor = new EditDescriptor(string3);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            ConvertSelectionCaseAction.makeEditable(basicEditorPane);
            if (!ConvertSelectionCaseAction.isEditable(basicEditorPane, true)) {
                return;
            }
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            int n2 = basicEditorPane.getSelectionStart();
            if (n2 == (n = basicEditorPane.getSelectionEnd())) {
                return;
            }
            EditDescriptor editDescriptor = this.doUpcase ? upcaseDescriptor : downcaseDescriptor;
            basicEditorPane.beginEdit(editDescriptor);
            try {
                int n3 = n - n2;
                String string = textBuffer.getString(n2, n3);
                String string2 = this.doUpcase ? string.toUpperCase() : string.toLowerCase();
                int n4 = basicEditorPane.getCaretPosition();
                boolean bl = n4 == n2;
                try {
                    basicDocument.remove(n2, n3);
                    basicDocument.insertString(n2, string2, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (bl) {
                    basicEditorPane.setCaretPosition(n);
                    basicEditorPane.moveCaretPosition(n2);
                } else {
                    basicEditorPane.setCaretPosition(n2);
                    basicEditorPane.moveCaretPosition(n);
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends BasicAction {
        private static EditDescriptor insertDescriptor;
        private static EditDescriptor replaceDescriptor;
        private static EditDescriptor smartDescriptor;
        private static final TextAction originalKeyTypedAction;

        public DefaultKeyTypedAction() {
            super("default-typed");
            if (insertDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_TYPED_INSERT");
                insertDescriptor = new EditDescriptor(string, BasicEditorKit.MERGE_TYPED_INSERT);
                String string2 = bundleHelper.getString("UNDO_TYPED_REPLACE");
                replaceDescriptor = new EditDescriptor(string2, BasicEditorKit.MERGE_TYPED_REPLACE);
                String string3 = bundleHelper.getString("UNDO_SMART_INDENT");
                smartDescriptor = new EditDescriptor(string3);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof BasicEditorPane) {
                super.actionPerformed(actionEvent);
            } else {
                originalKeyTypedAction.actionPerformed(actionEvent);
            }
        }

        static {
            originalKeyTypedAction = new DefaultEditorKit.DefaultKeyTypedAction();
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            char c;
            block20: {
                String string = actionEvent.getActionCommand();
                int n2 = actionEvent.getModifiers();
                if (string == null || string.length() == 0) {
                    return;
                }
                if (BasicEditorKit.ra$MAC_OS_X() ? (n2 & 6) != 0 : (n2 & 8) != (n2 & 2)) {
                    return;
                }
                c = string.charAt(0);
                if (c < ' ' || c == '\u007f') {
                    return;
                }
                DefaultKeyTypedAction.makeEditable(basicEditorPane);
                if (!DefaultKeyTypedAction.isEditable(basicEditorPane, true)) {
                    return;
                }
                n = basicEditorPane.getSelectionStart();
                int n3 = basicEditorPane.getSelectionEnd();
                try {
                    if (n != n3) {
                        basicEditorPane.beginEdit(replaceDescriptor);
                        basicEditorPane.replaceSelection(string);
                        basicEditorPane.endEdit();
                        break block20;
                    }
                    boolean bl = false;
                    Caret caret = basicEditorPane.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        BasicCaret basicCaret = (BasicCaret)caret;
                        boolean bl2 = basicCaret.getInsertMode();
                        bl = bl2 ^ true;
                    }
                    boolean bl3 = false;
                    if (bl && n < basicDocument.getLength() && !basicDocument.getText(n, 1).equals("\n")) {
                        bl3 = true;
                    }
                    EditDescriptor editDescriptor = bl3 ? replaceDescriptor : insertDescriptor;
                    basicEditorPane.beginEdit(editDescriptor);
                    try {
                        if (bl3) {
                            basicDocument.remove(n, 1);
                        }
                        basicDocument.insertString(n, string, null);
                    }
                    finally {
                        basicEditorPane.endEdit();
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalStateException("Error while typing: " + badLocationException);
                }
            }
            SmartIndentProvider smartIndentProvider = DefaultKeyTypedAction.getSmartIndentProvider(basicEditorPane, basicDocument);
            if (smartIndentProvider != null && smartIndentProvider.isAutoReindentTriggerChar(c)) {
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int n4 = lineMap.getLineFromOffset(n);
                int n5 = lineMap.getLineStartOffset(n4);
                int n6 = lineMap.getLineEndOffset(n4);
                int n7 = DefaultKeyTypedAction.getIndentSizeProperty(basicEditorPane);
                int n8 = DefaultKeyTypedAction.getTabSizeProperty(basicEditorPane);
                boolean bl = DefaultKeyTypedAction.getUseTabsProperty(basicEditorPane);
                int n9 = smartIndentProvider.getIndentForLine(n4, n7);
                int n10 = DefaultKeyTypedAction.skipLeadingIndent(textBuffer, n5, n6);
                if (n10 == -1) {
                    int n11 = lineMap.getLineCount() - 1;
                    n10 = n4 == n11 ? n6 : n6 - 1;
                }
                basicEditorPane.beginEdit(smartDescriptor);
                try {
                    try {
                        String string = DefaultKeyTypedAction.buildIndent(bl, n8, n9);
                        basicDocument.remove(n5, n10 - n5);
                        basicDocument.insertString(n5, string, null);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
            basicEditorPane.fireCharacterTypedEvent(n, c);
        }
    }

    public static class DeleteLineAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public DeleteLineAction() {
            super("delete-line");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DELETE_LINE");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            DeleteLineAction.makeEditable(basicEditorPane);
            if (!DeleteLineAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            basicEditorPane.setCaretPosition(n);
            LineMap lineMap = basicDocument.getLineMap();
            int n2 = lineMap.getLineFromOffset(n);
            int n3 = lineMap.getLineStartOffset(n2);
            int n4 = lineMap.getLineEndOffset(n2);
            if (n3 != n4) {
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        basicDocument.remove(n3, n4 - n3);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static class DeleteNextCharAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public DeleteNextCharAction() {
            super("delete-next");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DELETE_NEXT");
                editDescriptor = new EditDescriptor(string, BasicEditorKit.MERGE_DELETE_NEXT);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            boolean bl;
            block12: {
                DeleteNextCharAction.makeEditable(basicEditorPane);
                if (!DeleteNextCharAction.isEditable(basicEditorPane, true)) {
                    return;
                }
                int n = basicEditorPane.getSelectionStart();
                int n2 = basicEditorPane.getSelectionEnd();
                bl = true;
                try {
                    if (n != n2) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicDocument.remove(n, n2 - n);
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                        bl = false;
                        break block12;
                    }
                    if (n >= basicDocument.getLength()) break block12;
                    basicEditorPane.beginEdit(editDescriptor);
                    try {
                        basicDocument.remove(n, 1);
                    }
                    finally {
                        basicEditorPane.endEdit();
                    }
                    bl = false;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                DeleteNextCharAction.beep(basicEditorPane);
            }
        }
    }

    public static class DeletePrevCharAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public DeletePrevCharAction() {
            super("delete-previous");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DELETE_PREVIOUS");
                editDescriptor = new EditDescriptor(string, BasicEditorKit.MERGE_DELETE_PREVIOUS);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            boolean bl;
            block14: {
                DeletePrevCharAction.makeEditable(basicEditorPane);
                if (!DeletePrevCharAction.isEditable(basicEditorPane, true)) {
                    return;
                }
                int n = basicEditorPane.getSelectionStart();
                int n2 = basicEditorPane.getSelectionEnd();
                bl = true;
                try {
                    if (n != n2) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicDocument.remove(n, n2 - n);
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                        bl = false;
                        break block14;
                    }
                    if (n == 0) break block14;
                    TextBuffer textBuffer = basicDocument.getTextBuffer();
                    LineMap lineMap = basicDocument.getLineMap();
                    int n3 = basicEditorPane.getCaretPosition();
                    int n4 = lineMap.getLineFromOffset(n3);
                    int n5 = DeletePrevCharAction.getIndentSizeProperty(basicEditorPane);
                    int n6 = DeletePrevCharAction.getTabSizeProperty(basicEditorPane);
                    boolean bl2 = DeletePrevCharAction.getUseTabsProperty(basicEditorPane);
                    int n7 = lineMap.getLineStartOffset(n4);
                    int n8 = lineMap.getLineEndOffset(n4);
                    int n9 = DeletePrevCharAction.skipLeadingIndent(textBuffer, n7, n8);
                    basicEditorPane.beginEdit(editDescriptor);
                    try {
                        if (n9 != -1 && n9 < n3 || n3 == n7) {
                            basicDocument.remove(n3 - 1, 1);
                            bl = false;
                        } else {
                            int n10 = Utilities.getColumnFromOffset(textBuffer, n4, n3, n6);
                            int n11 = n10 - 1;
                            n11 -= n11 % n5;
                            String string = DeletePrevCharAction.buildIndent(bl2, n6, n11);
                            basicDocument.remove(n7, n3 - n7);
                            basicDocument.insertString(n7, string, null);
                            bl = false;
                        }
                    }
                    finally {
                        basicEditorPane.endEdit();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                DeletePrevCharAction.beep(basicEditorPane);
            }
        }
    }

    public static class DeleteUntilEOLAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public DeleteUntilEOLAction() {
            super("delete-until-eol");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DELETE_UNTIL_EOL");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            DeleteUntilEOLAction.makeEditable(basicEditorPane);
            if (!DeleteUntilEOLAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            int n2 = Utilities.getRowEnd(basicDocument, n);
            if (n2 > n) {
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        basicDocument.remove(n, n2 - n);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static class DeleteNextWordAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public DeleteNextWordAction(String string, int n) {
            super(string);
            this.wordBehavior = n;
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_DELETE_NEXT_WORD");
                editDescriptor = new EditDescriptor(string2);
            }
            if (n != 1 && n != 2 && n != 3) {
                throw new IllegalStateException("invalid word behavior: " + n);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            DeleteNextWordAction.makeEditable(basicEditorPane);
            if (!DeleteNextWordAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n2 = basicEditorPane.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    n = Utilities.getNextWordStart(basicDocument, n2);
                    break;
                }
                case 2: {
                    n = Utilities.getNextWordEnd(basicDocument, n2);
                    break;
                }
                case 3: {
                    n = Math.min(Utilities.getNextWordStart(basicDocument, n2), Utilities.getNextWordEnd(basicDocument, n2));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (n2 != n) {
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        basicDocument.remove(n2, n - n2);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static class DeletePreviousWordAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public DeletePreviousWordAction(String string, int n) {
            super(string);
            this.wordBehavior = n;
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_DELETE_PREVIOUS_WORD");
                editDescriptor = new EditDescriptor(string2);
            }
            if (n != 1 && n != 2 && n != 3) {
                throw new IllegalStateException("invalid word behavior: " + n);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            DeletePreviousWordAction.makeEditable(basicEditorPane);
            if (!DeletePreviousWordAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n2 = basicEditorPane.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    n = Utilities.getPreviousWordStart(basicDocument, n2);
                    break;
                }
                case 2: {
                    n = Utilities.getPreviousWordEnd(basicDocument, n2);
                    break;
                }
                case 3: {
                    n = Math.max(Utilities.getPreviousWordStart(basicDocument, n2), Utilities.getPreviousWordEnd(basicDocument, n2));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (n2 != n) {
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        basicDocument.remove(n, n2 - n);
                        basicEditorPane.setCaretPosition(n);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends BasicAction {
        private static EditDescriptor newlineDescriptor;

        public InsertBreakAction() {
            super("insert-break");
            if (newlineDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_INSERT_LINE");
                newlineDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            InsertBreakAction.makeEditable(basicEditorPane);
            if (!InsertBreakAction.isEditable(basicEditorPane, true)) {
                return;
            }
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            LineMap lineMap = basicDocument.getLineMap();
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            int n3 = lineMap.getLineFromOffset(n);
            int n4 = InsertBreakAction.getTabSizeProperty(basicEditorPane);
            boolean bl = InsertBreakAction.getUseTabsProperty(basicEditorPane);
            boolean bl2 = false;
            basicEditorPane.beginEdit(newlineDescriptor);
            try {
                try {
                    int n5;
                    int n6;
                    int n7;
                    if (n != n2) {
                        basicDocument.remove(n, n2 - n);
                    }
                    if ((n7 = InsertBreakAction.skipLeadingIndent(textBuffer, n6 = lineMap.getLineStartOffset(n3), n5 = lineMap.getLineEndOffset(n3))) == -1 || n <= n7) {
                        int n8 = Utilities.getColumnFromOffset(textBuffer, n3, n, n4);
                        String string = InsertBreakAction.buildIndent(bl, n4, n8);
                        bl2 = true;
                        basicDocument.insertString(n, string, null);
                        basicDocument.insertString(n, "\n", null);
                    } else {
                        basicDocument.insertString(n, "\n", null);
                    }
                    if (!bl2) {
                        int n9 = lineMap.getLineStartOffset(n3);
                        int n10 = lineMap.getLineEndOffset(n3);
                        int n11 = n3 + 1;
                        int n12 = n10;
                        int n13 = lineMap.getLineEndOffset(n11);
                        boolean bl3 = InsertBreakAction.getUseAutoIndentProperty(basicEditorPane);
                        SmartIndentProvider smartIndentProvider = InsertBreakAction.getSmartIndentProvider(basicEditorPane, basicDocument);
                        if (smartIndentProvider != null) {
                            boolean bl4 = smartIndentProvider.shouldAutoReindentOldLine();
                            boolean bl5 = smartIndentProvider.shouldAutoIndentNewLine();
                            if (bl5) {
                                int n14 = smartIndentProvider.getIndentForLine(n11, n4);
                                int n15 = InsertBreakAction.skipLeadingIndent(textBuffer, n12, n13);
                                if (n15 == -1) {
                                    int n16 = lineMap.getLineCount() - 1;
                                    n15 = n11 == n16 ? n13 : n13 - 1;
                                }
                                String string = InsertBreakAction.buildIndent(bl, n4, n14);
                                basicDocument.remove(n12, n15 - n12);
                                basicDocument.insertString(n12, string, null);
                                basicEditorPane.setCaretPosition(n12 + string.length());
                            }
                            if (bl4) {
                                int n17 = smartIndentProvider.getIndentForLine(n3, n4);
                                int n18 = InsertBreakAction.skipLeadingIndent(textBuffer, n9, n10);
                                if (n18 == -1) {
                                    int n19 = lineMap.getLineCount() - 1;
                                    n18 = n11 == n19 ? n10 : n10 - 1;
                                }
                                String string = InsertBreakAction.buildIndent(bl, n4, n17);
                                basicDocument.remove(n9, n18 - n9);
                                basicDocument.insertString(n9, string, null);
                            }
                        } else if (bl3) {
                            int n20 = InsertBreakAction.skipLeadingIndent(textBuffer, n9, n10);
                            if (n20 == -1) {
                                n20 = n10 - 1;
                            }
                            int n21 = Utilities.getColumnFromOffset(textBuffer, n20, n4);
                            String string = InsertBreakAction.buildIndent(bl, n4, n21);
                            n20 = InsertBreakAction.skipLeadingIndent(textBuffer, n12, n13);
                            if (n20 == -1) {
                                int n22 = lineMap.getLineCount() - 1;
                                n20 = n11 == n22 ? n13 : n13 - 1;
                            }
                            basicDocument.remove(n12, n20 - n12);
                            basicDocument.insertString(n12, string, null);
                            basicEditorPane.setCaretPosition(n12 + string.length());
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class InsertTabAction
    extends BlockIndentOutdentAction {
        private static EditDescriptor editDescriptor;

        public InsertTabAction() {
            super("insert-tab", true);
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_INSERT_TAB");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            block9: {
                int n;
                if (this.shouldPerformBlockOperation(basicEditorPane)) {
                    super.actionPerformed(actionEvent, basicEditorPane, basicDocument);
                    return;
                }
                InsertTabAction.makeEditable(basicEditorPane);
                if (!InsertTabAction.isEditable(basicEditorPane, true)) {
                    return;
                }
                int n2 = InsertTabAction.getIndentSizeProperty(basicEditorPane);
                int n3 = InsertTabAction.getTabSizeProperty(basicEditorPane);
                boolean bl = InsertTabAction.getUseTabsProperty(basicEditorPane);
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                LineMap lineMap = basicDocument.getLineMap();
                int n4 = n = basicEditorPane.getSelectionStart();
                int n5 = basicEditorPane.getSelectionEnd();
                int n6 = lineMap.getLineFromOffset(n);
                int n7 = lineMap.getLineStartOffset(n6);
                int n8 = lineMap.getLineEndOffset(n6);
                int n9 = InsertTabAction.skipLeadingIndent(textBuffer, n7, n8);
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        int n10 = Utilities.getColumnFromOffset(textBuffer, n6, n, n3);
                        int n11 = Utilities.getNextTabStop(n2, n10);
                        if (n9 != -1 && n9 < n) {
                            String string;
                            int n12 = n11 - n10;
                            String string2 = string = bl ? "\t" : InsertTabAction.getSpaces(n12);
                            if (n4 != n5) {
                                basicDocument.remove(n4, n5 - n4);
                            }
                            basicDocument.insertString(n4, string, null);
                            break block9;
                        }
                        String string = InsertTabAction.buildIndent(bl, n3, n11);
                        basicDocument.remove(n7, n5 - n7);
                        basicDocument.insertString(n7, string, null);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }

    public static class OpenLineAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public OpenLineAction() {
            super("open-line");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_OPEN_LINE");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            OpenLineAction.makeEditable(basicEditorPane);
            if (!OpenLineAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            basicEditorPane.beginEdit(editDescriptor);
            try {
                try {
                    if (n != n2) {
                        basicDocument.remove(n, n2 - n);
                    }
                    basicDocument.insertString(n, "\n", null);
                    basicEditorPane.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class ReverseTabAction
    extends BlockIndentOutdentAction {
        public ReverseTabAction() {
            super("reverse-tab", false);
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            if (this.shouldPerformBlockOperation(basicEditorPane)) {
                super.actionPerformed(actionEvent, basicEditorPane, basicDocument);
                return;
            }
            int n = ReverseTabAction.getIndentSizeProperty(basicEditorPane);
            int n2 = ReverseTabAction.getTabSizeProperty(basicEditorPane);
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int n3 = basicEditorPane.getCaretPosition();
            int n4 = Utilities.getColumnFromOffset(textBuffer, n3, n2);
            int n5 = n4 - n - 1;
            n5 = n5 > 0 ? Utilities.getNextTabStop(n, n5) : 0;
            int n6 = lineMap.getLineFromOffset(n3);
            int n7 = Utilities.getOffsetFromColumn(textBuffer, n6, n5, n2);
            if (n3 != n7) {
                basicEditorPane.beginNavigation();
                try {
                    basicEditorPane.setCaretPosition(n7);
                }
                finally {
                    basicEditorPane.endNavigation();
                }
            }
        }
    }

    public static class SortSelectedLines
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public SortSelectedLines() {
            super("sort-selected-lines");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_SORT_SELECTED_LINES");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            SortSelectedLines.makeEditable(basicEditorPane);
            if (!SortSelectedLines.isEditable(basicEditorPane, true)) {
                return;
            }
            if (!basicEditorPane.hasSelection()) {
                return;
            }
            basicEditorPane.beginEdit(editDescriptor);
            try {
                try {
                    LineMap lineMap = basicDocument.getLineMap();
                    int n = basicEditorPane.getSelectionStart();
                    int n2 = basicEditorPane.getSelectionEnd();
                    int n3 = lineMap.getLineFromOffset(n);
                    int n4 = lineMap.getLineFromOffset(n2);
                    if (n2 == lineMap.getLineStartOffset(n4)) {
                        --n4;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n5 = lineMap.getLineCount() - 1;
                    int n6 = n3;
                    while (n6 <= n4) {
                        int n7 = lineMap.getLineStartOffset(n6);
                        int n8 = lineMap.getLineEndOffset(n6);
                        if (n6 != n5) {
                            --n8;
                        }
                        String string = basicDocument.getText(n7, n8 - n7);
                        arrayList.add(string);
                        ++n6;
                    }
                    Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
                    int n9 = lineMap.getLineStartOffset(n3);
                    int n10 = lineMap.getLineEndOffset(n4);
                    basicDocument.remove(n9, n10 - n9);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n11 = arrayList.size();
                    int n12 = 0;
                    while (n12 < n11) {
                        stringBuffer.append(arrayList.get(n12).toString());
                        stringBuffer.append('\n');
                        ++n12;
                    }
                    basicDocument.insertString(n9, stringBuffer.toString(), null);
                    basicEditorPane.select(n9, n9 + stringBuffer.length());
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class TabifyAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public TabifyAction() {
            super("tabify");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_TABIFY");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            TabifyAction.makeEditable(basicEditorPane);
            if (!TabifyAction.isEditable(basicEditorPane, true)) {
                return;
            }
            basicEditorPane.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                LineMap lineMap = basicDocument.getLineMap();
                int n = lineMap.getLineCount();
                int n2 = TabifyAction.getTabSizeProperty(basicEditorPane);
                boolean bl = true;
                int n3 = 0;
                while (n3 < n) {
                    int n4;
                    int n5 = lineMap.getLineStartOffset(n3);
                    int n6 = TabifyAction.skipLeadingIndent(textBuffer, n5, n4 = lineMap.getLineEndOffset(n3));
                    if (n6 != -1) {
                        int n7 = Utilities.getColumnFromOffset(textBuffer, n3, n6, n2);
                        String string = TabifyAction.buildIndent(true, n2, n7);
                        String string2 = textBuffer.getString(n5, n6 - n5);
                        if (!string2.equals(string)) {
                            try {
                                basicDocument.remove(n5, n6 - n5);
                                basicDocument.insertString(n5, string, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n3;
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class ToggleCommentsAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public ToggleCommentsAction() {
            super("toggle-java-comments");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_TOGGLE_COMMENTS");
                editDescriptor = new EditDescriptor(string);
            }
        }

        private boolean isWhitespaceOnly(TextBuffer textBuffer, int n, int n2) {
            int n3 = n;
            while (n3 < n2) {
                char c;
                if (Character.isWhitespace(c = textBuffer.getChar(n3++))) continue;
                return false;
            }
            return true;
        }

        private int getCommentStart(TextBuffer textBuffer, String string, int n, int n2, boolean bl) {
            int n3 = string.length();
            int n4 = n2 - n3 + 1;
            int n5 = n;
            if (bl) {
                while (n5 < n4) {
                    char c = textBuffer.getChar(n5);
                    if (!Character.isWhitespace(c)) break;
                    ++n5;
                }
            }
            if (n5 < n4) {
                int n6 = 0;
                while (n6 < n3) {
                    char c;
                    char c2 = textBuffer.getChar(n5 + n6);
                    if (c2 != (c = string.charAt(n6))) {
                        return -1;
                    }
                    ++n6;
                }
                return n5;
            }
            return -1;
        }

        private boolean areLinesCommented(TextBuffer textBuffer, String string, int n, int n2) {
            LineMap lineMap = textBuffer.getLineMap();
            boolean bl = true;
            boolean bl2 = true;
            int n3 = n;
            while (n3 <= n2) {
                int n4;
                int n5 = lineMap.getLineStartOffset(n3);
                if (!this.isWhitespaceOnly(textBuffer, n5, n4 = lineMap.getLineEndOffset(n3))) {
                    bl = false;
                    if (this.getCommentStart(textBuffer, string, n5, n4, true) == -1) {
                        bl2 = false;
                        break;
                    }
                }
                ++n3;
            }
            if (bl) {
                return false;
            }
            return bl2;
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            ToggleCommentsAction.makeEditable(basicEditorPane);
            if (!ToggleCommentsAction.isEditable(basicEditorPane, true)) {
                return;
            }
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            String string = (String)languageSupport.getProperty("line-comment-start");
            if (string == null || string.length() == 0) {
                return;
            }
            basicEditorPane.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                LineMap lineMap = basicDocument.getLineMap();
                int n = basicEditorPane.getSelectionStart();
                int n2 = basicEditorPane.getSelectionEnd();
                boolean bl = n != n2;
                int n3 = lineMap.getLineFromOffset(n);
                int n4 = lineMap.getLineFromOffset(n2);
                if (n3 != n4 && lineMap.getLineStartOffset(n4) == n2) {
                    --n4;
                }
                boolean bl2 = this.areLinesCommented(textBuffer, string, n3, n4) ^ true;
                int n5 = n3;
                while (n5 <= n4) {
                    try {
                        int n6 = lineMap.getLineStartOffset(n5);
                        int n7 = lineMap.getLineEndOffset(n5);
                        if (bl2) {
                            basicDocument.insertString(n6, string, null);
                        } else {
                            int n8 = this.getCommentStart(textBuffer, string, n6, n7, true);
                            if (n8 != -1) {
                                basicDocument.remove(n8, string.length());
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ++n5;
                }
                if (!bl) {
                    int n9 = lineMap.getLineEndOffset(n4);
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl3 = editorProperties.getBooleanProperty("toggle-comments-advance");
                    if (bl3) {
                        basicEditorPane.setCaretPosition(n9);
                    }
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class TransposeCharsAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public TransposeCharsAction() {
            super("transpose-chars");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_TRANSPOSE_CHARS");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            TransposeCharsAction.makeEditable(basicEditorPane);
            if (!TransposeCharsAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            if (n == 0 || n == basicDocument.getLength()) {
                TransposeCharsAction.beep(basicEditorPane);
                return;
            }
            basicEditorPane.beginEdit(editDescriptor);
            try {
                try {
                    basicEditorPane.unselect();
                    String string = basicDocument.getText(n, 1);
                    basicDocument.remove(n, 1);
                    basicDocument.insertString(n - 1, string, null);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class UntabifyAction
    extends BasicAction {
        private static EditDescriptor editDescriptor;

        public UntabifyAction() {
            super("untabify");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_UNTABIFY");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            UntabifyAction.makeEditable(basicEditorPane);
            if (!UntabifyAction.isEditable(basicEditorPane, true)) {
                return;
            }
            basicEditorPane.beginEdit(editDescriptor);
            try {
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                LineMap lineMap = basicDocument.getLineMap();
                int n = textBuffer.getLength();
                int n2 = UntabifyAction.getTabSizeProperty(basicEditorPane);
                boolean bl = false;
                int n3 = n - 1;
                while (n3 >= 0) {
                    char c = textBuffer.getChar(n3);
                    if (c == '\t') {
                        int n4 = lineMap.getLineFromOffset(n3);
                        int n5 = Utilities.getColumnFromOffset(textBuffer, n4, n3, n2);
                        int n6 = n2 - n5 % n2;
                        String string = UntabifyAction.buildIndent(false, n2, n6);
                        try {
                            basicDocument.remove(n3, 1);
                            basicDocument.insertString(n3, string, null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    --n3;
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static class BeepAction
    extends BasicAction {
        public BeepAction() {
            super("beep");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            BeepAction.beep(basicEditorPane);
        }
    }

    public static class SetLocalTabSizeAction
    extends BasicAction {
        private Integer tabSize;

        public SetLocalTabSizeAction(String string, int n) {
            super(string);
            this.tabSize = new Integer(n);
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.putProperty("tab-size", this.tabSize);
        }
    }

    public static class ReadOnlyAction
    extends BasicAction {
        public ReadOnlyAction() {
            super("set-read-only");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.setEditable(false);
        }
    }

    public static class WritableAction
    extends BasicAction {
        public WritableAction() {
            super("set-writable");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.setEditable(true);
        }
    }

    public static class ToggleInsertModeAction
    extends BasicAction {
        public ToggleInsertModeAction() {
            super("toggle-insert-mode");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Caret caret = basicEditorPane.getCaret();
            if (caret != null && caret instanceof BasicCaret) {
                BasicCaret basicCaret = (BasicCaret)caret;
                basicCaret.toggleInsertMode();
            }
        }
    }

    public static class MacroRecorderAction
    extends BasicAction {
        private static KeyRecorder recorder = new KeyRecorder();
        private boolean doPlayback;

        public MacroRecorderAction(String string, boolean bl) {
            super(string);
            this.doPlayback = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            if (this.doPlayback) {
                recorder.playbackRecording(basicEditorPane);
            } else {
                recorder.toggleRecording(basicEditorPane);
            }
        }
    }

    public static class GotoMatchingBraceAction
    extends BasicAction {
        private boolean performSelect;
        private static String NOT_AVAILABLE;
        private static String NONE_AT_CURSOR;
        private static String MISMATCH;

        public GotoMatchingBraceAction(String string, boolean bl) {
            super(string);
            this.performSelect = bl;
            if (NOT_AVAILABLE == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                NOT_AVAILABLE = bundleHelper.getString("BRACE_MATCHING_NOT_AVAILABLE");
                NONE_AT_CURSOR = bundleHelper.getString("BRACE_MATCHING_NONE_AT_CURSOR");
                MISMATCH = bundleHelper.getString("BRACE_MATCHING_MISMATCH");
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            BraceProvider braceProvider = languageSupport.getBraceProvider();
            if (braceProvider == null) {
                GotoMatchingBraceAction.showMessage(basicEditorPane, NOT_AVAILABLE);
                return;
            }
            NumberRange numberRange = new NumberRange(0, 0);
            NumberRange numberRange2 = new NumberRange(0, 0);
            int n = basicEditorPane.getCaretPosition();
            int n2 = -1;
            if (n > 0) {
                n2 = braceProvider.isPartOfBrace(n - 1, numberRange);
            }
            if (n2 == -1) {
                n2 = braceProvider.isPartOfBrace(n, numberRange);
            }
            if (n2 == -1) {
                GotoMatchingBraceAction.showMessage(basicEditorPane, NONE_AT_CURSOR);
                return;
            }
            int n3 = braceProvider.findMatchingBrace(n2, numberRange, numberRange2);
            if (n3 != 3) {
                boolean bl = numberRange2.end <= numberRange.start;
                basicEditorPane.beginNavigation();
                if (this.performSelect) {
                    if (bl) {
                        basicEditorPane.setCaretPositionCenter(numberRange.start);
                        basicEditorPane.moveCaretPositionCenter(numberRange2.end);
                    } else {
                        basicEditorPane.setCaretPositionCenter(numberRange.end);
                        basicEditorPane.moveCaretPositionCenter(numberRange2.start);
                    }
                } else {
                    basicEditorPane.setCaretPositionCenter(numberRange2.end);
                }
                basicEditorPane.endNavigation();
            } else {
                GotoMatchingBraceAction.showMessage(basicEditorPane, MISMATCH);
            }
        }
    }

    public static abstract class NavigateAction
    extends BasicAction {
        private boolean performSelect;

        protected NavigateAction(String string, boolean bl) {
            super(string);
            this.performSelect = bl;
        }

        protected final boolean doSelect() {
            return this.performSelect;
        }

        public final void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.beginNavigation();
            try {
                this.navigatePerformed(actionEvent, basicEditorPane, basicDocument);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }

        protected abstract void navigatePerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3);
    }

    public static class PageUpAction
    extends NavigateAction {
        public PageUpAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Rectangle rectangle = PageUpAction.getVisibleRect(basicEditorPane);
            int n = PageUpAction.getFontHeight(basicEditorPane);
            int n2 = rectangle.height / n;
            int n3 = n2 * n;
            rectangle.y -= n3;
            rectangle.y = Math.max(0, rectangle.y);
            basicEditorPane.scrollRectToVisible(rectangle);
            try {
                int n4 = basicEditorPane.getCaretPosition();
                Point point = PageUpAction.getMagicCaretPosition(basicEditorPane);
                Rectangle rectangle2 = basicEditorPane.modelToView(n4);
                Point point2 = new Point(rectangle2.x, rectangle2.y);
                point2.y -= n3;
                point2.y = Math.max(0, point2.y);
                point2.x = point.x;
                int n5 = basicEditorPane.viewToModel(point2);
                if (n5 != n4) {
                    if (this.doSelect()) {
                        basicEditorPane.moveCaretPosition(n5);
                    } else {
                        basicEditorPane.setCaretPosition(n5);
                    }
                }
                PageUpAction.setMagicCaretPosition(basicEditorPane, point2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class PageDownAction
    extends NavigateAction {
        public PageDownAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Rectangle rectangle = PageDownAction.getVisibleRect(basicEditorPane);
            int n = PageDownAction.getFontHeight(basicEditorPane);
            int n2 = rectangle.height / n;
            int n3 = n2 * n;
            rectangle.y += n3;
            int n4 = basicEditorPane.getHeight();
            if (rectangle.y + rectangle.height > n4) {
                rectangle.y = n4 - rectangle.height;
            }
            basicEditorPane.scrollRectToVisible(rectangle);
            try {
                int n5 = basicEditorPane.getCaretPosition();
                Point point = PageDownAction.getMagicCaretPosition(basicEditorPane);
                Rectangle rectangle2 = basicEditorPane.modelToView(n5);
                Point point2 = new Point(rectangle2.x, rectangle2.y);
                point2.y += n3;
                point2.y = Math.min(point2.y, basicEditorPane.getHeight());
                point2.x = point.x;
                int n6 = basicEditorPane.viewToModel(point2);
                if (n6 != n5) {
                    if (this.doSelect()) {
                        basicEditorPane.moveCaretPosition(n6);
                    } else {
                        basicEditorPane.setCaretPosition(n6);
                    }
                }
                PageDownAction.setMagicCaretPosition(basicEditorPane, point2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class ForwardAction
    extends NavigateAction {
        public ForwardAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            int n2 = Math.min(n + 1, basicDocument.getLength());
            if (n2 != n) {
                if (this.doSelect()) {
                    basicEditorPane.moveCaretPosition(n2);
                } else {
                    basicEditorPane.setCaretPosition(n2);
                }
            }
        }
    }

    public static class BackwardAction
    extends NavigateAction {
        public BackwardAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            int n2 = Math.max(n - 1, 0);
            if (n2 != n) {
                if (this.doSelect()) {
                    basicEditorPane.moveCaretPosition(n2);
                } else {
                    basicEditorPane.setCaretPosition(n2);
                }
            }
        }
    }

    public static class UpAction
    extends NavigateAction {
        public UpAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            try {
                int n = UpAction.getFontHeight(basicEditorPane);
                int n2 = basicEditorPane.getCaretPosition();
                Point point = UpAction.getMagicCaretPosition(basicEditorPane);
                Rectangle rectangle = basicEditorPane.modelToView(n2);
                Point point2 = new Point(rectangle.x, rectangle.y);
                point2.y -= n;
                point2.y = Math.max(0, point2.y);
                point2.x = point.x;
                int n3 = basicEditorPane.viewToModel(point2);
                if (n3 != n2) {
                    if (this.doSelect()) {
                        basicEditorPane.moveCaretPosition(n3);
                    } else {
                        basicEditorPane.setCaretPosition(n3);
                    }
                }
                UpAction.setMagicCaretPosition(basicEditorPane, point2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class DownAction
    extends NavigateAction {
        public DownAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            try {
                int n = DownAction.getFontHeight(basicEditorPane);
                int n2 = basicEditorPane.getCaretPosition();
                Point point = DownAction.getMagicCaretPosition(basicEditorPane);
                Rectangle rectangle = basicEditorPane.modelToView(n2);
                Point point2 = new Point(rectangle.x, rectangle.y);
                point2.y += n;
                point2.y = Math.min(point2.y, basicEditorPane.getHeight());
                point2.x = point.x;
                int n3 = basicEditorPane.viewToModel(point2);
                if (n3 != n2) {
                    if (this.doSelect()) {
                        basicEditorPane.moveCaretPosition(n3);
                    } else {
                        basicEditorPane.setCaretPosition(n3);
                    }
                }
                DownAction.setMagicCaretPosition(basicEditorPane, point2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class BeginWordAction
    extends NavigateAction {
        public BeginWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            int n2 = Utilities.getWordStart(basicDocument, n);
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(n2);
            } else {
                basicEditorPane.setCaretPosition(n2);
            }
        }
    }

    public static class EndWordAction
    extends NavigateAction {
        public EndWordAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            int n2 = Utilities.getWordEnd(basicDocument, n);
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(n2);
            } else {
                basicEditorPane.setCaretPosition(n2);
            }
        }
    }

    public static class PreviousWordAction
    extends NavigateAction {
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public PreviousWordAction(String string, int n, boolean bl) {
            super(string, bl);
            this.wordBehavior = n;
            if (n != 1 && n != 2 && n != 3) {
                throw new IllegalStateException("invalid word behavior: " + n);
            }
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            int n2 = basicEditorPane.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    n = Utilities.getPreviousWordStart(basicDocument, n2);
                    break;
                }
                case 2: {
                    n = Utilities.getPreviousWordEnd(basicDocument, n2);
                    break;
                }
                case 3: {
                    n = Math.max(Utilities.getPreviousWordStart(basicDocument, n2), Utilities.getPreviousWordEnd(basicDocument, n2));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(n);
            } else {
                basicEditorPane.setCaretPosition(n);
            }
        }
    }

    public static class NextWordAction
    extends NavigateAction {
        public static final int TO_START = 1;
        public static final int TO_END = 2;
        public static final int TO_BOTH = 3;
        private int wordBehavior;

        public NextWordAction(String string, int n, boolean bl) {
            super(string, bl);
            this.wordBehavior = n;
            if (n != 1 && n != 2 && n != 3) {
                throw new IllegalStateException("invalid word behavior: " + n);
            }
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n;
            int n2 = basicEditorPane.getCaretPosition();
            switch (this.wordBehavior) {
                case 1: {
                    n = Utilities.getNextWordStart(basicDocument, n2);
                    break;
                }
                case 2: {
                    n = Utilities.getNextWordEnd(basicDocument, n2);
                    break;
                }
                case 3: {
                    n = Math.min(Utilities.getNextWordStart(basicDocument, n2), Utilities.getNextWordEnd(basicDocument, n2));
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid word behavior: " + this.wordBehavior);
                }
            }
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(n);
            } else {
                basicEditorPane.setCaretPosition(n);
            }
        }
    }

    public static class BeginLineAction
    extends NavigateAction {
        public BeginLineAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Boolean bl = (Boolean)basicEditorPane.getProperty("use-smart-home");
            boolean bl2 = bl;
            int n = basicEditorPane.getCaretPosition();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            try {
                n = Math.max(0, n);
                n = Math.min(textBuffer.getLength(), n);
                Rectangle rectangle = basicEditorPane.modelToView(n);
                Point point = new Point(0, rectangle.y);
                int n2 = basicEditorPane.viewToModel(point);
                Point point2 = new Point(basicEditorPane.getWidth(), rectangle.y);
                int n3 = basicEditorPane.viewToModel(point2);
                if (bl2) {
                    int n4 = n2;
                    while (n4 < n3) {
                        char c = textBuffer.getChar(n4);
                        if (c == '\n' || !Character.isWhitespace(c)) break;
                        ++n4;
                    }
                    if (n != n4) {
                        n2 = n4;
                    }
                }
                if (this.doSelect()) {
                    basicEditorPane.moveCaretPosition(n2);
                } else {
                    basicEditorPane.setCaretPosition(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class EndLineAction
    extends NavigateAction {
        public EndLineAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Boolean bl = (Boolean)basicEditorPane.getProperty("use-smart-end");
            boolean bl2 = bl;
            int n = basicEditorPane.getCaretPosition();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            try {
                n = Math.max(0, n);
                n = Math.min(textBuffer.getLength(), n);
                Rectangle rectangle = basicEditorPane.modelToView(n);
                Point point = new Point(0, rectangle.y);
                int n2 = basicEditorPane.viewToModel(point);
                Point point2 = new Point(basicEditorPane.getWidth(), rectangle.y);
                int n3 = basicEditorPane.viewToModel(point2);
                if (bl2) {
                    int n4 = n3;
                    while (n4 > n2) {
                        char c = textBuffer.getChar(n4 - 1);
                        if (c == '\n' || !Character.isWhitespace(c)) break;
                        --n4;
                    }
                    if (n != n4) {
                        n3 = n4;
                    }
                }
                if (this.doSelect()) {
                    basicEditorPane.moveCaretPosition(n3);
                } else {
                    basicEditorPane.setCaretPosition(n3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class BeginAction
    extends NavigateAction {
        public BeginAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(0);
            } else {
                basicEditorPane.setCaretPosition(0);
            }
        }
    }

    public static class EndAction
    extends NavigateAction {
        public EndAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void navigatePerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicDocument.getLength();
            if (this.doSelect()) {
                basicEditorPane.moveCaretPosition(n);
            } else {
                basicEditorPane.setCaretPosition(n);
            }
        }
    }

    public static class SelectWordAction
    extends BasicAction {
        public SelectWordAction() {
            super("select-word");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            int n2 = Utilities.getWordStart(basicDocument, n);
            int n3 = Utilities.getWordEnd(basicDocument, n);
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.setCaretPosition(n2);
                basicEditorPane.moveCaretPosition(n3);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class SelectLineAction
    extends BasicAction {
        public SelectLineAction() {
            super("select-line");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getSelectionStart();
            try {
                n = Math.max(0, n);
                n = Math.min(basicDocument.getLength(), n);
                Rectangle rectangle = basicEditorPane.modelToView(n);
                Point point = new Point(0, rectangle.y);
                int n2 = basicEditorPane.viewToModel(point);
                int n3 = SelectLineAction.getFontHeight(basicEditorPane);
                Point point2 = new Point(0, rectangle.y + n3);
                int n4 = basicEditorPane.viewToModel(point2);
                basicEditorPane.beginNavigation();
                try {
                    basicEditorPane.setCaretPosition(n2);
                    basicEditorPane.moveCaretPosition(n4);
                }
                finally {
                    basicEditorPane.endNavigation();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class SelectAllAction
    extends BasicAction {
        public SelectAllAction() {
            super("select-all");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.selectAll();
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class UnselectAction
    extends BasicAction {
        public UnselectAction() {
            super("unselect");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.unselect();
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class RecenterLineAction
    extends BasicAction {
        public RecenterLineAction() {
            super("recenter-line");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            try {
                int n = basicEditorPane.getCaretPosition();
                Rectangle rectangle = basicEditorPane.modelToView(n);
                Rectangle rectangle2 = RecenterLineAction.getVisibleRect(basicEditorPane);
                rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height >> 1);
                rectangle2.y = Math.max(0, rectangle2.y);
                int n2 = basicEditorPane.getHeight();
                if (rectangle2.y + rectangle2.height > n2) {
                    rectangle2.y = n2 - rectangle2.height;
                }
                basicEditorPane.scrollRectToVisible(rectangle2);
                basicEditorPane.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class ScrollLineUpAction
    extends BasicAction {
        public ScrollLineUpAction() {
            super("scroll-line-up");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            block7: {
                int n = ScrollLineUpAction.getFontHeight(basicEditorPane);
                Rectangle rectangle = ScrollLineUpAction.getVisibleRect(basicEditorPane);
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.y -= n;
                rectangle2.y = Math.max(0, rectangle2.y);
                if (rectangle.y == rectangle2.y) {
                    return;
                }
                basicEditorPane.scrollRectToVisible(rectangle2);
                try {
                    boolean bl;
                    Rectangle rectangle3;
                    int n2 = basicEditorPane.getCaretPosition();
                    Rectangle rectangle4 = rectangle3 = basicEditorPane.modelToView(n2);
                    Caret caret = basicEditorPane.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        rectangle4 = ((BasicCaret)caret).getCaretInsets(rectangle3);
                    }
                    if (bl = rectangle2.contains(rectangle4)) break block7;
                    int n3 = (rectangle4.height + n) / 2;
                    Point point = new Point(rectangle2.x, rectangle2.y + rectangle2.height);
                    Point point2 = ScrollLineUpAction.getMagicCaretPosition(basicEditorPane);
                    Point point3 = new Point(point);
                    point3.y -= n3;
                    point3.y = Math.max(0, point3.y);
                    point3.x = point2.x;
                    int n4 = basicEditorPane.viewToModel(point3);
                    basicEditorPane.beginNavigation();
                    try {
                        basicEditorPane.setCaretPosition(n4);
                    }
                    finally {
                        basicEditorPane.endNavigation();
                    }
                    ScrollLineUpAction.setMagicCaretPosition(basicEditorPane, point3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ScrollLineDownAction
    extends BasicAction {
        public ScrollLineDownAction() {
            super("scroll-line-down");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            block8: {
                int n = ScrollLineDownAction.getFontHeight(basicEditorPane);
                Rectangle rectangle = ScrollLineDownAction.getVisibleRect(basicEditorPane);
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.y += n;
                int n2 = basicEditorPane.getHeight();
                if (rectangle2.y + rectangle2.height > n2) {
                    rectangle2.y = n2 - rectangle2.height;
                }
                if (rectangle.y == rectangle2.y) {
                    return;
                }
                basicEditorPane.scrollRectToVisible(rectangle2);
                try {
                    boolean bl;
                    Rectangle rectangle3;
                    int n3 = basicEditorPane.getCaretPosition();
                    Rectangle rectangle4 = rectangle3 = basicEditorPane.modelToView(n3);
                    Caret caret = basicEditorPane.getCaret();
                    if (caret != null && caret instanceof BasicCaret) {
                        rectangle4 = ((BasicCaret)caret).getCaretInsets(rectangle3);
                    }
                    if (bl = rectangle2.contains(rectangle4)) break block8;
                    int n4 = (rectangle4.height + n) / 2;
                    Point point = new Point(rectangle2.x, rectangle2.y);
                    Point point2 = ScrollLineDownAction.getMagicCaretPosition(basicEditorPane);
                    Point point3 = new Point(point);
                    point3.y += n4;
                    point3.y = Math.min(point3.y, basicEditorPane.getHeight());
                    point3.x = point2.x;
                    int n5 = basicEditorPane.viewToModel(point3);
                    basicEditorPane.beginNavigation();
                    try {
                        basicEditorPane.setCaretPosition(n5);
                    }
                    finally {
                        basicEditorPane.endNavigation();
                    }
                    ScrollLineDownAction.setMagicCaretPosition(basicEditorPane, point3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ScrollPageUpAction
    extends BasicAction {
        public ScrollPageUpAction() {
            super("scroll-page-up");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Rectangle rectangle = ScrollPageUpAction.getVisibleRect(basicEditorPane);
            int n = ScrollPageUpAction.getFontHeight(basicEditorPane);
            int n2 = rectangle.height / n;
            int n3 = n2 * n;
            rectangle.y -= n3;
            rectangle.y = Math.max(0, rectangle.y);
            basicEditorPane.scrollRectToVisible(rectangle);
        }
    }

    public static class ScrollPageDownAction
    extends BasicAction {
        public ScrollPageDownAction() {
            super("scroll-page-down");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            Rectangle rectangle = ScrollPageDownAction.getVisibleRect(basicEditorPane);
            int n = ScrollPageDownAction.getFontHeight(basicEditorPane);
            int n2 = rectangle.height / n;
            int n3 = n2 * n;
            rectangle.y += n3;
            int n4 = basicEditorPane.getHeight();
            if (rectangle.y + rectangle.height > n4) {
                rectangle.y = n4 - rectangle.height;
            }
            basicEditorPane.scrollRectToVisible(rectangle);
        }
    }

    public static class EmacsSetMarkAction
    extends EmacsAction {
        public EmacsSetMarkAction() {
            super("emacs-set-mark");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            EmacsSetMarkAction.setMark(basicEditorPane, n);
            EmacsSetMarkAction.showMarkSetMessage(basicEditorPane);
        }
    }

    public static class EmacsExchangePointMarkAction
    extends EmacsAction {
        public EmacsExchangePointMarkAction() {
            super("emacs-exchange-point-mark");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = EmacsExchangePointMarkAction.getMark(basicEditorPane);
            if (n == -1) {
                EmacsExchangePointMarkAction.showMarkNotSetMessage(basicEditorPane);
                EmacsExchangePointMarkAction.beep(basicEditorPane);
                return;
            }
            int n2 = basicEditorPane.getCaretPosition();
            EmacsExchangePointMarkAction.setMark(basicEditorPane, n2);
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.setCaretPositionCenter(n);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class EmacsBeginAction
    extends EmacsAction {
        public EmacsBeginAction() {
            super("emacs-caret-begin");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            EmacsBeginAction.setMark(basicEditorPane, n);
            EmacsBeginAction.showMarkSetMessage(basicEditorPane);
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.setCaretPosition(0);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class EmacsEndAction
    extends EmacsAction {
        public EmacsEndAction() {
            super("emacs-caret-end");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicEditorPane.getCaretPosition();
            EmacsEndAction.setMark(basicEditorPane, n);
            EmacsEndAction.showMarkSetMessage(basicEditorPane);
            int n2 = basicDocument.getLength();
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.setCaretPosition(n2);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static class EmacsMarkBufferAction
    extends EmacsAction {
        public EmacsMarkBufferAction() {
            super("emacs-mark-whole-buffer");
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            int n = basicDocument.getLength();
            EmacsMarkBufferAction.setMark(basicEditorPane, n);
            EmacsMarkBufferAction.showMarkSetMessage(basicEditorPane);
            basicEditorPane.beginNavigation();
            try {
                basicEditorPane.setCaretPosition(0);
            }
            finally {
                basicEditorPane.endNavigation();
            }
        }
    }

    public static abstract class EmacsKillTypeAction
    extends EmacsAction {
        private static EmacsAction.Tracker tracker;

        public EmacsKillTypeAction(String string) {
            super(string);
            if (tracker == null) {
                tracker = new EmacsAction.Tracker();
            }
        }

        protected abstract boolean killPerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3, boolean var4);

        public final void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            boolean bl = this.wasLastActionKill(basicEditorPane);
            boolean bl2 = this.killPerformed(actionEvent, basicEditorPane, basicDocument, bl);
            if (bl2) {
                tracker.trackEditor(basicEditorPane);
            }
        }

        private final boolean wasLastActionKill(BasicEditorPane basicEditorPane) {
            int n;
            BasicAction basicAction = this.getLastAction(basicEditorPane);
            return basicAction != null && basicAction instanceof EmacsKillTypeAction && tracker.matchesEditor(basicEditorPane, n = basicEditorPane.getCaretPosition());
        }
    }

    public static class EmacsKillWordAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsKillWordAction() {
            super("emacs-kill-word");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_KILL_WORD");
                editDescriptor = new EditDescriptor(string);
            }
        }

        protected boolean killPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument, boolean bl) {
            block12: {
                int n = basicEditorPane.getCaretPosition();
                if (n == basicDocument.getLength()) {
                    return false;
                }
                int n2 = Utilities.getNextWordEnd(basicDocument, n);
                try {
                    int n3 = n2 - n;
                    String string = basicDocument.getText(n, n3);
                    if (bl) {
                        EmacsKillWordAction.appendKillRing(string);
                    } else {
                        EmacsKillWordAction.addKillRing(string);
                    }
                    EmacsKillWordAction.makeEditable(basicEditorPane);
                    if (EmacsKillWordAction.isEditable(basicEditorPane, true)) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicEditorPane.unselect();
                            basicDocument.remove(n, n3);
                            break block12;
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                    }
                    EmacsKillWordAction.showReadOnlyMessage(basicEditorPane);
                    EmacsKillWordAction.beep(basicEditorPane);
                    basicEditorPane.beginNavigation();
                    try {
                        basicEditorPane.setCaretPosition(n2);
                    }
                    finally {
                        basicEditorPane.endNavigation();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsBackwardKillWordAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsBackwardKillWordAction() {
            super("emacs-backward-kill-word");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_BACKWARD_KILL_WORD");
                editDescriptor = new EditDescriptor(string);
            }
        }

        protected boolean killPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument, boolean bl) {
            block12: {
                int n = basicEditorPane.getCaretPosition();
                if (n == 0) {
                    return false;
                }
                int n2 = Utilities.getPreviousWordStart(basicDocument, n);
                try {
                    int n3 = n - n2;
                    String string = basicDocument.getText(n2, n3);
                    if (bl) {
                        EmacsBackwardKillWordAction.prependKillRing(string);
                    } else {
                        EmacsBackwardKillWordAction.addKillRing(string);
                    }
                    EmacsBackwardKillWordAction.makeEditable(basicEditorPane);
                    if (EmacsBackwardKillWordAction.isEditable(basicEditorPane, true)) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicEditorPane.unselect();
                            basicDocument.remove(n2, n3);
                            break block12;
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                    }
                    EmacsBackwardKillWordAction.showReadOnlyMessage(basicEditorPane);
                    EmacsBackwardKillWordAction.beep(basicEditorPane);
                    basicEditorPane.beginNavigation();
                    try {
                        basicEditorPane.setCaretPosition(n2);
                    }
                    finally {
                        basicEditorPane.endNavigation();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsKillLineAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;

        public EmacsKillLineAction() {
            super("emacs-kill-line");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_KILL_LINE");
                editDescriptor = new EditDescriptor(string);
            }
        }

        protected boolean killPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument, boolean bl) {
            block13: {
                int n = basicEditorPane.getCaretPosition();
                if (n == basicDocument.getLength()) {
                    EmacsKillLineAction.showEndBufferMessage(basicEditorPane);
                    EmacsKillLineAction.beep(basicEditorPane);
                    return false;
                }
                int n2 = Utilities.getRowEnd(basicDocument, n);
                if (n == n2) {
                    ++n2;
                }
                try {
                    int n3 = n2 - n;
                    String string = basicDocument.getText(n, n3);
                    if (bl) {
                        EmacsKillLineAction.appendKillRing(string);
                    } else {
                        EmacsKillLineAction.addKillRing(string);
                    }
                    EmacsKillLineAction.makeEditable(basicEditorPane);
                    if (EmacsKillLineAction.isEditable(basicEditorPane, true)) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicEditorPane.unselect();
                            basicDocument.remove(n, n3);
                            break block13;
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                    }
                    EmacsKillLineAction.showReadOnlyMessage(basicEditorPane);
                    EmacsKillLineAction.beep(basicEditorPane);
                    basicEditorPane.beginNavigation();
                    try {
                        basicEditorPane.setCaretPosition(n2);
                    }
                    finally {
                        basicEditorPane.endNavigation();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public static class EmacsKillRegionAction
    extends EmacsKillTypeAction {
        private static EditDescriptor editDescriptor;
        private boolean doSave;

        public EmacsKillRegionAction(String string, boolean bl) {
            super(string);
            this.doSave = bl;
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_KILL_REGION");
                editDescriptor = new EditDescriptor(string2);
            }
        }

        protected boolean killPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument, boolean bl) {
            block10: {
                int n = EmacsKillRegionAction.getMark(basicEditorPane);
                if (n == -1) {
                    EmacsKillRegionAction.showMarkNotSetMessage(basicEditorPane);
                    EmacsKillRegionAction.beep(basicEditorPane);
                    return false;
                }
                int n2 = basicEditorPane.getCaretPosition();
                if (n == n2) {
                    return false;
                }
                try {
                    int n3 = Math.min(n, n2);
                    int n4 = Math.max(n, n2);
                    int n5 = n4 - n3;
                    String string = basicDocument.getText(n3, n5);
                    if (bl) {
                        EmacsKillRegionAction.appendKillRing(string);
                    } else {
                        EmacsKillRegionAction.addKillRing(string);
                    }
                    if (this.doSave) break block10;
                    EmacsKillRegionAction.makeEditable(basicEditorPane);
                    if (EmacsKillRegionAction.isEditable(basicEditorPane, true)) {
                        basicEditorPane.beginEdit(editDescriptor);
                        try {
                            basicEditorPane.unselect();
                            basicDocument.remove(n3, n5);
                            break block10;
                        }
                        finally {
                            basicEditorPane.endEdit();
                        }
                    }
                    EmacsKillRegionAction.showReadOnlyMessage(basicEditorPane);
                    EmacsKillRegionAction.beep(basicEditorPane);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return !this.doSave;
        }
    }

    public static class EmacsAppendNextKillAction
    extends EmacsKillTypeAction {
        public EmacsAppendNextKillAction() {
            super("emacs-append-next-kill");
        }

        protected boolean killPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument, boolean bl) {
            EmacsAppendNextKillAction.showNextKillAppendMessage(basicEditorPane);
            return true;
        }
    }

    public static class EmacsYankAction
    extends EmacsAction {
        private static EditDescriptor editDescriptor;
        private boolean doYank;
        private static EmacsAction.Tracker tracker;

        public EmacsYankAction(String string, boolean bl) {
            super(string);
            this.doYank = bl;
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_YANK");
                editDescriptor = new EditDescriptor(string2);
            }
            if (tracker == null) {
                tracker = new EmacsAction.Tracker();
            }
        }

        public void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            EmacsYankAction.makeEditable(basicEditorPane);
            if (!EmacsYankAction.isEditable(basicEditorPane, true)) {
                EmacsYankAction.showReadOnlyMessage(basicEditorPane);
                EmacsYankAction.beep(basicEditorPane);
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            if (this.doYank) {
                String string = EmacsYankAction.yankKillRing();
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        basicDocument.insertString(n, string, null);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
                EmacsYankAction.setMark(basicEditorPane, n);
                EmacsYankAction.showMarkSetMessage(basicEditorPane);
            } else {
                if (!this.wasLastActionYank(basicEditorPane)) {
                    EmacsYankAction.showPreviousNotYankMessage(basicEditorPane);
                    EmacsYankAction.beep(basicEditorPane);
                    return;
                }
                int n2 = EmacsYankAction.getMark(basicEditorPane);
                if (n2 > n || n2 == -1) {
                    throw new IllegalStateException("yank: " + n2 + " offset: " + n);
                }
                String string = EmacsYankAction.popKillRing();
                int n3 = n - n2;
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicDocument.remove(n2, n3);
                        basicDocument.insertString(n2, string, null);
                        EmacsYankAction.setMark(basicEditorPane, n2);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
            tracker.trackEditor(basicEditorPane);
        }

        private final boolean wasLastActionYank(BasicEditorPane basicEditorPane) {
            int n;
            BasicAction basicAction = this.getLastAction(basicEditorPane);
            return basicAction != null && basicAction instanceof EmacsYankAction && tracker.matchesEditor(basicEditorPane, n = basicEditorPane.getCaretPosition());
        }
    }

    public static abstract class EmacsCaseWordAction
    extends EmacsAction {
        public EmacsCaseWordAction(String string) {
            super(string);
        }

        public final void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            EmacsCaseWordAction.makeEditable(basicEditorPane);
            if (!EmacsCaseWordAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            int n2 = Utilities.getNextWordEnd(basicDocument, n);
            while (n < n2) {
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                char c = textBuffer.getChar(n);
                if (Character.isLetterOrDigit(c)) break;
                ++n;
            }
            if (n2 <= n) {
                return;
            }
            EditDescriptor editDescriptor = this.getEditDescriptor();
            basicEditorPane.beginEdit(editDescriptor);
            try {
                try {
                    basicEditorPane.unselect();
                    int n3 = n2 - n;
                    String string = basicDocument.getText(n, n3);
                    String string2 = this.performModification(string);
                    basicDocument.remove(n, n3);
                    basicDocument.insertString(n, string2, null);
                    basicEditorPane.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }

        public abstract String performModification(String var1);

        public abstract EditDescriptor getEditDescriptor();
    }

    public static final class EmacsUpcaseWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsUpcaseWordAction() {
            super("emacs-upcase-word");
        }

        public String performModification(String string) {
            return string.toUpperCase();
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_UPCASE_WORD");
                editDescriptor = new EditDescriptor(string);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsDowncaseWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsDowncaseWordAction() {
            super("emacs-downcase-word");
        }

        public String performModification(String string) {
            return string.toLowerCase();
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DOWNCASE_WORD");
                editDescriptor = new EditDescriptor(string);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsCapitalizeWordAction
    extends EmacsCaseWordAction {
        private static EditDescriptor editDescriptor;

        public EmacsCapitalizeWordAction() {
            super("emacs-capitalize-word");
        }

        public String performModification(String string) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!Character.isWhitespace(c)) break;
                ++n2;
            }
            String string2 = string;
            if (n2 < n) {
                String string3 = string.substring(0, n2);
                String string4 = string.substring(n2, n2 + 1);
                String string5 = string.substring(n2 + 1);
                string2 = string3 + string4.toUpperCase() + string5.toLowerCase();
            }
            return string2;
        }

        public EditDescriptor getEditDescriptor() {
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_CAPITALIZE_WORD");
                editDescriptor = new EditDescriptor(string);
            }
            return editDescriptor;
        }
    }

    public static final class EmacsCaseRegionAction
    extends EmacsAction {
        private boolean doUpcase;
        private static EditDescriptor upperDescriptor;
        private static EditDescriptor lowerDescriptor;

        public EmacsCaseRegionAction(String string, boolean bl) {
            super(string);
            this.doUpcase = bl;
            if (upperDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string2 = bundleHelper.getString("UNDO_UPCASE_REGION");
                upperDescriptor = new EditDescriptor(string2);
                String string3 = bundleHelper.getString("UNDO_DOWNCASE_REGION");
                lowerDescriptor = new EditDescriptor(string3);
            }
        }

        public final void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            EmacsCaseRegionAction.makeEditable(basicEditorPane);
            if (!EmacsCaseRegionAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = EmacsCaseRegionAction.getMark(basicEditorPane);
            if (n == -1) {
                EmacsCaseRegionAction.showMarkNotSetMessage(basicEditorPane);
                EmacsCaseRegionAction.beep(basicEditorPane);
                return;
            }
            int n2 = basicEditorPane.getCaretPosition();
            if (n2 == n) {
                return;
            }
            EditDescriptor editDescriptor = this.doUpcase ? upperDescriptor : lowerDescriptor;
            basicEditorPane.beginEdit(editDescriptor);
            try {
                try {
                    String string;
                    basicEditorPane.unselect();
                    int n3 = Math.min(n2, n);
                    int n4 = Math.max(n2, n);
                    int n5 = n4 - n3;
                    String string2 = basicDocument.getText(n3, n5);
                    String string3 = string = this.doUpcase ? string2.toUpperCase() : string2.toLowerCase();
                    if (!string2.equals(string)) {
                        basicDocument.remove(n3, n5);
                        basicDocument.insertString(n3, string, null);
                    }
                    basicEditorPane.setCaretPosition(n2);
                    EmacsCaseRegionAction.setMark(basicEditorPane, n);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
    }

    public static final class EmacsDeleteHorizontalSpaceAction
    extends EmacsAction {
        private static EditDescriptor editDescriptor;

        public EmacsDeleteHorizontalSpaceAction() {
            super("emacs-delete-horizontal-space");
            if (editDescriptor == null) {
                BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                String string = bundleHelper.getString("UNDO_DELETE_HORIZONTAL_SPACE");
                editDescriptor = new EditDescriptor(string);
            }
        }

        public final void actionPerformed(ActionEvent actionEvent, BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
            EmacsDeleteHorizontalSpaceAction.makeEditable(basicEditorPane);
            if (!EmacsDeleteHorizontalSpaceAction.isEditable(basicEditorPane, true)) {
                return;
            }
            int n = basicEditorPane.getCaretPosition();
            int n2 = basicDocument.getLength();
            int n3 = n;
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            while (n3 < n2) {
                char c = textBuffer.getChar(n3);
                if (c != ' ' && c != '\t') break;
                ++n3;
            }
            int n4 = n;
            while (n4 > 0) {
                char c = textBuffer.getChar(n4 - 1);
                if (c != ' ' && c != '\t') break;
                --n4;
            }
            if (n4 != n3) {
                basicEditorPane.beginEdit(editDescriptor);
                try {
                    try {
                        basicEditorPane.unselect();
                        int n5 = n3 - n4;
                        basicDocument.remove(n4, n5);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }
}

