/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorUI;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EmacsAction;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.keys.KeyHandlerFactory;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.resource.BundleHelper;

public class BasicEditorPane
extends JEditorPane
implements PropertyChangeListener,
Autoscroll,
ActionInvoker {
    private static Boolean DEBUG_4569221 = null;
    private final ChangeListener DEBUG_4569221_LISTENER;
    private HashMap properties;
    private MultiKeyHandler handler;
    private ArrayList layerList;
    private ArrayList pluginList;
    private PopupManager popupManager;
    private ToolTipProvider tooltipProvider;
    private FeedbackManager feedbackManager;
    private ArrayList typedListeners;
    private ArrayList hookInvokers;
    private ArrayList postInvokers;
    private boolean isProtected;
    private boolean isEditable;
    private boolean isReadOnly;
    private int beginEditCount;
    private int beginNavigationCount;
    private DocEdit editInProgress;
    private NavEdit navInProgress;
    private boolean undoInProgress;
    private UndoHelper undoHelper;
    private static final String UNDO_NAVIGATION = "undo-navigation";
    private WeakReference reference;
    private static final EditDescriptor cutDescriptor;
    private static final EditDescriptor pasteDescriptor;
    private static final EditDescriptor replaceDescriptor;
    private static final EditDescriptor navigateDescriptor;
    private static final String MERGE_NAVIGATION = "merge-navigation";
    private static final String EDIT_MERGE_COUNT = "edit-merge-count";
    private static final String NAVIGATION_MERGE_COUNT = "navigation-merge-count";

    static {
        Keymap keymap = BasicEditorPane.getKeymap("default");
        keymap.setDefaultAction(new BasicEditorKit.DefaultKeyTypedAction());
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("UNDO_CUT");
        cutDescriptor = new EditDescriptor(string);
        String string2 = bundleHelper.getString("UNDO_PASTE");
        pasteDescriptor = new EditDescriptor(string2);
        String string3 = bundleHelper.getString("UNDO_REPLACE");
        replaceDescriptor = new EditDescriptor(string3);
        String string4 = bundleHelper.getString("UNDO_NAVIGATION");
        navigateDescriptor = new EditDescriptor(string4, MERGE_NAVIGATION);
    }

    void $init$() {
        this.DEBUG_4569221_LISTENER = new 2();
        this.reference = new WeakReference<BasicEditorPane>(this);
    }

    public static void setDebug_4569221() {
        DEBUG_4569221 = Boolean.TRUE;
    }

    public BasicEditorPane() {
        this.$init$();
        this.updateColors();
        this.updateFont();
        this.popupManager = null;
        this.tooltipProvider = null;
        this.feedbackManager = null;
        this.isProtected = false;
        this.isReadOnly = false;
        this.isEditable = this.isEditable();
        this.beginEditCount = 0;
        this.beginNavigationCount = 0;
        this.editInProgress = null;
        this.navInProgress = null;
        this.undoInProgress = false;
        this.undoHelper = new UndoHelper(null);
        this.addFocusListener(this.undoHelper);
        this.layerList = new ArrayList();
        this.typedListeners = new ArrayList();
        this.hookInvokers = new ArrayList();
        this.postInvokers = new ArrayList();
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        basicDocument.addPropertyChangeListener(this);
        this.installKeyboardSupport();
        this.pluginList = new ArrayList();
        this.installBuiltInPlugins();
    }

    public void setLanguageSupport(String string) {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        basicDocument.setLanguageSupport(string);
    }

    public void beginEdit(EditDescriptor editDescriptor) {
        ++this.beginEditCount;
        if (this.beginEditCount == 1) {
            if (this.beginNavigationCount > 0) {
                System.err.println("Navigation count: " + this.beginNavigationCount);
            }
            if (this.editInProgress != null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            BasicDocument basicDocument = (BasicDocument)this.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.beginEdit();
            this.editInProgress = new DocEdit(null);
            DocEdit.mav$recordCaretStart(this.editInProgress, this, editDescriptor);
        }
    }

    public void endEdit(boolean bl, UndoableEdit undoableEdit) {
        if (this.beginEditCount == 0) {
            throw new IllegalStateException("Unmatched endEdit");
        }
        --this.beginEditCount;
        if (this.beginEditCount == 0) {
            if (this.editInProgress == null) {
                throw new IllegalStateException("Unexpected beginEdit()");
            }
            DocEdit docEdit = this.editInProgress;
            this.editInProgress = null;
            if (bl) {
                DocEdit.mav$requestForceMerge(docEdit);
            }
            DocEdit.mav$recordCaretEnd(docEdit, this);
            BasicDocument basicDocument = (BasicDocument)this.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            UndoableEdit undoableEdit2 = textBuffer.endEdit();
            DocEdit.mav$recordEdit(docEdit, undoableEdit2);
            if (undoableEdit != null) {
                CompoundEdit compoundEdit = new CompoundEdit();
                compoundEdit.addEdit(docEdit);
                compoundEdit.addEdit(undoableEdit);
                compoundEdit.end();
                UndoHelper.mav$fireUndoableEditEvent(this.undoHelper, basicDocument, compoundEdit);
            } else {
                UndoHelper.mav$fireUndoableEditEvent(this.undoHelper, basicDocument, docEdit);
            }
        }
    }

    public void endEdit() {
        this.endEdit(false);
    }

    public void endEdit(boolean bl) {
        this.endEdit(bl, null);
    }

    public void beginNavigation() {
        if (!this.isUndoInProgress() && this.beginEditCount == 0) {
            if (this.isNavigationUndoable()) {
                ++this.beginNavigationCount;
                if (this.beginNavigationCount == 1) {
                    if (this.navInProgress != null) {
                        throw new IllegalStateException("Unexpected beginNavigation()");
                    }
                    this.navInProgress = new NavEdit(null);
                    NavEdit.mav$recordCaretStart(this.navInProgress, this, navigateDescriptor);
                }
            } else {
                UndoHelper.mav$clearNextMerge(this.undoHelper);
            }
        }
    }

    public void endNavigation() {
        if (!this.isUndoInProgress() && this.beginEditCount == 0) {
            if (this.isNavigationUndoable()) {
                --this.beginNavigationCount;
                if (this.beginNavigationCount == 0) {
                    if (this.navInProgress == null) {
                        throw new IllegalStateException("Unexpected endNavigation()");
                    }
                    NavEdit navEdit = this.navInProgress;
                    this.navInProgress = null;
                    NavEdit.mav$recordCaretEnd(navEdit, this);
                    BasicDocument basicDocument = (BasicDocument)this.getDocument();
                    UndoHelper.mav$fireUndoableEditEvent(this.undoHelper, basicDocument, navEdit);
                }
            } else {
                UndoHelper.mav$clearNextMerge(this.undoHelper);
            }
        }
    }

    public void unselect() {
        this.beginNavigation();
        try {
            int n = this.getCaretPosition();
            this.setCaretPosition(n);
        }
        finally {
            this.endNavigation();
        }
    }

    public void setCaretPositionCenter(int n) {
        Document document = this.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
            n = Math.max(n, 0);
            this.ensureVisibleAndCentered(n);
            super.setCaretPosition(n);
        }
    }

    public void moveCaretPositionCenter(int n) {
        Document document = this.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
            n = Math.max(n, 0);
            this.ensureVisibleAndCentered(n);
            super.moveCaretPosition(n);
        }
    }

    public void ensureCaretVisible() {
        int n = this.getCaretPosition();
        this.ensurePositionVisible(n);
    }

    public void ensurePositionVisible(int n) {
        Document document = this.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
            n = Math.max(n, 0);
            this.ensureVisibleAndCentered(n);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (this.undoHelper != null) {
            Container container;
            EmacsAction.removeMark(this);
            this.reference.clear();
            if (this.undoHelper != null) {
                this.removeFocusListener(this.undoHelper);
                this.undoHelper = null;
            }
            if ((container = this.getParent()) != null) {
                container.remove(this);
            }
            if (this.pluginList != null) {
                this.deinstallAllPlugins();
                this.pluginList = null;
            }
            if (this.tooltipProvider != null) {
                this.removeToolTipProvider(this.tooltipProvider);
            }
            this.removeAllHighlights();
            this.layerList = null;
            this.deinstallKeyboardSupport();
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean bl) {
        this.isProtected = bl;
        this.updateEditable();
    }

    protected boolean isCutCopyLineEnabled() {
        return this.getBooleanProperty("cut-copy-line");
    }

    public boolean canCut() {
        boolean bl = this.canCopy() && this.isEditable() && this.isEnabled();
        return bl;
    }

    public boolean canCopy() {
        boolean bl = this.isCutCopyLineEnabled() || this.hasSelection();
        return bl;
    }

    public boolean canPaste() {
        if (this.isEditable()) {
            EditorProperties editorProperties = EditorProperties.getProperties();
            boolean bl = editorProperties.getBooleanProperty("check-clipboard-for-paste");
            if (!bl) {
                return true;
            }
            Toolkit toolkit = this.getToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null) {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return true;
                }
                try {
                    Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                    String string = (String)object;
                    if (string != null && string.length() > 0) {
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean hasSelection() {
        int n;
        int n2 = this.getSelectionStart();
        boolean bl = n2 != (n = this.getSelectionEnd());
        return bl;
    }

    public FontHelper getFontHelper() {
        return (FontHelper)this.getProperty("font-helper");
    }

    public void setBaseFont(String string, int n) {
        FontHelper fontHelper = new FontHelper(string, n);
        this.setFontHelper(fontHelper);
        this.updateFont();
        Font font = fontHelper.getBaseFont();
        this.putProperty("editor-font", font);
    }

    public StyleRegistry getStyleRegistry() {
        return (StyleRegistry)this.getProperty("style-registry");
    }

    public void setStyleRegistry(StyleRegistry styleRegistry) {
        this.putProperty("style-registry", styleRegistry);
    }

    public HighlightRegistry getHighlightRegistry() {
        return (HighlightRegistry)this.getProperty("highlight-registry");
    }

    public void setHighlightRegistry(HighlightRegistry highlightRegistry) {
        this.putProperty("highlight-registry", highlightRegistry);
    }

    public void setFont(Font font) {
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
        this.updateEditable();
    }

    protected EditorKit createDefaultEditorKit() {
        return new BasicEditorKit();
    }

    public void updateUI() {
        TextUI textUI = this.getUI();
        if (textUI == null || !(textUI instanceof BasicEditorUI)) {
            this.setUI(BasicEditorUI.createUI(this));
            this.invalidate();
        }
    }

    public void setDocument(Document document) {
        this.setCaretPosition(0);
        EmacsAction.removeMark(this);
        this.removeAllHighlights();
        Document document2 = this.getDocument();
        super.setDocument(document);
        if (document2 != null) {
            BasicDocument basicDocument = (BasicDocument)document2;
            basicDocument.removePropertyChangeListener(this);
        }
        if (document != null) {
            BasicDocument basicDocument = (BasicDocument)document;
            basicDocument.addPropertyChangeListener(this);
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            this.isReadOnly = textBuffer.isReadOnly();
            this.updateEditable();
        }
        this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cut() {
        Toolkit toolkit = this.getToolkit();
        if (this.isEditable() && this.isEnabled()) {
            BasicDocument basicDocument = (BasicDocument)this.getDocument();
            basicDocument.readLock();
            try {
                try {
                    int n = this.getSelectionStart();
                    int n2 = this.getSelectionEnd();
                    if (n == n2 && this.isCutCopyLineEnabled()) {
                        int n3 = this.getCaretPosition();
                        LineMap lineMap = basicDocument.getLineMap();
                        int n4 = lineMap.getLineFromOffset(n3);
                        n = lineMap.getLineStartOffset(n4);
                        n2 = lineMap.getLineEndOffset(n4);
                    }
                    if (n == n2) return;
                    String string = basicDocument.getText(n, n2 - n);
                    this.setClipboardContents(string);
                    this.beginEdit(cutDescriptor);
                    basicDocument.remove(n, n2 - n);
                    this.endEdit();
                    return;
                }
                catch (BadLocationException badLocationException) {}
                return;
            }
            finally {
                basicDocument.readUnlock();
            }
        } else {
            toolkit.beep();
        }
    }

    public void copy() {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        basicDocument.readLock();
        try {
            try {
                boolean bl;
                int n = this.getSelectionStart();
                int n2 = this.getSelectionEnd();
                boolean bl2 = bl = n != n2;
                if (n == n2 && this.isCutCopyLineEnabled()) {
                    int n3 = this.getCaretPosition();
                    LineMap lineMap = basicDocument.getLineMap();
                    int n4 = lineMap.getLineFromOffset(n3);
                    n = lineMap.getLineStartOffset(n4);
                    n2 = lineMap.getLineEndOffset(n4);
                }
                if (n != n2) {
                    String string = basicDocument.getText(n, n2 - n);
                    this.setClipboardContents(string);
                    if (!bl) {
                        this.setCaretPosition(n2);
                        this.moveCaretPosition(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    protected void setClipboardContents(String string) {
        Toolkit toolkit = this.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        StringSelection stringSelection = new StringSelection(string);
        int n = 0;
        while (n < 5) {
            try {
                clipboard.setContents(stringSelection, null);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    Thread.sleep(50);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void paste() {
        Toolkit toolkit = this.getToolkit();
        if (this.isEditable() && this.isEnabled()) {
            Clipboard clipboard = toolkit.getSystemClipboard();
            this.pasteFromClipboard(toolkit, clipboard);
        } else {
            toolkit.beep();
        }
    }

    protected void pasteFromClipboard(Toolkit toolkit, Clipboard clipboard) {
        Transferable transferable;
        if (clipboard != null && this.isEditable() && this.isEnabled() && (transferable = clipboard.getContents(this)) != null) {
            try {
                Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                String string = (String)object;
                if (string != null && string.length() > 0) {
                    this.beginEdit(pasteDescriptor);
                    super.replaceSelection(string);
                    this.endEdit();
                }
            }
            catch (Exception exception) {
                toolkit.beep();
            }
        }
    }

    public void setText(String string) {
        if (this.isEditable() && this.isEnabled()) {
            this.beginEdit(replaceDescriptor);
            try {
                try {
                    Document document = this.getDocument();
                    int n = document.getLength();
                    if (n > 0) {
                        document.remove(0, n);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(0, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                this.endEdit();
            }
        }
    }

    public void replaceSelection(String string) {
        if (this.isEditable() && this.isEnabled()) {
            this.beginEdit(replaceDescriptor);
            super.replaceSelection(string);
            this.endEdit();
        } else {
            this.getToolkit().beep();
        }
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.beginNavigation();
            try {
                super.selectAll();
            }
            finally {
                this.endNavigation();
            }
        }
    }

    public void select(int n, int n2) {
        this.beginNavigation();
        try {
            super.select(n, n2);
        }
        finally {
            this.endNavigation();
        }
    }

    public Highlighter getHighlighter() {
        return null;
    }

    public void setHighlighter(Highlighter highlighter) {
    }

    public void setToolTipText(String string) {
    }

    public String getToolTipText() {
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.tooltipProvider != null) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = this.getUI().viewToModel(this, point);
            String string = this.tooltipProvider.getToolTipText(this, mouseEvent, n);
            return string;
        }
        return null;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        switch (n) {
            case 1: {
                n4 = rectangle.height >> 4;
                n3 = fontMetrics.getHeight();
                break;
            }
            case 0: {
                n4 = rectangle.width >> 4;
                n3 = fontMetrics.charWidth('m');
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + n);
            }
        }
        int n5 = Math.max(1, n4 / n3);
        return n3 * n5;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        switch (n) {
            case 1: {
                int n3 = fontMetrics.getHeight();
                int n4 = rectangle.height / n3;
                return n3 * n4;
            }
            case 0: {
                int n5 = fontMetrics.charWidth('m');
                int n6 = rectangle.width / n5;
                return n5 * n6;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public void setCaret(Caret caret) {
        Caret caret2;
        if (DEBUG_4569221 == Boolean.TRUE && (caret2 = this.getCaret()) != null) {
            caret2.removeChangeListener(this.DEBUG_4569221_LISTENER);
        }
        super.setCaret(caret);
        if (DEBUG_4569221 == Boolean.TRUE && caret != null) {
            caret.addChangeListener(this.DEBUG_4569221_LISTENER);
        }
    }

    public void setCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
            n = Math.max(n, 0);
            super.setCaretPosition(n);
        }
    }

    public void moveCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
            n = Math.max(n, 0);
            super.moveCaretPosition(n);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        int n = this.getScrollableUnitIncrement(rectangle, 0, 1);
        int n2 = this.getScrollableUnitIncrement(rectangle, 1, 1);
        int n3 = rectangle.y + n2;
        int n4 = rectangle.x + n;
        int n5 = this.getWidth() - rectangle.width - rectangle.x + n;
        int n6 = this.getHeight() - rectangle.height - rectangle.y + n2;
        Insets insets = new Insets(n3, n4, n6, n5);
        return insets;
    }

    public void autoscroll(Point point) {
        int n;
        int n2;
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        int n3 = this.getScrollableUnitIncrement(rectangle, 0, 1);
        Insets insets = this.getAutoscrollInsets();
        if (point.x < insets.left) {
            rectangle.x -= n3;
        }
        if (point.x > (n2 = this.getWidth() - insets.right)) {
            rectangle.x += n3;
        }
        if (point.y < insets.top) {
            rectangle.y -= n3;
        }
        if (point.y > (n = this.getHeight() - insets.bottom)) {
            rectangle.y += n3;
        }
        this.validateVisibleRect(rectangle);
        this.scrollRectToVisible(rectangle);
    }

    protected void validateVisibleRect(Rectangle rectangle) {
        int n;
        rectangle.x = Math.max(0, rectangle.x);
        rectangle.y = Math.max(0, rectangle.y);
        int n2 = this.getWidth();
        if (rectangle.x + rectangle.width > n2) {
            rectangle.x = n2 - rectangle.width;
        }
        if (rectangle.y + rectangle.height > (n = this.getHeight())) {
            rectangle.y = n - rectangle.height;
        }
    }

    public final synchronized Object getProperty(String string) {
        Object object = null;
        if (this.properties != null) {
            object = this.properties.get(string);
        }
        if (object == null) {
            Document document = this.getDocument();
            object = document != null ? document.getProperty(string) : EditorProperties.getProperties().getProperty(string);
        }
        return object;
    }

    public final synchronized void putProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        Object object2 = this.properties.put(string, object);
        this.firePropertyChange(string, object2, object);
    }

    public synchronized boolean getBooleanProperty(String string) {
        Boolean bl = (Boolean)this.getProperty(string);
        return bl;
    }

    public synchronized void putBooleanProperty(String string, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.putProperty(string, bl2);
    }

    public synchronized int getIntegerProperty(String string) {
        Integer n = (Integer)this.getProperty(string);
        return n;
    }

    public synchronized void putIntegerProperty(String string, int n) {
        Integer n2 = new Integer(n);
        this.putProperty(string, n2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.properties != null) {
            this.properties.remove(string);
        }
        if (string.equals("selected-handler")) {
            this.deinstallKeyboardSupport();
            this.installKeyboardSupport();
        } else if (string.equals("read-only-mode")) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.isReadOnly = bl;
            this.updateEditable();
        } else if (string.equals("editor-font")) {
            this.setFontHelper(null);
            this.updateFont();
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public int getLineCount() {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        return basicDocument.getLineCount();
    }

    public int getLineFromOffset(int n) {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        return basicDocument.getLineFromOffset(n);
    }

    public int getLineStartOffset(int n) {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        return basicDocument.getLineStartOffset(n);
    }

    public int getLineEndOffset(int n) {
        BasicDocument basicDocument = (BasicDocument)this.getDocument();
        return basicDocument.getLineEndOffset(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionHookInvoker(ActionHookInvoker actionHookInvoker) {
        ArrayList arrayList = this.hookInvokers;
        synchronized (arrayList) {
            this.hookInvokers.add(0, actionHookInvoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionHookInvoker(ActionHookInvoker actionHookInvoker) {
        ArrayList arrayList = this.hookInvokers;
        synchronized (arrayList) {
            int n = this.hookInvokers.indexOf(actionHookInvoker);
            if (n != -1) {
                this.hookInvokers.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionPostInvoker(ActionPostInvoker actionPostInvoker) {
        ArrayList arrayList = this.postInvokers;
        synchronized (arrayList) {
            this.postInvokers.add(actionPostInvoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionPostInvoker(ActionPostInvoker actionPostInvoker) {
        ArrayList arrayList = this.postInvokers;
        synchronized (arrayList) {
            int n = this.postInvokers.indexOf(actionPostInvoker);
            if (n != -1) {
                this.postInvokers.remove(n);
            }
        }
    }

    public ActionInvoker getActionInvoker() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(String string) {
        BasicEditorKit basicEditorKit;
        Action action;
        if (this.hookInvokers.size() > 0) {
            ArrayList arrayList = this.hookInvokers;
            synchronized (arrayList) {
                int n = this.hookInvokers.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    ActionHookInvoker actionHookInvoker = (ActionHookInvoker)this.hookInvokers.get(n2);
                    if (actionHookInvoker.invokeAction(string)) {
                        this.notifyPostInvokers(string);
                        return;
                    }
                    --n2;
                }
            }
        }
        if ((action = (basicEditorKit = (BasicEditorKit)this.getEditorKit()).findAction(string)) != null && action.isEnabled()) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, string, 0);
            action.actionPerformed(actionEvent);
            this.notifyPostInvokers(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPostInvokers(String string) {
        if (this.postInvokers.size() > 0) {
            ArrayList arrayList = this.postInvokers;
            synchronized (arrayList) {
                int n = this.postInvokers.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    ActionPostInvoker actionPostInvoker = (ActionPostInvoker)this.postInvokers.get(n2);
                    actionPostInvoker.invokedAction(string);
                    --n2;
                }
            }
        }
    }

    public void installPlugin(EditorPlugin editorPlugin) {
        if (editorPlugin != null) {
            editorPlugin.install(this);
            this.pluginList.add(editorPlugin);
            this.addPropertyChangeListener(editorPlugin);
        }
    }

    public void deinstallPlugin(EditorPlugin editorPlugin) {
        int n;
        if (editorPlugin != null && (n = this.pluginList.indexOf(editorPlugin)) != -1) {
            this.removePropertyChangeListener(editorPlugin);
            this.pluginList.remove(n);
            editorPlugin.deinstall(this);
        }
    }

    protected void installBuiltInPlugins() {
    }

    protected void deinstallAllPlugins() {
        int n = this.pluginList.size();
        int n2 = 0;
        while (n2 < n) {
            EditorPlugin editorPlugin = (EditorPlugin)this.pluginList.get(n2);
            this.removePropertyChangeListener(editorPlugin);
            editorPlugin.deinstall(this);
            ++n2;
        }
        this.pluginList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightLayer createHighlightLayer() {
        HighlightLayer highlightLayer = new HighlightLayer(this);
        ArrayList arrayList = this.layerList;
        synchronized (arrayList) {
            this.layerList.add(highlightLayer);
        }
        return highlightLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyHighlightLayer(HighlightLayer highlightLayer) {
        ArrayList arrayList = this.layerList;
        synchronized (arrayList) {
            int n = this.layerList.indexOf(highlightLayer);
            if (n != -1) {
                this.layerList.remove(n);
                highlightLayer.removeAllHighlights();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllHighlights() {
        if (this.layerList != null) {
            ArrayList arrayList = this.layerList;
            synchronized (arrayList) {
                int n = this.layerList != null ? this.layerList.size() : 0;
                int n2 = 0;
                while (n2 < n) {
                    HighlightLayer highlightLayer = (HighlightLayer)this.layerList.get(n2);
                    highlightLayer.removeAllHighlights();
                    ++n2;
                }
            }
        }
    }

    protected Iterator getHighlightLayers() {
        if (this.layerList != null) {
            return this.layerList.iterator();
        }
        return null;
    }

    public void addPopupManager(PopupManager popupManager) {
        this.popupManager = popupManager;
    }

    public void removePopupManager(PopupManager popupManager) {
        this.popupManager = null;
    }

    public PopupManager getPopupManager() {
        return this.popupManager;
    }

    public void addToolTipProvider(ToolTipProvider toolTipProvider) {
        this.tooltipProvider = toolTipProvider;
        if (this.tooltipProvider != null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }
    }

    public void removeToolTipProvider(ToolTipProvider toolTipProvider) {
        if (this.tooltipProvider != null) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.unregisterComponent(this);
        }
        this.tooltipProvider = null;
    }

    public ToolTipProvider getToolTipProvider() {
        return this.tooltipProvider;
    }

    public void addFeedbackManager(FeedbackManager feedbackManager) {
        this.feedbackManager = feedbackManager;
    }

    public void removeFeedbackManager(FeedbackManager feedbackManager) {
        this.feedbackManager = null;
    }

    public FeedbackManager getFeedbackManager() {
        return this.feedbackManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterTypedListener(CharacterTypedListener characterTypedListener) {
        ArrayList arrayList = this.typedListeners;
        synchronized (arrayList) {
            this.typedListeners.add(characterTypedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterTypedListener(CharacterTypedListener characterTypedListener) {
        ArrayList arrayList = this.typedListeners;
        synchronized (arrayList) {
            int n = this.typedListeners.indexOf(characterTypedListener);
            if (n != -1) {
                this.typedListeners.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCharacterTypedEvent(int n, char c) {
        if (this.typedListeners.size() > 0) {
            ArrayList arrayList = this.typedListeners;
            synchronized (arrayList) {
                int n2 = this.typedListeners.size();
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    CharacterTypedListener characterTypedListener = (CharacterTypedListener)this.typedListeners.get(n3);
                    characterTypedListener.characterTyped(this, n, c);
                    --n3;
                }
            }
        }
    }

    private void updateEditable() {
        boolean bl = !this.isProtected && this.isEditable && !this.isReadOnly;
        super.setEditable(bl);
    }

    private void setFontHelper(FontHelper fontHelper) {
        this.putProperty("font-helper", fontHelper);
    }

    private void updateFont() {
        FontHelper fontHelper = this.getFontHelper();
        super.setFont(fontHelper.getBaseFont());
    }

    protected void updateColors() {
        StyleRegistry styleRegistry = this.getStyleRegistry();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        this.setBackground(builtInStyles.plainStyle.getBackgroundColor());
        this.setForeground(builtInStyles.plainStyle.getForegroundColor());
    }

    protected boolean useDefaultKeyHandling() {
        return true;
    }

    protected void installKeyboardSupport() {
        if (this.useDefaultKeyHandling()) {
            EditorProperties editorProperties = EditorProperties.getProperties();
            String string = editorProperties.getHandlerName();
            this.handler = KeyHandlerFactory.createHandler(string);
            this.handler.install(this, this.getActionInvoker());
        }
    }

    protected void deinstallKeyboardSupport() {
        if (this.useDefaultKeyHandling() && this.handler != null) {
            this.handler.deinstall();
            this.handler = null;
        }
    }

    protected void ensureVisibleAndCentered(int n) {
        boolean bl = false;
        try {
            if (!this.isVisible()) {
                bl = true;
            } else {
                Rectangle rectangle = this.modelToView(n);
                if (rectangle == null) {
                    bl = true;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        boolean bl2 = bl;
        1 var6_6 = new 1(this, n, bl2);
        SwingUtilities.invokeLater(var6_6);
    }

    protected void ensureVisibleAndCentered(Rectangle rectangle) {
        this.ensureVisibleAndCentered(rectangle, false);
    }

    protected void ensureVisibleAndCentered(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle();
        this.computeVisibleRect(rectangle2);
        boolean bl2 = false;
        int n = rectangle2.y;
        int n2 = n + rectangle2.height;
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height;
        if (bl || n3 < n || n4 > n2) {
            bl2 = true;
            rectangle2.y = n3 - (rectangle2.height - rectangle.height >> 1);
            rectangle2.y = Math.max(0, rectangle2.y);
            int n5 = this.getHeight();
            if (rectangle2.y + rectangle2.height > n5) {
                rectangle2.y = n5 - rectangle2.height;
            }
        }
        int n6 = rectangle2.x;
        int n7 = n6 + rectangle2.width;
        int n8 = rectangle.x;
        int n9 = n8 + rectangle.width;
        if (n8 < n6 || n9 > n7) {
            bl2 = true;
            rectangle2.x = n8 - (rectangle2.width - rectangle.width >> 1);
            rectangle2.x = Math.max(0, rectangle2.x);
            int n10 = this.getWidth();
            if (rectangle2.x + rectangle2.width > n10) {
                rectangle2.x = n10 - rectangle2.width;
            }
        }
        if (bl2) {
            this.scrollRectToVisible(rectangle2);
        }
    }

    public boolean makeEditable() {
        if (this.isEditable()) {
            return true;
        }
        if (this.isProtected() || !this.isEnabled()) {
            return false;
        }
        try {
            this.fireVetoableChange("consumerVetoForMakeEditable", null, null);
            boolean bl = false;
            return bl;
        }
        catch (PropertyVetoException propertyVetoException) {
            try {
                this.fireVetoableChange("isEditable", Boolean.FALSE, Boolean.TRUE);
                BasicDocument basicDocument = (BasicDocument)this.getDocument();
                if (basicDocument.getTextBuffer().isReadOnly()) {
                    basicDocument.getTextBuffer().setReadOnly(false);
                    basicDocument.firePropertyChange("read-only-mode", Boolean.TRUE, Boolean.FALSE);
                }
                this.setEditable(true);
                if (this.isEditable()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (PropertyVetoException propertyVetoException2) {
                // empty catch block
            }
            return false;
        }
    }

    private boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    private void setUndoInProgress(boolean bl) {
        this.undoInProgress = bl;
    }

    private boolean isNavigationUndoable() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        Object object = editorProperties.getProperty(UNDO_NAVIGATION);
        return object != null && !object.equals(Boolean.FALSE);
    }

    private Reference getReference() {
        return this.reference;
    }

    static void mav$setUndoInProgress(BasicEditorPane basicEditorPane, boolean bl) {
        basicEditorPane.setUndoInProgress(bl);
    }

    static Reference mav$getReference(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getReference();
    }

    public final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof Caret) {
                Caret caret = (Caret)object;
                int n = caret.getDot();
                int n2 = BasicEditorPane.this.getLineFromOffset(n);
                int n3 = BasicEditorPane.this.getLineStartOffset(n2);
                System.err.println("# " + n + "=" + (n2 + 1) + ":" + (n - n3 + 1));
                if (n3 == n) {
                    Exception exception = new Exception();
                    System.err.println("----------------------------------------------------------------------------------------------------");
                    System.err.println("The caret moved to position 0. ");
                    System.err.println("If that was not supposed to happen, please report this stack in bug 4569221");
                    System.err.println("  http://bug.us.oracle.com/pls/bug/webbug_edit.edit_info_top?rptno=4569221");
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$location;
        private final /* synthetic */ boolean v$passForce;
        final /* synthetic */ BasicEditorPane this$0;

        public void run() {
            try {
                Rectangle rectangle = this.this$0.modelToView(this.v$location);
                this.this$0.ensureVisibleAndCentered(rectangle, this.v$passForce);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public 1(BasicEditorPane basicEditorPane, int n, boolean bl) {
            this.v$passForce = bl;
            this.v$location = n;
            this.this$0 = basicEditorPane;
        }
    }

    private static final class UndoHelper
    implements FocusListener {
        UndoableEdit lastEdit = null;

        private UndoHelper() {
        }

        private synchronized void clearNextMerge() {
            this.lastEdit = null;
        }

        private synchronized void fireUndoableEditEvent(BasicDocument basicDocument, UndoableEdit undoableEdit) {
            boolean bl;
            if (undoableEdit == null || !undoableEdit.canUndo()) {
                this.clearNextMerge();
            }
            if (this.lastEdit != null && !(bl = this.lastEdit.addEdit(undoableEdit))) {
                this.lastEdit = null;
            }
            if (this.lastEdit == null) {
                this.lastEdit = undoableEdit;
                basicDocument.fireUndoableEditEvent(undoableEdit);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.clearNextMerge();
        }

        static void mav$fireUndoableEditEvent(UndoHelper undoHelper, BasicDocument basicDocument, UndoableEdit undoableEdit) {
            undoHelper.fireUndoableEditEvent(basicDocument, undoableEdit);
        }

        static void mav$clearNextMerge(UndoHelper undoHelper) {
            undoHelper.clearNextMerge();
        }

        UndoHelper(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class NavEdit
    extends AbstractUndoableEdit {
        private int mergeCount;
        private int startDot;
        private int startMark;
        private int endDot;
        private int endMark;
        private Reference editorReference;
        private EditDescriptor editDescriptor;

        private NavEdit() {
            this.$init$();
            this.mergeCount = 1;
        }

        void $init$() {
            this.startDot = -1;
            this.startMark = -1;
            this.endDot = -1;
            this.endMark = -1;
            this.editorReference = null;
            this.editDescriptor = null;
        }

        private void recordCaretStart(BasicEditorPane basicEditorPane, EditDescriptor editDescriptor) {
            Caret caret = basicEditorPane.getCaret();
            this.startDot = caret.getDot();
            this.startMark = caret.getMark();
            this.editorReference = BasicEditorPane.mav$getReference(basicEditorPane);
            this.editDescriptor = editDescriptor;
        }

        private void recordCaretEnd(BasicEditorPane basicEditorPane) {
            Caret caret = basicEditorPane.getCaret();
            this.endDot = caret.getDot();
            this.endMark = caret.getMark();
            if (this.startDot == this.endDot && this.startMark == this.endMark) {
                this.die();
            }
        }

        public boolean canUndo() {
            Object t;
            boolean bl = super.canUndo();
            if (bl && (t = this.editorReference.get()) == null) {
                bl = false;
            }
            return bl;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.mergeCount = -1;
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.editorReference.get();
            if (basicEditorPane != null) {
                basicEditorPane.requestFocus();
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, true);
                basicEditorPane.setCaretPositionCenter(this.startMark);
                basicEditorPane.moveCaretPositionCenter(this.startDot);
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, false);
            }
        }

        public boolean canRedo() {
            Object t;
            boolean bl = super.canRedo();
            if (bl && (t = this.editorReference.get()) == null) {
                bl = false;
            }
            return bl;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.editorReference.get();
            if (basicEditorPane != null) {
                basicEditorPane.requestFocus();
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, true);
                basicEditorPane.setCaretPositionCenter(this.endMark);
                basicEditorPane.moveCaretPositionCenter(this.endDot);
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, false);
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof NavEdit) {
                NavEdit navEdit = (NavEdit)undoableEdit;
                if (this.editDescriptor.canMergeWith(navEdit.editDescriptor)) {
                    int n;
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    Integer n2 = (Integer)editorProperties.getProperty(BasicEditorPane.NAVIGATION_MERGE_COUNT);
                    int n3 = n = n2 != null ? n2 : 1;
                    if (this.mergeCount != -1 && this.mergeCount < n) {
                        this.endDot = navEdit.endDot;
                        this.endMark = navEdit.endMark;
                        navEdit.die();
                        ++this.mergeCount;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public void die() {
            super.die();
            this.editorReference = null;
        }

        public String getPresentationName() {
            return this.editDescriptor.getEditName();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("start dot, mark: " + this.startDot + ", " + this.startMark + "\n");
            stringBuffer.append("end dot, mark: " + this.endDot + ", " + this.endMark + "\n");
            return stringBuffer.toString();
        }

        public boolean isSignificant() {
            return false;
        }

        static void mav$recordCaretEnd(NavEdit navEdit, BasicEditorPane basicEditorPane) {
            navEdit.recordCaretEnd(basicEditorPane);
        }

        NavEdit(1 var1_1) {
            this();
        }

        static void mav$recordCaretStart(NavEdit navEdit, BasicEditorPane basicEditorPane, EditDescriptor editDescriptor) {
            navEdit.recordCaretStart(basicEditorPane, editDescriptor);
        }

        public final class 1 {
        }
    }

    private static final class DocEdit
    extends AbstractUndoableEdit {
        private int mergeCount;
        private int startDot;
        private int startMark;
        private int endDot;
        private int endMark;
        private boolean forceMerge;
        private UndoableEdit wrappedEdit;
        private Reference editorReference;
        private EditDescriptor editDescriptor;

        private DocEdit() {
            this.$init$();
            this.mergeCount = 1;
        }

        void $init$() {
            this.startDot = -1;
            this.startMark = -1;
            this.endDot = -1;
            this.endMark = -1;
            this.forceMerge = false;
            this.wrappedEdit = null;
            this.editorReference = null;
            this.editDescriptor = null;
        }

        private void recordCaretStart(BasicEditorPane basicEditorPane, EditDescriptor editDescriptor) {
            Caret caret = basicEditorPane.getCaret();
            this.startDot = caret.getDot();
            this.startMark = caret.getMark();
            this.editorReference = BasicEditorPane.mav$getReference(basicEditorPane);
            this.editDescriptor = editDescriptor;
        }

        private void requestForceMerge() {
            this.forceMerge = true;
        }

        private void recordEdit(UndoableEdit undoableEdit) {
            this.wrappedEdit = undoableEdit;
            if (this.wrappedEdit == null) {
                this.die();
            }
        }

        private void recordCaretEnd(BasicEditorPane basicEditorPane) {
            Caret caret = basicEditorPane.getCaret();
            this.endDot = caret.getDot();
            this.endMark = caret.getMark();
        }

        public boolean canUndo() {
            boolean bl = super.canUndo();
            if (bl) {
                bl = this.wrappedEdit.canUndo();
            }
            return bl;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.mergeCount = -1;
            Rectangle rectangle = null;
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.editorReference.get();
            if (basicEditorPane != null && basicEditorPane.hasSelection()) {
                rectangle = new Rectangle();
                basicEditorPane.computeVisibleRect(rectangle);
                basicEditorPane.setCaretPosition(0);
            }
            this.wrappedEdit.undo();
            if (basicEditorPane != null) {
                if (rectangle != null) {
                    basicEditorPane.scrollRectToVisible(rectangle);
                }
                basicEditorPane.requestFocus();
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, true);
                basicEditorPane.setCaretPositionCenter(this.startMark);
                basicEditorPane.moveCaretPositionCenter(this.startDot);
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, false);
            }
        }

        public boolean canRedo() {
            boolean bl = super.canRedo();
            if (bl) {
                bl = this.wrappedEdit.canRedo();
            }
            return bl;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.wrappedEdit.redo();
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.editorReference.get();
            if (basicEditorPane != null) {
                basicEditorPane.requestFocus();
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, true);
                basicEditorPane.setCaretPositionCenter(this.endMark);
                basicEditorPane.moveCaretPositionCenter(this.endDot);
                BasicEditorPane.mav$setUndoInProgress(basicEditorPane, false);
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof DocEdit) {
                boolean bl;
                DocEdit docEdit = (DocEdit)undoableEdit;
                boolean bl2 = false;
                boolean bl3 = false;
                if (docEdit.forceMerge) {
                    bl2 = true;
                    bl3 = true;
                } else if (this.editDescriptor.canMergeWith(docEdit.editDescriptor)) {
                    int n;
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    Integer n2 = (Integer)editorProperties.getProperty(BasicEditorPane.EDIT_MERGE_COUNT);
                    int n3 = n = n2 != null ? n2 : 1;
                    if (this.mergeCount < n) {
                        bl2 = true;
                    }
                }
                if (bl2 && this.mergeCount != -1 && (bl = this.wrappedEdit.addEdit(docEdit.wrappedEdit))) {
                    this.endDot = docEdit.endDot;
                    this.endMark = docEdit.endMark;
                    docEdit.wrappedEdit = null;
                    docEdit.die();
                    if (!this.forceMerge) {
                        ++this.mergeCount;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public void die() {
            super.die();
            this.editorReference = null;
            if (this.wrappedEdit != null) {
                this.wrappedEdit.die();
                this.wrappedEdit = null;
            }
        }

        public String getPresentationName() {
            return this.editDescriptor.getEditName();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("start dot, mark: " + this.startDot + ", " + this.startMark + "\n");
            stringBuffer.append("wrapped edit: " + this.wrappedEdit.toString() + "\n");
            stringBuffer.append("end dot, mark: " + this.endDot + ", " + this.endMark + "\n");
            return stringBuffer.toString();
        }

        static void mav$requestForceMerge(DocEdit docEdit) {
            docEdit.requestForceMerge();
        }

        static void mav$recordCaretEnd(DocEdit docEdit, BasicEditorPane basicEditorPane) {
            docEdit.recordCaretEnd(basicEditorPane);
        }

        static void mav$recordEdit(DocEdit docEdit, UndoableEdit undoableEdit) {
            docEdit.recordEdit(undoableEdit);
        }

        DocEdit(1 var1_1) {
            this();
        }

        static void mav$recordCaretStart(DocEdit docEdit, BasicEditorPane basicEditorPane, EditDescriptor editDescriptor) {
            docEdit.recordCaretStart(basicEditorPane, editDescriptor);
        }

        public final class 1 {
        }
    }
}

