/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class BasicEditorUI
extends BasicEditorPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicEditorUI();
    }

    public void installUI(JComponent jComponent) {
        JTextComponent jTextComponent;
        super.installUI(jComponent);
        if (jComponent instanceof JTextComponent && (jTextComponent = (JTextComponent)jComponent) instanceof BasicEditorPane) {
            Color color;
            BasicEditorPane basicEditorPane = (BasicEditorPane)jTextComponent;
            boolean bl = basicEditorPane.getBooleanProperty("caret-enable-blink");
            int n = bl ? basicEditorPane.getIntegerProperty("caret-blink-rate") : 0;
            Caret caret = basicEditorPane.getCaret();
            if (caret != null) {
                caret.setBlinkRate(n);
            }
            if ((color = (Color)basicEditorPane.getProperty("caret-color")) != null) {
                jTextComponent.setCaretColor(color);
            } else {
                jTextComponent.setCaretColor(Color.black);
            }
        }
    }

    protected Caret createCaret() {
        BasicCaret basicCaret = new BasicCaret();
        return basicCaret;
    }

    protected void paintSafely(Graphics graphics) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        basicDocument.readLock();
        try {
            super.paintSafely(graphics);
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        Dimension dimension = null;
        basicDocument.readLock();
        try {
            dimension = super.getPreferredSize(jComponent);
        }
        finally {
            basicDocument.readUnlock();
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        Dimension dimension = null;
        basicDocument.readLock();
        try {
            dimension = super.getMinimumSize(jComponent);
        }
        finally {
            basicDocument.readUnlock();
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        Dimension dimension = null;
        basicDocument.readLock();
        try {
            dimension = super.getMaximumSize(jComponent);
        }
        finally {
            basicDocument.readUnlock();
        }
        return dimension;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        Rectangle rectangle = null;
        basicDocument.readLock();
        try {
            rectangle = super.modelToView(jTextComponent, n, bias);
        }
        finally {
            basicDocument.readUnlock();
        }
        return rectangle;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        int n = -1;
        basicDocument.readLock();
        try {
            n = super.viewToModel(jTextComponent, point, biasArray);
        }
        finally {
            basicDocument.readUnlock();
        }
        return n;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        int n3 = n;
        basicDocument.readLock();
        try {
            n3 = super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
        }
        finally {
            basicDocument.readUnlock();
        }
        return n3;
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        BasicEditorPane basicEditorPane = (BasicEditorPane)this.getComponent();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        basicDocument.readLock();
        try {
            try {
                super.damageRange(jTextComponent, n, n2, bias, bias2);
            }
            catch (NullPointerException nullPointerException) {}
        }
        finally {
            basicDocument.readUnlock();
        }
    }
}

