/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.RowMap;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.resource.BundleHelper;

public class BasicView
extends View
implements PropertyChangeListener {
    private BasicEditorPane _editor;
    private BasicDocument _document;
    private TextBuffer _textBuffer;
    private LineMap _lineMap;
    private Segment _lineBuffer;
    private CodeFoldingModel _foldingModel;
    private CodeFoldingMargin _foldingMargin;
    private NumberRange _lineRange;
    private Color _editorBackgroundColor;
    private FontHelper _fontHelper;
    private StyleRegistry _styleRegistry;
    private HighlightRegistry _highlightRegistry;
    private Font _font;
    private FontMetrics _metrics;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontDescent;
    private int _fontWidth;
    private int _numberRows;
    private int _tabSize;
    private int _composedStart;
    private int _composedEnd;
    private FoldedRowMap _rowMap;
    private boolean _useAA;
    private boolean _useItalicAA;
    private static final int[] PAINTER_TYPE_ORDER = new int[]{0, 1, 2};
    private FoldingListener _foldingListener;
    private static final int HIGHLIGHT_ARRAY_SIZE = 5;
    private static HighlightFragmentsList[] sharedHighlightArray = new HighlightFragmentsList[5];
    protected static final int MINIMUM_INCREMENT = 25;
    protected static final int MAXIMUM_INCREMENT = 500;
    protected static final float INCREMENT_RATE = 0.1f;
    private static final CollapsedInfo[] UNCOLLAPSED_VIEW_INFO = new CollapsedInfo[0];
    public static final String FOLDED_BLOCK_HIGHLIGHT = "folded-block-highlight";
    public static final int DEFAULT_FOLDED_BLOCK_PRIORITY = 99;
    private static final CollapsedBlocks UNCOLLAPSED_VIEW;

    public BasicView(Element element) {
        super(element);
        this.$init$();
        this._editor = null;
        this._document = (BasicDocument)this.getDocument();
        this._textBuffer = this._document.getTextBuffer();
        this._lineMap = this._document.getLineMap();
        this._lineBuffer = new Segment();
        this._lineRange = new NumberRange(0, 0);
        this._styleRegistry = null;
        this._highlightRegistry = null;
        this._fontHelper = null;
        this._composedStart = -1;
        this._composedEnd = -1;
        this._rowMap = null;
        this._useAA = false;
        this._useItalicAA = false;
    }

    private DocumentRenderer getDocumentRenderer() {
        return this._document.getDocumentRenderer();
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateMetrics();
        Rectangle rectangle = (Rectangle)shape;
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = new Rectangle(0, 0, n, n2);
        this.attachToRegistries();
        NumberRange numberRange = this._document.getComposedTextRange();
        if (numberRange != null) {
            this._composedStart = numberRange.start;
            this._composedEnd = numberRange.end;
        } else {
            this._composedStart = -1;
            this._composedEnd = -1;
        }
        boolean bl = true;
        Rectangle rectangle3 = graphics.getClipBounds();
        if (!rectangle3.intersects(rectangle2)) {
            bl = false;
        }
        rectangle3 = rectangle3.intersection(rectangle2);
        int n3 = rectangle3.y;
        int n4 = rectangle3.height + rectangle3.y;
        int n5 = this._numberRows - 1;
        int n6 = n3 / this._fontHeight;
        int n7 = n4 / this._fontHeight;
        n6 = Math.min(n6, n5);
        n7 = Math.min(n7, n5);
        int n8 = this._numberRows * this._fontHeight;
        if (n8 <= rectangle3.y) {
            bl = false;
        }
        if (bl) {
            Graphics2D graphics2D = this._useAA && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
            int n9 = this._rowMap.getRowStartOffset(n6);
            int n10 = this._rowMap.getRowEndOffset(n7);
            int n11 = this._lineMap.getLineFromOffset(n9);
            int n12 = this._lineMap.getLineFromOffset(n10);
            DocumentRenderer documentRenderer = this.getDocumentRenderer();
            StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n11, n12);
            HighlightFragmentsList highlightFragmentsList = this.renderTextHighlights(n9, n10);
            RenderFragmentGenerator renderFragmentGenerator = this._rowMap.createRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
            Object object = null;
            if (graphics2D != null) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int n13 = n6;
            while (n13 <= n7) {
                this.paintRow(graphics, rectangle3, n13, renderFragmentGenerator, highlightFragmentsList.getSentinelBackground());
                ++n13;
            }
            if (graphics2D != null && object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
            this.paintUnderlines(graphics, rectangle3, styledFragmentsList, n6, n7 + 1);
            if (styledFragmentsList != null) {
                documentRenderer.recycleFragmentsList(styledFragmentsList);
            }
            BasicView.freeHighlightFragmentsList(highlightFragmentsList);
        }
        this.paintRightMargin(graphics, rectangle3);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintUnderlines(Graphics graphics, Rectangle rectangle, StyledFragmentsList styledFragmentsList, int n, int n2) {
        int n3 = this._rowMap.getRowStartOffset(n);
        int n4 = this._rowMap.getRowEndOffset(n2 - 1);
        this.paintLineUnderlines(graphics, rectangle, n3, n4);
        if (n3 == n4 || styledFragmentsList == null) {
            return;
        }
        HighlightFragmentsList highlightFragmentsList = this.renderFontHighlights(n3, n4);
        this.paintRangeUnderlines(graphics, rectangle, styledFragmentsList, highlightFragmentsList, n3, n4);
    }

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("FOLDED_BLOCK_HIGHLIGHT");
        highlightRegistry.createStyle(FOLDED_BLOCK_HIGHLIGHT, string, true, 99, null, new Color(198, 214, 255));
        UNCOLLAPSED_VIEW = new CollapsedBlocks(null);
    }

    protected void paintLineUnderlines(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x + rectangle.width;
        int n4 = this._lineMap.getLineCount() - 1;
        int n5 = 0;
        while (n5 < PAINTER_TYPE_ORDER.length) {
            int n6 = PAINTER_TYPE_ORDER[n5];
            HighlightFragmentsList highlightFragmentsList = this.renderUnderlineHighlights(n6, true, n, n2);
            int n7 = highlightFragmentsList.size();
            int n8 = 0;
            while (n8 < n7) {
                HighlightFragment highlightFragment = highlightFragmentsList.get(n8);
                HighlightStyle highlightStyle = highlightFragment.underlineStyle;
                if (highlightStyle != null) {
                    UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
                    Color color = highlightStyle.getUnderlineColor();
                    if (underlinePainter != null && color != null) {
                        int n9 = this._lineMap.getLineFromOffset(highlightFragment.startOffset);
                        int n10 = this._lineMap.getLineEndOffset(n9);
                        if (n9 != n4) {
                            --n10;
                        }
                        int n11 = this._rowMap.getRowFromOffset(n10);
                        int n12 = this._fontHeight * n11;
                        int n13 = n12 + this._fontAscent;
                        underlinePainter.paintUnderline(graphics, color, 0, n3, n12, n13, this._fontDescent);
                    }
                }
                ++n8;
            }
            HighlightStyle highlightStyle = highlightFragmentsList.getSentinelUnderline();
            if (highlightStyle != null && highlightStyle.getUseUnderline()) {
                UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
                Color color = highlightStyle.getUnderlineColor();
                int n14 = this._numberRows - 1;
                int n15 = this._fontHeight * n14;
                int n16 = n15 + this._fontAscent;
                underlinePainter.paintUnderline(graphics, color, 0, n3, n15, n16, this._fontDescent);
            }
            BasicView.freeHighlightFragmentsList(highlightFragmentsList);
            ++n5;
        }
    }

    protected void paintRangeUnderlines(Graphics graphics, Rectangle rectangle, StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList, int n, int n2) {
        int n3 = 0;
        while (n3 < PAINTER_TYPE_ORDER.length) {
            int n4 = PAINTER_TYPE_ORDER[n3];
            HighlightFragmentsList highlightFragmentsList2 = this.renderUnderlineHighlights(n4, false, n, n2);
            int n5 = highlightFragmentsList2.size();
            int n6 = 0;
            while (n6 < n5) {
                HighlightFragment highlightFragment = highlightFragmentsList2.get(n6);
                this.paintUnderlineSegment(graphics, rectangle, styledFragmentsList, highlightFragmentsList, highlightFragment, n, n2);
                ++n6;
            }
            BasicView.freeHighlightFragmentsList(highlightFragmentsList2);
            ++n3;
        }
    }

    protected void paintUnderlineSegment(Graphics graphics, Rectangle rectangle, StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList, HighlightFragment highlightFragment, int n, int n2) {
        int n3;
        HighlightStyle highlightStyle = highlightFragment.underlineStyle;
        if (highlightStyle == null) {
            return;
        }
        UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
        Color color = highlightStyle.getUnderlineColor();
        if (underlinePainter == null || color == null) {
            return;
        }
        int n4 = Math.max(n, highlightFragment.startOffset);
        if (n4 == (n3 = Math.min(n2, highlightFragment.endOffset))) {
            return;
        }
        int n5 = this._rowMap.getRowFromOffset(n4);
        int n6 = this._rowMap.getRowFromOffset(n3);
        int n7 = this._numberRows - 1;
        int n8 = n5;
        while (n8 <= n6) {
            int n9;
            int n10 = this._rowMap.getRowStartOffset(n8);
            int n11 = this._rowMap.getRowEndOffset(n8);
            int n12 = Math.max(n10, n4);
            if (n12 != (n9 = Math.min(n11, n3))) {
                int n13;
                int n14 = this.getXCoordinateForOffset(styledFragmentsList, highlightFragmentsList, n10, n12);
                int n15 = this.getXCoordinateForOffset(styledFragmentsList, highlightFragmentsList, n10, n9);
                if (n8 != n7 && highlightFragment.endOffset >= n11 && this._rowMap.rowEndIsLineEnd(n8)) {
                    n15 += this._fontWidth;
                }
                if (this.isXRegionInClip(rectangle, n14, n13 = n15 - n14)) {
                    int n16 = this._fontHeight * n8;
                    int n17 = n16 + this._fontAscent;
                    underlinePainter.paintUnderline(graphics, color, n14, n13, n16, n17, this._fontDescent);
                }
            }
            ++n8;
        }
    }

    protected void paintRightMargin(Graphics graphics, Rectangle rectangle) {
        boolean bl;
        if (this._editor != null && (bl = this._editor.getBooleanProperty("right-margin-visible"))) {
            int n = this._editor.getIntegerProperty("right-margin-column");
            Color color = (Color)this._editor.getProperty("right-margin-color");
            int n2 = this._fontWidth * n;
            if (rectangle.x <= n2 && n2 <= rectangle.x + rectangle.width) {
                graphics.setColor(color);
                graphics.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, int n, RenderFragmentGenerator renderFragmentGenerator, HighlightStyle highlightStyle) {
        int n2 = this._rowMap.getRowStartOffset(n);
        int n3 = this._rowMap.getRowEndOffset(n);
        int n4 = this._numberRows - 1;
        int n5 = this._fontHeight * n;
        int n6 = 0;
        RenderFragment renderFragment = renderFragmentGenerator.current();
        while (renderFragment != null && renderFragment.endOffset <= n2) {
            renderFragment = renderFragmentGenerator.next();
        }
        if (renderFragment != null) {
            int n7 = n2;
            while (renderFragment.startOffset < n3) {
                int n8 = n7;
                int n9 = Math.min(renderFragment.endOffset, n3);
                n6 = this.paintSegment(graphics, rectangle, renderFragment, n8, n9, n6, n5);
                n7 = n9;
                if (n9 == n3) break;
                renderFragment = renderFragmentGenerator.next();
            }
        }
        HighlightStyle highlightStyle2 = null;
        if (n == n4) {
            highlightStyle2 = highlightStyle;
        } else if (renderFragment != null && renderFragment.startOffset < n3 && renderFragment.endOffset >= n3) {
            highlightStyle2 = renderFragment.backgroundHighlight;
        }
        if (highlightStyle2 != null && highlightStyle2.getUseBackgroundColor()) {
            Color color = highlightStyle2.getBackgroundColor();
            graphics.setColor(color);
            int n10 = n6;
            int n11 = rectangle.x + rectangle.width;
            int n12 = n11 - n10;
            if (n12 > 0) {
                graphics.fillRect(n6, n5, n12, this._fontHeight);
            }
        }
    }

    protected int paintSegment(Graphics graphics, Rectangle rectangle, RenderFragment renderFragment, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        boolean bl;
        if (n == n2) {
            return n3;
        }
        Color color = renderFragment.getBackgroundColor();
        Color color2 = renderFragment.getForegroundColor();
        int n8 = renderFragment.getFontStyle();
        Font font = this._fontHelper.getFont(n8);
        FontMetrics fontMetrics = this._fontHelper.getFontMetrics(font, (Component)this._editor);
        graphics.setFont(font);
        String string = renderFragment.textToUse;
        boolean bl2 = bl = string != null;
        if (!this._editorBackgroundColor.equals(color)) {
            int n9 = bl ? this.getFoldedTextWidth(fontMetrics, string) : this.getTabbedTextWidth(fontMetrics, n, n2, n3);
            graphics.setColor(color);
            graphics.fillRect(n3, n4, n9, this._fontHeight);
        }
        graphics.setColor(color2);
        int n10 = n7 = bl ? this.drawFoldedText(graphics, rectangle, fontMetrics, string, n3, n4) : this.drawTabbedText(graphics, rectangle, fontMetrics, n, n2, n3, n4 += this._fontAscent);
        if (!bl && this._composedStart != -1 && (n6 = Math.max(this._composedStart, n)) < (n5 = Math.min(this._composedEnd, n2))) {
            int n11 = n3;
            if (n6 > n) {
                n11 += this.getTabbedTextWidth(fontMetrics, n, n6, n3);
            }
            int n12 = this.getTabbedTextWidth(fontMetrics, n6, n5, n11);
            graphics.drawLine(n11, n4 += fontMetrics.getDescent() / 2, n11 + n12, n4);
        }
        return n7;
    }

    private void updateMetrics() {
        Font font;
        if (this._editor == null) {
            this._editor = (BasicEditorPane)this.getContainer();
            this._editor.addPropertyChangeListener(this);
            this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
            this._useItalicAA = this._editor.getBooleanProperty("editor-italic-antialiasing");
            this._tabSize = this.calculateTabSize();
            this.updateFolding();
        }
        if ((font = this._editor.getFont()) != this._font) {
            this._font = font;
            this._metrics = this._editor.getFontMetrics(this._font);
            this._fontHeight = this._metrics.getHeight();
            this._fontAscent = this._metrics.getAscent();
            this._fontDescent = this._metrics.getDescent();
            this._fontWidth = this._metrics.charWidth('W');
            this._fontHelper = null;
        }
        if (this._fontHelper == null) {
            this._fontHelper = this._editor.getFontHelper();
        }
        this._editorBackgroundColor = this._editor.getBackground();
        if (this._rowMap == null) {
            this._rowMap = new FoldedRowMap();
            this._rowMap.rebuildFoldedMap();
        }
        this._numberRows = this._rowMap.getRowCount();
        this.attachToRegistries();
    }

    void $init$() {
        this._foldingListener = new FoldingListener(null);
    }

    private void updateFolding() {
        CodeFoldingModel codeFoldingModel = this._foldingModel;
        CodeFoldingModel codeFoldingModel2 = null;
        CodeFoldingMargin codeFoldingMargin = this._foldingMargin;
        CodeFoldingMargin codeFoldingMargin2 = null;
        boolean bl = this._editor.getBooleanProperty("code-folding-margin-visible");
        if (bl) {
            codeFoldingModel2 = this._foldingModel = (CodeFoldingModel)this._editor.getProperty("code-folding-model");
            codeFoldingMargin2 = this._foldingMargin = (CodeFoldingMargin)this._editor.getProperty("code-folding-margin");
        } else {
            this._foldingModel = null;
            codeFoldingModel2 = null;
            this._foldingMargin = null;
            codeFoldingMargin2 = null;
        }
        if (codeFoldingModel != codeFoldingModel2) {
            if (codeFoldingModel != null) {
                codeFoldingModel.removeCodeFoldingModelListener(this._foldingListener);
            }
            if (codeFoldingModel2 != null) {
                codeFoldingModel2.addCodeFoldingModelListener(this._foldingListener);
            }
        }
        if (codeFoldingMargin2 != codeFoldingMargin) {
            if (codeFoldingMargin != null) {
                codeFoldingMargin.removeCodeExpansionListener(this._foldingListener);
            }
            if (codeFoldingMargin2 != null) {
                codeFoldingMargin2.addCodeExpansionListener(this._foldingListener);
            }
        }
    }

    private void rebuildRowMap() {
        this._rowMap.rebuildRowMap();
        this._rowMap.rebuildFoldedMap();
        this.preferenceChanged(null, true, true);
        this._editor.repaint();
    }

    private void revalidateRowMap() {
        boolean bl;
        int n = this._numberRows;
        int n2 = this._rowMap.getMaxRowWidth();
        this._rowMap.revalidateRowMap();
        int n3 = this._numberRows = this._rowMap.getRowCount();
        int n4 = this._rowMap.getMaxRowWidth();
        boolean bl2 = n2 != n4;
        boolean bl3 = bl = n != n3;
        if (bl2 || bl) {
            this.preferenceChanged(null, bl2, bl);
        }
        this._editor.repaint();
    }

    private void rebuildFoldedBlocks() {
        boolean bl;
        if (this._rowMap == null) {
            return;
        }
        int n = this._numberRows;
        int n2 = this._rowMap.getMaxRowWidth();
        this._rowMap.rebuildFoldedMap();
        int n3 = this._numberRows = this._rowMap.getRowCount();
        int n4 = this._rowMap.getMaxRowWidth();
        boolean bl2 = n2 != n4;
        boolean bl3 = bl = n != n3;
        if (bl2 || bl) {
            this.preferenceChanged(null, bl2, bl);
        }
        this._editor.repaint();
    }

    private BaseStyle lookupStyle(String string) {
        BaseStyle baseStyle;
        if (this._styleRegistry == null) {
            this.attachToRegistries();
        }
        if ((baseStyle = this._styleRegistry.lookupStyle(string)) == null) {
            throw new IllegalStateException("style not found: " + string);
        }
        return baseStyle;
    }

    private HighlightStyle lookupHighlight(String string) {
        HighlightRegistry highlightRegistry = this._editor.getHighlightRegistry();
        HighlightStyle highlightStyle = highlightRegistry.lookupStyle(string);
        if (highlightStyle == null) {
            throw new IllegalStateException("highlight not found: " + string);
        }
        return highlightStyle;
    }

    private void attachToRegistries() {
        if (this._styleRegistry == null) {
            if (this._editor == null) {
                this.updateMetrics();
            }
            this._styleRegistry = this._editor.getStyleRegistry();
            this._styleRegistry.addPropertyChangeListener(this);
        }
        if (this._highlightRegistry == null) {
            this._highlightRegistry = this._editor.getHighlightRegistry();
            this._highlightRegistry.addPropertyChangeListener(this);
        }
    }

    private void detachFromStyleRegistry() {
        this._styleRegistry.removePropertyChangeListener(this);
        this._styleRegistry = null;
    }

    private void detachFromHighlightRegistry() {
        this._highlightRegistry.removePropertyChangeListener(this);
        this._highlightRegistry = null;
    }

    private Rectangle rowToRect(Shape shape, int n) {
        if (this._metrics == null) {
            this.updateMetrics();
        }
        Rectangle rectangle = shape.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + n * this._fontHeight, rectangle.width, this._fontHeight);
        return rectangle2;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int n2 = this._textBuffer.getLength();
        if (n < 0 || n > n2) {
            throw new BadLocationException("m2v(), bad offset", n);
        }
        int n3 = this._rowMap.getRowFromOffset(n);
        Rectangle rectangle = this.rowToRect(shape, n3);
        int n4 = this.getXCoordinateForOffset(n3, n);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this._fontHeight;
        return rectangle;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int n3 = this._textBuffer.getLength();
        if (n < 0 || n > n3) {
            throw new BadLocationException("m2v2(), bad offset", n);
        }
        if (n2 < 0 || n2 > n3) {
            throw new BadLocationException("m2v2(), bad offset", n2);
        }
        int n4 = this._rowMap.getRowFromOffset(n);
        int n5 = this._rowMap.getRowFromOffset(n2);
        Rectangle rectangle = this.rowToRect(shape, n4);
        Rectangle rectangle2 = this.rowToRect(shape, n5);
        rectangle.add(rectangle2);
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = n - rectangle.x;
        int n4 = n2 - rectangle.y;
        if (n4 < 0) {
            return this.getStartOffset();
        }
        if (n4 > rectangle.height) {
            return this.getEndOffset();
        }
        int n5 = n4 / this._fontHeight;
        if ((n5 = Math.max(n5, 0)) >= this._numberRows) {
            return this.getEndOffset();
        }
        return this.getOffsetForXCoordinate(n5, n3);
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape) {
        boolean bl;
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int n = this._numberRows;
        int n2 = this._rowMap.getMaxRowWidth();
        this._rowMap.documentChanged(documentEvent);
        if (shape == null) {
            return;
        }
        int n3 = this._numberRows = this._rowMap.getRowCount();
        int n4 = this._rowMap.getMaxRowWidth();
        boolean bl2 = n2 != n4;
        boolean bl3 = bl = n != n3;
        if (bl2 || bl) {
            this.preferenceChanged(null, bl2, bl);
        }
        if (bl) {
            Rectangle rectangle = this._editor.getVisibleRect();
            if (rectangle != null) {
                float f = (float)rectangle.y / (float)this._fontHeight;
                int n5 = documentEvent.getOffset();
                int n6 = this._rowMap.getRowFromOffset(n5);
                if ((float)n6 < f) {
                    int n7 = n3 - n;
                    rectangle.y += n7 * this._fontHeight;
                    rectangle.y = Math.max(0, rectangle.y);
                    this._editor.scrollRectToVisible(rectangle);
                }
            }
            this._editor.repaint();
        } else {
            DocumentRenderer documentRenderer = this.getDocumentRenderer();
            documentRenderer.calculateDamage(documentEvent, this._lineRange);
            int n8 = this._lineRange.start;
            int n9 = this._lineRange.end;
            int n10 = this._lineMap.getLineCount() - 1;
            int n11 = this._lineMap.getLineStartOffset(n8);
            int n12 = this._lineMap.getLineEndOffset(n9);
            if (n9 != n10) {
                --n12;
            }
            int n13 = this._rowMap.getRowFromOffset(n11);
            int n14 = this._rowMap.getRowFromOffset(n12);
            int n15 = n14 - n13 + 1;
            Rectangle rectangle = this.rowToRect(shape, n13);
            rectangle.height = n15 * this._fontHeight;
            this._editor.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape);
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                int n2 = this._editor.getIntegerProperty("trailing-blank-columns");
                int n3 = n2 * this._fontWidth;
                return this._rowMap.getMaxRowWidth() + n3;
            }
            case 1: {
                int n4 = this._editor.getIntegerProperty("trailing-blank-rows");
                return (this._numberRows + n4) * this._fontHeight;
            }
        }
        throw new IllegalArgumentException("Illegal axis: " + n);
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public int getBreakWeight(int n, float f, float f2) {
        return 0;
    }

    private boolean isXRegionInClip(Rectangle rectangle, int n, int n2) {
        return n + n2 >= rectangle.x && rectangle.x + rectangle.width >= n;
    }

    private int drawFoldedText(Graphics graphics, Rectangle rectangle, FontMetrics fontMetrics, String string, int n, int n2) {
        int n3 = this.getFoldedTextWidth(fontMetrics, string);
        boolean bl = fontMetrics.getFont().isItalic();
        boolean bl2 = bl && this._useItalicAA && !this._useAA;
        Graphics2D graphics2D = bl2 && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object object = null;
        if (graphics2D != null) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (string.length() > 0) {
            if (this.isXRegionInClip(rectangle, n, n3)) {
                graphics.drawString(string, n, n2);
            }
            n += n3;
        }
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return n;
    }

    private int drawTabbedText(Graphics graphics, Rectangle rectangle, FontMetrics fontMetrics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        this._textBuffer.getText(n, n5, this._lineBuffer);
        char[] cArray = this._lineBuffer.array;
        int n6 = this._lineBuffer.offset;
        int n7 = this._lineBuffer.offset + n5;
        this._lineBuffer.array = null;
        int n8 = n6;
        int n9 = n6;
        int n10 = 0;
        int n11 = 0;
        boolean bl = fontMetrics.getFont().isItalic();
        boolean bl2 = bl && this._useItalicAA && !this._useAA;
        Graphics2D graphics2D = bl2 && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object object = null;
        if (graphics2D != null) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        boolean bl3 = true;
        block5: while (n8 < n7) {
            char c = cArray[n8];
            switch (c) {
                case '\t': {
                    if (n10 > 0) {
                        if (!bl3 && this.isXRegionInClip(rectangle, n3, n11)) {
                            graphics.drawChars(cArray, n9, n10, n3, n4);
                        }
                        n3 += n11;
                        n10 = 0;
                        n11 = 0;
                        bl3 = true;
                    }
                    n9 = n8 + 1;
                    n3 = this.getNextTabStop(n3);
                    break;
                }
                case '\n': 
                case '\r': {
                    break block5;
                }
                default: {
                    bl3 = false;
                }
                case ' ': {
                    ++n10;
                    n11 += fontMetrics.charWidth(c);
                }
            }
            ++n8;
        }
        if (n10 > 0) {
            if (!bl3 && this.isXRegionInClip(rectangle, n3, n11)) {
                graphics.drawChars(cArray, n9, n10, n3, n4);
            }
            n3 += n11;
        }
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return n3;
    }

    private int getFoldedTextWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    private int getTabbedTextWidth(FontMetrics fontMetrics, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n3;
        block4: while (n4 < n2) {
            char c = this._textBuffer.getChar(n4);
            switch (c) {
                case '\t': {
                    n5 = this.getNextTabStop(n5);
                    break;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
                default: {
                    n5 += fontMetrics.charWidth(c);
                }
            }
            ++n4;
        }
        int n6 = n5 - n3;
        return n6;
    }

    private int getTabbedTextOffset(FontMetrics fontMetrics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3;
        int n6 = n;
        block4: while (n6 < n2) {
            int n7 = n5;
            char c = this._textBuffer.getChar(n6);
            switch (c) {
                case '\t': {
                    n5 = this.getNextTabStop(n7);
                    break;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
                default: {
                    n5 = n7 + fontMetrics.charWidth(c);
                }
            }
            if (n7 <= n4 && n4 < n5) {
                if (!bl || n5 - n4 >= n4 - n7) break;
                ++n6;
                break;
            }
            ++n6;
        }
        return n6;
    }

    private int getXCoordinateForOffset(int n, int n2) {
        int n3 = this._rowMap.getRowStartOffset(n);
        int n4 = this._rowMap.getRowEndOffset(n);
        if (n2 == n3) {
            return 0;
        }
        int n5 = this._lineMap.getLineFromOffset(n3);
        int n6 = this._lineMap.getLineFromOffset(n4);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n5, n6);
        HighlightFragmentsList highlightFragmentsList = this.renderFontHighlights(n3, n4);
        int n7 = this.getXCoordinateForOffset(styledFragmentsList, highlightFragmentsList, n3, n2);
        if (styledFragmentsList != null) {
            styledFragmentsList.clear();
            documentRenderer.recycleFragmentsList(styledFragmentsList);
        }
        BasicView.freeHighlightFragmentsList(highlightFragmentsList);
        return n7;
    }

    private int getXCoordinateForOffset(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList, int n, int n2) {
        RenderFragmentGenerator renderFragmentGenerator = this._rowMap.createRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
        return this.getXCoordinateForOffset(renderFragmentGenerator, n, n2);
    }

    private int getXCoordinateForOffset(RenderFragmentGenerator renderFragmentGenerator, int n, int n2) {
        int n3 = 0;
        if (n == n2) {
            return n3;
        }
        RenderFragment renderFragment = renderFragmentGenerator.current();
        while (renderFragment.endOffset <= n) {
            renderFragment = renderFragmentGenerator.next();
        }
        while (renderFragment.startOffset < n2) {
            int n4 = renderFragment.getFontStyle();
            FontMetrics fontMetrics = this._fontHelper.getFontMetrics(n4, (Component)this._editor);
            int n5 = Math.max(n, renderFragment.startOffset);
            int n6 = Math.min(n2, renderFragment.endOffset);
            String string = renderFragment.textToUse;
            int n7 = string != null ? this.getFoldedTextWidth(fontMetrics, renderFragment.textToUse) : this.getTabbedTextWidth(fontMetrics, n5, n6, n3);
            n3 += n7;
            if (n6 == n2) break;
            renderFragment = renderFragmentGenerator.next();
        }
        return n3;
    }

    private int getOffsetForXCoordinate(int n, int n2) {
        int n3 = this._rowMap.getRowStartOffset(n);
        int n4 = this._rowMap.getRowEndOffset(n);
        if (n2 <= 0) {
            return n3;
        }
        int n5 = this._lineMap.getLineFromOffset(n3);
        int n6 = this._lineMap.getLineFromOffset(n4);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n5, n6);
        HighlightFragmentsList highlightFragmentsList = this.renderFontHighlights(n3, n4);
        int n7 = this._numberRows - 1;
        if (n < n7 && this._rowMap.rowEndIsLineEnd(n)) {
            --n4;
        }
        int n8 = this.getOffsetForXCoordinate(styledFragmentsList, highlightFragmentsList, n3, n4, n2);
        if (styledFragmentsList != null) {
            styledFragmentsList.clear();
            documentRenderer.recycleFragmentsList(styledFragmentsList);
        }
        BasicView.freeHighlightFragmentsList(highlightFragmentsList);
        return n8;
    }

    private int getOffsetForXCoordinate(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList, int n, int n2, int n3) {
        if (n == n2) {
            return n;
        }
        RenderFragmentGenerator renderFragmentGenerator = this._rowMap.createRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
        RenderFragment renderFragment = renderFragmentGenerator.current();
        while (renderFragment.endOffset <= n) {
            renderFragment = renderFragmentGenerator.next();
        }
        int n4 = 0;
        int n5 = n;
        while (renderFragment.startOffset < n2) {
            int n6 = n4;
            if (n3 <= n6 || n5 >= n2) break;
            int n7 = Math.max(renderFragment.startOffset, n5);
            int n8 = Math.min(renderFragment.endOffset, n2);
            int n9 = renderFragment.getFontStyle();
            FontMetrics fontMetrics = this._fontHelper.getFontMetrics(n9, (Component)this._editor);
            String string = renderFragment.textToUse;
            int n10 = string != null ? this.getFoldedTextWidth(fontMetrics, string) : this.getTabbedTextWidth(fontMetrics, n7, n8, n6);
            n4 = n6 + n10;
            if (n6 <= n3 && n3 <= n4) {
                n5 = string != null ? renderFragment.endOffset : this.getTabbedTextOffset(fontMetrics, n7, n8, n6, n3, false);
                break;
            }
            n5 = n8;
            if (n5 >= n2) break;
            renderFragment = renderFragmentGenerator.next();
        }
        return n5;
    }

    private int getNextTabStop(int n) {
        int n2 = this._metrics.charWidth(' ');
        int n3 = this._tabSize * n2;
        int n4 = n / n3;
        int n5 = n3 * (n4 + 1);
        return n5;
    }

    private int calculateTabSize() {
        int n = this._editor.getIntegerProperty("tab-size");
        return Math.max(1, n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("language-support")) {
            this.revalidateRowMap();
        } else if (string.equals("tab-size")) {
            this._tabSize = this.calculateTabSize();
            this.rebuildRowMap();
        } else if (string.equals("editor-antialiasing") || string.equals("editor-italic-antialiasing")) {
            this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
            this._useItalicAA = this._editor.getBooleanProperty("editor-italic-antialiasing");
            this._editor.repaint();
        } else if (string.equals("trailing-blank-rows")) {
            this.preferenceChanged(null, false, true);
            this._editor.repaint();
        } else if (string.equals("trailing-blank-columns")) {
            this.preferenceChanged(null, true, false);
            this._editor.repaint();
        } else if (string.equals("right-margin-column") || string.equals("right-margin-color") || string.equals("right-margin-visible")) {
            this._editor.repaint();
        } else if (string.equals("editor-font")) {
            this._fontHelper = null;
            this.updateMetrics();
            this.rebuildRowMap();
        } else if (string.equals("style-registry")) {
            this.detachFromStyleRegistry();
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
        } else if (string.equals("style-changed")) {
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
        } else if (string.equals("highlight-registry")) {
            this.detachFromHighlightRegistry();
            this.revalidateRowMap();
        } else if (string.equals("highlight-changed")) {
            this.revalidateRowMap();
        } else if (string.equals("code-folding-model") || string.equals("code-folding-margin-visible")) {
            this.updateFolding();
            this.rebuildFoldedBlocks();
        }
    }

    private HighlightFragmentsList renderTextHighlights(int n, int n2) {
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeTextOnly();
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator.hasNext()) {
                HighlightLayer highlightLayer = (HighlightLayer)iterator.next();
                highlightLayer.renderHighlights(highlightFragmentsList, n, n2);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    private HighlightFragmentsList renderFontHighlights(int n, int n2) {
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeFontOnly();
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator != null && iterator.hasNext()) {
                HighlightLayer highlightLayer = (HighlightLayer)iterator.next();
                highlightLayer.renderHighlights(highlightFragmentsList, n, n2);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    private HighlightFragmentsList renderUnderlineHighlights(int n, boolean bl, int n2, int n3) {
        int n4;
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeUnderlineOnly();
        switch (n) {
            case 0: {
                n4 = 1;
                break;
            }
            case 1: {
                n4 = 2;
                break;
            }
            case 2: {
                n4 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid underline type: " + n);
            }
        }
        highlightFragmentsList.setUnderlineTypeFilter(n4);
        Iterator iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator != null && iterator.hasNext()) {
                int n5 = bl ? 2 : 1;
                HighlightLayer highlightLayer = (HighlightLayer)iterator.next();
                highlightLayer.renderHighlights(highlightFragmentsList, n5, n2, n3);
            }
        }
        highlightFragmentsList.clearAllFilters();
        return highlightFragmentsList;
    }

    private static synchronized HighlightFragmentsList allocHighlightFragmentsList() {
        int n = 0;
        while (n < 5) {
            HighlightFragmentsList highlightFragmentsList = sharedHighlightArray[n];
            if (highlightFragmentsList != null) {
                BasicView.sharedHighlightArray[n] = null;
                return highlightFragmentsList;
            }
            ++n;
        }
        return new HighlightFragmentsList();
    }

    private static synchronized void freeHighlightFragmentsList(HighlightFragmentsList highlightFragmentsList) {
        if (highlightFragmentsList != null) {
            highlightFragmentsList.clearAttributeFilter();
            highlightFragmentsList.clear();
            highlightFragmentsList.setHighlightRegistry(null);
            int n = 0;
            while (n < 5) {
                if (sharedHighlightArray[n] == null) {
                    BasicView.sharedHighlightArray[n] = highlightFragmentsList;
                    return;
                }
                ++n;
            }
        }
    }

    static void mav$rebuildFoldedBlocks(BasicView basicView) {
        basicView.rebuildFoldedBlocks();
    }

    static BaseStyle mav$lookupStyle(BasicView basicView, String string) {
        return basicView.lookupStyle(string);
    }

    static LineMap ra$_lineMap(BasicView basicView) {
        return basicView._lineMap;
    }

    static BasicEditorPane ra$_editor(BasicView basicView) {
        return basicView._editor;
    }

    static FontHelper ra$_fontHelper(BasicView basicView) {
        return basicView._fontHelper;
    }

    static int mav$getTabbedTextWidth(BasicView basicView, FontMetrics fontMetrics, int n, int n2, int n3) {
        return basicView.getTabbedTextWidth(fontMetrics, n, n2, n3);
    }

    static int mav$getXCoordinateForOffset(BasicView basicView, RenderFragmentGenerator renderFragmentGenerator, int n, int n2) {
        return basicView.getXCoordinateForOffset(renderFragmentGenerator, n, n2);
    }

    static HighlightFragmentsList mav$renderFontHighlights(BasicView basicView, int n, int n2) {
        return basicView.renderFontHighlights(n, n2);
    }

    static DocumentRenderer mav$getDocumentRenderer(BasicView basicView) {
        return basicView.getDocumentRenderer();
    }

    static void maS$freeHighlightFragmentsList(HighlightFragmentsList highlightFragmentsList) {
        BasicView.freeHighlightFragmentsList(highlightFragmentsList);
    }

    static int mav$getXCoordinateForOffset(BasicView basicView, int n, int n2) {
        return basicView.getXCoordinateForOffset(n, n2);
    }

    static CodeFoldingModel ra$_foldingModel(BasicView basicView) {
        return basicView._foldingModel;
    }

    static CollapsedBlocks ra$UNCOLLAPSED_VIEW() {
        return UNCOLLAPSED_VIEW;
    }

    static CollapsedInfo[] ra$UNCOLLAPSED_VIEW_INFO() {
        return UNCOLLAPSED_VIEW_INFO;
    }

    static HighlightStyle mav$lookupHighlight(BasicView basicView, String string) {
        return basicView.lookupHighlight(string);
    }

    private class FoldingListener
    implements CodeExpansionListener,
    CodeFoldingModelListener {
        public void structureChanged(CodeFoldingModelEvent codeFoldingModelEvent) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        public void codeExpanded(CodeExpansionEvent codeExpansionEvent) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        public void codeCollapsed(CodeExpansionEvent codeExpansionEvent) {
            BasicView.mav$rebuildFoldedBlocks(BasicView.this);
        }

        private FoldingListener() {
        }

        FoldingListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected static interface RenderFragmentGenerator {
        public RenderFragment current();

        public RenderFragment next();
    }

    protected class LineRenderFragmentGenerator
    implements RenderFragmentGenerator {
        private int _nextRenderOffset;
        private int _nextSyntaxIndex;
        private StyledFragment _syntaxFragment;
        private int _nextHighlightIndex;
        private HighlightFragment _highlightFragment;
        private StyledFragmentsList _syntaxFragmentsList;
        private HighlightFragmentsList _highlightFragmentsList;
        protected RenderFragment _currentFragment;

        public LineRenderFragmentGenerator(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList) {
            this.$init$();
            this._syntaxFragmentsList = styledFragmentsList;
            this._highlightFragmentsList = highlightFragmentsList;
            if (this._syntaxFragmentsList == null || this._highlightFragmentsList == null || this._syntaxFragmentsList.size() == 0) {
                this._currentFragment = null;
                return;
            }
            this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
            this._nextRenderOffset = this._syntaxFragment.startOffset;
            if (this._nextHighlightIndex < this._highlightFragmentsList.size()) {
                this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
            }
            this.next();
        }

        public RenderFragment current() {
            return this._currentFragment;
        }

        public RenderFragment next() {
            if (this._currentFragment == null) {
                return null;
            }
            try {
                RenderFragment renderFragment = this.nextImpl();
                return renderFragment;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RenderFragment renderFragment = this._currentFragment = null;
                return renderFragment;
            }
        }

        /*
         * Unable to fully structure code
         */
        protected RenderFragment nextImpl() {
            if (this._syntaxFragment.endOffset <= this._nextRenderOffset) {
                this._syntaxFragment = this._syntaxFragmentsList.get(this._nextSyntaxIndex++);
            }
            if (this._syntaxFragment.startOffset <= this._nextRenderOffset) ** GOTO lbl9
            throw new IllegalStateException("gap in style fragments");
lbl-1000:
            // 1 sources

            {
                this._highlightFragment = null;
                var1_1 = this._highlightFragmentsList.size();
                if (this._nextHighlightIndex >= var1_1) break;
                this._highlightFragment = this._highlightFragmentsList.get(this._nextHighlightIndex++);
lbl9:
                // 2 sources

                ** while (this._highlightFragment == null || this._highlightFragment.endOffset <= this._nextRenderOffset)
            }
lbl10:
            // 2 sources

            var2_2 = Math.max(this._nextRenderOffset, this._syntaxFragment.startOffset);
            var3_3 = this._syntaxFragment.endOffset;
            var4_4 = null;
            if (this._highlightFragment != null) {
                var5_5 = this._highlightFragment.startOffset;
                var6_6 = this._highlightFragment.endOffset;
                if (var2_2 < var5_5) {
                    var3_3 = Math.min(var3_3, var5_5);
                } else {
                    var3_3 = Math.min(var3_3, var6_6);
                    var4_4 = this._highlightFragment;
                }
            }
            if ((var8_8 = BasicView.mav$lookupStyle(BasicView.this, var7_7 = this._syntaxFragment.styleName)) == null) {
                throw new IllegalStateException("style not found: " + var7_7);
            }
            this._currentFragment.syntaxStyle = var8_8;
            if (var4_4 != null) {
                this._currentFragment.backgroundHighlight = var4_4.backgroundStyle;
                this._currentFragment.foregroundHighlight = var4_4.foregroundStyle;
                this._currentFragment.fontHighlight = var4_4.fontStyle;
            } else {
                this._currentFragment.backgroundHighlight = null;
                this._currentFragment.foregroundHighlight = null;
                this._currentFragment.fontHighlight = null;
            }
            this._currentFragment.startOffset = var2_2;
            this._currentFragment.endOffset = var3_3;
            this._currentFragment.textToUse = null;
            this._nextRenderOffset = var3_3;
            return this._currentFragment;
        }

        void $init$() {
            this._currentFragment = new RenderFragment();
        }
    }

    protected static class RenderFragment {
        public BaseStyle syntaxStyle;
        public HighlightStyle backgroundHighlight;
        public HighlightStyle foregroundHighlight;
        public String textToUse;
        public HighlightStyle fontHighlight;
        public int startOffset;
        public int endOffset;

        public Color getForegroundColor() {
            if (this.foregroundHighlight != null && this.foregroundHighlight.getUseForegroundColor()) {
                return this.foregroundHighlight.getForegroundColor();
            }
            return this.syntaxStyle.getForegroundColor();
        }

        public Color getBackgroundColor() {
            if (this.backgroundHighlight != null && this.backgroundHighlight.getUseBackgroundColor()) {
                return this.backgroundHighlight.getBackgroundColor();
            }
            return this.syntaxStyle.getBackgroundColor();
        }

        public int getFontStyle() {
            if (this.fontHighlight != null && this.fontHighlight.getUseFontStyle()) {
                return this.fontHighlight.getFontStyle();
            }
            return this.syntaxStyle.getFontStyle();
        }

        protected RenderFragment() {
        }
    }

    protected class LineRowMap
    implements RowMap {
        protected boolean _sameWidthFaces;
        protected int _rowCount;
        protected int _lineCount;
        protected int[] _rowWidths;
        protected int _maxWidth;
        protected int _maxWidthRow;

        void $init$() {
            this._sameWidthFaces = true;
            this._rowCount = -1;
            this._lineCount = -1;
            this._rowWidths = null;
            this._maxWidth = -1;
            this._maxWidthRow = -1;
        }

        protected LineRowMap() {
            this.$init$();
            this.rebuildRowMap();
        }

        protected RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList) {
            return new LineRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
        }

        protected void rebuildRowMap() {
            this.checkFontFaces();
            this._maxWidthRow = -1;
            this._maxWidth = -1;
            this._rowCount = 1;
            this._lineCount = 1;
            this.handleInsert(0);
        }

        protected void revalidateRowMap() {
            this.revalidateRows(0, this._rowCount);
        }

        protected void handleInsert(int n) {
            int n2 = this._lineCount;
            int n3 = BasicView.ra$_lineMap(BasicView.this).getLineCount();
            int n4 = n3 - n2;
            int n5 = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n);
            int n6 = 1;
            int n7 = n5;
            int n8 = n4 + 1;
            this.recalculateRows(n5, n6, n7, n8);
            this._lineCount = n3;
        }

        protected void handleRemove(int n) {
            int n2 = this._lineCount;
            int n3 = BasicView.ra$_lineMap(BasicView.this).getLineCount();
            int n4 = n3 - n2;
            int n5 = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n);
            int n6 = 1 - n4;
            int n7 = n5;
            int n8 = 1;
            this.recalculateRows(n5, n6, n7, n8);
            this._lineCount = n3;
        }

        protected void invalidateMaxWidthRow(int n, int n2) {
            if (this._maxWidthRow != -1) {
                int n3 = n + n2;
                if (n <= this._maxWidthRow && this._maxWidthRow < n3) {
                    this._maxWidthRow = -1;
                    this._maxWidth = -1;
                }
            }
        }

        protected void recalculateRows(int n, int n2, int n3, int n4) {
            try {
                if (n != n3) {
                    throw new IllegalStateException("non-matching row/line");
                }
                this.invalidateMaxWidthRow(n, n2);
                int n5 = this._rowCount;
                int n6 = n4 - n2;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                if (this._rowWidths == null) {
                    this._rowWidths = new int[20];
                }
                int[] nArray = this._rowWidths;
                int[] nArray2 = this._rowWidths;
                if (n6 < 0) {
                    int n10 = -n6;
                    n9 = n + 1;
                    n8 = n9 + n10;
                    n7 = n5 - n8;
                } else if (n6 > 0) {
                    int n11;
                    int n12 = n6;
                    n8 = n + 1;
                    n9 = n8 + n12;
                    n7 = n5 - n8;
                    int n13 = this._rowWidths != null ? this._rowWidths.length : 0;
                    if (n13 < (n11 = BasicView.ra$_lineMap(BasicView.this).getLineCount())) {
                        int n14 = (int)((float)n11 * 0.1f);
                        n14 = Math.min(500, n14);
                        n14 = Math.max(25, n14);
                        nArray2 = this._rowWidths = new int[n11 += n14];
                        if (nArray != null && n > 0) {
                            System.arraycopy(nArray, 0, nArray2, 0, n);
                        }
                    }
                }
                if (n7 > 0) {
                    System.arraycopy(nArray, n8, nArray2, n9, n7);
                }
                this._rowCount = BasicView.ra$_lineMap(BasicView.this).getLineCount();
                this.recalculateLineWidths(n, n4);
                this.updateMaxRowWidth();
            }
            catch (RuntimeException runtimeException) {
                System.out.println("Exception occurred updating RowMap: " + runtimeException.getMessage());
                System.out.println("  startRow: " + n);
                System.out.println("  numRows: " + n2);
                System.out.println("  startLine: " + n3);
                System.out.println("  numLines: " + n4);
                System.out.println("  _rowCount: " + this._rowCount);
                System.out.println("  lineCount: " + BasicView.ra$_lineMap(BasicView.this).getLineCount());
                System.out.println();
                System.out.println("Stack trace follows");
                runtimeException.printStackTrace(System.out);
                System.out.println();
                System.out.println("Forcing RowMap rebuild");
                this.rebuildRowMap();
            }
        }

        protected void recalculateLineWidths(int n, int n2) {
            if (this._sameWidthFaces) {
                FontMetrics fontMetrics = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(3, (Component)BasicView.ra$_editor(BasicView.this));
                int n3 = this._rowWidths.length;
                int n4 = n + n2;
                int n5 = n;
                while (n5 < n4) {
                    if (n3 <= n5) {
                        new RuntimeException().printStackTrace();
                        break;
                    }
                    int n6 = this._rowWidths[n5] = this.calculateLineWidth(fontMetrics, n5);
                    if (this._maxWidth != -1 && n6 > this._maxWidth) {
                        this._maxWidth = n6;
                        this._maxWidthRow = n5;
                    }
                    ++n5;
                }
            } else {
                int n7 = 200;
                int n8 = n;
                int n9 = n + n2;
                int n10 = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n8);
                int n11 = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(n9);
                HighlightFragmentsList highlightFragmentsList = BasicView.mav$renderFontHighlights(BasicView.this, n10, n11);
                int n12 = n2;
                int n13 = n;
                DocumentRenderer documentRenderer = BasicView.mav$getDocumentRenderer(BasicView.this);
                while (n12 > 0) {
                    int n14 = Math.min(n12, 200);
                    int n15 = n13;
                    int n16 = n15 + n14 - 1;
                    StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n15, n16);
                    LineRenderFragmentGenerator lineRenderFragmentGenerator = new LineRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
                    int n17 = n15;
                    while (n17 <= n16) {
                        int n18 = this._rowWidths[n17] = this.calculateLineWidth(lineRenderFragmentGenerator, n17);
                        if (this._maxWidth != -1 && n18 > this._maxWidth) {
                            this._maxWidth = n18;
                            this._maxWidthRow = n17;
                        }
                        ++n17;
                    }
                    if (styledFragmentsList != null) {
                        styledFragmentsList.clear();
                        documentRenderer.recycleFragmentsList(styledFragmentsList);
                    }
                    n12 -= n14;
                }
                BasicView.maS$freeHighlightFragmentsList(highlightFragmentsList);
            }
        }

        protected int calculateLineWidth(RenderFragmentGenerator renderFragmentGenerator, int n) {
            int n2 = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n);
            int n3 = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(n);
            int n4 = BasicView.mav$getXCoordinateForOffset(BasicView.this, renderFragmentGenerator, n2, n3);
            return n4;
        }

        protected int calculateLineWidth(FontMetrics fontMetrics, int n) {
            int n2 = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n);
            int n3 = BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(n);
            int n4 = BasicView.mav$getTabbedTextWidth(BasicView.this, fontMetrics, n2, n3, 0);
            return n4;
        }

        protected void revalidateRows(int n, int n2) {
            if (this._sameWidthFaces) {
                return;
            }
            this.invalidateMaxWidthRow(n, n2);
            this.recalculateLineWidths(n, n2);
            this.updateMaxRowWidth();
        }

        protected void updateMaxRowWidth() {
            if (this._maxWidth == -1) {
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                while (n3 < this._rowCount) {
                    int n4 = this._rowWidths[n3];
                    if (n4 > n2) {
                        n2 = n4;
                        n = n3;
                    }
                    ++n3;
                }
                this._maxWidth = n2;
                this._maxWidthRow = n;
            }
        }

        protected int getMaxRowWidth() {
            return this._maxWidth;
        }

        protected void checkFontFaces() {
            boolean bl = BasicView.ra$_editor(BasicView.this).getBooleanProperty("check-same-width-faces");
            if (bl) {
                FontMetrics fontMetrics = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(0, (Component)BasicView.ra$_editor(BasicView.this));
                FontMetrics fontMetrics2 = BasicView.ra$_fontHelper(BasicView.this).getFontMetrics(3, (Component)BasicView.ra$_editor(BasicView.this));
                this._sameWidthFaces = fontMetrics.charWidth('i') == fontMetrics2.charWidth('i') && fontMetrics.charWidth('m') == fontMetrics2.charWidth('m') && fontMetrics.charWidth('w') == fontMetrics2.charWidth('w');
            } else {
                this._sameWidthFaces = false;
            }
        }

        private void notYetImplemented() {
            throw new IllegalStateException("implement me");
        }

        protected void documentChanged(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                this.handleInsert(n);
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                this.handleRemove(n);
            }
        }

        protected boolean rowEndIsLineEnd(int n) {
            int n2 = this.getRowCount() - 1;
            if (n == n2) {
                return true;
            }
            int n3 = this.getRowEndOffset(n);
            int n4 = this.getRowStartLine(n + 1);
            return n3 == BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n4);
        }

        public BasicEditorPane getEditorPane() {
            return BasicView.ra$_editor(BasicView.this);
        }

        public int getRowCount() {
            return BasicView.ra$_lineMap(BasicView.this).getLineCount();
        }

        public int getRowFromOffset(int n) {
            return BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n);
        }

        public int getRowStartOffset(int n) {
            return BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n);
        }

        public int getRowEndOffset(int n) {
            return BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(n);
        }

        public int getRowStartLine(int n) {
            return n;
        }
    }

    protected static class CollapsedInfo {
        protected int _row;
        protected int _line;
        protected int _span;
        protected int _width;

        protected CollapsedInfo() {
        }
    }

    protected class FoldedRowMap
    extends LineRowMap {
        protected CollapsedBlocks _collapsedBlocks;
        protected int _collapsedLines;
        protected int _maxFoldedWidth;
        protected CollapsedInfo[] _collapsedInfo;

        void $init$() {
            this._collapsedBlocks = BasicView.ra$UNCOLLAPSED_VIEW();
            this._collapsedLines = 0;
            this._maxFoldedWidth = 0;
            this._collapsedInfo = BasicView.ra$UNCOLLAPSED_VIEW_INFO();
        }

        protected RenderFragmentGenerator createRenderFragmentGenerator(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList) {
            return new FoldedRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList, this._collapsedBlocks);
        }

        protected synchronized void rebuildFoldedMap() {
            if (BasicView.ra$_foldingModel(BasicView.this) != null) {
                try {
                    this._collapsedBlocks = new CollapsedBlocks(BasicView.ra$_foldingModel(BasicView.this));
                    this.rebuildCollapsedInfo();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Failed to build folding model: " + runtimeException.getMessage());
                    runtimeException.printStackTrace();
                }
            }
            this._collapsedBlocks = BasicView.ra$UNCOLLAPSED_VIEW();
            this._collapsedInfo = BasicView.ra$UNCOLLAPSED_VIEW_INFO();
            this._collapsedLines = 0;
            this._maxFoldedWidth = 0;
        }

        protected void revalidateRowMap() {
            super.revalidateRowMap();
        }

        protected void recalculateFoldedWidths() {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = this._collapsedInfo.length;
            int n5 = 0;
            while (n5 < n4) {
                CollapsedInfo collapsedInfo = this._collapsedInfo[n5];
                int n6 = collapsedInfo._row;
                if (n6 == n) {
                    collapsedInfo._width = n2;
                } else {
                    int n7 = this.getRowEndOffset(n6);
                    n2 = collapsedInfo._width = BasicView.mav$getXCoordinateForOffset(BasicView.this, n6, n7);
                    n3 = Math.max(n3, n2);
                    n = n6;
                }
                ++n5;
            }
            this._maxFoldedWidth = n3;
        }

        protected void rebuildCollapsedInfo() {
            int n = this._collapsedBlocks._numBlocks;
            ArrayList<CollapsedInfo> arrayList = new ArrayList<CollapsedInfo>(n);
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = this._collapsedBlocks._blockStarts[n3];
                int n5 = this._collapsedBlocks._blockEnds[n3];
                int n6 = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n4);
                int n7 = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n5);
                int n8 = n7 - n6 + 1;
                CollapsedInfo collapsedInfo = new CollapsedInfo();
                collapsedInfo._line = n6;
                collapsedInfo._width = -1;
                collapsedInfo._span = n8;
                collapsedInfo._row = n6 - n2;
                arrayList.add(collapsedInfo);
                n2 += n8 - 1;
                ++n3;
            }
            this._collapsedLines = n2;
            this._collapsedInfo = arrayList.toArray(new CollapsedInfo[arrayList.size()]);
            this.recalculateFoldedWidths();
        }

        protected void documentChanged(DocumentEvent documentEvent) {
            super.documentChanged(documentEvent);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                this._collapsedBlocks.insertUpdate(documentEvent);
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                this._collapsedBlocks.removeUpdate(documentEvent);
            }
            this.rebuildFoldedMap();
        }

        protected int getMaxRowWidth() {
            int n = super.getMaxRowWidth();
            return Math.max(this._maxFoldedWidth, n);
        }

        protected synchronized int getRowForLine(int n) {
            int n2 = this._collapsedInfo.length;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                CollapsedInfo collapsedInfo = this._collapsedInfo[n4];
                if (collapsedInfo._line >= n) break;
                n3 = n < collapsedInfo._line + collapsedInfo._span ? (n3 += n - collapsedInfo._line) : (n3 += collapsedInfo._span - 1);
                ++n4;
            }
            int n5 = n - n3;
            return n5;
        }

        protected synchronized int getLineForRow(int n) {
            int n2 = this._collapsedInfo.length;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                CollapsedInfo collapsedInfo = this._collapsedInfo[n4];
                if (collapsedInfo._row >= n) break;
                n3 += collapsedInfo._span - 1;
                ++n4;
            }
            int n5 = n + n3;
            return n5;
        }

        public int getRowCount() {
            int n = super.getRowCount();
            int n2 = n - this._collapsedLines;
            return n2;
        }

        public int getRowFromOffset(int n) {
            int n2 = BasicView.ra$_lineMap(BasicView.this).getLineFromOffset(n);
            int n3 = this.getRowForLine(n2);
            return n3;
        }

        public int getRowStartOffset(int n) {
            int n2 = this.getRowStartLine(n);
            int n3 = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n2);
            return n3;
        }

        public int getRowEndOffset(int n) {
            int n2 = this.getRowCount() - 1;
            if (n == n2) {
                int n3 = BasicView.ra$_lineMap(BasicView.this).getLineCount() - 1;
                return BasicView.ra$_lineMap(BasicView.this).getLineEndOffset(n3);
            }
            int n4 = this.getRowStartLine(n + 1);
            int n5 = BasicView.ra$_lineMap(BasicView.this).getLineStartOffset(n4);
            return n5;
        }

        public int getRowStartLine(int n) {
            return this.getLineForRow(n);
        }

        protected FoldedRowMap() {
            this.$init$();
        }
    }

    protected class FoldedRenderFragmentGenerator
    implements RenderFragmentGenerator {
        private RenderFragmentGenerator _generator;
        private CollapsedBlocks _blocks;
        private int _lastOffset;
        private int _currentBlock;
        private HighlightStyle _foldedStyle;
        protected RenderFragment _currentFragment;

        protected FoldedRenderFragmentGenerator(StyledFragmentsList styledFragmentsList, HighlightFragmentsList highlightFragmentsList, CollapsedBlocks collapsedBlocks) {
            this.$init$();
            this._generator = new LineRenderFragmentGenerator(styledFragmentsList, highlightFragmentsList);
            this._blocks = collapsedBlocks;
            this._foldedStyle = BasicView.mav$lookupHighlight(BasicView.this, BasicView.FOLDED_BLOCK_HIGHLIGHT);
            RenderFragment renderFragment = this._generator.current();
            if (renderFragment == null) {
                this._currentFragment = null;
                return;
            }
            this._lastOffset = renderFragment.startOffset;
            this._currentBlock = 0;
            this.next();
        }

        public RenderFragment current() {
            return this._currentFragment;
        }

        public RenderFragment next() {
            if (this._currentFragment == null) {
                return null;
            }
            try {
                RenderFragment renderFragment = this.nextImpl();
                return renderFragment;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RenderFragment renderFragment = this._currentFragment = null;
                return renderFragment;
            }
        }

        protected RenderFragment nextImpl() {
            int n = -1;
            int n2 = -1;
            String string = null;
            while (this._currentBlock < this._blocks._numBlocks) {
                n = this._blocks._blockStarts[this._currentBlock];
                n2 = this._blocks._blockEnds[this._currentBlock];
                string = this._blocks._blockTexts[this._currentBlock];
                if (string == null) {
                    string = "<**ERROR in CodeFoldingModel: No replacement text for block**>";
                }
                if (n2 > this._lastOffset) break;
                ++this._currentBlock;
                n2 = -1;
                n = -1;
                string = null;
            }
            RenderFragment renderFragment = this._generator.current();
            while (renderFragment != null && renderFragment.endOffset <= this._lastOffset) {
                renderFragment = this._generator.next();
            }
            if (renderFragment == null) {
                this._currentFragment = null;
                return null;
            }
            int n3 = renderFragment.startOffset;
            n3 = Math.max(n3, this._lastOffset);
            int n4 = renderFragment.endOffset;
            if (n == n3) {
                BaseStyle baseStyle;
                this._currentFragment.syntaxStyle = baseStyle = BasicView.mav$lookupStyle(BasicView.this, "base-plain-style");
                this._currentFragment.startOffset = n;
                this._currentFragment.endOffset = n2;
                this._currentFragment.textToUse = string;
                this._currentFragment.backgroundHighlight = null;
                this._currentFragment.foregroundHighlight = null;
                this._currentFragment.fontHighlight = null;
                HighlightStyle highlightStyle = renderFragment.backgroundHighlight;
                HighlightStyle highlightStyle2 = renderFragment.foregroundHighlight;
                HighlightStyle highlightStyle3 = renderFragment.fontHighlight;
                while (renderFragment.endOffset < n2) {
                    renderFragment = this._generator.next();
                    if (renderFragment == null) break;
                    if (n2 <= renderFragment.startOffset) continue;
                    if (renderFragment.backgroundHighlight != highlightStyle) {
                        highlightStyle = null;
                    }
                    if (renderFragment.foregroundHighlight != highlightStyle2) {
                        highlightStyle2 = null;
                    }
                    if (renderFragment.fontHighlight == highlightStyle3) continue;
                    highlightStyle3 = null;
                }
                if (this._foldedStyle != null && this._foldedStyle.getEnabled()) {
                    if (this._foldedStyle.getUseBackgroundColor() && (highlightStyle == null || highlightStyle.getPriority() < this._foldedStyle.getPriority())) {
                        highlightStyle = this._foldedStyle;
                    }
                    if (this._foldedStyle.getUseForegroundColor() && (highlightStyle2 == null || highlightStyle2.getPriority() < this._foldedStyle.getPriority())) {
                        highlightStyle2 = this._foldedStyle;
                    }
                    if (this._foldedStyle.getUseFontStyle() && (highlightStyle3 == null || highlightStyle3.getPriority() < this._foldedStyle.getPriority())) {
                        highlightStyle3 = this._foldedStyle;
                    }
                }
                this._currentFragment.backgroundHighlight = highlightStyle;
                this._currentFragment.foregroundHighlight = highlightStyle2;
                this._currentFragment.fontHighlight = highlightStyle3;
                ++this._currentBlock;
                this._lastOffset = n2;
                return this._currentFragment;
            }
            if (n != -1) {
                n4 = Math.min(n4, n);
            }
            this._currentFragment.syntaxStyle = renderFragment.syntaxStyle;
            this._currentFragment.startOffset = n3;
            this._currentFragment.endOffset = n4;
            this._currentFragment.textToUse = null;
            this._currentFragment.backgroundHighlight = renderFragment.backgroundHighlight;
            this._currentFragment.foregroundHighlight = renderFragment.foregroundHighlight;
            this._currentFragment.fontHighlight = renderFragment.fontHighlight;
            this._lastOffset = n4;
            return this._currentFragment;
        }

        void $init$() {
            this._currentFragment = new RenderFragment();
        }
    }

    protected static class BlockSorter
    implements Comparator {
        protected final int[] TEMP_SORT_OFFSETS;
        private CodeFoldingModel _model;

        void $init$() {
            this.TEMP_SORT_OFFSETS = new int[2];
        }

        protected BlockSorter(CodeFoldingModel codeFoldingModel) {
            this.$init$();
            this._model = codeFoldingModel;
        }

        public int compare(Object object, Object object2) {
            this._model.getTextOffsets(object, this.TEMP_SORT_OFFSETS);
            int n = this.TEMP_SORT_OFFSETS[0];
            int n2 = this.TEMP_SORT_OFFSETS[1];
            this._model.getTextOffsets(object2, this.TEMP_SORT_OFFSETS);
            int n3 = this.TEMP_SORT_OFFSETS[0];
            int n4 = this.TEMP_SORT_OFFSETS[1];
            if (n <= n3 && n3 < n2 || n < n4 && n4 <= n2 || n3 <= n && n < n4 || n3 < n2 && n2 <= n4) {
                throw new IllegalStateException("nested or overlapping blocks,  s1 = " + n + " e1 = " + n2 + " s2 = " + n3 + " e2 = " + n4);
            }
            return n - n3;
        }

        public boolean equals(Object object) {
            return object instanceof BlockSorter && this._model == ((BlockSorter)object)._model;
        }
    }

    protected static class CollapsedBlocks {
        protected int[] _blockStarts;
        protected int[] _blockEnds;
        protected String[] _blockTexts;
        protected Object[] _blocks;
        protected int _numBlocks;
        protected CodeFoldingModel _model;
        protected final int[] TEMP_OFFSETS;

        protected CollapsedBlocks(CodeFoldingModel codeFoldingModel) {
            this.$init$();
            this._model = codeFoldingModel;
            if (codeFoldingModel != null) {
                this.buildList(codeFoldingModel);
            }
        }

        void $init$() {
            this.TEMP_OFFSETS = new int[2];
        }

        protected void buildList(CodeFoldingModel codeFoldingModel) {
            codeFoldingModel.readLock();
            try {
                Object[] objectArray = codeFoldingModel.getCollapsedBlocks();
                Arrays.sort(objectArray, new BlockSorter(codeFoldingModel));
                int n = objectArray.length;
                this.initializeCapacity(n);
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.addBlock(codeFoldingModel, object);
                    ++n2;
                }
            }
            finally {
                codeFoldingModel.readUnlock();
            }
        }

        protected void initializeCapacity(int n) {
            this._blockStarts = new int[n];
            this._blockEnds = new int[n];
            this._blockTexts = new String[n];
            this._blocks = new Object[n];
        }

        protected void ensureCapacity() {
            int n = this._numBlocks + 1;
            int n2 = this._blocks != null ? this._blocks.length : 0;
            if (n > n2) {
                int n3 = (int)((float)n * 0.1f);
                n3 = Math.min(500, n3);
                n3 = Math.max(25, n3);
                int n4 = n3 + n;
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                String[] stringArray = new String[n4];
                Object[] objectArray = new Object[n4];
                if (this._numBlocks > 0) {
                    System.arraycopy(this._blockStarts, 0, nArray, 0, this._numBlocks);
                    System.arraycopy(this._blockEnds, 0, nArray2, 0, this._numBlocks);
                    System.arraycopy(this._blockTexts, 0, stringArray, 0, this._numBlocks);
                    System.arraycopy(this._blocks, 0, objectArray, 0, this._numBlocks);
                }
                this._blockStarts = nArray;
                this._blockEnds = nArray2;
                this._blockTexts = stringArray;
                this._blocks = objectArray;
            }
        }

        protected boolean insertUpdate(DocumentEvent documentEvent) {
            if (this._model == null) {
                return false;
            }
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            this._model.readLock();
            try {
                int n3 = 0;
                while (n3 < this._numBlocks) {
                    if (n <= this._blockStarts[n3]) {
                        int n4 = n3;
                        this._blockStarts[n4] = this._blockStarts[n4] + n2;
                    }
                    if (n < this._blockEnds[n3]) {
                        int n5 = n3;
                        this._blockEnds[n5] = this._blockEnds[n5] + n2;
                    }
                    Object object = this._blocks[n3];
                    boolean bl = this._model.isExpanded(object);
                    this._model.getTextOffsets(object, this.TEMP_OFFSETS);
                    int n6 = this.TEMP_OFFSETS[0];
                    int n7 = this.TEMP_OFFSETS[1];
                    if (bl || n6 != this._blockStarts[n3] || n7 != this._blockEnds[n3]) {
                        boolean bl2 = false;
                        this._model.readUnlock();
                        return bl2;
                    }
                    ++n3;
                }
            }
            finally {
                this._model.readUnlock();
            }
            return true;
        }

        protected boolean removeUpdate(DocumentEvent documentEvent) {
            if (this._model == null) {
                return false;
            }
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = n + n2;
            this._model.readLock();
            try {
                int n4 = 0;
                while (n4 < this._numBlocks) {
                    if (this._blockStarts[n4] >= n3) {
                        int n5 = n4;
                        this._blockStarts[n5] = this._blockStarts[n5] - n2;
                    } else if (this._blockStarts[n4] > n) {
                        this._blockStarts[n4] = n;
                    }
                    if (this._blockEnds[n4] >= n3) {
                        int n6 = n4;
                        this._blockEnds[n6] = this._blockEnds[n6] - n2;
                    } else if (this._blockEnds[n4] > n) {
                        this._blockEnds[n4] = n;
                    }
                    Object object = this._blocks[n4];
                    boolean bl = this._model.isExpanded(object);
                    this._model.getTextOffsets(object, this.TEMP_OFFSETS);
                    int n7 = this.TEMP_OFFSETS[0];
                    int n8 = this.TEMP_OFFSETS[1];
                    if (bl || n7 != this._blockStarts[n4] || n8 != this._blockEnds[n4]) {
                        boolean bl2 = false;
                        this._model.readUnlock();
                        return bl2;
                    }
                    ++n4;
                }
            }
            finally {
                this._model.readUnlock();
            }
            return true;
        }

        protected void addBlock(CodeFoldingModel codeFoldingModel, Object object) {
            this._model.getTextOffsets(object, this.TEMP_OFFSETS);
            int n = this.TEMP_OFFSETS[0];
            int n2 = this.TEMP_OFFSETS[1];
            if (n == n2) {
                return;
            }
            this.ensureCapacity();
            this._blocks[this._numBlocks] = object;
            this._blockStarts[this._numBlocks] = n;
            this._blockEnds[this._numBlocks] = n2;
            this._blockTexts[this._numBlocks] = codeFoldingModel.getAbbreviatedText(object);
            ++this._numBlocks;
        }

        public boolean equals(Object object) {
            if (object instanceof CollapsedBlocks) {
                CollapsedBlocks collapsedBlocks = this;
                int n = collapsedBlocks._numBlocks;
                CollapsedBlocks collapsedBlocks2 = (CollapsedBlocks)object;
                int n2 = collapsedBlocks2._numBlocks;
                if (n == n2 && this.equals(collapsedBlocks._blockStarts, collapsedBlocks2._blockStarts, n) && this.equals(collapsedBlocks._blockEnds, collapsedBlocks2._blockEnds, n) && this.equals(collapsedBlocks._blockTexts, collapsedBlocks2._blockTexts, n)) {
                    return true;
                }
            }
            return false;
        }

        protected boolean equals(int[] nArray, int[] nArray2, int n) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (nArray[n2] != nArray2[n2]) {
                    return false;
                }
                --n2;
            }
            return true;
        }

        protected boolean equals(String[] stringArray, String[] stringArray2, int n) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (!stringArray[n2].equals(stringArray2[n2])) {
                    return false;
                }
                --n2;
            }
            return true;
        }
    }
}

