/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.MissingResourceException;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.keys.KeyHandlerFactory;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.resource.BundleHelper;

public final class EditorProperties {
    public static final String PROPERTY_STYLE_REGISTRY = "style-registry";
    public static final String PROPERTY_STYLE_CHANGED = "style-changed";
    public static final String PROPERTY_LANGUAGE_SUPPORT = "language-support";
    public static final String PROPERTY_EDITOR_ANTIALIASING = "editor-antialiasing";
    public static final String PROPERTY_EDITOR_ITALIC_ANTIALIASING = "editor-italic-antialiasing";
    public static final String PROPERTY_EDITOR_ANTIALIASING_SET = "editor-antialiasing-set";
    public static final String PROPERTY_EDITOR_WIDTH = "editor-width";
    public static final String PROPERTY_HIGHLIGHT_REGISTRY = "highlight-registry";
    public static final String PROPERTY_HIGHLIGHT_CHANGED = "highlight-changed";
    public static final String PROPERTY_EDITOR_FONT_HELPER = "font-helper";
    public static final String PROPERTY_EDITOR_FONT = "editor-font";
    public static final String PROPERTY_EDITOR_FONT_FAMILY = "editor-font-family";
    public static final String PROPERTY_EDITOR_FONT_SIZE = "editor-font-size";
    public static final String PROPERTY_RIGHT_MARGIN_COLUMN = "right-margin-column";
    public static final String PROPERTY_RIGHT_MARGIN_VISIBLE = "right-margin-visible";
    public static final String PROPERTY_RIGHT_MARGIN_COLOR = "right-margin-color";
    public static final String PROPERTY_TRAILING_BLANK_ROWS = "trailing-blank-rows";
    public static final String PROPERTY_TRAILING_BLANK_COLUMNS = "trailing-blank-columns";
    public static final String PROPERTY_BRACE_MATCHING_AUTO = "brace-matching-auto";
    public static final String PROPERTY_BRACE_MATCHING_ENCLOSING_BLOCKS = "brace-matching-enclosing-blocks";
    public static final String PROPERTY_BRACE_MATCHING_ENCLOSING_PARENS = "brace-matching-enclosing-parens";
    public static final String PROPERTY_BRACE_MATCHING_DELAY = "brace-matching-delay";
    public static final String PROPERTY_SHOW_LINE_NUMBERS = "show-line-numbers";
    public static final int GUTTER_COLORS_USE_LNF = 1;
    public static final int GUTTER_COLORS_USE_EDITOR = 2;
    public static final int GUTTER_COLORS_USE_CUSTOM = 3;
    public static final String PROPERTY_GUTTER_COLOR_SOURCE = "gutter-color-source";
    public static final String PROPERTY_GUTTER_CUSTOM_BGCOLOR = "gutter-custom-bgcolor";
    public static final String PROPERTY_GUTTER_CUSTOM_FGCOLOR = "gutter-custom-fgcolor";
    public static final String PROPERTY_GUTTER_DEFAULT_BORDERCOLOR = "gutter-default-bordercolor";
    public static final String PROPERTY_GUTTER_SHARED_COLUMN = "gutter-shared-column";
    public static final String PROPERTY_GUTTER_ENABLE_DRAGGING = "gutter-enable-selection";
    public static final String PROPERTY_CODE_FOLDING_MODEL = "code-folding-model";
    public static final String PROPERTY_CODE_FOLDING_MARGIN = "code-folding-margin";
    public static final String PROPERTY_CODE_FOLDING_MARGIN_VISIBLE = "code-folding-margin-visible";
    public static final String PROPERTY_CODE_FOLDING_HIGHLIGHT = "code-folding-highlight";
    public static final String PROPERTY_CODE_FOLDING_ENABLED = "code-folding-enabled";
    public static final String PROPERTY_INDENT_SIZE = "indent-size";
    public static final String PROPERTY_TAB_SIZE = "tab-size";
    public static final String PROPERTY_USE_AUTO_INDENT = "use-auto-indent";
    public static final String PROPERTY_USE_SMART_INDENT = "use-smart-indent";
    public static final String PROPERTY_USE_TAB_CHARACTER = "use-tabs";
    public static final String PROPERTY_USE_SMART_HOME = "use-smart-home";
    public static final String PROPERTY_USE_SMART_END = "use-smart-end";
    public static final String PROPERTY_DO_BLOCK_INDENTS_ON_SELECTION = "do-block-indents-on-selection";
    public static final String PROPERTY_WORD_BOUNDARY_USE_LINE_START = "word-boundary-use-line-start";
    public static final String PROPERTY_WORD_BOUNDARY_USE_LINE_END = "word-boundary-use-line-end";
    public static final String PROPERTY_USE_JUMP_SCROLL = "use-jump-scroll";
    public static final String PROPERTY_CARET_INSET_ROWS = "caret-inset-rows";
    public static final String PROPERTY_CARET_INSET_COLUMNS = "caret-inset-columns";
    public static final String PROPERTY_COMPLETION_ENABLE_POPUP = "completion-enable-autopopup";
    public static final String PROPERTY_COMPLETION_POPUP_DELAY = "completion-popup-delay";
    public static final String PROPERTY_PARAMETER_ENABLE_POPUP = "parameter-enable-autopopup";
    public static final String PROPERTY_PARAMETER_POPUP_DELAY = "parameter-popup-delay";
    public static final String PROPERTY_INSIGHT_FONT_FAMILY = "insight-font-family";
    public static final String PROPERTY_INSIGHT_FONT_SIZE = "insight-font-size";
    public static final String PROPERTY_INSIGHT_PARTIAL_COMPLETE_SINGLE = "insight-partial-complete-single";
    public static final String PROPERTY_INSIGHT_MANUAL_COMPLETE_SINGLE = "insight-manual-complete-single";
    public static final String PROPERTY_INSIGHT_TYPED_COMPLETE_SINGLE = "insight-typed-complete-single";
    public static final String PROPERTY_INSIGHT_NEWDATA_COMPLETE_SINGLE = "insight-newdata-complete-single";
    public static final String PROPERTY_INSIGHT_FILTER_MATCHING = "insight-filter-matching";
    public static final String PROPERTY_INSIGHT_MAX_POPUP_WIDTH = "insight-max-popup-width";
    public static final String PROPERTY_CHECK_FRAGLIST_RECYCLING = "check-fraglist-recycling";
    public static final String PROPERTY_REUSE_UNDOABLE_EDIT = "reuse-undoable-edit";
    public static final String PROPERTY_REUSE_DOCUMENT_EVENT = "reuse-document-event";
    public static final String PROPERTY_CHECK_CLIPBOARD_FOR_PASTE = "check-clipboard-for-paste";
    public static final String PROPERTY_CONSUME_KEY_RELEASE = "consume-key-release";
    public static final String PROPERTY_CHECK_SAME_WIDTH_FACES = "check-same-width-faces";
    public static final String PROPERTY_CUT_COPY_LINE = "cut-copy-line";
    public static final String PROPERTY_IMPORTS_COPY_PASTE = "smart-copy-paste";
    public static final String PROPERTY_AUTOINDENT_COPY_PASTE = "autoindent-copy-paste";
    public static final String PROPERTY_ESCAPESTRING_PASTE = "escape-string-paste";
    public static final String PROPERTY_TOGGLE_COMMENTS_ADVANCE = "toggle-comments-advance";
    public static final String PROPERTY_CARET_COLOR = "caret-color";
    public static final String PROPERTY_CARET_SHAPE_INSERT = "caret-shape-insert";
    public static final String PROPERTY_CARET_SHAPE_OVERWRITE = "caret-shape-overwrite";
    public static final String PROPERTY_CARET_ENABLE_BLINK = "caret-enable-blink";
    public static final String PROPERTY_CARET_BLINK_RATE = "caret-blink-rate";
    public static final String PROPERTY_CARET_XOR_PAINTING = "caret-xor-painting";
    public static final String PROPERTY_CARET_RIGHT_CLICK_SELECTION = "caret-right-click-selection";
    public static final String PROPERTY_MERGE_TYPED_INSERT = "merge-typed-insert";
    public static final String PROPERTY_MERGE_TYPED_REPLACE = "merge-typed-replace";
    public static final String PROPERTY_MERGE_DELETE_NEXT = "merge-delete-next";
    public static final String PROPERTY_MERGE_DELETE_PREVIOUS = "merge-delete-previous";
    public static final String PROPERTY_EDIT_MERGE_COUNT = "edit-merge-count";
    public static final String PROPERTY_MERGE_NAVIGATION = "merge-navigation";
    public static final String PROPERTY_UNDO_NAVIGATION = "undo-navigation";
    public static final String PROPERTY_NAVIGATION_MERGE_COUNT = "navigation-merge-count";
    public static final String PROPERTY_KEY_HANDLERS = "key-handlers";
    public static final String PROPERTY_SELECTED_HANDLER = "selected-handler";
    public static final String PROPERTY_MACRO_PLAYBACK_DELAY = "macro-playback-delay";
    private static BundleHelper editorBundle;
    private WeakPropertyChangeSupport changeSupport;
    private HashMap properties = new HashMap(10);
    private static EditorProperties singleton;

    static {
        singleton = new EditorProperties();
        singleton.installPropertyDefaults();
        EditorProperties.getEditorBundle();
    }

    private EditorProperties() {
        this.changeSupport = new WeakPropertyChangeSupport(this);
    }

    public static EditorProperties getProperties() {
        return singleton;
    }

    private void installPropertyDefaults() {
        this.putIntegerProperty(PROPERTY_INDENT_SIZE, 2);
        this.putIntegerProperty(PROPERTY_TAB_SIZE, 8);
        this.putBooleanProperty(PROPERTY_USE_AUTO_INDENT, true);
        this.putBooleanProperty(PROPERTY_USE_SMART_INDENT, true);
        this.putBooleanProperty(PROPERTY_USE_TAB_CHARACTER, false);
        this.putBooleanProperty(PROPERTY_USE_SMART_HOME, false);
        this.putBooleanProperty(PROPERTY_USE_SMART_END, false);
        this.putBooleanProperty(PROPERTY_DO_BLOCK_INDENTS_ON_SELECTION, true);
        this.putBooleanProperty(PROPERTY_WORD_BOUNDARY_USE_LINE_START, false);
        this.putBooleanProperty(PROPERTY_WORD_BOUNDARY_USE_LINE_END, false);
        this.putBooleanProperty(PROPERTY_USE_JUMP_SCROLL, false);
        this.putIntegerProperty(PROPERTY_CARET_INSET_ROWS, 1);
        this.putIntegerProperty(PROPERTY_CARET_INSET_COLUMNS, 4);
        this.putBooleanProperty(PROPERTY_COMPLETION_ENABLE_POPUP, true);
        this.putIntegerProperty(PROPERTY_COMPLETION_POPUP_DELAY, 1000);
        this.putBooleanProperty(PROPERTY_PARAMETER_ENABLE_POPUP, true);
        this.putIntegerProperty(PROPERTY_PARAMETER_POPUP_DELAY, 1000);
        this.putProperty(PROPERTY_INSIGHT_FONT_FAMILY, "Dialog");
        this.putIntegerProperty(PROPERTY_INSIGHT_FONT_SIZE, 12);
        this.putBooleanProperty(PROPERTY_INSIGHT_PARTIAL_COMPLETE_SINGLE, false);
        this.putBooleanProperty(PROPERTY_INSIGHT_MANUAL_COMPLETE_SINGLE, false);
        this.putBooleanProperty(PROPERTY_INSIGHT_TYPED_COMPLETE_SINGLE, false);
        this.putBooleanProperty(PROPERTY_INSIGHT_NEWDATA_COMPLETE_SINGLE, false);
        this.putBooleanProperty(PROPERTY_INSIGHT_FILTER_MATCHING, false);
        this.putIntegerProperty(PROPERTY_INSIGHT_MAX_POPUP_WIDTH, 620);
        this.putBooleanProperty(PROPERTY_MERGE_TYPED_INSERT, true);
        this.putBooleanProperty(PROPERTY_MERGE_TYPED_REPLACE, true);
        this.putBooleanProperty(PROPERTY_MERGE_DELETE_NEXT, true);
        this.putBooleanProperty(PROPERTY_MERGE_DELETE_PREVIOUS, true);
        this.putBooleanProperty(PROPERTY_MERGE_NAVIGATION, true);
        this.putBooleanProperty(PROPERTY_UNDO_NAVIGATION, true);
        this.putIntegerProperty(PROPERTY_EDIT_MERGE_COUNT, 10);
        this.putIntegerProperty(PROPERTY_NAVIGATION_MERGE_COUNT, 20);
        this.putBooleanProperty(PROPERTY_REUSE_UNDOABLE_EDIT, true);
        this.putBooleanProperty(PROPERTY_REUSE_DOCUMENT_EVENT, true);
        this.putBooleanProperty(PROPERTY_CHECK_CLIPBOARD_FOR_PASTE, false);
        this.putBooleanProperty(PROPERTY_CUT_COPY_LINE, false);
        this.putBooleanProperty(PROPERTY_CONSUME_KEY_RELEASE, false);
        this.putBooleanProperty(PROPERTY_CHECK_SAME_WIDTH_FACES, true);
        this.putBooleanProperty(PROPERTY_TOGGLE_COMMENTS_ADVANCE, false);
        this.putBooleanProperty(PROPERTY_CHECK_FRAGLIST_RECYCLING, false);
        this.setBaseFont("DialogInput", 12);
        this.putBooleanProperty(PROPERTY_CODE_FOLDING_MARGIN_VISIBLE, true);
        this.putBooleanProperty(PROPERTY_CODE_FOLDING_HIGHLIGHT, true);
        this.putBooleanProperty(PROPERTY_CODE_FOLDING_ENABLED, false);
        String string = System.getProperty("swing.aatext");
        boolean bl = string == null ? false : Boolean.valueOf(string);
        String string2 = System.getProperty("editor.antialiasing");
        boolean bl2 = string2 == null ? bl : Boolean.valueOf(string2);
        this.putBooleanProperty(PROPERTY_EDITOR_ANTIALIASING, bl2);
        String string3 = System.getProperty("editor.italic.antialiasing");
        boolean bl3 = string3 == null ? false : Boolean.valueOf(string3);
        this.putBooleanProperty(PROPERTY_EDITOR_ITALIC_ANTIALIASING, bl3);
        boolean bl4 = string != null || string2 != null || string3 != null;
        this.putBooleanProperty(PROPERTY_EDITOR_ANTIALIASING_SET, bl4);
        this.putIntegerProperty(PROPERTY_EDITOR_WIDTH, 500);
        this.putIntegerProperty(PROPERTY_RIGHT_MARGIN_COLUMN, 80);
        this.putBooleanProperty(PROPERTY_RIGHT_MARGIN_VISIBLE, true);
        this.putProperty(PROPERTY_RIGHT_MARGIN_COLOR, Color.lightGray);
        this.putIntegerProperty(PROPERTY_TRAILING_BLANK_ROWS, 0);
        this.putIntegerProperty(PROPERTY_TRAILING_BLANK_COLUMNS, 0);
        this.putBooleanProperty(PROPERTY_BRACE_MATCHING_AUTO, true);
        this.putBooleanProperty(PROPERTY_BRACE_MATCHING_ENCLOSING_BLOCKS, false);
        this.putBooleanProperty(PROPERTY_BRACE_MATCHING_ENCLOSING_PARENS, false);
        this.putIntegerProperty(PROPERTY_BRACE_MATCHING_DELAY, 300);
        this.putBooleanProperty(PROPERTY_SHOW_LINE_NUMBERS, true);
        this.putIntegerProperty(PROPERTY_GUTTER_COLOR_SOURCE, 1);
        this.putProperty(PROPERTY_GUTTER_CUSTOM_BGCOLOR, Color.lightGray);
        this.putProperty(PROPERTY_GUTTER_CUSTOM_FGCOLOR, Color.darkGray);
        this.putBooleanProperty(PROPERTY_GUTTER_SHARED_COLUMN, false);
        this.putBooleanProperty(PROPERTY_GUTTER_ENABLE_DRAGGING, true);
        this.putProperty(PROPERTY_CARET_COLOR, Color.black);
        this.putIntegerProperty(PROPERTY_CARET_SHAPE_INSERT, 2);
        this.putIntegerProperty(PROPERTY_CARET_SHAPE_OVERWRITE, 6);
        this.putBooleanProperty(PROPERTY_CARET_ENABLE_BLINK, true);
        this.putIntegerProperty(PROPERTY_CARET_BLINK_RATE, 500);
        boolean bl5 = true;
        String string4 = System.getProperty("os.name");
        if (string4.indexOf("Mac") != -1) {
            bl5 = false;
        }
        this.putBooleanProperty(PROPERTY_CARET_XOR_PAINTING, bl5);
        this.putBooleanProperty(PROPERTY_CARET_RIGHT_CLICK_SELECTION, true);
        this.putIntegerProperty(PROPERTY_MACRO_PLAYBACK_DELAY, 10);
        this.setStyleRegistry(new StyleRegistry());
        this.setHighlightRegistry(new HighlightRegistry());
        LanguageModule.getDefaultModule();
        KeyHandlerFactory.initialize();
        this.putProperty(PROPERTY_KEY_HANDLERS, KeyHandlerFactory.getAvailableHandlers());
        this.setHandlerName("Default");
    }

    public synchronized Object getProperty(String string) {
        return this.properties.get(string);
    }

    public synchronized void putProperty(String string, Object object) {
        Object object2 = this.properties.put(string, object);
        this.firePropertyChange(string, object2, object);
    }

    public synchronized boolean getBooleanProperty(String string) {
        Boolean bl = (Boolean)this.getProperty(string);
        return bl;
    }

    public synchronized void putBooleanProperty(String string, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.putProperty(string, bl2);
    }

    public synchronized int getIntegerProperty(String string) {
        Integer n = (Integer)this.getProperty(string);
        return n;
    }

    public synchronized void putIntegerProperty(String string, int n) {
        Integer n2 = new Integer(n);
        this.putProperty(string, n2);
    }

    public StyleRegistry getStyleRegistry() {
        return (StyleRegistry)this.getProperty(PROPERTY_STYLE_REGISTRY);
    }

    public void setStyleRegistry(StyleRegistry styleRegistry) {
        this.putProperty(PROPERTY_STYLE_REGISTRY, styleRegistry);
    }

    public HighlightRegistry getHighlightRegistry() {
        return (HighlightRegistry)this.getProperty(PROPERTY_HIGHLIGHT_REGISTRY);
    }

    public void setHighlightRegistry(HighlightRegistry highlightRegistry) {
        this.putProperty(PROPERTY_HIGHLIGHT_REGISTRY, highlightRegistry);
    }

    public static BundleHelper getEditorBundle() {
        if (editorBundle == null) {
            try {
                editorBundle = new BundleHelper("oracle.javatools.editor.resource.EditorBundle");
            }
            catch (MissingResourceException missingResourceException) {
                throw new IllegalStateException("Exception loading resource file: " + missingResourceException.getMessage());
            }
        }
        return editorBundle;
    }

    public FontHelper getFontHelper() {
        return (FontHelper)this.getProperty(PROPERTY_EDITOR_FONT_HELPER);
    }

    private void setFontHelper(FontHelper fontHelper) {
        this.putProperty(PROPERTY_EDITOR_FONT_HELPER, fontHelper);
    }

    public Font getBaseFont() {
        return (Font)this.getProperty(PROPERTY_EDITOR_FONT);
    }

    public void setBaseFont(String string, int n) {
        this.putProperty(PROPERTY_EDITOR_FONT_FAMILY, string);
        this.putProperty(PROPERTY_EDITOR_FONT_SIZE, new Integer(n));
        FontHelper fontHelper = this.getFontHelper();
        if (fontHelper == null) {
            fontHelper = new FontHelper(string, n);
            this.setFontHelper(fontHelper);
        } else {
            fontHelper.setBaseFont(string, n);
        }
        Font font = fontHelper.getBaseFont();
        this.putProperty(PROPERTY_EDITOR_FONT, font);
    }

    public void setHandlerName(String string) {
        this.putProperty(PROPERTY_SELECTED_HANDLER, string);
    }

    public String getHandlerName() {
        return (String)this.getProperty(PROPERTY_SELECTED_HANDLER);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }
}

