/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class EmacsAction
extends BasicAction {
    private static ArrayList killRingList = new ArrayList();
    private static int lastYankIndex = -1;
    private static final int MAX_KILL_RING_SIZE = 20;
    private static final String MARK_PROPERTY = "*emacs-mark*";
    private static final String MARK_SET_MESSAGE = "Mark set";
    private static final String MARK_NOT_SET_MESSAGE = "The mark has not been set";
    private static final String END_BUFFER_MESSAGE = "End of buffer";
    private static final String READ_ONLY_MESSAGE = "Buffer is read-only";
    private static final String NEXT_KILL_APPEND = "If next command is a kill, it will append";
    private static final String PREVIOUS_NOT_YANK = "Previous command was not a yank";

    public EmacsAction(String string) {
        super(string);
    }

    public abstract void actionPerformed(ActionEvent var1, BasicEditorPane var2, BasicDocument var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addKillRing(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            killRingList.add(string);
            EmacsAction.checkKillRingSize();
            EmacsAction.setClipboardText(string);
            lastYankIndex = killRingList.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void appendKillRing(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int n;
            Object e;
            int n2 = killRingList.size();
            String string2 = "";
            if (n2 > 0 && (e = killRingList.remove(n = n2 - 1)) != null) {
                string2 = e.toString();
            }
            string2 = string2 + string;
            EmacsAction.addKillRing(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void prependKillRing(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int n;
            Object e;
            int n2 = killRingList.size();
            String string2 = "";
            if (n2 > 0 && (e = killRingList.remove(n = n2 - 1)) != null) {
                string2 = e.toString();
            }
            string2 = string + string2;
            EmacsAction.addKillRing(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String yankKillRing() {
        String string = "";
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            boolean bl = false;
            String string2 = EmacsAction.getClipboardText();
            if (lastYankIndex == -1) {
                bl = true;
            } else {
                int n = killRingList.size();
                String string3 = killRingList.get(n - 1).toString();
                if (!string3.equals(string2)) {
                    bl = true;
                }
            }
            if (bl) {
                EmacsAction.addKillRing(string2);
            }
            if (lastYankIndex != -1) {
                string = killRingList.get(lastYankIndex).toString();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String popKillRing() {
        String string = "";
        ArrayList arrayList = killRingList;
        synchronized (arrayList) {
            int n = killRingList.size();
            if (n > 0) {
                if (--lastYankIndex < 0) {
                    lastYankIndex = n - 1;
                }
                string = killRingList.get(lastYankIndex).toString();
            }
        }
        return string;
    }

    private static void checkKillRingSize() {
        int n = killRingList.size();
        if (n > 20) {
            killRingList.remove(0);
        }
    }

    protected static String getClipboardText() {
        Clipboard clipboard = EmacsAction.getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        String string = "";
        if (transferable != null) {
            try {
                Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                string = (String)object;
            }
            catch (IOException iOException) {
                string = "";
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                string = "";
            }
        }
        return string;
    }

    protected static void setClipboardText(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = EmacsAction.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, null);
    }

    protected static Clipboard getSystemClipboard() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        return clipboard;
    }

    protected static int getMark(BasicEditorPane basicEditorPane) {
        Object object = basicEditorPane.getProperty(MARK_PROPERTY);
        if (object != null) {
            OffsetMark offsetMark = (OffsetMark)object;
            return offsetMark.getOffset();
        }
        return -1;
    }

    protected static void setMark(BasicEditorPane basicEditorPane, int n) {
        Object object = basicEditorPane.getProperty(MARK_PROPERTY);
        if (object != null) {
            OffsetMark offsetMark = (OffsetMark)object;
            offsetMark.setOffset(n);
        } else {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            OffsetMark offsetMark = textBuffer.addOffsetMark(n);
            basicEditorPane.putProperty(MARK_PROPERTY, offsetMark);
        }
    }

    protected static void removeMark(BasicEditorPane basicEditorPane) {
        OffsetMark offsetMark = (OffsetMark)basicEditorPane.getProperty(MARK_PROPERTY);
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        if (offsetMark != null && basicDocument != null) {
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            textBuffer.removeOffsetMark(offsetMark);
        }
        basicEditorPane.putProperty(MARK_PROPERTY, null);
    }

    protected static void showMarkSetMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, MARK_SET_MESSAGE);
    }

    protected static void showMarkNotSetMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, MARK_NOT_SET_MESSAGE);
    }

    protected static void showEndBufferMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, END_BUFFER_MESSAGE);
    }

    protected static void showReadOnlyMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, READ_ONLY_MESSAGE);
    }

    protected static void showNextKillAppendMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, NEXT_KILL_APPEND);
    }

    protected static void showPreviousNotYankMessage(BasicEditorPane basicEditorPane) {
        EmacsAction.showMessage(basicEditorPane, PREVIOUS_NOT_YANK);
    }

    protected static final class Tracker
    implements FocusListener,
    EditorPlugin,
    CaretListener {
        private int lastKillOffset = -1;
        private BasicEditorPane lastEditor = null;

        protected Tracker() {
        }

        protected boolean matchesEditor(BasicEditorPane basicEditorPane, int n) {
            return basicEditorPane == this.lastEditor && n == this.lastKillOffset;
        }

        protected void trackEditor(BasicEditorPane basicEditorPane) {
            if (this.lastEditor != null) {
                this.lastEditor.deinstallPlugin(this);
            }
            basicEditorPane.installPlugin(this);
        }

        public void install(BasicEditorPane basicEditorPane) {
            this.lastEditor = basicEditorPane;
            this.lastKillOffset = basicEditorPane.getCaretPosition();
            basicEditorPane.addFocusListener(this);
            basicEditorPane.addCaretListener(this);
        }

        public void deinstall(BasicEditorPane basicEditorPane) {
            basicEditorPane.removeFocusListener(this);
            basicEditorPane.removeCaretListener(this);
            this.lastKillOffset = -1;
            this.lastEditor = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.lastEditor.deinstallPlugin(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.lastEditor.deinstallPlugin(this);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.lastEditor.deinstallPlugin(this);
        }
    }
}

