/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class FileOverviewMargin
extends JComponent
implements EditorPlugin {
    public static final int PRIORITY_LOW = 3;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_HIGH = 1;
    private BasicEditorPane editor;
    private DocumentListener documentListener;
    private ComponentListener componentListener;
    private CodeFoldingModel codeFoldingModel;
    private CodeFoldingMargin codeFoldingMargin;
    private CodeFoldingListener codeFoldingListener;
    private Map collapsedBlocks;
    private int collapsedLines;
    private int lineCount;
    private int height;
    private double yMultiplier;
    private final Map mapLineToMarks;
    private final Map mapAnalysisIdToTooltip;
    private boolean analysisCompleted;
    private int maximumSeverity;
    private String summaryCategory;
    private static final Map mapCategoryToColor = new HashMap();
    private static final Map mapCategoryToPriority = new HashMap();
    private static final Map mapEditorToFileOverviewMargin = new HashMap();
    private static final PropertyChangeListener editorPropertyChangeListener;
    private static final Comparator categoryComparator;
    private static final int COLUMN_WIDTH = 12;
    private static final int MARK_HEIGHT = 6;
    private static int GET_INFO_LINE;
    private static int GET_INFO_LOCATION;
    private static int GET_INFO_MARKS;

    static {
        categoryComparator = new 6();
        editorPropertyChangeListener = new 5();
        EditorProperties.getProperties().addPropertyChangeListener(editorPropertyChangeListener);
        GET_INFO_LINE = 0;
        GET_INFO_LOCATION = 1;
        GET_INFO_MARKS = 2;
    }

    public static void setMarkColor(String string, Color color) {
        FileOverviewMargin.setMarkColor(string, 3, color);
    }

    public static void setMarkColor(String string, HighlightStyle highlightStyle) {
        FileOverviewMargin.setMarkColor(string, 3, highlightStyle);
    }

    public static void setMarkColor(String string, int n, Color color) {
        mapCategoryToColor.put(string, color);
        mapCategoryToPriority.put(string, new Integer(n));
    }

    public static void setMarkColor(String string, int n, HighlightStyle highlightStyle) {
        mapCategoryToColor.put(string, highlightStyle);
        mapCategoryToPriority.put(string, new Integer(n));
    }

    public static Object getMarkColor(String string) {
        return mapCategoryToColor.get(string);
    }

    public static void removeMarkColor(String string) {
        mapCategoryToColor.remove(string);
        mapCategoryToPriority.remove(string);
    }

    public static FileOverviewMargin getFileOverviewMargin(BasicEditorPane basicEditorPane) {
        return (FileOverviewMargin)mapEditorToFileOverviewMargin.get(basicEditorPane);
    }

    public FileOverviewMargin() {
        this.setBackground(UIManager.getColor("window"));
        this.collapsedBlocks = new TreeMap();
        this.collapsedLines = 0;
        this.codeFoldingListener = new CodeFoldingListener(null);
        this.lineCount = 1;
        this.height = 1;
        this.yMultiplier = 1.0;
        this.mapLineToMarks = new TreeMap();
        this.mapAnalysisIdToTooltip = new HashMap();
        4 var1_1 = new 4();
        this.addMouseListener(var1_1);
        this.addMouseMotionListener(var1_1);
    }

    protected void navigate(int n, FileOverviewMark fileOverviewMark) {
        int n2 = fileOverviewMark.getSelectionStart();
        if (n2 >= 0) {
            int n3 = fileOverviewMark.getSelectionLength();
            this.editor.select(n2, n2 + n3);
        } else {
            int n4 = this.editor.getLineStartOffset(n - 1);
            this.editor.setCaretPositionCenter(n4);
        }
    }

    public void clearAnalysis() {
        this.analysisCompleted = false;
        this.repaintSummaryBlock();
    }

    public void startAnalysis(Object object, String string) {
        this.mapAnalysisIdToTooltip.put(object, string);
        this.repaintSummaryBlock();
    }

    public void stopAnalysis(Object object) {
        this.mapAnalysisIdToTooltip.remove(object);
        int n = 0;
        String string = null;
        for (Map map : this.mapLineToMarks.values()) {
            for (String string2 : map.keySet()) {
                if (mapCategoryToColor.get(string2) == null) continue;
                Object v = map.get(string2);
                if (v instanceof FileOverviewMark[]) {
                    FileOverviewMark[] fileOverviewMarkArray = (FileOverviewMark[])v;
                    int n2 = fileOverviewMarkArray.length - 1;
                    while (n2 >= 0) {
                        int n3 = fileOverviewMarkArray[n2].getSeverity();
                        if (n3 > n) {
                            n = n3;
                            string = string2;
                        }
                        --n2;
                    }
                    continue;
                }
                FileOverviewMark fileOverviewMark = (FileOverviewMark)v;
                int n4 = fileOverviewMark.getSeverity();
                if (n4 <= n) continue;
                n = n4;
                string = string2;
            }
        }
        this.maximumSeverity = n;
        this.summaryCategory = string;
        this.analysisCompleted = true;
        this.repaintSummaryBlock();
    }

    public final void clearMarks(String string) {
        if (!this.mapLineToMarks.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object k : this.mapLineToMarks.keySet()) {
                Map map = (Map)this.mapLineToMarks.get(k);
                if (map.isEmpty()) continue;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().equals(string)) continue;
                    arrayList.add(string);
                }
                while (!arrayList.isEmpty()) {
                    map.remove(arrayList.remove(0));
                }
            }
            this.repaint();
        }
    }

    public final void addMark(String string, int n, FileOverviewMark fileOverviewMark) {
        Object v;
        Integer n2;
        TreeMap<String, Object> treeMap;
        if (n < 1) {
            return;
        }
        if (this.codeFoldingMargin == null || this.codeFoldingModel == null) {
            this.updateCodeFolding();
        }
        if ((treeMap = (TreeMap<String, Object>)this.mapLineToMarks.get(n2 = new Integer(n))) == null) {
            treeMap = new TreeMap<String, Object>(categoryComparator);
            this.mapLineToMarks.put(n2, treeMap);
        }
        if ((v = treeMap.get(string)) != null) {
            FileOverviewMark[] fileOverviewMarkArray;
            if (v instanceof FileOverviewMark[]) {
                FileOverviewMark[] fileOverviewMarkArray2 = (FileOverviewMark[])v;
                int n3 = fileOverviewMarkArray2.length;
                fileOverviewMarkArray = new FileOverviewMark[n3 + 1];
                System.arraycopy(fileOverviewMarkArray2, 0, fileOverviewMarkArray, 0, n3);
                fileOverviewMarkArray[n3] = fileOverviewMark;
            } else {
                fileOverviewMarkArray = new FileOverviewMark[]{(FileOverviewMark)v, fileOverviewMark};
            }
            treeMap.put(string, fileOverviewMarkArray);
        } else {
            treeMap.put(string, fileOverviewMark);
        }
        if (mapCategoryToColor.containsKey(string) && n <= this.lineCount) {
            this.repaintLine(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeMark(String string, int n, FileOverviewMark fileOverviewMark) {
        if (n < 1) {
            return;
        }
        Integer n2 = new Integer(n);
        Map map = (Map)this.mapLineToMarks.get(n2);
        if (map == null) {
            return;
        }
        Object v = map.get(string);
        if (v == null) return;
        if (v instanceof FileOverviewMark[]) {
            FileOverviewMark[] fileOverviewMarkArray = (FileOverviewMark[])v;
            int n3 = fileOverviewMarkArray.length;
            int n4 = -1;
            int n5 = 0;
            while (n5 < fileOverviewMarkArray.length) {
                if (fileOverviewMarkArray[n5].equals(fileOverviewMark)) {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            if (n4 == -1) return;
            if (n3 == 2) {
                map.put(string, fileOverviewMarkArray[1 - n4]);
            } else {
                FileOverviewMark[] fileOverviewMarkArray2 = new FileOverviewMark[n3 - 1];
                System.arraycopy(fileOverviewMarkArray, 0, fileOverviewMarkArray2, 0, n4);
                System.arraycopy(fileOverviewMarkArray, n4 + 1, fileOverviewMarkArray2, n4, n3 - n4 - 1);
                map.put(string, fileOverviewMarkArray2);
            }
        } else {
            map.remove(string);
        }
        if (!mapCategoryToColor.containsKey(string) || n > this.lineCount) return;
        this.repaintLine(n);
    }

    private static void stylesChanged() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        for (Object k : mapCategoryToColor.keySet()) {
            Object v = mapCategoryToColor.get(k);
            if (!(v instanceof HighlightStyle)) continue;
            HighlightStyle highlightStyle = (HighlightStyle)v;
            highlightStyle = highlightRegistry.lookupStyle(highlightStyle.getName());
            mapCategoryToColor.put(k, highlightStyle);
        }
    }

    private static Color getColorForCategory(String string) {
        Object v = mapCategoryToColor.get(string);
        if (v instanceof Color) {
            return (Color)v;
        }
        if (v instanceof HighlightStyle) {
            HighlightStyle highlightStyle = (HighlightStyle)v;
            if (highlightStyle.getUseUnderline()) {
                return highlightStyle.getUnderlineColor();
            }
            if (highlightStyle.getUseBackgroundColor()) {
                return highlightStyle.getBackgroundColor();
            }
            if (highlightStyle.getUseForegroundColor()) {
                return highlightStyle.getForegroundColor();
            }
        }
        return null;
    }

    private void checkLineCount() {
        if (this.editor != null) {
            int n = this.editor.getLineCount() + this.editor.getIntegerProperty("trailing-blank-rows");
            if (n <= 0) {
                n = 1;
            }
            if (this.lineCount != n) {
                this.lineCount = n;
                this.updateYMultiplier();
            }
        }
    }

    private void checkHeight() {
        if (this.editor != null) {
            Rectangle rectangle = this.getWholeRectangle();
            if (this.height != rectangle.height) {
                this.height = rectangle.height;
                this.updateYMultiplier();
            }
        }
    }

    private void updateYMultiplier() {
        this.yMultiplier = (double)this.height / (double)(this.lineCount - this.collapsedLines);
        if (this.yMultiplier < 0.001) {
            this.yMultiplier = 0.001;
        } else {
            try {
                FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
                int n = fontMetrics.getHeight();
                if (this.yMultiplier > (double)n) {
                    this.yMultiplier = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint();
    }

    private void repaintSummaryBlock() {
        Rectangle rectangle = this.getSummaryRectangle();
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void repaintLine(int n) {
        Rectangle rectangle = this.getLineRectangle(null, n);
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int getBottomOffset() {
        return 0;
    }

    private Rectangle getWholeRectangle() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        int n = this.getTopOffset();
        int n2 = this.getBottomOffset();
        rectangle.y += n;
        rectangle.height -= n + n2;
        if (rectangle.height < 1) {
            rectangle.height = 1;
        }
        return rectangle;
    }

    private Rectangle getSummaryRectangle() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        ++rectangle.x;
        rectangle.width -= 2;
        rectangle.y += 2;
        rectangle.height = rectangle.width;
        return rectangle;
    }

    private Rectangle getLineRectangle(Rectangle rectangle, int n) {
        if (rectangle == null) {
            rectangle = this.getWholeRectangle();
        }
        int n2 = (int)Math.round((double)(n - 1) * this.yMultiplier);
        if (this.collapsedLines > 0) {
            for (Object k : this.collapsedBlocks.keySet()) {
                int n3 = (Integer)k;
                int n4 = (Integer)this.collapsedBlocks.get(k);
                if (n <= n3) break;
                if (n3 < n && n <= n4) {
                    n2 -= (int)Math.round((double)(n - n3) * this.yMultiplier);
                    break;
                }
                if (n4 >= n) continue;
                n2 -= (int)Math.round((double)(n4 - n3) * this.yMultiplier);
            }
        }
        return new Rectangle(rectangle.x + 1, rectangle.y + n2, rectangle.width - 2, 6);
    }

    private Map makeMapRectToColor(Rectangle rectangle) {
        if (this.lineCount > 0 && !this.mapLineToMarks.isEmpty() && !mapCategoryToColor.isEmpty()) {
            Rectangle rectangle2 = this.getWholeRectangle();
            HashMap<Rectangle, String> hashMap = new HashMap<Rectangle, String>();
            TreeMap<Rectangle, Color> treeMap = new TreeMap<Rectangle, Color>(new 3(this, hashMap));
            for (Integer n : this.mapLineToMarks.keySet()) {
                Object v;
                String string;
                Color color;
                Iterator iterator;
                Map map;
                int n2 = n;
                Rectangle rectangle3 = this.getLineRectangle(rectangle2, n2);
                if (!rectangle.intersects(rectangle3) || (map = (Map)this.mapLineToMarks.get(n)).isEmpty() || !(iterator = map.keySet().iterator()).hasNext() || (color = FileOverviewMargin.getColorForCategory(string = (String)iterator.next())) == null || (v = hashMap.get(rectangle3)) != null && categoryComparator.compare(v, string) < 0) continue;
                hashMap.put(rectangle3, string);
                treeMap.put(rectangle3, color);
            }
            return treeMap;
        }
        return null;
    }

    private Object getInfoAtY(int n, int n2) {
        ArrayList<FileOverviewMark> arrayList;
        ArrayList<FileOverviewMark> arrayList2 = arrayList = n2 == GET_INFO_MARKS ? new ArrayList<FileOverviewMark>() : null;
        if (this.lineCount > 0 && !this.mapLineToMarks.isEmpty() && !mapCategoryToColor.isEmpty()) {
            Rectangle rectangle = this.getWholeRectangle();
            int n3 = rectangle.x + 1;
            for (Integer n4 : this.mapLineToMarks.keySet()) {
                Map map;
                int n5 = n4;
                Rectangle rectangle2 = this.getLineRectangle(rectangle, n5);
                if (!rectangle2.contains(n3, n) || (map = (Map)this.mapLineToMarks.get(n4)).isEmpty()) continue;
                for (Object k : map.keySet()) {
                    Object v;
                    if (mapCategoryToColor.get(k) == null) continue;
                    if (n2 == GET_INFO_LINE) {
                        return n4;
                    }
                    if (n2 == GET_INFO_LOCATION) {
                        Object v2 = map.get(k);
                        if (v2 == null) continue;
                        FileOverviewMark fileOverviewMark = null;
                        if (v2 instanceof FileOverviewMark[]) {
                            FileOverviewMark[] fileOverviewMarkArray = (FileOverviewMark[])v2;
                            if (fileOverviewMarkArray.length > 0) {
                                fileOverviewMark = fileOverviewMarkArray[0];
                            }
                        } else {
                            fileOverviewMark = (FileOverviewMark)v2;
                        }
                        if (fileOverviewMark == null) continue;
                        Object[] objectArray = new Object[]{n4, fileOverviewMark};
                        return objectArray;
                    }
                    if (n2 != GET_INFO_MARKS || (v = map.get(k)) == null) continue;
                    if (v instanceof FileOverviewMark[]) {
                        FileOverviewMark[] fileOverviewMarkArray = (FileOverviewMark[])v;
                        int n6 = 0;
                        while (n6 < fileOverviewMarkArray.length) {
                            arrayList.add(fileOverviewMarkArray[n6]);
                            ++n6;
                        }
                        continue;
                    }
                    arrayList.add((FileOverviewMark)v);
                }
            }
        }
        if (n2 == GET_INFO_LINE || n2 == GET_INFO_LOCATION) {
            return null;
        }
        if (n2 == GET_INFO_MARKS) {
            return arrayList;
        }
        return null;
    }

    private Integer getLineAtY(int n) {
        return (Integer)this.getInfoAtY(n, GET_INFO_LINE);
    }

    private Object[] getLocationAtY(int n) {
        return (Object[])this.getInfoAtY(n, GET_INFO_LOCATION);
    }

    private String getToolTipAtPt(Point point, MouseEvent mouseEvent) {
        StringBuffer stringBuffer;
        block9: {
            block7: {
                block10: {
                    block8: {
                        stringBuffer = new StringBuffer();
                        Rectangle rectangle = this.getSummaryRectangle();
                        if (!rectangle.contains(point)) break block7;
                        if (this.mapAnalysisIdToTooltip.isEmpty()) {
                            String string = this.analysisCompleted ? "FILE_OVERVIEW_MARGIN_ANALYSIS_COMPLETED" : "FILE_OVERVIEW_MARGIN_NO_ANALYSIS_PERFORMED";
                            stringBuffer.append(EditorProperties.getEditorBundle().getString(string));
                            stringBuffer.append("\n");
                        } else {
                            for (String string : this.mapAnalysisIdToTooltip.values()) {
                                stringBuffer.append(string);
                                stringBuffer.append("\n");
                            }
                        }
                        if (this.maximumSeverity != 2) break block8;
                        stringBuffer.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_ERRORS"));
                        stringBuffer.append("\n");
                        break block9;
                    }
                    if (this.maximumSeverity != 1) break block10;
                    stringBuffer.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_WARNINGS"));
                    stringBuffer.append("\n");
                    break block9;
                }
                if (!this.analysisCompleted) break block9;
                stringBuffer.append(EditorProperties.getEditorBundle().getString("FILE_OVERVIEW_MARGIN_SUMMARY_GOOD"));
                stringBuffer.append("\n");
                break block9;
            }
            List list = (List)this.getInfoAtY(point.y, GET_INFO_MARKS);
            if (list != null && !list.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    FileOverviewMark fileOverviewMark = (FileOverviewMark)list.get(n2);
                    String string = fileOverviewMark.getToolTipText(mouseEvent);
                    if (string != null && string.length() > 0 && hashSet.add(string)) {
                        stringBuffer.append(string);
                        stringBuffer.append("\n");
                    }
                    ++n2;
                }
            }
        }
        int n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.delete(n - 1, n);
            return stringBuffer.toString();
        }
        return null;
    }

    public final JToolTip createToolTip() {
        MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
        multiLineToolTip.setTextWrapper(null);
        return multiLineToolTip;
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 12;
        return dimension;
    }

    public final Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 12;
        return dimension;
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.width = 12;
        return dimension;
    }

    public final boolean isFocusTraversable() {
        return false;
    }

    protected void paintComponent(Graphics graphics) {
        Map map;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Color color = this.analysisCompleted ? (this.maximumSeverity == 2 || this.maximumSeverity == 1 ? FileOverviewMargin.getColorForCategory(this.summaryCategory) : Color.GREEN) : this.getBackground();
        Rectangle rectangle22 = this.getSummaryRectangle();
        this.drawBox(graphics, rectangle22, color);
        if (!(this.lineCount <= 0 || mapCategoryToColor.isEmpty() || this.mapLineToMarks.isEmpty() || (map = this.makeMapRectToColor(rectangle)) == null || map.isEmpty())) {
            for (Rectangle rectangle22 : map.keySet()) {
                color = (Color)map.get(rectangle22);
                this.drawBox(graphics, rectangle22, color);
            }
        }
    }

    protected void drawBox(Graphics graphics, Rectangle rectangle, Color color) {
        if (color == null) {
            color = this.getBackground();
        }
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color.darker());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public final String getToolTipText() {
        return null;
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        Point point;
        String string;
        if (mouseEvent != null && (string = this.getToolTipAtPt(point = mouseEvent.getPoint(), mouseEvent)) != null) {
            return string;
        }
        return null;
    }

    public final void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        mapEditorToFileOverviewMargin.put(basicEditorPane, this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.checkLineCount();
        this.documentListener = new 2();
        basicEditorPane.getDocument().addDocumentListener(this.documentListener);
        this.componentListener = new 1();
        this.addComponentListener(this.componentListener);
    }

    public final void deinstall(BasicEditorPane basicEditorPane) {
        this.removeComponentListener(this.componentListener);
        this.componentListener = null;
        basicEditorPane.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        ToolTipManager.sharedInstance().unregisterComponent(this);
        mapEditorToFileOverviewMargin.remove(basicEditorPane);
        this.editor = null;
        this.updateCodeFolding();
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("trailing-blank-rows")) {
            this.checkLineCount();
        } else if (string.equals("code-folding-margin-visible")) {
            this.updateCodeFolding();
        } else if (string.equals("code-folding-model")) {
            this.updateCodeFolding();
        }
    }

    private void updateCodeFolding() {
        if (this.codeFoldingMargin != null) {
            this.codeFoldingMargin.removeCodeExpansionListener(this.codeFoldingListener);
        }
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.removeCodeFoldingModelListener(this.codeFoldingListener);
        }
        this.collapsedBlocks.clear();
        this.collapsedLines = 0;
        if (this.editor != null) {
            this.codeFoldingMargin = (CodeFoldingMargin)this.editor.getProperty("code-folding-margin");
            this.codeFoldingModel = (CodeFoldingModel)this.editor.getProperty("code-folding-model");
        } else {
            this.codeFoldingMargin = null;
            this.codeFoldingModel = null;
        }
        if (this.codeFoldingMargin != null) {
            this.codeFoldingMargin.addCodeExpansionListener(this.codeFoldingListener);
        }
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.addCodeFoldingModelListener(this.codeFoldingListener);
        }
        this.rebuildFoldingFromScratch();
        this.updateYMultiplier();
    }

    private void rebuildFoldingFromScratch() {
        this.collapsedBlocks.clear();
        this.collapsedLines = 0;
        if (this.codeFoldingModel != null) {
            this.codeFoldingModel.readLock();
            try {
                this.addCollapsedChildren(this.codeFoldingModel.getRoot());
            }
            finally {
                this.codeFoldingModel.readUnlock();
            }
        }
    }

    private void addCollapsedChildren(Object object) {
        Iterator iterator = this.codeFoldingModel.getChildren(object);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.codeFoldingModel.isExpanded(e)) {
                this.addCollapsedChildren(e);
                continue;
            }
            this.addCollapsedBlock(e);
        }
    }

    private void removeCollapsedChildren(Object object) {
        Iterator iterator = this.codeFoldingModel.getChildren(object);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.codeFoldingModel.isExpanded(e)) {
                this.removeCollapsedChildren(e);
                continue;
            }
            this.removeCollapsedBlock(e);
        }
    }

    private void addCollapsedBlock(Object object) {
        int[] nArray = this.codeFoldingModel.getTextOffsets(object, null);
        int n = this.editor.getLineFromOffset(nArray[0]) + 1;
        int n2 = this.editor.getLineFromOffset(nArray[1]) + 1;
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        this.collapsedBlocks.put(n3, n4);
        this.collapsedLines += n2 - n;
    }

    private void removeCollapsedBlock(Object object) {
        int[] nArray = this.codeFoldingModel.getTextOffsets(object, null);
        int n = this.editor.getLineFromOffset(nArray[0]) + 1;
        int n2 = this.editor.getLineFromOffset(nArray[1]) + 1;
        Integer n3 = new Integer(n);
        this.collapsedBlocks.remove(n3);
        this.collapsedLines -= n2 - n;
    }

    static Map ra$mapCategoryToPriority() {
        return mapCategoryToPriority;
    }

    static void maS$stylesChanged() {
        FileOverviewMargin.stylesChanged();
    }

    static BasicEditorPane ra$editor(FileOverviewMargin fileOverviewMargin) {
        return fileOverviewMargin.editor;
    }

    static Object[] mav$getLocationAtY(FileOverviewMargin fileOverviewMargin, int n) {
        return fileOverviewMargin.getLocationAtY(n);
    }

    static Integer mav$getLineAtY(FileOverviewMargin fileOverviewMargin, int n) {
        return fileOverviewMargin.getLineAtY(n);
    }

    static Comparator ra$categoryComparator() {
        return categoryComparator;
    }

    static void mav$checkLineCount(FileOverviewMargin fileOverviewMargin) {
        fileOverviewMargin.checkLineCount();
    }

    static void mav$checkHeight(FileOverviewMargin fileOverviewMargin) {
        fileOverviewMargin.checkHeight();
    }

    static void mav$rebuildFoldingFromScratch(FileOverviewMargin fileOverviewMargin) {
        fileOverviewMargin.rebuildFoldingFromScratch();
    }

    static void mav$updateYMultiplier(FileOverviewMargin fileOverviewMargin) {
        fileOverviewMargin.updateYMultiplier();
    }

    static CodeFoldingModel ra$codeFoldingModel(FileOverviewMargin fileOverviewMargin) {
        return fileOverviewMargin.codeFoldingModel;
    }

    static void mav$removeCollapsedChildren(FileOverviewMargin fileOverviewMargin, Object object) {
        fileOverviewMargin.removeCollapsedChildren(object);
    }

    static void mav$addCollapsedBlock(FileOverviewMargin fileOverviewMargin, Object object) {
        fileOverviewMargin.addCollapsedBlock(object);
    }

    static void mav$removeCollapsedBlock(FileOverviewMargin fileOverviewMargin, Object object) {
        fileOverviewMargin.removeCollapsedBlock(object);
    }

    static void mav$addCollapsedChildren(FileOverviewMargin fileOverviewMargin, Object object) {
        fileOverviewMargin.addCollapsedChildren(object);
    }

    public static final class 6
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            Integer n2 = (Integer)FileOverviewMargin.ra$mapCategoryToPriority().get(object);
            int n3 = n2 != null ? n2 : 3;
            Integer n4 = (Integer)FileOverviewMargin.ra$mapCategoryToPriority().get(object2);
            int n5 = n = n4 != null ? n4 : 3;
            if (n3 != n) {
                return n3 - n;
            }
            return ((String)object).compareTo((String)object2);
        }
    }

    public static final class 5
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("highlight-registry")) {
                FileOverviewMargin.maS$stylesChanged();
            }
        }
    }

    public final class 4
    extends MouseInputAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            if (FileOverviewMargin.ra$editor(FileOverviewMargin.this) != null) {
                Point point = mouseEvent.getPoint();
                Integer n = FileOverviewMargin.mav$getLineAtY(FileOverviewMargin.this, point.y);
                if (n != null) {
                    FileOverviewMargin.this.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            FileOverviewMargin.this.setCursor(null);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (FileOverviewMargin.ra$editor(FileOverviewMargin.this) != null && (mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 1) {
                    Point point = mouseEvent.getPoint();
                    Object[] objectArray = FileOverviewMargin.mav$getLocationAtY(FileOverviewMargin.this, point.y);
                    if (objectArray != null) {
                        int n = (Integer)objectArray[0];
                        FileOverviewMark fileOverviewMark = (FileOverviewMark)objectArray[1];
                        FileOverviewMargin.this.navigate(n, fileOverviewMark);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final class 3
    implements Comparator {
        private final /* synthetic */ Map v$mapRectToCategory;
        final /* synthetic */ FileOverviewMargin this$0;

        public int compare(Object object, Object object2) {
            Rectangle rectangle = (Rectangle)object;
            Rectangle rectangle2 = (Rectangle)object2;
            String string = (String)this.v$mapRectToCategory.get(rectangle);
            String string2 = (String)this.v$mapRectToCategory.get(rectangle2);
            int n = FileOverviewMargin.ra$categoryComparator().compare(string2, string);
            if (n != 0) {
                return n;
            }
            return rectangle.y - rectangle2.y;
        }

        public 3(FileOverviewMargin fileOverviewMargin, Map map) {
            this.v$mapRectToCategory = map;
            this.this$0 = fileOverviewMargin;
        }
    }

    public final class 2
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            FileOverviewMargin.mav$checkLineCount(FileOverviewMargin.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FileOverviewMargin.mav$checkLineCount(FileOverviewMargin.this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FileOverviewMargin.mav$checkLineCount(FileOverviewMargin.this);
        }
    }

    public final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            FileOverviewMargin.mav$checkHeight(FileOverviewMargin.this);
        }
    }

    private class CodeFoldingListener
    implements CodeFoldingModelListener,
    CodeExpansionListener {
        public void codeExpanded(CodeExpansionEvent codeExpansionEvent) {
            if (FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this) != null) {
                FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this).readLock();
                try {
                    Object object = codeExpansionEvent.getBlock();
                    FileOverviewMargin.mav$removeCollapsedBlock(FileOverviewMargin.this, object);
                    FileOverviewMargin.mav$addCollapsedChildren(FileOverviewMargin.this, object);
                    FileOverviewMargin.mav$updateYMultiplier(FileOverviewMargin.this);
                }
                finally {
                    FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this).readUnlock();
                }
            }
        }

        public void codeCollapsed(CodeExpansionEvent codeExpansionEvent) {
            if (FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this) != null) {
                FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this).readLock();
                try {
                    Object object = codeExpansionEvent.getBlock();
                    FileOverviewMargin.mav$removeCollapsedChildren(FileOverviewMargin.this, object);
                    FileOverviewMargin.mav$addCollapsedBlock(FileOverviewMargin.this, object);
                    FileOverviewMargin.mav$updateYMultiplier(FileOverviewMargin.this);
                }
                finally {
                    FileOverviewMargin.ra$codeFoldingModel(FileOverviewMargin.this).readUnlock();
                }
            }
        }

        public void structureChanged(CodeFoldingModelEvent codeFoldingModelEvent) {
            FileOverviewMargin.mav$rebuildFoldingFromScratch(FileOverviewMargin.this);
            FileOverviewMargin.mav$updateYMultiplier(FileOverviewMargin.this);
        }

        private CodeFoldingListener() {
        }

        CodeFoldingListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

