/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;

public final class FontHelper {
    private static final int FONT_TABLE_SLOTS = 4;
    private Font[] fontTable = new Font[4];
    private FontMetrics[] metricsTable = new FontMetrics[4];

    public FontHelper(String string, int n) {
        this.setBaseFont(string, n);
    }

    private void clearFonts() {
        int n = this.fontTable.length;
        int n2 = 0;
        while (n2 < n) {
            this.fontTable[n2] = null;
            this.metricsTable[n2] = null;
            ++n2;
        }
    }

    public Font setBaseFont(String string, int n) {
        Font font;
        this.clearFonts();
        this.fontTable[0] = font = new Font(string, 0, n);
        return font;
    }

    public Font getBaseFont() {
        return this.getFont(0);
    }

    public Font getFont(int n) {
        Font font = this.fontTable[n];
        if (font == null) {
            Font font2 = this.fontTable[0];
            this.fontTable[n] = font = font2.deriveFont(n);
        }
        return font;
    }

    public FontMetrics getFontMetrics(Font font, Component component) {
        int n = font.getStyle();
        FontMetrics fontMetrics = this.metricsTable[n];
        if (fontMetrics == null) {
            this.metricsTable[n] = fontMetrics = component.getFontMetrics(font);
        }
        return fontMetrics;
    }

    public FontMetrics getFontMetrics(int n, Component component) {
        FontMetrics fontMetrics = this.metricsTable[n];
        if (fontMetrics == null) {
            Font font = this.getFont(n);
            this.metricsTable[n] = fontMetrics = component.getFontMetrics(font);
        }
        return fontMetrics;
    }
}

