/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class Utilities {
    public static int getTextWidth(TextBuffer textBuffer, int n, int n2, int n3, int n4) {
        int n5 = textBuffer.getLength();
        n = Math.min(Math.max(0, n), n5);
        n2 = Math.min(Math.max(0, n2), n5);
        int n6 = n;
        int n7 = n4;
        while (n6 < n2) {
            char c = textBuffer.getChar(n6++);
            switch (c) {
                case '\t': {
                    n7 = Utilities.getNextTabStop(n3, n7);
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    ++n7;
                }
            }
        }
        return n7 - n4;
    }

    public static int getNextTabStop(int n, int n2) {
        if (n <= 0 || n2 < 0) {
            throw new IllegalArgumentException("bad tab size or column");
        }
        switch (n) {
            case 1: {
                return n2 + 1;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return (n2 & ~(n - 1)) + n;
            }
        }
        int n3 = n2 - n2 % n + n;
        return n3;
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int n, int n2) {
        LineMap lineMap = textBuffer.getLineMap();
        int n3 = lineMap.getLineFromOffset(n);
        return Utilities.getColumnFromOffset(textBuffer, n3, n, n2);
    }

    public static int getColumnFromOffset(TextBuffer textBuffer, int n, int n2, int n3) {
        LineMap lineMap = textBuffer.getLineMap();
        int n4 = lineMap.getLineStartOffset(n);
        if (n4 == n2) {
            return 0;
        }
        return Utilities.getTextWidth(textBuffer, n4, n2, n3, 0);
    }

    public static int getOffsetFromColumn(TextBuffer textBuffer, int n, int n2, int n3) {
        LineMap lineMap = textBuffer.getLineMap();
        int n4 = lineMap.getLineStartOffset(n);
        int n5 = lineMap.getLineEndOffset(n);
        if (n2 == 0) {
            return n4;
        }
        int n6 = n4;
        int n7 = 0;
        boolean bl = false;
        while (!bl && n6 < n5) {
            char c = textBuffer.getChar(n6);
            switch (c) {
                case '\t': {
                    ++n6;
                    n7 = Utilities.getNextTabStop(n3, n7);
                    break;
                }
                case '\n': 
                case '\r': {
                    return n6;
                }
                default: {
                    ++n6;
                    ++n7;
                }
            }
            if (n7 < n2) continue;
            if (n7 <= n2) break;
            --n6;
            break;
        }
        return n6;
    }

    public static int getRowStart(BasicDocument basicDocument, int n) {
        n = Math.max(n, 0);
        n = Math.min(n, basicDocument.getLength());
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        int n3 = lineMap.getLineStartOffset(n2);
        return n3;
    }

    public static int getRowEnd(BasicDocument basicDocument, int n) {
        n = Math.max(n, 0);
        n = Math.min(n, basicDocument.getLength());
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        int n3 = lineMap.getLineEndOffset(n2);
        int n4 = lineMap.getLineCount();
        if (n4 - 1 != n2) {
            --n3;
        }
        return n3;
    }

    private static WordLocator getWordLocator(BasicDocument basicDocument) {
        LanguageSupport languageSupport = basicDocument.getLanguageSupport();
        return languageSupport.getWordLocator();
    }

    public static int getWordStart(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        return wordLocator.getWordStart(n);
    }

    public static int getWordEnd(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        return wordLocator.getWordEnd(n);
    }

    public static int getNextWordStart(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        int n2 = wordLocator.getNextWordStart(n);
        if (Utilities.useLineStartForWordBoundary()) {
            int n3 = Utilities.getNextLineStart(basicDocument, n);
            n2 = Math.min(n2, n3);
        }
        if (Utilities.useLineEndForWordBoundary()) {
            int n4 = Utilities.getNextLineEnd(basicDocument, n);
            n2 = Math.min(n2, n4);
        }
        return n2;
    }

    public static int getNextWordEnd(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        int n2 = wordLocator.getNextWordEnd(n);
        if (Utilities.useLineStartForWordBoundary()) {
            int n3 = Utilities.getNextLineStart(basicDocument, n);
            n2 = Math.min(n2, n3);
        }
        if (Utilities.useLineEndForWordBoundary()) {
            int n4 = Utilities.getNextLineEnd(basicDocument, n);
            n2 = Math.min(n2, n4);
        }
        return n2;
    }

    public static int getPreviousWordStart(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        int n2 = wordLocator.getPreviousWordStart(n);
        if (Utilities.useLineStartForWordBoundary()) {
            int n3 = Utilities.getPreviousLineStart(basicDocument, n);
            n2 = Math.max(n2, n3);
        }
        if (Utilities.useLineEndForWordBoundary()) {
            int n4 = Utilities.getPreviousLineEnd(basicDocument, n);
            n2 = Math.max(n2, n4);
        }
        return n2;
    }

    public static int getPreviousWordEnd(BasicDocument basicDocument, int n) {
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        WordLocator wordLocator = Utilities.getWordLocator(basicDocument);
        int n2 = wordLocator.getPreviousWordEnd(n);
        if (Utilities.useLineStartForWordBoundary()) {
            int n3 = Utilities.getPreviousLineStart(basicDocument, n);
            n2 = Math.max(n2, n3);
        }
        if (Utilities.useLineEndForWordBoundary()) {
            int n4 = Utilities.getPreviousLineEnd(basicDocument, n);
            n2 = Math.max(n2, n4);
        }
        return n2;
    }

    private static boolean useLineStartForWordBoundary() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorProperties.getBooleanProperty("word-boundary-use-line-start");
        return bl;
    }

    private static boolean useLineEndForWordBoundary() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorProperties.getBooleanProperty("word-boundary-use-line-end");
        return bl;
    }

    private static int getPreviousLineStart(BasicDocument basicDocument, int n) {
        int n2;
        LineMap lineMap = basicDocument.getLineMap();
        int n3 = lineMap.getLineStartOffset(n2 = lineMap.getLineFromOffset(n));
        if (n3 == n && n2 > 0) {
            n3 = lineMap.getLineStartOffset(n2 - 1);
        }
        return n3;
    }

    private static int getPreviousLineEnd(BasicDocument basicDocument, int n) {
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        int n3 = 0;
        if (n2 > 0) {
            n3 = lineMap.getLineEndOffset(n2 - 1);
            --n3;
        }
        return n3;
    }

    private static int getNextLineStart(BasicDocument basicDocument, int n) {
        int n2;
        LineMap lineMap = basicDocument.getLineMap();
        int n3 = lineMap.getLineFromOffset(n);
        int n4 = n3 < (n2 = lineMap.getLineCount() - 1) ? lineMap.getLineStartOffset(n3 + 1) : lineMap.getLineEndOffset(n2);
        return n4;
    }

    private static int getNextLineEnd(BasicDocument basicDocument, int n) {
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        int n3 = lineMap.getLineCount() - 1;
        int n4 = lineMap.getLineEndOffset(n2);
        if (n2 < n3) {
            --n4;
        }
        if (n4 == n && n2 < n3) {
            int n5 = n2 + 1;
            n4 = lineMap.getLineEndOffset(n5);
            if (n5 < n3) {
                --n4;
            }
        }
        return n4;
    }

    public static boolean testBit(int n, int n2) {
        return (n & n2) != 0;
    }

    public static int setBit(int n, int n2) {
        return n | n2;
    }

    public static int clearBit(int n, int n2) {
        return n & ~n2;
    }
}

