/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WeakPropertyChangeSupport {
    private transient List viewListeners;
    private transient Object source;

    public WeakPropertyChangeSupport(Object object) {
        this.source = object;
        this.viewListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        List list = this.viewListeners;
        synchronized (list) {
            int n = this.findListener(propertyChangeListener);
            if (n == -1) {
                WeakReference<PropertyChangeListener> weakReference = new WeakReference<PropertyChangeListener>(propertyChangeListener);
                this.viewListeners.add(weakReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        List list = this.viewListeners;
        synchronized (list) {
            int n = this.findListener(propertyChangeListener);
            if (n != -1) {
                this.viewListeners.set(n, null);
            }
        }
    }

    public synchronized void firePropertyChange(String string, Object object, Object object2) {
        if (this.valuesMatch(object, object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        this.fireEvent(propertyChangeEvent);
    }

    public synchronized void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.valuesMatch(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue())) {
            return;
        }
        this.fireEvent(propertyChangeEvent);
    }

    private int findListener(PropertyChangeListener propertyChangeListener) {
        int n = this.viewListeners.size();
        int n2 = 0;
        while (n2 < n) {
            Object t;
            WeakReference weakReference = (WeakReference)this.viewListeners.get(n2);
            if (weakReference != null && (t = weakReference.get()) == propertyChangeListener) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void packListeners() {
        Iterator iterator = this.viewListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference != null && weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    private boolean valuesMatch(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private void fireEvent(PropertyChangeEvent propertyChangeEvent) {
        for (WeakReference weakReference : this.viewListeners) {
            PropertyChangeListener propertyChangeListener;
            if (weakReference == null || (propertyChangeListener = (PropertyChangeListener)weakReference.get()) == null) continue;
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.packListeners();
    }
}

