/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.event.DocumentEvent;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.plugins.AbstractEditorPlugin;

public abstract class AbstractCodeFoldingPlugin
extends AbstractEditorPlugin {
    private CodeFoldingProvider provider;
    private CodeFoldingMargin margin;
    private BasicDocument.PrePostDocumentListener documentHandler;

    protected void installImpl(BasicEditorPane basicEditorPane) {
        if (this.isMarginEnabled()) {
            this.attach(basicEditorPane);
        }
    }

    protected void deinstallImpl(BasicEditorPane basicEditorPane) {
        if (this.margin.isVisible()) {
            this.detach(basicEditorPane);
        }
        this.provider = null;
        this.margin = null;
    }

    protected void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        if (codeFoldingMargin == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editor-font") || string.equals("trailing-blank-rows") || string.equals("code-folding-highlight") || string.equals("code-folding-enabled")) {
            codeFoldingMargin.repaint();
        } else if (string.equals("right-margin-color")) {
            Color color = (Color)propertyChangeEvent.getNewValue();
            codeFoldingMargin.setForeground(color);
        } else if (string.equals("code-folding-margin-visible")) {
            BasicEditorPane basicEditorPane = (BasicEditorPane)propertyChangeEvent.getSource();
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            boolean bl2 = bl;
            if (bl2) {
                this.attach(basicEditorPane);
            } else {
                this.detach(basicEditorPane);
            }
            codeFoldingMargin.setVisible(bl2);
        }
    }

    protected abstract CodeFoldingProvider createProvider();

    protected void attach(BasicEditorPane basicEditorPane) {
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        codeFoldingMargin.attach(basicEditorPane);
        this.documentHandler = this.createPrePostDocumentListener();
        if (this.documentHandler != null) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            basicDocument.addPrePostDocumentListener(this.documentHandler);
        }
    }

    protected void detach(BasicEditorPane basicEditorPane) {
        if (this.documentHandler != null) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            basicDocument.removePrePostDocumentListener(this.documentHandler);
            this.documentHandler = null;
        }
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        codeFoldingMargin.detach(basicEditorPane);
    }

    protected boolean isMarginEnabled() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        return editorProperties.getBooleanProperty("code-folding-margin-visible");
    }

    protected CodeFoldingModel getModel() {
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        return codeFoldingMargin.getModel();
    }

    protected void setModel(CodeFoldingModel codeFoldingModel) {
        CodeFoldingMargin codeFoldingMargin = this.getMargin();
        codeFoldingMargin.setModel(codeFoldingModel);
    }

    protected CodeFoldingProvider getProvider() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    protected CodeFoldingMargin getMargin() {
        if (this.margin == null) {
            this.margin = this.createMargin();
        }
        return this.margin;
    }

    protected CodeFoldingMargin createMargin() {
        CodeFoldingProvider codeFoldingProvider = this.getProvider();
        return new CodeFoldingMargin(codeFoldingProvider);
    }

    protected BasicDocument.PrePostDocumentListener createPrePostDocumentListener() {
        return new DocumentHandler();
    }

    protected class DocumentHandler
    implements BasicDocument.PrePostDocumentListener {
        protected DocumentHandler() {
        }

        protected boolean isInsertOrRemoveEvent(DocumentEvent documentEvent) {
            DocumentEvent.EventType eventType = documentEvent.getType();
            return eventType == DocumentEvent.EventType.INSERT || eventType == DocumentEvent.EventType.REMOVE;
        }

        public void preNotify(DocumentEvent documentEvent) {
            boolean bl;
            if (!this.isInsertOrRemoveEvent(documentEvent)) {
                return;
            }
            CodeFoldingProvider codeFoldingProvider = AbstractCodeFoldingPlugin.this.getProvider();
            CodeFoldingModel codeFoldingModel = AbstractCodeFoldingPlugin.this.getModel();
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            boolean bl2 = bl = documentEvent.getType() == DocumentEvent.EventType.INSERT;
            if (bl) {
                codeFoldingProvider.insertUpdate(codeFoldingModel, n, n2);
            } else {
                codeFoldingProvider.removeUpdate(codeFoldingModel, n, n2);
            }
        }

        public void postNotify(DocumentEvent documentEvent) {
            CodeFoldingMargin codeFoldingMargin = AbstractCodeFoldingPlugin.this.getMargin();
            codeFoldingMargin.repaint();
        }
    }
}

