/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.editor.folding.FoldingBlock;

public abstract class AbstractFoldingBlock
implements FoldingBlock {
    private FoldingBlock parent;
    private List children;
    private boolean isExpanded;

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    public FoldingBlock getParent() {
        return this.parent;
    }

    public void setParent(FoldingBlock foldingBlock) {
        this.parent = foldingBlock;
    }

    public void add(FoldingBlock foldingBlock) {
        FoldingBlock foldingBlock2 = foldingBlock.getParent();
        if (foldingBlock2 != null) {
            foldingBlock2.remove(foldingBlock);
        }
        foldingBlock.setParent(this);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(foldingBlock);
    }

    public void remove(FoldingBlock foldingBlock) {
        if (this.children != null && this.children.remove(foldingBlock)) {
            foldingBlock.setParent(null);
        }
    }

    public void removeAll() {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            FoldingBlock foldingBlock = (FoldingBlock)iterator.next();
            foldingBlock.setParent(null);
        }
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public Iterator getChildren() {
        return this.children != null ? this.children.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public int length() {
        int n = this.getEndOffset();
        int n2 = this.getStartOffset();
        return Math.abs(n - n2);
    }

    public boolean bounds(int n) {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        return n > n2 && n < n3;
    }

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract String getReplacementText();
}

