/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeExpansionVetoException;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.folding.CodeWillExpandListener;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;

public class CodeFoldingMargin
extends JComponent {
    protected BasicEditorPane editorPane;
    protected CodeFoldingProvider provider;
    protected CodeFoldingModel model;
    protected final int[] TEMP_OFFSETS;
    private static final Composite BLOCK_HIGHLIGHT_COMPOSITE = AlphaComposite.getInstance(3, 0.15f);
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private EventHandler eventHandler;
    private PopupCodeWindow popupWindow;
    private Icon expandedIcon;
    private Icon collapsedIcon;
    private Point lastMousePosition;
    private int lastCaretPosition;

    void $init$() {
        this.TEMP_OFFSETS = new int[2];
    }

    public CodeFoldingMargin(CodeFoldingProvider codeFoldingProvider) {
        this.$init$();
        this.provider = codeFoldingProvider;
        this.setOpaque(true);
        Border border = this.createBorder();
        this.setBorder(border);
    }

    public CodeFoldingModel getModel() {
        return this.model;
    }

    public CodeFoldingProvider getProvider() {
        return this.provider;
    }

    public void setModel(CodeFoldingModel codeFoldingModel) {
        CodeFoldingModel codeFoldingModel2 = this.getModel();
        if (codeFoldingModel != codeFoldingModel2) {
            if (codeFoldingModel2 != null) {
                codeFoldingModel2.removeCodeFoldingModelListener(this.eventHandler);
            }
            this.model = codeFoldingModel;
            this.editorPane.putProperty("code-folding-model", codeFoldingModel);
            if (codeFoldingModel != null) {
                codeFoldingModel.addCodeFoldingModelListener(this.eventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setExpansionState(Object object, boolean bl) {
        CodeFoldingModel codeFoldingModel = this.getModel();
        if (bl == codeFoldingModel.isExpanded(object)) {
            return;
        }
        if (bl) {
            Object object2;
            codeFoldingModel.readLock();
            try {
                object2 = codeFoldingModel.getParent(object);
            }
            finally {
                codeFoldingModel.readUnlock();
            }
            if (object2 != null && !codeFoldingModel.isExpanded(object2)) {
                this.setExpansionState(object2, bl);
            }
            try {
                this.fireCodeWillExpand(object);
            }
            catch (CodeExpansionVetoException codeExpansionVetoException) {
                return;
            }
            codeFoldingModel.setExpanded(object, bl);
            this.fireCodeExpanded(object);
        } else {
            block18: {
                try {
                    this.fireCodeWillCollapse(object);
                }
                catch (CodeExpansionVetoException codeExpansionVetoException) {
                    return;
                }
                codeFoldingModel.readLock();
                try {
                    int n = this.getCaretPosition();
                    if (!this.blockContainsOffset(codeFoldingModel, object, n)) break block18;
                    int[] nArray = this.TEMP_OFFSETS;
                    // MONITORENTER : this.TEMP_OFFSETS
                    codeFoldingModel.getTextOffsets(object, this.TEMP_OFFSETS);
                    int n2 = this.TEMP_OFFSETS[1];
                    // MONITOREXIT : nArray
                    this.editorPane.setCaretPosition(n2);
                }
                finally {
                    codeFoldingModel.readUnlock();
                }
            }
            codeFoldingModel.setExpanded(object, bl);
            this.fireCodeCollapsed(object);
        }
        this.repaint();
    }

    public boolean expandEnclosingBlocks(int n) {
        CodeFoldingModel codeFoldingModel = this.getModel();
        if (codeFoldingModel == null) {
            return false;
        }
        codeFoldingModel.readLock();
        try {
            Object object = codeFoldingModel.getRoot();
            boolean bl = this.expandEnclosingChild(codeFoldingModel, object, n);
            codeFoldingModel.readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            codeFoldingModel.readUnlock();
            throw throwable;
        }
    }

    public void addCodeWillExpandListener(CodeWillExpandListener codeWillExpandListener) {
        this.listenerList.add(CodeWillExpandListener.class, codeWillExpandListener);
    }

    public void removeCodeWillExpandListener(CodeWillExpandListener codeWillExpandListener) {
        this.listenerList.remove(CodeWillExpandListener.class, codeWillExpandListener);
    }

    public CodeWillExpandListener[] getCodeWillExpandListeners() {
        return (CodeWillExpandListener[])this.listenerList.getListeners(CodeWillExpandListener.class);
    }

    public void addCodeExpansionListener(CodeExpansionListener codeExpansionListener) {
        this.listenerList.add(CodeExpansionListener.class, codeExpansionListener);
    }

    public void removeCodeExpansionListener(CodeExpansionListener codeExpansionListener) {
        this.listenerList.remove(CodeExpansionListener.class, codeExpansionListener);
    }

    public CodeExpansionListener[] getCodeExpansionListeners() {
        return (CodeExpansionListener[])this.listenerList.getListeners(CodeExpansionListener.class);
    }

    protected void attach(BasicEditorPane basicEditorPane) {
        this.editorPane = basicEditorPane;
        this.eventHandler = new EventHandler(this);
        CodeFoldingModel codeFoldingModel = this.createCodeFoldingModel(basicEditorPane);
        this.setModel(codeFoldingModel);
        this.addMouseListener(this.eventHandler);
        this.addMouseMotionListener(this.eventHandler);
        basicEditorPane.addCaretListener(this.eventHandler);
        basicEditorPane.addPropertyChangeListener(this.eventHandler);
        basicEditorPane.addComponentListener(this.eventHandler);
        basicEditorPane.putProperty("code-folding-margin", this);
        Color color = (Color)basicEditorPane.getProperty("right-margin-color");
        this.setForeground(color);
        this.setBackground(basicEditorPane.getBackground());
    }

    protected void detach(BasicEditorPane basicEditorPane) {
        basicEditorPane.putProperty("code-folding-margin", null);
        this.disposePopupWindow();
        this.removeMouseListener(this.eventHandler);
        this.removeMouseMotionListener(this.eventHandler);
        basicEditorPane.removeCaretListener(this.eventHandler);
        basicEditorPane.addPropertyChangeListener(this.eventHandler);
        basicEditorPane.removeComponentListener(this.eventHandler);
        this.setModel(null);
        this.eventHandler = null;
        this.editorPane = null;
    }

    protected CodeFoldingModel createCodeFoldingModel(BasicEditorPane basicEditorPane) {
        CodeFoldingProvider codeFoldingProvider = this.getProvider();
        return codeFoldingProvider.createModel(basicEditorPane);
    }

    protected Border createBorder() {
        Border border = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        DottedRightBorder dottedRightBorder = new DottedRightBorder(null);
        return BorderFactory.createCompoundBorder(dottedRightBorder, border);
    }

    protected int getPreferredWidth() {
        Icon icon;
        int n = 0;
        Icon icon2 = this.getExpandedIcon();
        if (icon2 != null) {
            n = Math.max(n, icon2.getIconWidth());
        }
        if ((icon = this.getCollapsedIcon()) != null) {
            n = Math.max(n, icon.getIconWidth());
        }
        Insets insets = this.getInsets();
        return n += insets.left + insets.right;
    }

    protected int getPreferredHeight() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        if (basicEditorPane != null) {
            return basicEditorPane.getHeight();
        }
        return 0;
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    protected BasicDocument getDocument() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return (BasicDocument)basicEditorPane.getDocument();
    }

    protected CodeFoldingProvider getFoldingProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockContainsOffset(CodeFoldingModel codeFoldingModel, Object object, int n) {
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            codeFoldingModel.getTextOffsets(object, this.TEMP_OFFSETS);
            int n2 = this.TEMP_OFFSETS[0];
            int n3 = this.TEMP_OFFSETS[1];
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return n > n2 && n < n3;
        }
    }

    protected boolean expandEnclosingChild(CodeFoldingModel codeFoldingModel, Object object, int n) {
        Iterator iterator = codeFoldingModel.getChildren(object);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.blockContainsOffset(codeFoldingModel, e, n)) continue;
            boolean bl = codeFoldingModel.isExpanded(e);
            if (!bl) {
                this.setExpansionState(e, true);
            }
            return this.expandEnclosingChild(codeFoldingModel, e, n) || !bl;
        }
        return false;
    }

    protected Object getSmallestEnclosingBlock(int n) {
        CodeFoldingModel codeFoldingModel = this.getModel();
        return codeFoldingModel != null ? codeFoldingModel.getSmallestEnclosingBlock(n) : null;
    }

    protected Object getFirstBlockAtLine(int n) {
        CodeFoldingModel codeFoldingModel = this.getModel();
        return codeFoldingModel.getFirstBlockAtLine(n);
    }

    protected Icon getExpandedIcon() {
        if (this.expandedIcon == null) {
            this.expandedIcon = this.createExpandedIcon();
        }
        return this.expandedIcon;
    }

    protected Icon getCollapsedIcon() {
        if (this.collapsedIcon == null) {
            this.collapsedIcon = this.createCollapsedIcon();
        }
        return this.collapsedIcon;
    }

    protected Icon createExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    protected Icon createCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    protected int getYCoordinateFromOffset(int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        BasicDocument basicDocument = this.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        n = lineMap.getLineStartOffset(n2);
        try {
            Rectangle rectangle = basicEditorPane.modelToView(n);
            int n3 = rectangle.y;
            return n3;
        }
        catch (BadLocationException badLocationException) {
            int n4 = 0;
            return n4;
        }
    }

    protected int getLineFromRow(int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n2 = this.getFontHeight();
        int n3 = n;
        Insets insets = basicEditorPane.getInsets();
        int n4 = n3 * n2 + insets.top;
        int n5 = basicEditorPane.viewToModel(new Point(0, n4));
        BasicDocument basicDocument = this.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        return lineMap.getLineFromOffset(n5);
    }

    protected int getRowCount() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n = this.getFontHeight();
        Insets insets = basicEditorPane.getInsets();
        int n2 = insets.top + insets.bottom;
        int n3 = basicEditorPane.getHeight();
        int n4 = (n3 - n2) / n;
        int n5 = basicEditorPane.getIntegerProperty("trailing-blank-rows");
        return n4 - n5;
    }

    protected int getClosestLineFromCoordinate(int n) {
        int n2 = this.getTopPadding();
        int n3 = n - n2;
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = this.getFontHeight();
        int n5 = this.getRowCount();
        int n6 = Math.min(n3 / n4, n5);
        return this.getLineFromRow(n6);
    }

    protected int getLineFromOffset(int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getLineFromOffset(n);
    }

    protected int getLineStartOffset(int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getLineStartOffset(n);
    }

    protected int getTopPadding() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        Insets insets = basicEditorPane.getInsets();
        Insets insets2 = this.getInsets();
        return insets.top - insets2.top;
    }

    protected int getFontHeight() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        Font font = basicEditorPane.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.getHeight();
    }

    protected int getLineCount() {
        BasicDocument basicDocument = this.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        return lineMap.getLineCount();
    }

    protected int getCaretPosition() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane != null ? basicEditorPane.getCaretPosition() : 0;
    }

    protected void ensurePositionVisible(int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        basicEditorPane.ensurePositionVisible(n);
    }

    protected int getBlankLines() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getIntegerProperty("trailing-blank-rows");
    }

    protected boolean isCodeFoldingHighlight() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return basicEditorPane.getBooleanProperty("code-folding-highlight");
    }

    protected boolean isCodeFoldingEnabled() {
        CodeFoldingModel codeFoldingModel = this.getModel();
        BasicEditorPane basicEditorPane = this.getEditorPane();
        return codeFoldingModel != null && basicEditorPane.getBooleanProperty("code-folding-enabled");
    }

    protected void fireCodeWillExpand(Object object) throws CodeExpansionVetoException {
        CodeExpansionEvent codeExpansionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == CodeWillExpandListener.class) {
                if (codeExpansionEvent == null) {
                    BasicEditorPane basicEditorPane = this.getEditorPane();
                    codeExpansionEvent = new CodeExpansionEvent(basicEditorPane, object);
                }
                CodeWillExpandListener codeWillExpandListener = (CodeWillExpandListener)objectArray[n + 1];
                codeWillExpandListener.codeWillExpand(codeExpansionEvent);
            }
            n -= 2;
        }
    }

    protected void fireCodeExpanded(Object object) {
        CodeExpansionEvent codeExpansionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == CodeExpansionListener.class) {
                if (codeExpansionEvent == null) {
                    BasicEditorPane basicEditorPane = this.getEditorPane();
                    codeExpansionEvent = new CodeExpansionEvent(basicEditorPane, object);
                }
                CodeExpansionListener codeExpansionListener = (CodeExpansionListener)objectArray[n + 1];
                codeExpansionListener.codeExpanded(codeExpansionEvent);
            }
            n -= 2;
        }
    }

    protected void fireCodeWillCollapse(Object object) throws CodeExpansionVetoException {
        CodeExpansionEvent codeExpansionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == CodeWillExpandListener.class) {
                if (codeExpansionEvent == null) {
                    BasicEditorPane basicEditorPane = this.getEditorPane();
                    codeExpansionEvent = new CodeExpansionEvent(basicEditorPane, object);
                }
                CodeWillExpandListener codeWillExpandListener = (CodeWillExpandListener)objectArray[n + 1];
                codeWillExpandListener.codeWillCollapse(codeExpansionEvent);
            }
            n -= 2;
        }
    }

    protected void fireCodeCollapsed(Object object) {
        CodeExpansionEvent codeExpansionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == CodeExpansionListener.class) {
                if (codeExpansionEvent == null) {
                    BasicEditorPane basicEditorPane = this.getEditorPane();
                    codeExpansionEvent = new CodeExpansionEvent(basicEditorPane, object);
                }
                CodeExpansionListener codeExpansionListener = (CodeExpansionListener)objectArray[n + 1];
                codeExpansionListener.codeCollapsed(codeExpansionEvent);
            }
            n -= 2;
        }
    }

    public Dimension getPreferredSize() {
        int n = this.getPreferredWidth();
        int n2 = this.getPreferredHeight();
        return new Dimension(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getWidth();
        SwingUtilities.computeIntersection(0, 0, n, this.getHeight(), rectangle);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color = UIManager.getColor("textHighlight");
        int n2 = rectangle.y + rectangle.height;
        int n3 = this.getFontHeight();
        CodeFoldingModel codeFoldingModel = this.getModel();
        if (codeFoldingModel == null) {
            return;
        }
        codeFoldingModel.readLock();
        try {
            Object object;
            int n4;
            Object object2;
            if (this.isCodeFoldingHighlight() && (object2 = this.getSmallestEnclosingBlock(n4 = this.getLastCaretPosition())) != null) {
                int[] nArray = this.TEMP_OFFSETS;
                // MONITORENTER : this.TEMP_OFFSETS
                codeFoldingModel.getTextOffsets(object2, this.TEMP_OFFSETS);
                int n5 = this.TEMP_OFFSETS[0];
                int n6 = this.TEMP_OFFSETS[1];
                // MONITOREXIT : nArray
                int n7 = this.getYCoordinateFromOffset(n5);
                n7 = Math.max(n7, rectangle.y);
                int n8 = this.getYCoordinateFromOffset(n6) + n3;
                n8 = Math.min(n8, n2);
                if (n8 > n7) {
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setColor(color);
                    graphics2D.setComposite(BLOCK_HIGHLIGHT_COMPOSITE);
                    graphics2D.fillRect(0, n7, n, n8 - n7);
                    graphics2D.setComposite(composite);
                }
            }
            if (!this.isCodeFoldingEnabled()) return;
            Point point = this.getLastMousePosition();
            if (point != null) {
                int n9 = this.getClosestLineFromCoordinate(point.y);
                Object object3 = this.getFirstBlockAtLine(n9);
                if (object3 == null) {
                    int n10 = this.getLineStartOffset(n9);
                    object3 = this.getSmallestEnclosingBlock(n10);
                }
                if (object3 != null && codeFoldingModel.isExpanded(object3)) {
                    int[] nArray = this.TEMP_OFFSETS;
                    // MONITORENTER : this.TEMP_OFFSETS
                    codeFoldingModel.getTextOffsets(object3, this.TEMP_OFFSETS);
                    int n11 = this.TEMP_OFFSETS[0];
                    int n12 = this.TEMP_OFFSETS[1];
                    // MONITOREXIT : nArray
                    int n13 = this.getYCoordinateFromOffset(n11) + n3 / 2;
                    n13 = Math.max(n13, rectangle.y);
                    int n14 = this.getYCoordinateFromOffset(n12) + n3 - 1;
                    n14 = Math.min(n14, n2);
                    if (n14 >= n13) {
                        Insets insets = this.getInsets();
                        int n15 = (n + insets.left - insets.right) / 2;
                        graphics2D.setColor(color);
                        graphics2D.drawLine(n15, n13, n15, n14);
                        if (n14 <= n2) {
                            graphics2D.drawLine(n15, n14, n15 + 2, n14);
                        }
                    }
                }
            }
            if ((object = codeFoldingModel.getRoot()) == null) return;
            this.paintChildTurners(graphics2D, rectangle, codeFoldingModel, object);
            return;
        }
        finally {
            codeFoldingModel.readUnlock();
        }
    }

    protected void paintChildTurners(Graphics graphics, Rectangle rectangle, CodeFoldingModel codeFoldingModel, Object object) {
        Iterator iterator = codeFoldingModel.getChildren(object);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.isTurnerDamaged(rectangle, codeFoldingModel, e)) {
                this.paintTurner(graphics, codeFoldingModel, e);
            }
            if (!codeFoldingModel.isExpanded(e)) continue;
            this.paintChildTurners(graphics, rectangle, codeFoldingModel, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTurner(Graphics graphics, CodeFoldingModel codeFoldingModel, Object object) {
        boolean bl = codeFoldingModel.isExpanded(object);
        Icon icon = this.getExpandedIcon();
        Icon icon2 = this.getCollapsedIcon();
        Icon icon3 = bl ? icon : icon2;
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            codeFoldingModel.getTextOffsets(object, this.TEMP_OFFSETS);
            int n = this.TEMP_OFFSETS[0];
            // ** MonitorExit[var16_8] (shouldn't be in output)
            int n2 = this.getYCoordinateFromOffset(n);
            int n3 = icon3.getIconHeight();
            int n4 = icon3.getIconWidth();
            int n5 = this.getFontHeight();
            int n6 = this.getWidth();
            int n7 = (n6 - n4) / 2;
            int n8 = n2 + (n5 - n3) / 2;
            icon3.paintIcon(this, graphics, n7, n8);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTurnerDamaged(Rectangle rectangle, CodeFoldingModel codeFoldingModel, Object object) {
        int[] nArray = this.TEMP_OFFSETS;
        synchronized (this.TEMP_OFFSETS) {
            codeFoldingModel.getTextOffsets(object, this.TEMP_OFFSETS);
            int n = this.TEMP_OFFSETS[0];
            // ** MonitorExit[var8_4] (shouldn't be in output)
            int n2 = this.getFontHeight();
            int n3 = this.getYCoordinateFromOffset(n);
            int n4 = n3 + n2;
            return n3 <= rectangle.y + rectangle.height && n4 >= rectangle.y;
        }
    }

    private Point getLastMousePosition() {
        return this.lastMousePosition;
    }

    private void setLastMousePosition(Point point) {
        this.lastMousePosition = point;
        this.repaint();
    }

    private int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    private void setLastCaretPosition(int n) {
        this.lastCaretPosition = n;
    }

    private PopupCodeWindow getPopupWindow() {
        if (this.popupWindow == null) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            this.popupWindow = new PopupCodeWindow(basicEditorPane);
        }
        return this.popupWindow;
    }

    private void showPopupWindow(Point point, Point point2) {
        if (this.isCodeFoldingEnabled()) {
            int n;
            int n2 = point.y;
            int n3 = this.getClosestLineFromCoordinate(n2);
            if (point2 != null && n3 == (n = this.getClosestLineFromCoordinate(point2.y))) {
                return;
            }
            this.hidePopupWindow();
            CodeFoldingModel codeFoldingModel = this.getModel();
            codeFoldingModel.readLock();
            try {
                Object object = this.getFirstBlockAtLine(n3);
                if (object != null && !codeFoldingModel.isExpanded(object)) {
                    this.popupWindow = this.getPopupWindow();
                    String string = codeFoldingModel.getToolTipText(object);
                    this.popupWindow.setText(string);
                    Point point3 = this.getLocationOnScreen();
                    Insets insets = this.popupWindow.getPopupInsets();
                    int n4 = this.getLineStartOffset(n3);
                    int n5 = point3.x + this.getWidth() - insets.left;
                    int n6 = point3.y + this.getYCoordinateFromOffset(n4) - insets.top;
                    this.popupWindow.setLocation(n5, n6);
                    Dimension dimension = this.popupWindow.getContentPane().getPreferredSize();
                    this.popupWindow.setSize(dimension.width, dimension.height);
                    this.popupWindow.validate();
                    this.popupWindow.setVisible(true);
                }
            }
            finally {
                codeFoldingModel.readUnlock();
            }
        }
    }

    private void hidePopupWindow() {
        if (this.isCodeFoldingEnabled() && this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void disposePopupWindow() {
        if (this.isCodeFoldingEnabled() && this.popupWindow != null) {
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
    }

    static BasicStroke ra$DASHED_STROKE() {
        return DASHED_STROKE;
    }

    static void mav$hidePopupWindow(CodeFoldingMargin codeFoldingMargin) {
        codeFoldingMargin.hidePopupWindow();
    }

    static void mav$setLastMousePosition(CodeFoldingMargin codeFoldingMargin, Point point) {
        codeFoldingMargin.setLastMousePosition(point);
    }

    static Point mav$getLastMousePosition(CodeFoldingMargin codeFoldingMargin) {
        return codeFoldingMargin.getLastMousePosition();
    }

    static void mav$showPopupWindow(CodeFoldingMargin codeFoldingMargin, Point point, Point point2) {
        codeFoldingMargin.showPopupWindow(point, point2);
    }

    static void mav$setLastCaretPosition(CodeFoldingMargin codeFoldingMargin, int n) {
        codeFoldingMargin.setLastCaretPosition(n);
    }

    private static final class DottedRightBorder
    extends AbstractBorder {
        public static final int WIDTH = 1;

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(component.getForeground());
            graphics2D.setStroke(CodeFoldingMargin.ra$DASHED_STROKE());
            graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 0;
            insets.top = 0;
            insets.left = 0;
            insets.right = 1;
            return insets;
        }

        private DottedRightBorder() {
        }

        DottedRightBorder(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class EventHandler
    implements CodeFoldingModelListener,
    PropertyChangeListener,
    MouseMotionListener,
    MouseListener,
    ComponentListener,
    CaretListener,
    ActionListener {
        private static final int CARET_UPDATE_DELAY_MSEC = 150;
        private CodeFoldingMargin margin;
        private Timer caretUpdateTimer;

        public EventHandler(CodeFoldingMargin codeFoldingMargin) {
            this.margin = codeFoldingMargin;
            this.caretUpdateTimer = new Timer(150, this);
            this.caretUpdateTimer.setRepeats(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.caretUpdateTimer) {
                this.updateMargin();
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.caretUpdateTimer.restart();
            int n = caretEvent.getDot();
            if (this.margin.expandEnclosingBlocks(n)) {
                this.margin.ensurePositionVisible(n);
            }
        }

        private void updateMargin() {
            int n = this.margin.getCaretPosition();
            CodeFoldingMargin.mav$setLastCaretPosition(this.margin, n);
            this.margin.repaint();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.margin.invalidate();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        private boolean isValidXCoordinate(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            int n = mouseEvent.getX();
            return n > 0 && n < component.getWidth() - 1;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.isValidXCoordinate(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                Point point2 = CodeFoldingMargin.mav$getLastMousePosition(this.margin);
                CodeFoldingMargin.mav$showPopupWindow(this.margin, point, point2);
                CodeFoldingMargin.mav$setLastMousePosition(this.margin, point);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            CodeFoldingMargin.mav$hidePopupWindow(this.margin);
            CodeFoldingMargin.mav$setLastMousePosition(this.margin, null);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            CodeFoldingMargin.mav$hidePopupWindow(this.margin);
            BasicEditorPane basicEditorPane = this.getEditorPane();
            if (!basicEditorPane.hasFocus()) {
                basicEditorPane.requestFocus();
            }
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            } else if (this.margin.isCodeFoldingEnabled() && mouseEvent.getButton() == 1) {
                CodeFoldingModel codeFoldingModel = this.getModel();
                codeFoldingModel.readLock();
                try {
                    int n = this.margin.getClosestLineFromCoordinate(mouseEvent.getY());
                    Object object = this.margin.getFirstBlockAtLine(n);
                    if (object != null) {
                        boolean bl = codeFoldingModel.isExpanded(object);
                        this.margin.setExpansionState(object, bl ^ true);
                    }
                }
                finally {
                    codeFoldingModel.readUnlock();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            CodeFoldingProvider codeFoldingProvider;
            JPopupMenu jPopupMenu;
            if (this.margin.isCodeFoldingEnabled() && (jPopupMenu = (codeFoldingProvider = this.getProvider()).getPopupMenu()) != null && jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.show(this.margin, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEntered(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            BasicEditorPane basicEditorPane;
            Object object = propertyChangeEvent.getSource();
            if (object == (basicEditorPane = this.getEditorPane()) && (string = propertyChangeEvent.getPropertyName()).equals("background")) {
                this.margin.setBackground(basicEditorPane.getBackground());
            }
        }

        public void structureChanged(CodeFoldingModelEvent codeFoldingModelEvent) {
            this.margin.repaint();
        }

        private CodeFoldingProvider getProvider() {
            return this.margin.getProvider();
        }

        private CodeFoldingModel getModel() {
            return this.margin.getModel();
        }

        private BasicEditorPane getEditorPane() {
            return this.margin.getEditorPane();
        }
    }

    private static final class PopupCodeWindow
    extends JWindow {
        private JScrollPane popupScrollPane;
        private BasicEditorPane popupEditorPane;

        public PopupCodeWindow(BasicEditorPane basicEditorPane) {
            super(SwingUtilities.getWindowAncestor(basicEditorPane));
            this.initializeFrom(basicEditorPane);
        }

        public void setText(String string) {
            this.popupEditorPane.setText(string);
        }

        public String getText() {
            return this.popupEditorPane.getText();
        }

        public Insets getPopupInsets() {
            Insets insets = super.getInsets();
            Container container = this.popupEditorPane;
            while (container != this) {
                Insets insets2 = ((Container)container).getInsets();
                insets.top += insets2.top;
                insets.left += insets2.left;
                insets.bottom += insets2.bottom;
                insets.right += insets2.right;
                container = container.getParent();
            }
            return insets;
        }

        private void initializeFrom(BasicEditorPane basicEditorPane) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            LanguageSupport languageSupport2 = LanguageModule.createSupportForFileType(languageSupport.getClass());
            BasicDocument basicDocument2 = new BasicDocument();
            basicDocument2.setLanguageSupport(languageSupport2);
            this.popupEditorPane = new BasicEditorPane();
            this.popupEditorPane.setDocument(basicDocument2);
            this.popupEditorPane.setBorder(BorderFactory.createEmptyBorder());
            this.popupEditorPane.setOpaque(false);
            Border border = UIManager.getBorder("ToolTip.border");
            this.popupScrollPane = new JScrollPane(this.popupEditorPane);
            this.popupScrollPane.setBorder(border);
            this.popupScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            Insets insets = basicEditorPane.getInsets();
            Border border2 = BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right);
            this.popupScrollPane.setViewportBorder(border2);
            this.popupScrollPane.getViewport().setOpaque(false);
            this.getContentPane().add(this.popupScrollPane);
            this.setFocusableWindowState(false);
        }
    }
}

