/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;

public class DefaultCodeFoldingModel
implements CodeFoldingModel {
    protected static final int MAX_TOOLTIP_LENGTH = 4096;
    protected static final Object[] NO_BLOCKS = new Object[0];
    protected DefaultFoldingBlock root;
    protected BasicDocument document;
    protected EventListenerList listenerList;
    protected ReadWriteLock lock;

    public DefaultCodeFoldingModel(BasicDocument basicDocument) {
        this.document = basicDocument;
        this.listenerList = new EventListenerList();
        this.lock = new ReadWriteLock();
    }

    public BasicDocument getDocument() {
        return this.document;
    }

    public void reload() {
        FoldingBlock foldingBlock;
        this.readLock();
        try {
            foldingBlock = (FoldingBlock)this.getRoot();
        }
        finally {
            this.readUnlock();
        }
        this.fireStructureChanged(foldingBlock);
    }

    public void setRoot(Object object) {
        DefaultFoldingBlock defaultFoldingBlock;
        this.writeLock();
        try {
            defaultFoldingBlock = this.root;
            this.root = (DefaultFoldingBlock)object;
        }
        finally {
            this.writeUnlock();
        }
        if (object != defaultFoldingBlock) {
            this.fireStructureChanged(this.root);
        }
    }

    public CodeFoldingModelListener[] getCodeFoldingModelListeners() {
        return (CodeFoldingModelListener[])this.listenerList.getListeners(CodeFoldingModelListener.class);
    }

    public void insertUpdate(int n, int n2) {
        this.writeLock();
        try {
            DefaultFoldingBlock defaultFoldingBlock = (DefaultFoldingBlock)this.getRoot();
            if (defaultFoldingBlock != null) {
                this.insertUpdateChildren(defaultFoldingBlock, n, n2);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeUpdate(int n, int n2) {
        this.writeLock();
        try {
            DefaultFoldingBlock defaultFoldingBlock = (DefaultFoldingBlock)this.getRoot();
            if (defaultFoldingBlock != null) {
                this.removeUpdateChildren(defaultFoldingBlock, n, n2);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void insertUpdateChildren(DefaultFoldingBlock defaultFoldingBlock, int n, int n2) {
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            DefaultFoldingBlock defaultFoldingBlock2 = (DefaultFoldingBlock)iterator.next();
            int n3 = defaultFoldingBlock2.getStartOffset();
            int n4 = defaultFoldingBlock2.getEndOffset();
            if (n <= n3) {
                defaultFoldingBlock2.setStartOffset(n3 + n2);
                defaultFoldingBlock2.setEndOffset(n4 + n2);
                this.insertUpdateChildren(defaultFoldingBlock2, n, n2);
                continue;
            }
            if (n >= n4) continue;
            defaultFoldingBlock2.setEndOffset(n4 + n2);
            this.insertUpdateChildren(defaultFoldingBlock2, n, n2);
        }
    }

    protected void removeUpdateChildren(DefaultFoldingBlock defaultFoldingBlock, int n, int n2) {
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            DefaultFoldingBlock defaultFoldingBlock2 = (DefaultFoldingBlock)iterator.next();
            int n3 = defaultFoldingBlock2.getStartOffset();
            int n4 = defaultFoldingBlock2.getEndOffset();
            if (n <= n3) {
                if (n + n2 > n3) {
                    iterator.remove();
                    continue;
                }
                defaultFoldingBlock2.setStartOffset(n3 - n2);
                defaultFoldingBlock2.setEndOffset(n4 - n2);
                this.removeUpdateChildren(defaultFoldingBlock2, n, n2);
                continue;
            }
            if (n >= n4) continue;
            if (n + n2 >= n4) {
                defaultFoldingBlock2.setEndOffset(n);
            } else {
                defaultFoldingBlock2.setEndOffset(n4 - n2);
            }
            this.removeUpdateChildren(defaultFoldingBlock2, n, n2);
        }
    }

    public void readLock() {
        BasicDocument basicDocument = this.getDocument();
        basicDocument.readLock();
        this.lock.readLock();
    }

    public void readUnlock() {
        BasicDocument basicDocument = this.getDocument();
        this.lock.readUnlock();
        basicDocument.readUnlock();
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getSmallestEnclosingBlock(int n) {
        FoldingBlock foldingBlock = (FoldingBlock)this.getRoot();
        if (foldingBlock != null) {
            return this.getEnclosingDescendant(foldingBlock, n);
        }
        return null;
    }

    public Object getFirstBlockAtLine(int n) {
        FoldingBlock foldingBlock = (FoldingBlock)this.getRoot();
        if (foldingBlock != null) {
            return this.getFirstDescendantAtLine(foldingBlock, n);
        }
        return null;
    }

    public Object[] getCollapsedBlocks() {
        FoldingBlock foldingBlock = (FoldingBlock)this.getRoot();
        if (foldingBlock != null) {
            ArrayList arrayList = new ArrayList();
            this.getCollapsedDescendants(foldingBlock, arrayList);
            return arrayList.toArray(new Object[arrayList.size()]);
        }
        return NO_BLOCKS;
    }

    public String getToolTipText(Object object) {
        String string;
        BasicDocument basicDocument = this.getDocument();
        FoldingBlock foldingBlock = (FoldingBlock)object;
        int n = foldingBlock.getStartOffset();
        int n2 = foldingBlock.getEndOffset();
        int n3 = this.getLineFromOffset(n);
        int n4 = this.getLineStartOffset(n3);
        basicDocument.readLock();
        try {
            try {
                int n5 = n2 - n4;
                n5 = Math.min(n5, 4096);
                string = basicDocument.getText(n4, n5);
            }
            catch (BadLocationException badLocationException) {
                string = null;
            }
        }
        finally {
            basicDocument.readUnlock();
        }
        return string;
    }

    public Iterator getChildren(Object object) {
        FoldingBlock foldingBlock = (FoldingBlock)object;
        return foldingBlock.getChildren();
    }

    public Object getParent(Object object) {
        FoldingBlock foldingBlock = (FoldingBlock)object;
        return foldingBlock.getParent();
    }

    public int[] getTextOffsets(Object object, int[] nArray) {
        if (nArray == null) {
            nArray = new int[2];
        }
        FoldingBlock foldingBlock = (FoldingBlock)object;
        nArray[0] = foldingBlock.getStartOffset();
        nArray[1] = foldingBlock.getEndOffset();
        return nArray;
    }

    public String getAbbreviatedText(Object object) {
        FoldingBlock foldingBlock = (FoldingBlock)object;
        return foldingBlock.getReplacementText();
    }

    public boolean isExpanded(Object object) {
        FoldingBlock foldingBlock = (FoldingBlock)object;
        return foldingBlock.isExpanded();
    }

    public void setExpanded(Object object, boolean bl) {
        FoldingBlock foldingBlock = (FoldingBlock)object;
        foldingBlock.setExpanded(bl);
    }

    public void addCodeFoldingModelListener(CodeFoldingModelListener codeFoldingModelListener) {
        this.listenerList.add(CodeFoldingModelListener.class, codeFoldingModelListener);
    }

    public void removeCodeFoldingModelListener(CodeFoldingModelListener codeFoldingModelListener) {
        this.listenerList.remove(CodeFoldingModelListener.class, codeFoldingModelListener);
    }

    protected void writeLock() {
        this.lock.writeLock();
    }

    protected void writeUnlock() {
        this.lock.writeUnlock();
    }

    protected int getLineFromOffset(int n) {
        BasicDocument basicDocument = this.getDocument();
        return basicDocument.getLineFromOffset(n);
    }

    protected int getLineCount() {
        BasicDocument basicDocument = this.getDocument();
        return basicDocument.getLineCount();
    }

    protected int getLineStartOffset(int n) {
        BasicDocument basicDocument = this.getDocument();
        return basicDocument.getLineStartOffset(n);
    }

    protected int getLineEndOffset(int n) {
        BasicDocument basicDocument = this.getDocument();
        return basicDocument.getLineEndOffset(n);
    }

    protected FoldingBlock getFirstDescendantAtLine(FoldingBlock foldingBlock, int n) {
        FoldingBlock foldingBlock2 = null;
        Iterator iterator = foldingBlock.getChildren();
        while (iterator.hasNext()) {
            FoldingBlock foldingBlock3 = (FoldingBlock)iterator.next();
            int n2 = foldingBlock3.getStartOffset();
            int n3 = this.getLineFromOffset(n2);
            if (n3 != n) continue;
            if (foldingBlock2 == null) {
                foldingBlock2 = foldingBlock3;
                continue;
            }
            int n4 = foldingBlock2.getStartOffset();
            if (n2 >= n4) continue;
            foldingBlock2 = foldingBlock3;
        }
        if (foldingBlock2 == null) {
            Iterator iterator2 = foldingBlock.getChildren();
            while (iterator2.hasNext()) {
                FoldingBlock foldingBlock4 = (FoldingBlock)iterator2.next();
                foldingBlock2 = this.getFirstDescendantAtLine(foldingBlock4, n);
                if (foldingBlock2 == null) continue;
                return foldingBlock2;
            }
        }
        return foldingBlock2;
    }

    protected FoldingBlock getEnclosingDescendant(FoldingBlock foldingBlock, int n) {
        Iterator iterator = foldingBlock.getChildren();
        while (iterator.hasNext()) {
            FoldingBlock foldingBlock2 = (FoldingBlock)iterator.next();
            if (!foldingBlock2.bounds(n)) continue;
            FoldingBlock foldingBlock3 = this.getEnclosingDescendant(foldingBlock2, n);
            return foldingBlock3 != null ? foldingBlock3 : foldingBlock2;
        }
        return null;
    }

    protected void getCollapsedDescendants(FoldingBlock foldingBlock, Collection collection) {
        Iterator iterator = foldingBlock.getChildren();
        while (iterator.hasNext()) {
            FoldingBlock foldingBlock2 = (FoldingBlock)iterator.next();
            boolean bl = foldingBlock2.isExpanded();
            if (!bl) {
                collection.add(foldingBlock2);
                continue;
            }
            this.getCollapsedDescendants(foldingBlock2, collection);
        }
    }

    protected void fireStructureChanged(FoldingBlock foldingBlock) {
        CodeFoldingModelEvent codeFoldingModelEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == CodeFoldingModelListener.class) {
                if (codeFoldingModelEvent == null) {
                    codeFoldingModelEvent = new CodeFoldingModelEvent(this, foldingBlock);
                }
                CodeFoldingModelListener codeFoldingModelListener = (CodeFoldingModelListener)objectArray[n + 1];
                codeFoldingModelListener.structureChanged(codeFoldingModelEvent);
            }
            n -= 2;
        }
    }
}

