/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.gutter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Log;

public class LineGutterPlugin
extends JComponent
implements TextBufferListener,
MouseMotionListener,
MouseListener,
Gutter,
EditorPlugin,
DocumentListener,
ComponentListener {
    private static final Log LOG;
    public static final int SHOW_LINE_NUMBERS_ALWAYS = 1;
    public static final int SHOW_LINE_NUMBERS_NEVER = 2;
    public static final int SHOW_LINE_NUMBERS_DEFAULT = 3;
    protected int _showLineNumberFlag;
    protected static List _scratchList;
    private static final boolean JUSTIFY_MARKS_RIGHT = true;
    private static final int LEFT_PADDING = 1;
    private static final int RIGHT_PADDING = 3;
    private static final int ICON_SPACING = 2;
    private static final int MINIMUM_DIGITS = 3;
    private int _minimumDigits;
    private List _columnsList;
    private int[] _columnGroupWidths;
    private boolean[] _columnGroupIsTiled;
    private int _preferredWidth;
    private int _reservedColumnWidth;
    private static final int MAX_ICON_WIDTH = 24;
    private CopyOnWriteList _clickListeners;
    private BasicEditorPane _editor;
    private HighlightLayer _highlightLayer;
    private BasicDocument _document;
    private Font _font;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontWidth;
    private int _lineCount;
    private int _rowCount;
    private volatile boolean _gutterResizeNeeded;
    private Dimension _gutterSize;
    private Rectangle _gutterBounds;
    private Rectangle _rolloverBounds;
    private boolean _showLineNumbers;
    private Color _borderColor;
    private int _pressedY;
    private boolean _selectStarted;
    private boolean _inReload;
    private int _location;
    private List temporaryMarksOnLine;
    private List temporaryOverlaidColumns;
    private static final int DRAG_SENSITIVITY = 4;
    protected boolean _mouseInGutter;
    protected GutterMark _mouseInMark;
    static final /* synthetic */ boolean $assertionsDisabled;
    protected static final Comparator MARK_COMPARATOR;

    static {
        $assertionsDisabled = LineGutterPlugin.class.desiredAssertionStatus() ^ true;
        LOG = new Log("gutter");
        _scratchList = null;
        MARK_COMPARATOR = new MarkComparator();
    }

    public LineGutterPlugin() {
        this.$init$();
        this.setFocusable(false);
    }

    public void install(BasicEditorPane basicEditorPane) {
        LOG.trace("installing {0}", this);
        this._columnsList = new ArrayList(5);
        this._clickListeners = new CopyOnWriteList(GutterClickListener.class);
        this._editor = basicEditorPane;
        this.installDocument((BasicDocument)basicEditorPane.getDocument());
        this._inReload = false;
        this._highlightLayer = basicEditorPane.createHighlightLayer();
        this._gutterResizeNeeded = true;
        this._gutterSize = new Dimension();
        this._gutterBounds = new Rectangle();
        this._rolloverBounds = new Rectangle();
        this.updateShowLineNumbers();
        this.updateMetrics();
        this.updateColors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        basicEditorPane.addComponentListener(this);
        this.setAutoscrolls(this.allowDragging());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    protected void installDocument(BasicDocument basicDocument) {
        this._document = basicDocument;
        this._document.addDocumentListener(this);
        LineMap lineMap = basicDocument.getLineMap();
        this._lineCount = lineMap.getLineCount();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.addTextBufferListener(this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        LOG.trace("deinstalling {0}", this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.unregisterComponent(this);
        this.setAutoscrolls(false);
        basicEditorPane.removeComponentListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.deinstallDocument(this._document);
        this._font = null;
        this._highlightLayer.removeAllHighlights();
        this._editor.destroyHighlightLayer(this._highlightLayer);
        this._highlightLayer = null;
        this._editor = null;
        this._columnsList = null;
        this._reservedColumnWidth = -1;
        this._clickListeners = null;
    }

    protected void deinstallDocument(BasicDocument basicDocument) {
        if (basicDocument != null && basicDocument == this._document) {
            this._document.removeDocumentListener(this);
            TextBuffer textBuffer = this._document.getTextBuffer();
            textBuffer.removeTextBufferListener(this);
            this._document = null;
        }
    }

    public String getToolTipText() {
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._mouseInMark != null) {
            Column column = (Column)this._mouseInMark.getGutterColumn();
            return column.getMarkToolTip(this._mouseInMark, mouseEvent);
        }
        return null;
    }

    void $init$() {
        this._showLineNumberFlag = 3;
        this._minimumDigits = 3;
        this._preferredWidth = -1;
        this._reservedColumnWidth = -1;
        this._location = 2;
        this.temporaryMarksOnLine = new ArrayList();
        this.temporaryOverlaidColumns = new ArrayList();
        this._mouseInGutter = false;
        this._mouseInMark = null;
    }

    protected void updateShowLineNumbers() {
        boolean bl = this._showLineNumbers;
        switch (this._showLineNumberFlag) {
            case 1: {
                this._showLineNumbers = true;
                break;
            }
            case 2: {
                this._showLineNumbers = false;
                break;
            }
            default: {
                this._showLineNumbers = this._editor.getBooleanProperty("show-line-numbers");
            }
        }
        if (this._showLineNumbers != bl) {
            this.linesChanged();
        }
    }

    public void setShowLineNumbers(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this._showLineNumberFlag = n;
                break;
            }
            default: {
                this._showLineNumberFlag = 3;
            }
        }
        if (this._editor != null) {
            this.updateShowLineNumbers();
        }
    }

    public void setLocation(int n) {
        this._location = n;
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("show-line-numbers")) {
            this.updateShowLineNumbers();
        } else if (string.equals("gutter-enable-selection")) {
            this.setAutoscrolls(this.allowDragging());
        } else if (string.equals("editor-font")) {
            this.updateMetrics();
        } else if (string.equals("gutter-color-source") || string.equals("gutter-custom-bgcolor") || string.equals("gutter-custom-fgcolor") || string.equals("gutter-default-bordercolor") || string.equals("style-registry")) {
            this.updateColors();
            this.repaint();
        } else if (string.equals("document")) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof Document) {
                this.deinstallDocument(this._document);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                this.installDocument((BasicDocument)object);
            }
            this.discardAllMarks();
        }
    }

    protected void discardAllMarks() {
        int n = this._columnsList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this._columnsList.get(n2);
            column.discardAllGutterMarks();
            ++n2;
        }
    }

    protected static synchronized List allocateScratchList() {
        ArrayList arrayList = _scratchList;
        _scratchList = null;
        if (arrayList == null) {
            arrayList = new ArrayList(100);
        }
        return arrayList;
    }

    protected static synchronized void freeScratchList(List list) {
        if (list != null && _scratchList == null) {
            _scratchList = list;
            list.clear();
        }
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.updateColors();
    }

    protected void getMarksOnLine(Collection collection, int n) {
        int n2 = this._columnsList.size();
        int n3 = 0;
        while (n3 < n2) {
            Column column = (Column)this._columnsList.get(n3);
            column.getMarks(collection, n);
            ++n3;
        }
    }

    private void columnsChanged() {
        this._preferredWidth = -1;
        this._reservedColumnWidth = -1;
        this.revalidate();
        this.repaint();
    }

    private void markChanged(GutterMark gutterMark, int n, int n2) {
        if (this._preferredWidth >= 0) {
            int n3 = gutterMark.getLine();
            if (n == n2) {
                this.repaintLine(n3);
            } else {
                Column column = (Column)gutterMark.getGutterColumn();
                int n4 = this._columnGroupWidths[column.groupIndex];
                if (n <= n4 && n2 <= n4) {
                    if (!this._columnGroupIsTiled[column.groupIndex]) {
                        this.repaintLine(n3);
                    } else {
                        List list = column.group;
                        List list2 = LineGutterPlugin.allocateScratchList();
                        int n5 = 0;
                        while (n5 < list.size()) {
                            Column column2 = (Column)this._columnsList.get(n5);
                            column2.getMarks(list2, n3);
                            if (list2.size() > 1) break;
                            ++n5;
                        }
                        if (list2.size() == 1 && gutterMark == list2.get(0)) {
                            LOG.trace("repainting after scanning marks on line {0}", n3);
                            this.repaintLine(n3);
                        } else {
                            LOG.trace("revalidating after scanning marks on line {0}", n3);
                            this.marksChanged();
                        }
                        LineGutterPlugin.freeScratchList(list2);
                    }
                } else {
                    LOG.trace("revalidating after width change {0} to {1} on line {2}, reserved {3}", n, n2, n3, n4);
                    this.marksChanged();
                }
            }
        }
    }

    private void marksChanged() {
        this._preferredWidth = -1;
        this.revalidate();
        this.repaint();
    }

    private void columnMarksRemoved(Column column) {
        if (this._preferredWidth < 0) {
            return;
        }
        int n = column.groupIndex;
        if (this._columnGroupIsTiled[n]) {
            this.marksChanged();
        } else {
            List list = column._marksList;
            int n2 = column.getReservedWidth();
            int n3 = 0;
            while (n3 < list.size()) {
                GutterMark gutterMark = (GutterMark)list.get(n3);
                if (this.markWidth(gutterMark) > n2) {
                    this.marksChanged();
                    return;
                }
                ++n3;
            }
        }
        this.repaint();
    }

    private void linesChanged() {
        this.revalidate();
        this.repaint();
    }

    protected void updateColors() {
        Color color;
        Color color2;
        if (this._editor == null) {
            return;
        }
        int n = this._editor.getIntegerProperty("gutter-color-source");
        switch (n) {
            case 3: {
                color2 = (Color)this._editor.getProperty("gutter-custom-bgcolor");
                this._borderColor = color = (Color)this._editor.getProperty("gutter-custom-fgcolor");
                break;
            }
            case 2: {
                StyleRegistry styleRegistry = this._editor.getStyleRegistry();
                BaseStyle baseStyle = styleRegistry.lookupStyle("base-plain-style");
                color2 = baseStyle.getBackgroundColor();
                this._borderColor = color = baseStyle.getForegroundColor();
                break;
            }
            default: {
                color2 = UIManager.getColor("control");
                color = Color.darkGray;
                if (color2.equals(color)) {
                    color = Color.lightGray;
                }
                this._borderColor = Color.gray;
            }
        }
        Color color3 = (Color)this._editor.getProperty("gutter-default-bordercolor");
        if (color3 != null) {
            this._borderColor = color3;
        }
        if (color2 != null) {
            this.setBackground(color2);
        }
        if (color != null) {
            this.setForeground(color);
        }
    }

    protected void updateMetrics() {
        Font font = this._editor.getFont();
        if (this._font == null || font != this._font) {
            this._font = font;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this._fontHeight = fontMetrics.getHeight();
            this._fontAscent = fontMetrics.getAscent();
            this._fontWidth = fontMetrics.charWidth('0');
            this.linesChanged();
        }
    }

    public void revalidate() {
        this._gutterResizeNeeded = true;
        super.revalidate();
    }

    public Dimension getPreferredSize() {
        if (!this._gutterResizeNeeded) {
            return this._gutterSize;
        }
        if (this._editor == null) {
            return new Dimension(0, 0);
        }
        int n = this.recalculateLineWidths();
        int n2 = this.recalculateColumnWidths();
        int n3 = this._editor.getHeight();
        this._rowCount = this.getRowCount();
        this._gutterSize.width = Math.max(n, n2);
        this._gutterSize.height = n3;
        this._gutterResizeNeeded = false;
        return this._gutterSize;
    }

    protected void repaintLine(int n, int n2) {
        if (n <= 0 || n > this._lineCount) {
            return;
        }
        int n3 = n - 1;
        try {
            LineMap lineMap = this._document.getLineMap();
            int n4 = lineMap.getLineStartOffset(n3);
            Rectangle rectangle = this._editor.modelToView(n4);
            if (rectangle == null) {
                this.repaint();
            } else {
                this.repaint(0, rectangle.y - n2, this.getWidth(), rectangle.height + n2 * 2);
            }
        }
        catch (BadLocationException badLocationException) {
            this.repaint();
        }
    }

    protected void repaintLine(int n) {
        this.repaintLine(n, 0);
    }

    public void paint(Graphics graphics) {
        int n = this.getTopPadding();
        Rectangle rectangle = graphics.getClipBounds();
        this._gutterBounds.x = 0;
        this._gutterBounds.y = 0;
        this._gutterBounds.width = this.getWidth();
        this._gutterBounds.height = this.getHeight();
        rectangle = rectangle.intersection(this._gutterBounds);
        graphics.setFont(this._font);
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Color color = this.getForeground();
        if (this._borderColor != null) {
            graphics.setColor(this._borderColor);
        } else {
            graphics.setColor(color);
        }
        if (this._location == 4) {
            graphics.drawLine(this._gutterBounds.x, rectangle.y, this._gutterBounds.x, rectangle.y + rectangle.height - 1);
        } else {
            graphics.drawLine(this._gutterBounds.width - 1, rectangle.y, this._gutterBounds.width - 1, rectangle.y + rectangle.height - 1);
        }
        graphics.setColor(color);
        int n2 = this.getClosestRowFromCoordinate(rectangle.y);
        int n3 = this.getClosestRowFromCoordinate(rectangle.y + rectangle.height);
        int n4 = Math.max(LineGutterPlugin.numDigits(this._lineCount), 3);
        int n5 = this._gutterSize.width - 4;
        int n6 = n4 * this._fontWidth;
        int n7 = this._location == 4 ? 1 : n5 - n6 + 1;
        List list = LineGutterPlugin.allocateScratchList();
        char[] cArray = new char[n4];
        int n8 = 1;
        LineGutterPlugin.setNumber(cArray, n8);
        boolean bl = this._editor.getBooleanProperty("editor-antialiasing");
        Graphics2D graphics2D = bl && graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        Object object = null;
        if (graphics2D != null) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n9 = n2;
        while (n9 <= n3) {
            int n10 = this.getLineFromRow(n9);
            this.getVisibleMarks(list, n10);
            int n11 = (n9 - 1) * this._fontHeight + n;
            boolean bl2 = false;
            int n12 = this.getWidth() - 3;
            int n13 = list.size();
            int n14 = n13 - 1;
            while (n14 >= 0) {
                GutterMark gutterMark = (GutterMark)list.get(n14);
                Icon icon = gutterMark.getIcon();
                int n15 = this.markWidth(gutterMark);
                int n16 = n12 - n15;
                int n17 = icon.getIconWidth();
                int n18 = icon.getIconHeight();
                int n19 = n16 + (n15 - n17 >> 1);
                int n20 = n11 + (this._fontHeight - n18 >> 1);
                icon.paintIcon(this, graphics, n19, n20);
                bl2 = true;
                if (gutterMark == this._mouseInMark) {
                    this.paintRollover(graphics, gutterMark, n16, n15, n11);
                }
                n12 = n16 - 2;
                --n14;
            }
            if (!bl2 && this._showLineNumbers) {
                if (n10 == n8 + 1) {
                    LineGutterPlugin.incrementNumber(cArray);
                } else {
                    LineGutterPlugin.setNumber(cArray, n10);
                }
                int n21 = LineGutterPlugin.numDigits(cArray);
                int n22 = cArray.length - n21;
                int n23 = n11 + this._fontAscent;
                int n24 = n7;
                if (this._location == 2) {
                    n24 += n22 * this._fontWidth;
                }
                graphics.drawChars(cArray, n22, n21, n24, n23);
            }
            ++n9;
        }
        if (graphics2D != null && object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        LineGutterPlugin.freeScratchList(list);
    }

    protected Rectangle getRolloverRectFor(GutterMark gutterMark) {
        int n = gutterMark.getLine();
        int n2 = this.getRowFromLine(n);
        int n3 = (n2 - 1) * this._fontHeight + this.getTopPadding();
        List list = LineGutterPlugin.allocateScratchList();
        try {
            this.getVisibleMarks(list, n);
            Collections.sort(list, MARK_COMPARATOR);
            int n4 = this.getWidth() - 3;
            int n5 = list.size();
            int n6 = n5 - 1;
            while (n6 >= 0) {
                GutterMark gutterMark2 = (GutterMark)list.get(n6);
                int n7 = this.markWidth(gutterMark2);
                int n8 = n4 - n7;
                if (gutterMark2 == gutterMark) {
                    Rectangle rectangle = this.calculateRolloverBounds(new Rectangle(), n8, n7, n3);
                    LineGutterPlugin.freeScratchList(list);
                    return rectangle;
                }
                n4 = n8 - 2;
                --n6;
            }
            Rectangle rectangle = null;
            LineGutterPlugin.freeScratchList(list);
            return rectangle;
        }
        catch (Throwable throwable) {
            LineGutterPlugin.freeScratchList(list);
            throw throwable;
        }
    }

    private List getVisibleMarks(List list, int n) {
        this.temporaryMarksOnLine.clear();
        this.getMarksOnLine(this.temporaryMarksOnLine, n);
        Collections.sort(this.temporaryMarksOnLine, MARK_COMPARATOR);
        List list2 = this.temporaryMarksOnLine;
        int n2 = 0;
        int n3 = this.temporaryMarksOnLine.size();
        return this.filterVisibleMarks(list2, n2, n3, list);
    }

    private List filterVisibleMarks(List list, int n, int n2, List list2) {
        List list3 = this.temporaryOverlaidColumns;
        list3.clear();
        list2.clear();
        int n3 = n;
        while (n3 < n2) {
            Column column = (Column)((GutterMark)list.get(n3)).getGutterColumn();
            int n4 = column.getLayoutConstraint();
            String string = column.getLayoutColumn();
            if (n4 == 2 && string != null) {
                list3.add(string);
            }
            ++n3;
        }
        int n5 = n;
        while (n5 < n2) {
            GutterColumn gutterColumn;
            GutterMark gutterMark = (GutterMark)list.get(n5);
            if (gutterMark.isVisible() && gutterMark.getIcon() != null && list3.indexOf((gutterColumn = gutterMark.getGutterColumn()).getColumnName()) < 0) {
                list2.add(gutterMark);
            }
            ++n5;
        }
        return list2;
    }

    protected Rectangle calculateRolloverBounds(Rectangle rectangle, int n, int n2, int n3) {
        rectangle.x = n - 2;
        rectangle.y = n3;
        rectangle.width = n2 + 3;
        rectangle.height = this._fontHeight - 1;
        return rectangle;
    }

    protected int markWidth(GutterMark gutterMark) {
        if (!gutterMark.isVisible()) {
            return 0;
        }
        Icon icon = gutterMark.getIcon();
        if (icon == null) {
            return 0;
        }
        return Math.min(icon.getIconWidth(), 24);
    }

    protected int reservedColumnWidth(GutterColumn gutterColumn) {
        int n;
        if (gutterColumn instanceof Column && (n = ((Column)gutterColumn).getReservedWidth()) > 0) {
            return Math.min(n, 24);
        }
        return 0;
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark gutterMark, int n, int n2, int n3) {
        Column column = (Column)gutterMark.getGutterColumn();
        if (column.getMarkSupportsClicks(gutterMark)) {
            this.calculateRolloverBounds(this._rolloverBounds, n, n2, n3);
            Color color = graphics.getColor();
            graphics.setColor(this._borderColor);
            graphics.drawRect(this._rolloverBounds.x, this._rolloverBounds.y, this._rolloverBounds.width, this._rolloverBounds.height);
            graphics.setColor(color);
            return this._rolloverBounds;
        }
        return null;
    }

    protected static void setNumber(char[] cArray, int n) {
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = 32;
            ++n3;
        }
        String string = Integer.toString(n);
        char[] cArray2 = string.toCharArray();
        int n4 = cArray2.length;
        int n5 = n2 - n4;
        System.arraycopy(cArray2, 0, cArray, n5, n4);
    }

    protected static void incrementNumber(char[] cArray) {
        int n = cArray.length;
        int n2 = 1;
        int n3 = n - 1;
        while (n3 >= 0) {
            char c = cArray[n3];
            int n4 = c == ' ' ? 0 : c - 48;
            n2 = 0;
            if ((n4 += n2) > 9) {
                n2 = 1;
                n4 -= 10;
            }
            cArray[n3] = (char)(n4 + 48);
            if (n2 == 0) break;
            --n3;
        }
    }

    protected static int numDigits(char[] cArray) {
        int n;
        int n2 = n = cArray.length;
        int n3 = 0;
        while (n3 < n) {
            if (cArray[n3] != ' ') break;
            --n2;
            ++n3;
        }
        return n2;
    }

    protected int recalculateLineWidths() {
        if (this._showLineNumbers) {
            this._minimumDigits = Math.max(this._minimumDigits, LineGutterPlugin.numDigits(this._lineCount));
            int n = 4 + this._fontWidth * this._minimumDigits;
            return n;
        }
        return 3 + this._fontWidth + 1;
    }

    protected int getRowCount() {
        Insets insets = this._editor.getInsets();
        int n = insets.top + insets.bottom;
        int n2 = this._editor.getPreferredSize().height;
        int n3 = (n2 - n) / this._fontHeight;
        int n4 = this._editor.getIntegerProperty("trailing-blank-rows");
        return n3 - n4;
    }

    protected int getLineFromRow(int n) {
        int n2 = n - 1;
        Insets insets = this._editor.getInsets();
        int n3 = n2 * this._fontHeight + insets.top;
        int n4 = this._editor.viewToModel(new Point(0, n3));
        LineMap lineMap = this._document.getLineMap();
        return lineMap.getLineFromOffset(n4) + 1;
    }

    protected int getRowFromLine(int n) {
        LineMap lineMap = this._document.getLineMap();
        int n2 = lineMap.getLineStartOffset(n - 1);
        try {
            Rectangle rectangle = this._editor.modelToView(n2);
            int n3 = this.getRowFromCoordinate(rectangle.y);
            return n3;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    protected int getRowFromCoordinate(int n) {
        int n2 = this.getTopPadding();
        int n3 = n - n2;
        if (n3 < 0) {
            return -1;
        }
        int n4 = n3 / this._fontHeight + 1;
        if (n4 <= this._rowCount) {
            return n4;
        }
        return -1;
    }

    protected int getClosestRowFromCoordinate(int n) {
        int n2 = this.getTopPadding();
        int n3 = n - n2;
        n3 = Math.max(0, n3);
        int n4 = n3 / this._fontHeight + 1;
        n4 = Math.min(n4, this._rowCount);
        return n4;
    }

    protected int getTopPadding() {
        Insets insets = this._editor.getInsets();
        Insets insets2 = this.getInsets();
        return insets.top - insets2.top;
    }

    protected int getLeftPadding() {
        Insets insets = this.getInsets();
        return 1 - insets.left;
    }

    public static int numDigits(int n) {
        if (n < 10) {
            return 1;
        }
        if (n < 100) {
            return 2;
        }
        if (n < 1000) {
            return 3;
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((n /= 10) != 0);
        return n2;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.linesChanged();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._inReload) {
            return;
        }
        int n = this._columnsList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this._columnsList.get(n2);
            column.insertUpdate(documentEvent);
            ++n2;
        }
        LineMap lineMap = this._document.getLineMap();
        this._lineCount = lineMap.getLineCount();
        this.linesChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this._inReload) {
            return;
        }
        int n = this._columnsList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this._columnsList.get(n2);
            column.removeUpdate(documentEvent);
            ++n2;
        }
        LineMap lineMap = this._document.getLineMap();
        this._lineCount = lineMap.getLineCount();
        this.linesChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        switch (n) {
            case 3: {
                this._inReload = true;
                break;
            }
            case 4: {
                this._inReload = false;
                LineMap lineMap = this._document.getLineMap();
                this._lineCount = lineMap.getLineCount();
                int n2 = this._columnsList.size();
                int n3 = 0;
                while (n3 < n2) {
                    Column column = (Column)this._columnsList.get(n3);
                    column.attributeUpdate(n);
                    ++n3;
                }
                this.linesChanged();
                break;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this._pressedY == -1) {
            return;
        }
        int n3 = mouseEvent.getY();
        if (!this._selectStarted) {
            int n4 = Math.abs(n3 - this._pressedY);
            if (n4 < 4) {
                return;
            }
            this._selectStarted = true;
        }
        boolean bl = (n2 = this.getClosestRowFromCoordinate(this._pressedY) - 1) <= (n = this.getClosestRowFromCoordinate(n3) - 1);
        int n5 = Math.min(n2, n);
        int n6 = Math.max(n2, n);
        Insets insets = this._editor.getInsets();
        int n7 = n5 * this._fontHeight + insets.top;
        int n8 = (n6 + 1) * this._fontHeight + insets.top;
        int n9 = this._editor.viewToModel(new Point(0, n7));
        int n10 = this._editor.viewToModel(new Point(0, n8));
        if (bl) {
            this._editor.setCaretPosition(n9);
            this._editor.moveCaretPosition(n10);
        } else {
            this._editor.setCaretPosition(n10);
            this._editor.moveCaretPosition(n9);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMouseInMark(mouseEvent);
    }

    protected boolean allowDragging() {
        boolean bl = this._editor.getBooleanProperty("gutter-enable-selection");
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this._editor.hasFocus()) {
            this._editor.requestFocus();
        }
        this._pressedY = -1;
        if (this.allowDragging()) {
            this._selectStarted = false;
            this._pressedY = Math.max(mouseEvent.getY(), 0);
        } else {
            this.processMousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._pressedY != -1 && !this._selectStarted) {
            this.processMousePressed(mouseEvent);
            this._pressedY = -1;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateMouseInMark(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateMouseInMark(mouseEvent);
    }

    protected void updateMouseInMark(MouseEvent mouseEvent) {
        GutterMark gutterMark = this._mouseInMark;
        switch (mouseEvent.getID()) {
            case 505: {
                this._mouseInGutter = false;
                this._mouseInMark = null;
                break;
            }
            case 504: {
                this._mouseInGutter = true;
                this._mouseInMark = null;
                break;
            }
        }
        GutterMark gutterMark2 = null;
        if (this._mouseInGutter) {
            gutterMark2 = this.getMarkAtLocation(mouseEvent.getY(), mouseEvent.getX());
        }
        this._mouseInMark = gutterMark2;
        if (gutterMark != gutterMark2) {
            if (gutterMark != null) {
                this.repaintLine(gutterMark.getLine(), 5);
            }
            if (gutterMark2 != null) {
                this.repaintLine(gutterMark2.getLine(), 5);
            }
        }
    }

    private GutterMark getMarkAtLocation(int n, int n2) {
        GutterMark gutterMark = null;
        int n3 = this.getLineFromRow(this.getRowFromCoordinate(n));
        if (n3 != -1) {
            List list = LineGutterPlugin.allocateScratchList();
            this.getVisibleMarks(list, n3);
            int n4 = this.getWidth() - 3;
            int n5 = list.size();
            int n6 = n5 - 1;
            while (n6 >= 0) {
                GutterMark gutterMark2 = (GutterMark)list.get(n6);
                int n7 = this.markWidth(gutterMark2);
                int n8 = n4 - n7;
                if (n8 <= n2 && n2 <= n4) {
                    gutterMark = gutterMark2;
                    break;
                }
                n4 = n8 - 2;
                --n6;
            }
            LineGutterPlugin.freeScratchList(list);
        }
        return gutterMark;
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        this.updateMouseInMark(mouseEvent);
        int n = mouseEvent.getX();
        if (n > this.getWidth() - 3 || n <= 1) {
            return;
        }
        int n2 = this.getLineFromRow(this.getRowFromCoordinate(mouseEvent.getY()));
        this.processMousePressed(mouseEvent, n2, this._mouseInMark);
        this.updateMouseInMark(mouseEvent);
    }

    protected void processMousePressed(MouseEvent mouseEvent, int n, GutterMark gutterMark) {
        if (gutterMark != null) {
            Column column = (Column)gutterMark.getGutterColumn();
            if (column.getMarkSupportsClicks(gutterMark)) {
                column.fireMarkClicked(mouseEvent, gutterMark, n);
            }
        } else {
            GutterClickListener[] gutterClickListenerArray = (GutterClickListener[])this._clickListeners.getItems();
            int n2 = gutterClickListenerArray.length;
            while (n2-- > 0) {
                try {
                    gutterClickListenerArray[n2].lineClicked(this, n, mouseEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public GutterColumn createGutterColumn(String string, GutterColumnListener gutterColumnListener) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        GutterColumn gutterColumn = this.lookupGutterColumn(string);
        if (gutterColumn != null) {
            return null;
        }
        LOG.trace("creating column {0} in {1}", string, (Object)this);
        Column column = this.createGutterColumnImpl(string, gutterColumnListener);
        this._columnsList.add(column);
        this.columnsChanged();
        return column;
    }

    protected Column createGutterColumnImpl(String string, GutterColumnListener gutterColumnListener) {
        return new Column(string, gutterColumnListener);
    }

    public GutterColumn lookupGutterColumn(String string) {
        if (string == null) {
            return null;
        }
        int n = this._columnsList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this._columnsList.get(n2);
            if (column.getColumnName().equals(string)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public void removeGutterColumn(GutterColumn gutterColumn) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this._columnsList.contains(gutterColumn)) {
            LOG.trace("removing column {0} from {1}", gutterColumn, (Object)this);
            gutterColumn.removeAllGutterMarks();
            this._columnsList.remove(gutterColumn);
            this.columnsChanged();
        }
    }

    public void removeAllGutterColumns() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        LOG.trace("removing all columns in {0}", this);
        int n = this._columnsList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this._columnsList.get(n2);
            column.removeAllGutterMarksImpl();
            ++n2;
        }
        this._columnsList.clear();
        this.columnsChanged();
    }

    protected void updateAllMarkHighlights() {
        this._document.readLock();
        try {
            int n = this._columnsList.size();
            int n2 = 0;
            while (n2 < n) {
                Column column = (Column)this._columnsList.get(n2);
                column.updateAllMarkHighlights();
                ++n2;
            }
        }
        finally {
            this._document.readUnlock();
        }
    }

    protected int recalculateColumnWidths() {
        if (this._preferredWidth < 0) {
            LOG.trace("recalculating preferred width");
            int n = this._columnsList.size();
            if (this._reservedColumnWidth < 0) {
                HashSet<String> hashSet = new HashSet<String>();
                int n2 = 0;
                while (n2 < n) {
                    Column column = (Column)this._columnsList.get(n2);
                    hashSet.add(column.getColumnName());
                    column.group = null;
                    column.groupIndex = -1;
                    ++n2;
                }
                ArrayList arrayList = new ArrayList(n);
                int n3 = 0;
                while (n3 < n) {
                    Column column = (Column)this._columnsList.get(n3);
                    Column column2 = (Column)this.lookupGutterColumn(column.getLayoutColumn());
                    if (column2 == null) {
                        if (column.group == null) {
                            ArrayList<Column> arrayList2 = new ArrayList<Column>();
                            arrayList2.add(column);
                            column.group = arrayList2;
                            arrayList.add(arrayList2);
                        }
                    } else if (column.group == null && column2.group == null) {
                        ArrayList<Column> arrayList3 = new ArrayList<Column>();
                        arrayList3.add(column);
                        arrayList3.add(column2);
                        column.group = column2.group = arrayList3;
                        arrayList.add(arrayList3);
                    } else if (column.group == null) {
                        List list = column2.group;
                        list.add(column);
                        column.group = list;
                    } else if (column2.group == null) {
                        List list = column.group;
                        list.add(column);
                        column2.group = list;
                    } else if (column.group != column2.group) {
                        List list = column2.group;
                        List list2 = column.group;
                        int n4 = 0;
                        while (n4 < list2.size()) {
                            Column column3 = (Column)list2.get(n4);
                            list.add(column3);
                            column3.group = list;
                            ++n4;
                        }
                        arrayList.remove(list2);
                    }
                    if (!$assertionsDisabled && column.group != null && column.group.size() != new HashSet(column.group).size()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && column2 != null && column2.group != null && column2.group.size() != new HashSet(column2.group).size()) {
                        throw new AssertionError();
                    }
                    ++n3;
                }
                int n5 = arrayList.size();
                this._columnGroupWidths = new int[n5];
                this._columnGroupIsTiled = new boolean[n5];
                this._reservedColumnWidth = 0;
                int n6 = 0;
                while (n6 < n5) {
                    List list = (List)arrayList.get(n6);
                    int n7 = 0;
                    boolean bl = false;
                    int n8 = 0;
                    while (n8 < list.size()) {
                        Column column = (Column)list.get(n8);
                        column.groupIndex = n6;
                        n7 = Math.max(n7, this.reservedColumnWidth(column));
                        bl |= column.getLayoutConstraint() == 1;
                        ++n8;
                    }
                    this._columnGroupWidths[n6] = n7;
                    this._columnGroupIsTiled[n6] = bl;
                    if (n7 > 0) {
                        if (this._reservedColumnWidth > 0) {
                            this._reservedColumnWidth += 2;
                        }
                        this._reservedColumnWidth += n7;
                    }
                    ++n6;
                }
                LOG.trace("recalculating column groups {0}, {1}, {2}", arrayList, (Object)this._columnGroupWidths, (Object)this._columnGroupIsTiled);
            }
            int n9 = this._reservedColumnWidth;
            List list = LineGutterPlugin.allocateScratchList();
            int n10 = 0;
            while (n10 < n) {
                Column column = (Column)this._columnsList.get(n10);
                column.getAllMarks(list);
                ++n10;
            }
            int n11 = list.size();
            if (n11 > 0) {
                Collections.sort(list, MARK_COMPARATOR);
                int n12 = 0;
                int n13 = ((GutterMark)list.get(0)).getLine();
                ArrayList arrayList = new ArrayList();
                int[] nArray = new int[this._columnGroupWidths.length];
                int n14 = 1;
                while (n14 <= n11) {
                    int n15;
                    int n16 = n15 = n14 < n11 ? ((GutterMark)list.get(n14)).getLine() : Integer.MAX_VALUE;
                    if (n15 != n13) {
                        this.filterVisibleMarks(list, n12, n14, arrayList);
                        int n17 = 0;
                        int n18 = 0;
                        System.arraycopy(this._columnGroupWidths, 0, nArray, 0, nArray.length);
                        int n19 = 0;
                        while (n19 < arrayList.size()) {
                            GutterMark gutterMark = (GutterMark)arrayList.get(n19);
                            int n20 = this.markWidth(gutterMark);
                            Column column = (Column)gutterMark.getGutterColumn();
                            int n21 = column.groupIndex;
                            int n22 = nArray[n21];
                            if (n20 < n22) {
                                n20 = n22;
                            }
                            nArray[n21] = 0;
                            if (n17 > 0) {
                                n17 += 2;
                            }
                            n17 += n20;
                            n18 = Math.max(n18, n20);
                            ++n19;
                        }
                        int n23 = 0;
                        while (n23 < nArray.length) {
                            int n24 = nArray[n23];
                            if (n24 > 0) {
                                if (n17 > 0) {
                                    n17 += 2;
                                }
                                n17 += n24;
                            }
                            ++n23;
                        }
                        n9 = Math.max(n9, n17);
                        n13 = n15;
                        n12 = n14;
                    }
                    ++n14;
                }
            }
            this._preferredWidth = 1 + n9 + 3;
            LineGutterPlugin.freeScratchList(list);
        }
        return this._preferredWidth;
    }

    public void addGutterClickListener(GutterClickListener gutterClickListener) {
        this._clickListeners.addIfAbsent(gutterClickListener);
    }

    public void removeGutterClickListener(GutterClickListener gutterClickListener) {
        this._clickListeners.remove(gutterClickListener);
    }

    public String toString() {
        return "Gutter#" + System.identityHashCode(this);
    }

    static int[] ra$_columnGroupWidths(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._columnGroupWidths;
    }

    static void mav$columnMarksRemoved(LineGutterPlugin lineGutterPlugin, Column column) {
        lineGutterPlugin.columnMarksRemoved(column);
    }

    static Log ra$LOG() {
        return LOG;
    }

    static void mav$markChanged(LineGutterPlugin lineGutterPlugin, GutterMark gutterMark, int n, int n2) {
        lineGutterPlugin.markChanged(gutterMark, n, n2);
    }

    static BasicDocument ra$_document(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._document;
    }

    static int ra$_lineCount(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._lineCount;
    }

    static void mav$columnsChanged(LineGutterPlugin lineGutterPlugin) {
        lineGutterPlugin.columnsChanged();
    }

    static BasicEditorPane ra$_editor(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._editor;
    }

    static HighlightLayer ra$_highlightLayer(LineGutterPlugin lineGutterPlugin) {
        return lineGutterPlugin._highlightLayer;
    }

    protected class Column
    implements GutterColumn {
        protected String _columnName;
        protected GutterColumnListener _columnListener;
        protected int _reservedWidth;
        protected String _layoutColumn;
        protected int _layoutConstraint;
        protected List _marksList;
        protected List group;
        protected int groupIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Column(String string, GutterColumnListener gutterColumnListener) {
            this.$init$();
            this._columnName = string;
            this._columnListener = gutterColumnListener;
            this._marksList = new ArrayList(10);
        }

        void $init$() {
            this._layoutConstraint = 0;
        }

        public void setReservedWidth(int n) {
            if (n != this._reservedWidth) {
                this._reservedWidth = n;
                LineGutterPlugin.mav$columnsChanged(LineGutterPlugin.this);
            }
        }

        protected int getReservedWidth() {
            return this._reservedWidth;
        }

        public void setLayoutConstraint(String string, int n) {
            if (n == 0) {
                string = null;
            } else {
                if (string == null) {
                    throw new IllegalArgumentException("columnName null");
                }
                if (string.equals(this._columnName)) {
                    throw new IllegalArgumentException("columnName circular");
                }
            }
            if (string == null ? this._layoutColumn != null : !string.equals(this._layoutColumn) || n != this._layoutConstraint) {
                this._layoutColumn = string;
                this._layoutConstraint = n;
                LineGutterPlugin.mav$columnsChanged(LineGutterPlugin.this);
            }
        }

        protected String getLayoutColumn() {
            return this._layoutColumn;
        }

        protected int getLayoutConstraint() {
            return this._layoutConstraint;
        }

        protected void updateAllMarkHighlights() {
            LineGutterPlugin.ra$_document(LineGutterPlugin.this).readLock();
            try {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                int n = this._marksList.size();
                int n2 = 0;
                while (n2 < n) {
                    Mark mark = (Mark)this._marksList.get(n2);
                    mark.updateHighlight(lineMap);
                    ++n2;
                }
            }
            finally {
                LineGutterPlugin.ra$_document(LineGutterPlugin.this).readUnlock();
            }
        }

        static {
            $assertionsDisabled = Column.class.desiredAssertionStatus() ^ true;
        }

        protected void discardAllGutterMarks() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int n = this._marksList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Mark mark = (Mark)this._marksList.get(n2);
                mark.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                try {
                    int n3 = mark.getLine();
                    if (!mark.isOptionSet(2)) {
                        this._columnListener.markRemoved(mark, n3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                --n2;
            }
            this._marksList.clear();
            LineGutterPlugin.ra$LOG().trace("revalidating after discarding all marks in column {0}", this);
            LineGutterPlugin.mav$columnMarksRemoved(LineGutterPlugin.this, this);
        }

        protected int getMarkCount() {
            return this._marksList.size();
        }

        protected void getAllMarks(Collection collection) {
            collection.addAll(this._marksList);
        }

        protected void getMarks(Collection collection, int n) {
            int n2 = this._marksList.size();
            int n3 = 0;
            while (n3 < n2) {
                Mark mark = (Mark)this._marksList.get(n3);
                if (mark.getLine() == n) {
                    collection.add(mark);
                }
                ++n3;
            }
        }

        protected int removeAllGutterMarksImpl() {
            int n = this._marksList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Mark mark = (Mark)this._marksList.get(n2);
                mark.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                --n2;
            }
            this._marksList.clear();
            return n;
        }

        protected boolean getMarkSupportsClicks(GutterMark gutterMark) {
            Mark mark = (Mark)gutterMark;
            return mark.isOptionSet(1);
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            return this._columnListener.getMarkToolTip(gutterMark, mouseEvent);
        }

        protected void fireMarkClicked(MouseEvent mouseEvent, GutterMark gutterMark, int n) {
            try {
                this._columnListener.markClicked(gutterMark, gutterMark.getLine(), mouseEvent);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        protected void insertUpdate(DocumentEvent documentEvent) {
            LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
            int n = documentEvent.getOffset();
            int n2 = lineMap.getLineCount() - LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this);
            ArrayList<Mark> arrayList = new ArrayList<Mark>();
            for (Mark mark : this._marksList) {
                int n3 = mark.getOffset();
                if (n > n3 || mark.isOptionSet(2)) continue;
                int n4 = mark.getLine();
                if (n2 == 0) {
                    n3 = lineMap.getLineStartOffset(n4 - 1);
                    mark.setOffset(n3);
                    continue;
                }
                int n5 = n4 + n2;
                n3 = lineMap.getLineStartOffset(n5 - 1);
                mark.setOffset(n3);
                mark.setLine(n5);
                arrayList.add(mark);
            }
            for (Mark mark : arrayList) {
                int n6 = mark.getLine();
                int n7 = n6 - n2;
                Mark.mav$moveMarkInFileOverviewMargin(mark, n7);
                try {
                    this._columnListener.markMoved(mark, n7, n6);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.updateAllMarkHighlights();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = lineMap.getLineFromOffset(n);
            int n4 = lineMap.getLineStartOffset(n3);
            int n5 = LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this) - lineMap.getLineCount();
            ArrayList<Mark> arrayList = new ArrayList<Mark>();
            ArrayList<Mark> arrayList2 = new ArrayList<Mark>();
            Iterator iterator = this._marksList.iterator();
            while (iterator.hasNext()) {
                Mark mark = (Mark)iterator.next();
                int n6 = mark.getOffset();
                if (n > n6 || mark.isOptionSet(2)) continue;
                int n7 = mark.getLine();
                if (n5 == 0) {
                    n6 = lineMap.getLineStartOffset(n7 - 1);
                    mark.setOffset(n6);
                    continue;
                }
                boolean bl = false;
                if (n <= n6 && n + n2 > n6) {
                    bl = true;
                } else if (n + n2 == n6 && n != n4) {
                    bl = true;
                }
                if (bl) {
                    iterator.remove();
                    arrayList2.add(mark);
                    mark.removeHighlight();
                    continue;
                }
                int n8 = n7 - n5;
                int n9 = lineMap.getLineStartOffset(n8 - 1);
                mark.setOffset(n9);
                mark.setLine(n8);
                arrayList.add(mark);
            }
            for (Mark mark : arrayList) {
                int n10 = mark.getLine();
                int n11 = n10 + n5;
                Mark.mav$moveMarkInFileOverviewMargin(mark, n11);
                try {
                    this._columnListener.markMoved(mark, n11, n10);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            for (Mark mark : arrayList2) {
                int n12 = mark.getLine();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                try {
                    this._columnListener.markRemoved(mark, n12);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.updateAllMarkHighlights();
        }

        public void attributeUpdate(int n) {
            if (n == 4) {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                ArrayList<Mark> arrayList = new ArrayList<Mark>();
                Iterator iterator = this._marksList.iterator();
                while (iterator.hasNext()) {
                    Mark mark = (Mark)iterator.next();
                    if (mark.isOptionSet(2)) continue;
                    int n2 = mark.getLine() - 1;
                    if (n2 < LineGutterPlugin.ra$_lineCount(LineGutterPlugin.this)) {
                        int n3 = lineMap.getLineStartOffset(n2);
                        mark.setOffset(n3);
                        continue;
                    }
                    arrayList.add(mark);
                    iterator.remove();
                    mark.removeHighlight();
                }
                for (Mark mark : arrayList) {
                    Mark.mav$removeMarkInFileOverviewMargin(mark);
                    int n4 = mark.getLine();
                    try {
                        this._columnListener.markRemoved(mark, n4);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                this.updateAllMarkHighlights();
            }
        }

        public Gutter getGutter() {
            return LineGutterPlugin.this;
        }

        public String getColumnName() {
            return this._columnName;
        }

        public GutterMark addGutterMark(int n, Icon icon, HighlightStyle highlightStyle, int n2, int n3) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            Mark mark = null;
            LineGutterPlugin.ra$_document(LineGutterPlugin.this).readLock();
            try {
                LineMap lineMap = LineGutterPlugin.ra$_document(LineGutterPlugin.this).getLineMap();
                int n4 = lineMap.getLineCount();
                int n5 = n - 1;
                if (n5 >= 0 && n5 < n4) {
                    int n6 = lineMap.getLineStartOffset(n5);
                    mark = new Mark(n, n6, icon, highlightStyle, n2, n3);
                    mark.updateHighlight(lineMap);
                    this._marksList.add(mark);
                    int n7 = LineGutterPlugin.this.markWidth(mark);
                    LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, mark, 0, n7);
                    LineGutterPlugin.ra$LOG().trace("adding mark of width {0} to column {1} in {2}", n7, (Object)this, (Object)LineGutterPlugin.this);
                }
            }
            finally {
                LineGutterPlugin.ra$_document(LineGutterPlugin.this).readUnlock();
            }
            return mark;
        }

        public GutterMark[] lookupGutterMarks(int n) {
            ArrayList arrayList = new ArrayList();
            this.getMarks(arrayList, n);
            int n2 = arrayList.size();
            GutterMark[] gutterMarkArray = new GutterMark[n2];
            return arrayList.toArray(gutterMarkArray);
        }

        public void removeGutterMark(GutterMark gutterMark) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int n = this._marksList.indexOf(gutterMark);
            if (n != -1) {
                int n2 = LineGutterPlugin.this.markWidth(gutterMark);
                this._marksList.remove(n);
                Mark mark = (Mark)gutterMark;
                mark.removeHighlight();
                Mark.mav$removeMarkInFileOverviewMargin(mark);
                LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, gutterMark, n2, 0);
            }
        }

        public void removeAllGutterMarks() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            int n = this.removeAllGutterMarksImpl();
            if (n > 0) {
                LineGutterPlugin.mav$columnMarksRemoved(LineGutterPlugin.this, this);
                LineGutterPlugin.ra$LOG().trace("revalidating after removing all marks in column {0}", this);
            }
        }

        public String toString() {
            String string = "?";
            if (this.groupIndex >= 0 && LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this) != null && LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this).length < this.groupIndex) {
                string = String.valueOf(LineGutterPlugin.ra$_columnGroupWidths(LineGutterPlugin.this)[this.groupIndex]);
            }
            return "column " + this._columnName + "{group " + this.group + ", width " + string + "}";
        }

        protected class Mark
        implements FileOverviewMark,
        GutterMark {
            private int _line;
            private int _lineStart;
            private Icon _icon;
            private HighlightStyle _style;
            private HighlightedText _highlight;
            private int _order;
            private int _options;
            private boolean _visible;
            private Object _userData;

            protected Mark(int n, int n2, Icon icon, HighlightStyle highlightStyle, int n3, int n4) {
                this._line = n;
                this._lineStart = n2;
                this._icon = icon;
                this._style = highlightStyle;
                this._order = n3;
                this._options = n4;
                this._highlight = null;
                this._visible = true;
                this._userData = null;
                this.createMarkInFileOverviewMargin();
            }

            protected void updateHighlight(LineMap lineMap) {
                if (this._style != null) {
                    if (this._highlight == null) {
                        this._highlight = LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).addLineHighlight(this._style, this._line - 1);
                    } else {
                        int n = lineMap.getLineStartOffset(this._line - 1);
                        int n2 = lineMap.getLineEndOffset(this._line - 1);
                        if (this._highlight.getStartOffset() != n || this._highlight.getEndOffset() != n2) {
                            LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).changeHighlight(this._highlight, n, n2);
                        }
                    }
                }
            }

            protected void removeHighlight() {
                if (this._highlight != null) {
                    LineGutterPlugin.ra$_highlightLayer(LineGutterPlugin.this).removeHighlight(this._highlight);
                    this._highlight = null;
                }
                if (LineGutterPlugin.this._mouseInMark == this) {
                    LineGutterPlugin.this._mouseInMark = null;
                }
            }

            protected void setLine(int n) {
                this._line = n;
            }

            protected int getOffset() {
                return this._lineStart;
            }

            protected void setOffset(int n) {
                this._lineStart = n;
            }

            public boolean isOptionSet(int n) {
                return (this._options & n) != 0;
            }

            protected int getOptions() {
                return this._options;
            }

            public GutterColumn getGutterColumn() {
                return Column.this;
            }

            public Gutter getGutter() {
                return Column.this.getGutter();
            }

            public Icon getIcon() {
                return this._icon;
            }

            public void setIcon(Icon icon) {
                int n = LineGutterPlugin.this.markWidth(this);
                this._icon = icon;
                LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, this, n, LineGutterPlugin.this.markWidth(this));
            }

            public HighlightStyle getHighlightStyle() {
                return this._style;
            }

            public int getLine() {
                return this._line;
            }

            public int getOrder() {
                return this._order;
            }

            public void setVisible(boolean bl) {
                int n = LineGutterPlugin.this.markWidth(this);
                this._visible = bl;
                LineGutterPlugin.mav$markChanged(LineGutterPlugin.this, this, n, LineGutterPlugin.this.markWidth(this));
            }

            public boolean isVisible() {
                return this._visible;
            }

            public Object getUserData() {
                return this._userData;
            }

            public void setUserData(Object object) {
                this._userData = object;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return Column.this.getMarkToolTip(this, mouseEvent);
            }

            public int getSelectionStart() {
                return -1;
            }

            public int getSelectionLength() {
                return 0;
            }

            public int getSeverity() {
                return 0;
            }

            private void createMarkInFileOverviewMargin() {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.addMark(Column.this._columnName, this._line, this);
                }
            }

            private void moveMarkInFileOverviewMargin(int n) {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.removeMark(Column.this._columnName, n, this);
                    fileOverviewMargin.addMark(Column.this._columnName, this._line, this);
                }
            }

            private void removeMarkInFileOverviewMargin() {
                FileOverviewMargin fileOverviewMargin;
                if (this.isOptionSet(4) && (fileOverviewMargin = FileOverviewMargin.getFileOverviewMargin(LineGutterPlugin.ra$_editor(LineGutterPlugin.this))) != null) {
                    fileOverviewMargin.removeMark(Column.this._columnName, this._line, this);
                }
            }

            static void mav$removeMarkInFileOverviewMargin(Mark mark) {
                mark.removeMarkInFileOverviewMargin();
            }

            static void mav$moveMarkInFileOverviewMargin(Mark mark, int n) {
                mark.moveMarkInFileOverviewMargin(n);
            }
        }
    }

    protected static final class MarkComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            GutterMark gutterMark = (GutterMark)object;
            GutterMark gutterMark2 = (GutterMark)object2;
            int n = gutterMark.getLine() - gutterMark2.getLine();
            if (n == 0) {
                n = gutterMark.getOrder() - gutterMark2.getOrder();
            }
            return n;
        }

        protected MarkComparator() {
        }
    }
}

