/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;

public class HighlightFragmentsList {
    private static final int DEFAULT_LIST_SIZE = 32;
    private static final float DEFAULT_PADDING = 0.25f;
    private HighlightStyle[] _bgStyleArray = null;
    private HighlightStyle[] _fgStyleArray = null;
    private HighlightStyle[] _fontStyleArray = null;
    private HighlightStyle[] _underlineStyleArray = null;
    private int[] _startOffsetArray = null;
    private int[] _endOffsetArray = null;
    private int _numFragments = 0;
    private HighlightStyle _sentinelBackgroundStyle;
    private HighlightStyle _sentinelUnderlineStyle;
    private int _preferredSize = 32;
    private HighlightFragment _returnFragment = new HighlightFragment();
    private HighlightRegistry _registry = null;
    public static final int ATTRIBUTE_BACKGROUND = 1;
    public static final int ATTRIBUTE_FOREGROUND = 2;
    public static final int ATTRIBUTE_FONT = 4;
    public static final int ATTRIBUTE_UNDERLINE = 8;
    public static final int ATTRIBUTE_ALL = 15;
    private int _attributeFilter;
    public static final int TYPE_STRIKETHRU = 1;
    public static final int TYPE_UNDERLINE = 2;
    public static final int TYPE_SEPARATOR = 4;
    public static final int TYPE_ALL = 7;
    private int _underlineTypeFilter;

    public HighlightFragmentsList() {
        this.clearAllFilters();
        this.ensureCapacity(this._preferredSize);
    }

    public void setHighlightRegistry(HighlightRegistry highlightRegistry) {
        this._registry = highlightRegistry;
    }

    private HighlightStyle getRealStyle(HighlightStyle highlightStyle) {
        if (this._registry == null) {
            throw new IllegalStateException("cannot add style without registry");
        }
        String string = highlightStyle.getName();
        HighlightStyle highlightStyle2 = this._registry.lookupStyle(string);
        return highlightStyle2;
    }

    public void addSentinel(HighlightStyle highlightStyle) {
        HighlightStyle highlightStyle2 = this.getRealStyle(highlightStyle);
        if (highlightStyle2 == null) {
            System.err.println("Could not find highlight: " + highlightStyle.getName());
            return;
        }
        if (highlightStyle2.getEnabled() && this.filterAllowsBackground(highlightStyle2) && (this._sentinelBackgroundStyle == null || highlightStyle2.getPriority() > this._sentinelBackgroundStyle.getPriority())) {
            this._sentinelBackgroundStyle = highlightStyle2;
        }
        if (highlightStyle2.getEnabled() && this.filterAllowsUnderline(highlightStyle2) && this.getTypeFilterAllows(highlightStyle2) && (this._sentinelUnderlineStyle == null || highlightStyle2.getPriority() > this._sentinelUnderlineStyle.getPriority())) {
            this._sentinelUnderlineStyle = highlightStyle2;
        }
    }

    public HighlightStyle getSentinelBackground() {
        return this._sentinelBackgroundStyle;
    }

    public HighlightStyle getSentinelUnderline() {
        return this._sentinelUnderlineStyle;
    }

    private void ensureCapacity(int n) {
        int n2;
        int n3 = n2 = this._bgStyleArray == null ? 0 : this._bgStyleArray.length;
        if (n2 >= n) {
            return;
        }
        if (this._bgStyleArray != null) {
            int n4 = (int)((float)n * 0.25f);
            n += n4;
        }
        HighlightStyle[] highlightStyleArray = new HighlightStyle[n];
        HighlightStyle[] highlightStyleArray2 = new HighlightStyle[n];
        HighlightStyle[] highlightStyleArray3 = new HighlightStyle[n];
        HighlightStyle[] highlightStyleArray4 = new HighlightStyle[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        if (this._numFragments > 0) {
            System.arraycopy(this._bgStyleArray, 0, highlightStyleArray, 0, this._numFragments);
            System.arraycopy(this._fgStyleArray, 0, highlightStyleArray2, 0, this._numFragments);
            System.arraycopy(this._fontStyleArray, 0, highlightStyleArray3, 0, this._numFragments);
            System.arraycopy(this._underlineStyleArray, 0, highlightStyleArray4, 0, this._numFragments);
            System.arraycopy(this._startOffsetArray, 0, nArray, 0, this._numFragments);
            System.arraycopy(this._endOffsetArray, 0, nArray2, 0, this._numFragments);
        }
        this._bgStyleArray = highlightStyleArray;
        this._fgStyleArray = highlightStyleArray2;
        this._fontStyleArray = highlightStyleArray3;
        this._underlineStyleArray = highlightStyleArray4;
        this._startOffsetArray = nArray;
        this._endOffsetArray = nArray2;
    }

    private void shiftDownByOne(int n) {
        this.ensureCapacity(this._numFragments + 1);
        int n2 = n;
        int n3 = n + 1;
        int n4 = this._numFragments - n;
        System.arraycopy(this._bgStyleArray, n2, this._bgStyleArray, n3, n4);
        System.arraycopy(this._fgStyleArray, n2, this._fgStyleArray, n3, n4);
        System.arraycopy(this._fontStyleArray, n2, this._fontStyleArray, n3, n4);
        System.arraycopy(this._underlineStyleArray, n2, this._underlineStyleArray, n3, n4);
        System.arraycopy(this._startOffsetArray, n2, this._startOffsetArray, n3, n4);
        System.arraycopy(this._endOffsetArray, n2, this._endOffsetArray, n3, n4);
    }

    private void merge(int n) {
        int n2 = this._endOffsetArray[n + 1];
        int n3 = n + 1;
        int n4 = n;
        int n5 = this._numFragments - (n + 1);
        System.arraycopy(this._bgStyleArray, n3, this._bgStyleArray, n4, n5);
        System.arraycopy(this._fgStyleArray, n3, this._fgStyleArray, n4, n5);
        System.arraycopy(this._fontStyleArray, n3, this._fontStyleArray, n4, n5);
        System.arraycopy(this._underlineStyleArray, n3, this._underlineStyleArray, n4, n5);
        System.arraycopy(this._startOffsetArray, n3, this._startOffsetArray, n4, n5);
        System.arraycopy(this._endOffsetArray, n3, this._endOffsetArray, n4, n5);
        this._endOffsetArray[n] = n2;
        --this._numFragments;
    }

    private void split(int n, int n2) {
        if (n2 <= this._startOffsetArray[n] || this._endOffsetArray[n] <= n2) {
            throw new IllegalStateException("illegal split");
        }
        this.shiftDownByOne(n);
        ++this._numFragments;
        int n3 = n2;
        this._startOffsetArray[n + 1] = n3;
        this._endOffsetArray[n] = n3;
    }

    private void store(int n, HighlightStyle highlightStyle, int n2, int n3) {
        this._bgStyleArray[n] = this.filterAllowsBackground(highlightStyle) ? highlightStyle : null;
        this._fgStyleArray[n] = this.filterAllowsForeground(highlightStyle) ? highlightStyle : null;
        this._fontStyleArray[n] = this.filterAllowsFont(highlightStyle) ? highlightStyle : null;
        this._underlineStyleArray[n] = this.filterAllowsUnderline(highlightStyle) ? highlightStyle : null;
        this._startOffsetArray[n] = n2;
        this._endOffsetArray[n] = n3;
    }

    private void update(int n, HighlightStyle highlightStyle) {
        HighlightStyle highlightStyle2 = this.filterAllowsBackground(highlightStyle) ? highlightStyle : null;
        HighlightStyle highlightStyle3 = this.filterAllowsForeground(highlightStyle) ? highlightStyle : null;
        HighlightStyle highlightStyle4 = this.filterAllowsFont(highlightStyle) ? highlightStyle : null;
        HighlightStyle highlightStyle5 = this.filterAllowsUnderline(highlightStyle) ? highlightStyle : null;
        this._bgStyleArray[n] = this.select(this._bgStyleArray[n], highlightStyle2);
        this._fgStyleArray[n] = this.select(this._fgStyleArray[n], highlightStyle3);
        this._fontStyleArray[n] = this.select(this._fontStyleArray[n], highlightStyle4);
        this._underlineStyleArray[n] = this.select(this._underlineStyleArray[n], highlightStyle5);
    }

    private HighlightStyle select(HighlightStyle highlightStyle, HighlightStyle highlightStyle2) {
        if (highlightStyle == null) {
            return highlightStyle2;
        }
        if (highlightStyle2 == null) {
            return highlightStyle;
        }
        return highlightStyle2.getPriority() > highlightStyle.getPriority() ? highlightStyle2 : highlightStyle;
    }

    public void compact() {
        int n = 0;
        while (n < this._numFragments - 1) {
            if (this._endOffsetArray[n] == this._startOffsetArray[n + 1] && this._bgStyleArray[n] == this._bgStyleArray[n + 1] && this._fgStyleArray[n] == this._fgStyleArray[n + 1] && this._fontStyleArray[n] == this._fontStyleArray[n + 1] && this._underlineStyleArray[n] == this._underlineStyleArray[n + 1]) {
                this.merge(n);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void add(HighlightStyle var1_1, int var2_2, int var3_3) {
        var4_4 = this.getRealStyle(var1_1);
        if (var4_4 == null) {
            System.err.println("Could not find highlight: " + var1_1.getName());
            return;
        }
        if (!var4_4.getEnabled()) {
            return;
        }
        if (this.isAttributeFilterSet() && !this.getAttributeFilterAllows(var1_1)) {
            return;
        }
        if (this.isUnderlineTypeFilterSet() && !this.getTypeFilterAllows(var1_1)) {
            return;
        }
        var5_5 = 0;
        ** GOTO lbl44
        {
            ++var5_5;
            do {
                if (var5_5 < this._numFragments && var2_2 >= this._endOffsetArray[var5_5]) continue block0;
                if (var5_5 == this._numFragments) {
                    this.ensureCapacity(this._numFragments + 1);
                    ++this._numFragments;
                    this.store(var5_5, var4_4, var2_2, var3_3);
                    return;
                }
                if (var3_3 <= this._startOffsetArray[var5_5]) {
                    this.shiftDownByOne(var5_5);
                    ++this._numFragments;
                    this.store(var5_5, var4_4, var2_2, var3_3);
                    return;
                }
                var6_6 = this._startOffsetArray[var5_5];
                var7_7 = this._endOffsetArray[var5_5];
                if (var6_6 < var2_2) {
                    this.split(var5_5, var2_2);
                    ++var5_5;
                    var6_6 = var2_2;
                } else if (var6_6 > var2_2) {
                    this.shiftDownByOne(var5_5);
                    ++this._numFragments;
                    this.store(var5_5, var4_4, var2_2, var6_6);
                    ++var5_5;
                    var2_2 = var6_6;
                }
                if (var7_7 > var3_3) {
                    this.split(var5_5, var3_3);
                    var7_7 = var3_3;
                }
                this.update(var5_5, var4_4);
                var2_2 = var7_7;
lbl44:
                // 2 sources

            } while (var3_3 > var2_2);
        }
    }

    public void clear() {
        this.clearAllFilters();
        int n = 0;
        while (n < this._numFragments) {
            this._underlineStyleArray[n] = null;
            this._fontStyleArray[n] = null;
            this._fgStyleArray[n] = null;
            this._bgStyleArray[n] = null;
            this._endOffsetArray[n] = -1;
            this._startOffsetArray[n] = -1;
            ++n;
        }
        this._sentinelBackgroundStyle = null;
        this._sentinelUnderlineStyle = null;
        this._numFragments = 0;
        this._returnFragment.backgroundStyle = null;
        this._returnFragment.foregroundStyle = null;
        this._returnFragment.fontStyle = null;
        this._returnFragment.underlineStyle = null;
        this._returnFragment.startOffset = -1;
        this._returnFragment.endOffset = -1;
    }

    public int size() {
        return this._numFragments;
    }

    public HighlightFragment get(int n) {
        if (n < 0 || n >= this._numFragments) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n);
        }
        this._returnFragment.backgroundStyle = this._bgStyleArray[n];
        this._returnFragment.foregroundStyle = this._fgStyleArray[n];
        this._returnFragment.fontStyle = this._fontStyleArray[n];
        this._returnFragment.underlineStyle = this._underlineStyleArray[n];
        this._returnFragment.startOffset = this._startOffsetArray[n];
        this._returnFragment.endOffset = this._endOffsetArray[n];
        return this._returnFragment;
    }

    public void clearAllFilters() {
        this.clearAttributeFilter();
        this.clearUnderlineTypeFilter();
    }

    public void clearAttributeFilter() {
        this.setAttributeFilter(15);
    }

    private boolean isAttributeFilterSet() {
        return Utilities.testBit(this._attributeFilter, 15) ^ true;
    }

    public void setAttributeFilter(int n) {
        this._attributeFilter = n;
    }

    public void setAttributeTextOnly() {
        int n = 7;
        this.setAttributeFilter(n);
    }

    public void setAttributeFontOnly() {
        this.setAttributeFilter(4);
    }

    public void setAttributeUnderlineOnly() {
        this.setAttributeFilter(8);
    }

    private boolean getAttributeFilterAllows(HighlightStyle highlightStyle) {
        return this.filterAllowsBackground(highlightStyle) || this.filterAllowsForeground(highlightStyle) || this.filterAllowsFont(highlightStyle) || this.filterAllowsUnderline(highlightStyle);
    }

    private boolean filterAllowsBackground(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._attributeFilter, 1);
        return highlightStyle.getUseBackgroundColor() && bl;
    }

    private boolean filterAllowsForeground(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._attributeFilter, 2);
        return highlightStyle.getUseForegroundColor() && bl;
    }

    private boolean filterAllowsFont(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._attributeFilter, 4);
        return highlightStyle.getUseFontStyle() && bl;
    }

    private boolean filterAllowsUnderline(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._attributeFilter, 8);
        return highlightStyle.getUseUnderline() && bl;
    }

    public void clearUnderlineTypeFilter() {
        this.setUnderlineTypeFilter(7);
    }

    private boolean isUnderlineTypeFilterSet() {
        return Utilities.testBit(this._underlineTypeFilter, 7) ^ true;
    }

    public void setUnderlineTypeFilter(int n) {
        this._underlineTypeFilter = n;
    }

    private boolean getTypeFilterAllows(HighlightStyle highlightStyle) {
        return this.typeAllowsStrikethru(highlightStyle) || this.typeAllowsUnderline(highlightStyle) || this.typeAllowsSeparator(highlightStyle);
    }

    private boolean typeAllowsStrikethru(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._underlineTypeFilter, 1);
        return bl && this.hasUnderlineType(highlightStyle, 0);
    }

    private boolean typeAllowsUnderline(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._underlineTypeFilter, 2);
        return bl && this.hasUnderlineType(highlightStyle, 1);
    }

    private boolean typeAllowsSeparator(HighlightStyle highlightStyle) {
        boolean bl = Utilities.testBit(this._underlineTypeFilter, 4);
        return bl && this.hasUnderlineType(highlightStyle, 2);
    }

    private boolean hasUnderlineType(HighlightStyle highlightStyle, int n) {
        if (highlightStyle.getUseUnderline()) {
            UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
            return underlinePainter.getUnderlineType() == n;
        }
        return false;
    }
}

