/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.util.ArrayList;
import javax.swing.plaf.TextUI;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedLine;
import oracle.javatools.editor.highlight.HighlightedText;

public final class HighlightLayer {
    private BasicEditorPane _editor;
    private ArrayList _highlightList;
    private boolean _blockUpdating;
    public static final int FETCH_ALL_HIGHLIGHTS = 0;
    public static final int FETCH_RANGE_HIGHLIGHTS = 1;
    public static final int FETCH_LINE_HIGHLIGHTS = 2;

    public HighlightLayer(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
        this._blockUpdating = false;
        this._highlightList = new ArrayList();
    }

    public void beginBlockUpdate() {
        this._blockUpdating = true;
    }

    public void endBlockUpdate() {
        this._blockUpdating = false;
        this._editor.repaint();
    }

    public HighlightedText addHighlight(HighlightStyle highlightStyle, int n, int n2) {
        TextBuffer textBuffer = this.getTextBuffer();
        OffsetMark offsetMark = textBuffer.addOffsetMark(n, true);
        OffsetMark offsetMark2 = textBuffer.addOffsetMark(n2, false);
        HighlightedText highlightedText = new HighlightedText(highlightStyle, offsetMark, offsetMark2);
        this._highlightList.add(highlightedText);
        this.damageRangeForAddedHighlight(highlightStyle, n, n2);
        return highlightedText;
    }

    public HighlightedText addLineHighlight(HighlightStyle highlightStyle, int n) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        if (n < 0 || n >= lineMap.getLineCount()) {
            return null;
        }
        int n2 = lineMap.getLineStartOffset(n);
        int n3 = lineMap.getLineEndOffset(n);
        OffsetMark offsetMark = textBuffer.addOffsetMark(n2);
        OffsetMark offsetMark2 = textBuffer.addOffsetMark(n3);
        HighlightedLine highlightedLine = new HighlightedLine(highlightStyle, offsetMark, offsetMark2);
        this._highlightList.add(highlightedLine);
        this.damageRangeForAddedHighlight(highlightStyle, n2, n3);
        return highlightedLine;
    }

    public void removeHighlight(HighlightedText highlightedText) {
        int n = this._highlightList.indexOf(highlightedText);
        if (n != -1) {
            this._highlightList.remove(n);
            TextBuffer textBuffer = this.getTextBuffer();
            int n2 = highlightedText.startMark.getOffset();
            int n3 = highlightedText.endMark.getOffset();
            textBuffer.removeOffsetMark(highlightedText.startMark);
            highlightedText.startMark = null;
            textBuffer.removeOffsetMark(highlightedText.endMark);
            highlightedText.endMark = null;
            HighlightStyle highlightStyle = highlightedText.getHighlightStyle();
            this.damageRangeForRemovedHighlight(highlightStyle, n2, n3);
        }
    }

    public void removeAllHighlights() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = textBuffer.getLength();
        int n2 = 0;
        int n3 = this._highlightList.size();
        int n4 = 0;
        while (n4 < n3) {
            HighlightedText highlightedText = (HighlightedText)this._highlightList.get(n4);
            n = Math.min(n, highlightedText.startMark.getOffset());
            n2 = Math.max(n2, highlightedText.endMark.getOffset());
            textBuffer.removeOffsetMark(highlightedText.startMark);
            highlightedText.startMark = null;
            textBuffer.removeOffsetMark(highlightedText.endMark);
            highlightedText.endMark = null;
            ++n4;
        }
        this._highlightList.clear();
        if (n3 > 0) {
            this.damageRange(n, n2);
        }
    }

    public void changeLineHighlight(HighlightedText highlightedText, HighlightStyle highlightStyle, int n) {
        LineMap lineMap = this.getLineMap();
        if (n < 0 || n >= lineMap.getLineCount()) {
            return;
        }
        int n2 = this._highlightList.indexOf(highlightedText);
        if (n2 != -1) {
            int n3 = highlightedText.startMark.getOffset();
            int n4 = highlightedText.endMark.getOffset();
            int n5 = lineMap.getLineStartOffset(n);
            int n6 = lineMap.getLineEndOffset(n);
            highlightedText.startMark.setOffset(n5);
            highlightedText.endMark.setOffset(n6);
            int n7 = Math.min(n3, n5);
            int n8 = Math.max(n4, n6);
            highlightedText.highlightStyle = highlightStyle;
            HighlightStyle highlightStyle2 = highlightedText.getHighlightStyle();
            this.damageRangeForRemovedHighlight(highlightStyle2, n7, n8);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, HighlightStyle highlightStyle) {
        int n = this._highlightList.indexOf(highlightedText);
        if (n != -1) {
            highlightedText.highlightStyle = highlightStyle;
            int n2 = highlightedText.startMark.getOffset();
            int n3 = highlightedText.endMark.getOffset();
            this.damageRange(n2, n3);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, int n, int n2) {
        int n3 = this._highlightList.indexOf(highlightedText);
        if (n3 != -1) {
            int n4 = highlightedText.startMark.getOffset();
            int n5 = highlightedText.endMark.getOffset();
            if (highlightedText.isLineHighlight()) {
                LineMap lineMap = this.getLineMap();
                int n6 = lineMap.getLineFromOffset(n);
                n = lineMap.getLineStartOffset(n6);
                n2 = lineMap.getLineEndOffset(n6);
            }
            highlightedText.startMark.setOffset(n);
            highlightedText.endMark.setOffset(n2);
            int n7 = Math.min(n4, n);
            int n8 = Math.max(n5, n2);
            HighlightStyle highlightStyle = highlightedText.getHighlightStyle();
            this.damageRangeForRemovedHighlight(highlightStyle, n7, n8);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, HighlightStyle highlightStyle, int n, int n2) {
        int n3 = this._highlightList.indexOf(highlightedText);
        if (n3 != -1) {
            int n4 = highlightedText.startMark.getOffset();
            int n5 = highlightedText.endMark.getOffset();
            if (highlightedText.isLineHighlight()) {
                LineMap lineMap = this.getLineMap();
                int n6 = lineMap.getLineFromOffset(n);
                n = lineMap.getLineStartOffset(n6);
                n2 = lineMap.getLineEndOffset(n6);
            }
            highlightedText.highlightStyle = highlightStyle;
            highlightedText.startMark.setOffset(n);
            highlightedText.endMark.setOffset(n2);
            n4 = Math.min(n4, n);
            n5 = Math.max(n5, n2);
            this.damageRange(n4, n5);
        }
    }

    public void renderHighlights(HighlightFragmentsList highlightFragmentsList, int n, int n2) {
        this.renderHighlights(highlightFragmentsList, 0, n, n2);
    }

    public void renderHighlights(HighlightFragmentsList highlightFragmentsList, int n, int n2, int n3) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int n4 = textBuffer.getLength();
        int n5 = lineMap.getLineCount() - 1;
        int n6 = lineMap.getLineStartOffset(n5);
        int n7 = this._highlightList.size();
        int n8 = 0;
        while (n8 < n7) {
            HighlightedText highlightedText = (HighlightedText)this._highlightList.get(n8);
            int n9 = highlightedText.getStartOffset();
            int n10 = highlightedText.getEndOffset();
            boolean bl = highlightedText.isLineHighlight();
            boolean bl2 = bl ^ true;
            if (!(n == 1 && bl || n == 2 && bl2)) {
                if (n9 >= n2 && n9 < n3 || n10 >= n2 && n10 < n3 || n2 >= n9 && n2 < n10) {
                    highlightFragmentsList.add(highlightedText.getHighlightStyle(), n9, n10);
                }
                if (bl && n9 == n6 && n10 == n4) {
                    highlightFragmentsList.addSentinel(highlightedText.getHighlightStyle());
                }
            }
            ++n8;
        }
    }

    private TextBuffer getTextBuffer() {
        BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    private LineMap getLineMap() {
        BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        return lineMap;
    }

    private void damageRange(int n, int n2) {
        if (!this._blockUpdating) {
            TextUI textUI = this._editor.getUI();
            textUI.damageRange(this._editor, n, n2);
        }
    }

    private HighlightStyle findConfiguredStyle(String string) {
        HighlightRegistry highlightRegistry = this._editor.getHighlightRegistry();
        HighlightStyle highlightStyle = highlightRegistry.lookupStyle(string);
        return highlightStyle;
    }

    private void damageRangeForAddedHighlight(HighlightStyle highlightStyle, int n, int n2) {
        if (!this._blockUpdating) {
            String string = highlightStyle.getName();
            HighlightStyle highlightStyle2 = this.findConfiguredStyle(string);
            if (highlightStyle2 == null) {
                System.err.println("Highlight not found: " + string);
            } else if (highlightStyle2.getEnabled()) {
                this.damageRange(n, n2);
            }
        }
    }

    private void damageRangeForRemovedHighlight(HighlightStyle highlightStyle, int n, int n2) {
        if (highlightStyle == null) {
            return;
        }
        if (!this._blockUpdating) {
            String string = highlightStyle.getName();
            HighlightStyle highlightStyle2 = this.findConfiguredStyle(string);
            if (highlightStyle2 == null || !highlightStyle2.getEnabled()) {
                return;
            }
            this.damageRange(n, n2);
        }
    }
}

