/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.highlight.DottedLinePainter;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.SimpleLinePainter;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.highlight.ZigZagLinePainter;

public final class HighlightRegistry {
    public static final int SINGLE_UNDERLINE = 0;
    public static final int DOUBLE_UNDERLINE = 1;
    public static final int SINGLE_DOTTED_UNDERLINE = 2;
    public static final int DOUBLE_DOTTED_UNDERLINE = 3;
    public static final int ZIGZAG_UNDERLINE = 4;
    public static final int SINGLE_SEPARATOR = 5;
    public static final int DOUBLE_SEPARATOR = 6;
    public static final int SINGLE_DOTTED_SEPARATOR = 7;
    public static final int DOUBLE_DOTTED_SEPARATOR = 8;
    public static final int PERFORATED_SEPARATOR = 9;
    public static final int SINGLE_STRIKETHRU = 10;
    public static final int DOUBLE_STRIKETHRU = 11;
    private static final UnderlinePainter[] PREDEFINED_PAINTERS = new UnderlinePainter[]{new SimpleLinePainter(1, 1), new SimpleLinePainter(2, 1), new DottedLinePainter(1, 1, 3, 3), new DottedLinePainter(2, 1, 3, 3), new ZigZagLinePainter(3, 1), new SimpleLinePainter(1, 2), new SimpleLinePainter(2, 2), new DottedLinePainter(1, 2, 4, 4), new DottedLinePainter(2, 2, 4, 4), new DottedLinePainter(1, 2, 1, 2), new SimpleLinePainter(1, 0), new SimpleLinePainter(2, 0)};
    private transient WeakPropertyChangeSupport changeSupport;
    public static final String PROPERTY_HIGHLIGHT_CHANGED = "highlight-changed";
    private HashMap _registryMap = new HashMap(30);
    private ArrayList _registryList = new ArrayList(30);
    private ArrayList _pendingList = new ArrayList();

    public HighlightRegistry() {
        this.changeSupport = new WeakPropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private void fireStyleChangedEvent() {
        this.changeSupport.firePropertyChange(PROPERTY_HIGHLIGHT_CHANGED, Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized Iterator getStyleIterator() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._registryList);
        arrayList.addAll(this._pendingList);
        return arrayList.iterator();
    }

    public synchronized Object clone() {
        HighlightRegistry highlightRegistry = new HighlightRegistry();
        for (HighlightStyle highlightStyle : this._registryList) {
            highlightRegistry.createStyle(highlightStyle.getName(), highlightStyle.getPresentationName(), highlightStyle.getEnabled(), highlightStyle.getPriority(), highlightStyle.getForegroundColor(), highlightStyle.getBackgroundColor(), highlightStyle.getFontStyle(), highlightStyle.getUnderlinePainter(), highlightStyle.getUnderlineColor());
        }
        for (HighlightStyle highlightStyle : this._pendingList) {
            highlightRegistry.modifyStyle(highlightStyle.getName(), highlightStyle.getEnabled(), highlightStyle.getPriority(), highlightStyle.getForegroundColor(), highlightStyle.getBackgroundColor(), highlightStyle.getFontStyle(), highlightStyle.getUnderlinePainter(), highlightStyle.getUnderlineColor());
        }
        return highlightRegistry;
    }

    private void addStyle(HighlightStyle highlightStyle) {
        this._registryMap.put(highlightStyle.getName(), highlightStyle);
        this._registryList.add(highlightStyle);
        HighlightStyle highlightStyle2 = this.lookupPendingStyle(highlightStyle.getName());
        if (highlightStyle2 != null) {
            int n = this._pendingList.indexOf(highlightStyle2);
            this._pendingList.remove(n);
            this.modifyStyle(highlightStyle, highlightStyle2.getEnabled(), highlightStyle2.getPriority(), highlightStyle2.getForegroundColor(), highlightStyle2.getBackgroundColor(), highlightStyle2.getFontStyle(), highlightStyle2.getUnderlinePainter(), highlightStyle2.getUnderlineColor());
        }
    }

    public synchronized HighlightStyle createStyle(String string, String string2, int n, Color color, Color color2) {
        return this.createStyle(string, string2, true, n, color, color2);
    }

    public synchronized HighlightStyle createStyle(String string, String string2, boolean bl, int n, Color color, Color color2) {
        return this.createStyle(string, string2, bl, n, color, color2, 0, -1, null);
    }

    public synchronized HighlightStyle createStyle(String string, String string2, boolean bl, int n, int n2, Color color) {
        return this.createStyle(string, string2, bl, n, null, null, 0, n2, color);
    }

    public synchronized HighlightStyle createStyle(String string, String string2, boolean bl, int n, int n2) {
        return this.createStyle(string, string2, bl, n, null, null, n2, -1, null);
    }

    public synchronized HighlightStyle createStyle(String string, String string2, boolean bl, int n, Color color, Color color2, int n2, int n3, Color color3) {
        UnderlinePainter underlinePainter = this.lookupPainter(n3);
        return this.createStyle(string, string2, bl, n, color, color2, n2 &= 3, underlinePainter, color3);
    }

    private UnderlinePainter lookupPainter(int n) {
        if (n < 0 || n >= PREDEFINED_PAINTERS.length) {
            return null;
        }
        return PREDEFINED_PAINTERS[n];
    }

    public static int lookupPredefinedPainter(UnderlinePainter underlinePainter) {
        int n = PREDEFINED_PAINTERS.length;
        int n2 = 0;
        while (n2 < n) {
            if (underlinePainter == PREDEFINED_PAINTERS[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private synchronized HighlightStyle createStyle(String string, String string2, boolean bl, int n, Color color, Color color2, int n2, UnderlinePainter underlinePainter, Color color3) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle == null) {
            highlightStyle = new HighlightStyle(string, string2, bl, n, color, color2, n2, underlinePainter, color3);
            this.addStyle(highlightStyle);
        }
        return highlightStyle;
    }

    public synchronized HighlightStyle lookupStyle(String string) {
        HighlightStyle highlightStyle = (HighlightStyle)this._registryMap.get(string);
        return highlightStyle;
    }

    private HighlightStyle lookupPendingStyle(String string) {
        int n = this._pendingList.size();
        int n2 = 0;
        while (n2 < n) {
            HighlightStyle highlightStyle = (HighlightStyle)this._pendingList.get(n2);
            if (highlightStyle.getName().equals(string)) {
                return highlightStyle;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void modifyStyleEnabled(String string, boolean bl) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setEnabled(bl);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStylePriority(String string, int n) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setPriority(n);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleForeground(String string, Color color) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setForegroundColor(color);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleBackground(String string, Color color) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setBackgroundColor(color);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleFont(String string, int n) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setFontStyle(n);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleUnderline(String string, int n, Color color) {
        UnderlinePainter underlinePainter = this.lookupPainter(n);
        this.modifyStyleUnderline(string, underlinePainter, color);
    }

    public synchronized void modifyStyleUnderline(String string, UnderlinePainter underlinePainter, Color color) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            highlightStyle.setUnderlinePainter(underlinePainter);
            highlightStyle.setUnderlineColor(color);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyle(String string, boolean bl, int n, boolean bl2, Color color, boolean bl3, Color color2) {
        Color color3 = bl2 ? color : null;
        Color color4 = bl3 ? color2 : null;
        this.modifyStyle(string, bl, n, color3, color4, 0, -1, null);
    }

    public synchronized void modifyStyle(String string, boolean bl, int n, Color color, Color color2, int n2, int n3, Color color3) {
        UnderlinePainter underlinePainter = this.lookupPainter(n3);
        this.modifyStyle(string, bl, n, color, color2, n2, underlinePainter, color3);
    }

    private synchronized void modifyStyle(String string, boolean bl, int n, Color color, Color color2, int n2, UnderlinePainter underlinePainter, Color color3) {
        HighlightStyle highlightStyle = this.lookupStyle(string);
        if (highlightStyle != null) {
            this.modifyStyle(highlightStyle, bl, n, color, color2, n2, underlinePainter, color3);
            this.fireStyleChangedEvent();
        } else {
            HighlightStyle highlightStyle2 = this.lookupPendingStyle(string);
            if (highlightStyle2 != null) {
                this.modifyStyle(highlightStyle2, bl, n, color, color2, n2, underlinePainter, color3);
            } else {
                highlightStyle2 = new HighlightStyle(string, "<" + string + ">", bl, n, color, color2, n2, underlinePainter, color3);
                this._pendingList.add(highlightStyle2);
            }
        }
    }

    private void modifyStyle(HighlightStyle highlightStyle, boolean bl, int n, Color color, Color color2) {
        if (highlightStyle != null) {
            highlightStyle.setEnabled(bl);
            highlightStyle.setPriority(n);
            highlightStyle.setForegroundColor(color);
            highlightStyle.setBackgroundColor(color2);
        }
    }

    private void modifyStyle(HighlightStyle highlightStyle, boolean bl, int n, Color color, Color color2, int n2, UnderlinePainter underlinePainter, Color color3) {
        if (highlightStyle != null) {
            highlightStyle.setEnabled(bl);
            highlightStyle.setPriority(n);
            highlightStyle.setForegroundColor(color);
            highlightStyle.setBackgroundColor(color2);
            highlightStyle.setFontStyle(n2);
            highlightStyle.setUnderlinePainter(underlinePainter);
            highlightStyle.setUnderlineColor(color3);
        }
    }
}

