/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import oracle.javatools.editor.highlight.UnderlinePainter;

public final class HighlightStyle {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int MAXIMUM_PRIORITY = 100;
    public static final int DEFAULT_SELECTION_PRIORITY = 100;
    public static final int FONT_NORMAL = 0;
    public static final int FONT_BOLD = 1;
    public static final int FONT_ITALIC = 2;
    public static final int FONT_BOLD_ITALIC = 3;
    private String _internalName;
    private String _presentationName;
    private boolean _enabled;
    private int _priority;
    private Color _fgColor;
    private Color _bgColor;
    private int _fontStyle;
    private Color _underlineColor;
    private UnderlinePainter _underlinePainter;

    HighlightStyle(String string, String string2, boolean bl, int n, Color color, Color color2, int n2, UnderlinePainter underlinePainter, Color color3) {
        this._internalName = string;
        this._presentationName = string2;
        this.setEnabled(bl);
        this.setPriority(n);
        this.setForegroundColor(color);
        this.setBackgroundColor(color2);
        this.setFontStyle(n2);
        this.setUnderlinePainter(underlinePainter);
        this.setUnderlineColor(color3);
    }

    public String getName() {
        return this._internalName;
    }

    public String getPresentationName() {
        return this._presentationName;
    }

    public String toString() {
        return this._presentationName;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public int getPriority() {
        return this._priority;
    }

    void setPriority(int n) {
        n = Math.max(1, n);
        this._priority = n = Math.min(100, n);
    }

    public boolean getUseForegroundColor() {
        return this.getForegroundColor() != null;
    }

    public boolean getUseBackgroundColor() {
        return this.getBackgroundColor() != null;
    }

    public boolean getUseFontStyle() {
        return this.getFontStyle() != 0;
    }

    public boolean getUseUnderline() {
        boolean bl = this.getUnderlineColor() != null;
        boolean bl2 = this.getUnderlinePainter() != null;
        return bl && bl2;
    }

    public Color getForegroundColor() {
        return this._fgColor;
    }

    void setForegroundColor(Color color) {
        this._fgColor = color;
    }

    public Color getBackgroundColor() {
        return this._bgColor;
    }

    void setBackgroundColor(Color color) {
        this._bgColor = color;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    void setFontStyle(int n) {
        this._fontStyle = n & 3;
    }

    public Color getUnderlineColor() {
        return this._underlineColor;
    }

    void setUnderlineColor(Color color) {
        this._underlineColor = color;
    }

    public UnderlinePainter getUnderlinePainter() {
        return this._underlinePainter;
    }

    void setUnderlinePainter(UnderlinePainter underlinePainter) {
        this._underlinePainter = underlinePainter;
    }
}

