/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.awt.Graphics;
import oracle.javatools.editor.highlight.UnderlinePainter;

public class SimpleLinePainter
implements UnderlinePainter {
    public static final int MAX_THICKNESS = 4;
    protected final int _thickness;
    protected final int _underlineType;

    public SimpleLinePainter(int n, int n2) {
        this._thickness = Math.min(Math.max(n, 1), 4);
        this._underlineType = n2;
        if (this._underlineType != 2 && this._underlineType != 1 && this._underlineType != 0) {
            throw new IllegalArgumentException("invalid type: " + n2);
        }
    }

    protected int getYPos(int n, int n2, int n3) {
        switch (this._underlineType) {
            case 0: {
                int n4 = n2 - n;
                return n + n4 * 3 / 4;
            }
            case 2: {
                return n2 + n3 - this._thickness;
            }
        }
        return n2 + 1;
    }

    public void paintUnderline(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getYPos(n3, n4, n5);
        graphics.setColor(color);
        graphics.fillRect(n, n6, n2, this._thickness);
    }

    public int getUnderlineType() {
        return this._underlineType;
    }
}

