/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;

public abstract class AbstractInsight
implements PopupWindowListener,
Insight,
FocusListener,
CharacterTypedListener,
CaretListener,
ActionListener,
ActionHookInvoker {
    public static final int COMPLETION_TYPE = 1;
    public static final int TOOLTIP_TYPE = 2;
    private static final int INACTIVE = 0;
    private static final int ACTIVE = 1;
    private int insightState;
    private Timer delayTimer;
    private Timer matchingTimer;
    private boolean dataChanged;
    private boolean inComplete;
    private PopupWindow insightWindow;
    private InsightProvider insightProvider;
    private InsightProvider smartInsightProvider;
    private boolean insightUseSmart;
    private InsightView insightView;
    private Component displayComponent;
    private InsightData insightData;
    private BasicEditorPane editorPane;
    private boolean insightAutopopup;
    private int insightDelay;
    private static final int UP_COMMAND = 1;
    private static final int DOWN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int PAGE_UP_COMMAND = 5;
    private static final int PAGE_DOWN_COMMAND = 6;
    private static final int BEGIN_COMMAND = 7;
    private static final int END_COMMAND = 8;
    private static final int COMPLETE_COMMAND = 9;
    private static final int PARTIAL_COMMAND = 10;
    private static final int CANCEL_COMMAND = 11;
    private static final int COMPLETION_INSIGHT_COMMAND = 12;
    private static final int TOOLTIP_INSIGHT_COMMAND = 13;
    private static final int COMPLETION_SMART_INSIGHT_COMMAND = 14;
    private static final int UNKNOWN_COMMAND = 0;
    private static HashMap commandMap = null;
    protected static final int[] COMPLETION_LOCATIONS = new int[]{8, 4};
    protected static final int[] TOOLTIP_LOCATIONS = new int[]{4, 8};
    private static final boolean JDK_HAS_SETFOCUSABLE;

    protected abstract InsightProvider createInsightProvider();

    protected InsightProvider createSmartInsightProvider() {
        return null;
    }

    public abstract boolean isInsightTriggerChar(char var1);

    protected boolean isExactMatchSupported(InsightData insightData) {
        return true;
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return false;
    }

    protected boolean isExactMatch(InsightData insightData) {
        return this.insightData.getMatchingDataCount() == 1;
    }

    static {
        AbstractInsight.initializeCommandMap();
        boolean bl = false;
        try {
            Method method;
            Class<JWindow> clazz = JWindow.class;
            if (clazz != null && (method = clazz.getMethod("setFocusableWindowState", Boolean.TYPE)) != null) {
                bl = true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        JDK_HAS_SETFOCUSABLE = bl;
    }

    protected int getInsightType() {
        return 1;
    }

    public final BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    public final BasicDocument getDocument() {
        return (BasicDocument)this.editorPane.getDocument();
    }

    public TextBuffer getTextBuffer() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    public int getCaretPosition() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        int n = basicEditorPane.getCaretPosition();
        return n;
    }

    public void setAccessibleName(String string) {
        if (string != null && string.length() > 0 && this.insightWindow != null) {
            this.insightWindow.setAccessibleName(string);
        }
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        if (!this.insightAutopopup) {
            return;
        }
        if (this.insightState == 0) {
            if (this.isInsightTriggerChar(c)) {
                this.restartPopupTimer();
            } else {
                this.clearPopupTimer();
            }
        }
    }

    public boolean invokeAction(String string) {
        boolean bl = this.getInsightType() == 1;
        int n = AbstractInsight.lookupCommand(string);
        if (bl) {
            return this.invokeCompletionTypeAction(n);
        }
        return this.invokeTooltipTypeAction(n);
    }

    protected boolean invokeCompletionTypeAction(int n) {
        if (n == 12 || n == 14) {
            boolean bl;
            boolean bl2 = bl = n == 14;
            if (this.insightState == 0) {
                this.insightUseSmart = bl;
                this.showInsight(false);
                n = 10;
            } else if (this.insightState == 1 && bl != this.insightUseSmart) {
                this.insightUseSmart = bl;
                this.updateInsight();
                return true;
            }
        }
        if (this.insightState == 1) {
            BasicEditorPane basicEditorPane = this.getEditorPane();
            switch (n) {
                case 1: {
                    return this.insightView.up();
                }
                case 2: {
                    return this.insightView.down();
                }
                case 3: {
                    return this.insightView.left();
                }
                case 4: {
                    return this.insightView.right();
                }
                case 5: {
                    return this.insightView.pageUp();
                }
                case 6: {
                    return this.insightView.pageDown();
                }
                case 7: {
                    return this.insightView.begin();
                }
                case 8: {
                    return this.insightView.end();
                }
                case 10: 
                case 12: 
                case 14: {
                    boolean bl = this.checkCompleteSingleMatching("insight-partial-complete-single");
                    if (!bl) {
                        return this.insightView.partialComplete();
                    }
                }
                case 9: {
                    this.inComplete = true;
                    boolean bl = this.insightView.complete(this);
                    this.inComplete = false;
                    basicEditorPane.requestFocus();
                    return bl;
                }
                case 11: {
                    this.hideInsight();
                    basicEditorPane.requestFocus();
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean invokeTooltipTypeAction(int n) {
        if (this.insightState == 0) {
            if (n == 13) {
                this.showInsight(false);
                return true;
            }
        } else {
            switch (n) {
                case 11: {
                    this.hideInsight();
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.delayTimer) {
            this.showInsight();
        } else if (object == this.matchingTimer) {
            boolean bl = false;
            if (this.dataChanged) {
                this.performCompleteSingleMatching("insight-newdata-complete-single");
                this.dataChanged = false;
            }
            if (!bl) {
                this.performCompleteSingleMatching("insight-typed-complete-single");
            }
        }
    }

    public void install(BasicEditorPane basicEditorPane) {
        basicEditorPane.addCharacterTypedListener(this);
        basicEditorPane.addActionHookInvoker(this);
        basicEditorPane.addCaretListener(this);
        basicEditorPane.addFocusListener(this);
        this.editorPane = basicEditorPane;
        this.delayTimer = new Timer(1000, this);
        this.delayTimer.setRepeats(false);
        this.matchingTimer = new Timer(100, this);
        this.matchingTimer.setRepeats(false);
        this.checkAutopopupProperty();
        this.checkDelayProperty();
        this.insightProvider = this.createInsightProvider();
        if (this.getInsightType() == 1) {
            this.smartInsightProvider = this.createSmartInsightProvider();
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.hideInsight();
        this.insightProvider = null;
        this.smartInsightProvider = null;
        this.delayTimer.stop();
        this.delayTimer = null;
        this.matchingTimer.stop();
        this.matchingTimer = null;
        basicEditorPane.removeCharacterTypedListener(this);
        basicEditorPane.removeActionHookInvoker(this);
        basicEditorPane.removeCaretListener(this);
        basicEditorPane.removeFocusListener(this);
        this.editorPane = null;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        String string2 = this.getAutopopupPropertyName();
        String string3 = this.getDelayPropertyName();
        if (string.equals(string2)) {
            this.checkAutopopupProperty();
        } else if (string.equals(string3)) {
            this.checkDelayProperty();
        }
        this.propertyChangeImpl(propertyChangeEvent);
    }

    protected void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
    }

    public void restartPopupTimer() {
        if (this.insightAutopopup) {
            this.delayTimer.restart();
        }
    }

    public void clearPopupTimer() {
        if (this.delayTimer != null) {
            this.delayTimer.stop();
        }
    }

    public boolean isInsightVisible() {
        return this.insightWindow != null;
    }

    public Rectangle getShowRectangle() {
        Rectangle rectangle;
        int n = this.editorPane.getCaretPosition();
        try {
            rectangle = this.editorPane.getUI().modelToView(this.editorPane, n);
        }
        catch (BadLocationException badLocationException) {
            rectangle = null;
        }
        return rectangle;
    }

    public void showInsight() {
        this.insightUseSmart = false;
        this.showInsight(true);
    }

    public void showInsight(boolean bl) {
        Object[] objectArray;
        InsightData insightData;
        boolean bl2;
        if (this.insightState == 1) {
            return;
        }
        this.clearPopupTimer();
        boolean bl3 = bl2 = this.getInsightType() == 1;
        if (bl2 && !this.editorPane.isEditable()) {
            return;
        }
        Rectangle rectangle = this.getShowRectangle();
        if (rectangle == null) {
            return;
        }
        InsightProvider insightProvider = this.insightProvider;
        if (bl2 && this.insightUseSmart && this.smartInsightProvider != null) {
            insightProvider = this.smartInsightProvider;
        }
        BasicDocument basicDocument = (BasicDocument)this.editorPane.getDocument();
        basicDocument.readLock();
        try {
            insightData = insightProvider.getInsightData(this.editorPane);
        }
        finally {
            basicDocument.readUnlock();
        }
        if (insightData != null && (objectArray = insightData.getData()) != null && objectArray.length != 0) {
            this.insightState = 1;
            this.insightData = insightData;
            this.insightView = this.insightProvider.getInsightView();
            this.insightView.setData(this.insightData);
            if (!bl && this.performCompleteSingleMatching("insight-manual-complete-single")) {
                return;
            }
            JComponent jComponent = this.insightView.getComponent();
            this.redirectActions(jComponent);
            this.displayComponent = jComponent;
            if (bl2) {
                JScrollPane jScrollPane = new JScrollPane(jComponent);
                jScrollPane.setHorizontalScrollBarPolicy(31);
                jScrollPane.setBorder(UIManager.getBorder("ToolTip.border"));
                this.displayComponent = jScrollPane;
                this.displayComponent.validate();
            }
            PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager(this.editorPane);
            this.insightWindow = popupWindowManager.createPopup(this.displayComponent, false);
            this.insightView.setPopupWindow(this.insightWindow);
            int[] nArray = this.getPreferredLocations();
            popupWindowManager.positionPopup(this.insightWindow, rectangle, nArray);
            popupWindowManager.showPopup(this.insightWindow, this);
            if (bl2) {
                this.insightView.selectDefault();
                if (!bl && this.isAutomaticPartialComplete(this.insightData)) {
                    this.insightView.partialComplete();
                }
            }
        }
    }

    public void hideInsight() {
        if (this.insightWindow != null) {
            PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager(this.editorPane);
            popupWindowManager.dismissPopup(this.insightWindow);
        }
        this.insightWindow = null;
        this.insightData = null;
        this.insightUseSmart = false;
        this.insightView = null;
        this.insightState = 0;
        this.displayComponent = null;
        if (this.matchingTimer != null) {
            this.matchingTimer.stop();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.clearPopupTimer();
    }

    public void popupClosed(PopupWindow popupWindow, int n) {
        this.insightWindow = null;
        this.hideInsight();
    }

    public void editorFocusGained(PopupWindow popupWindow) {
    }

    public void editorFocusLost(PopupWindow popupWindow, boolean bl) {
        if (!bl || JDK_HAS_SETFOCUSABLE) {
            this.hideInsight();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.insightState == 0) {
            this.clearPopupTimer();
        } else {
            this.updateInsight();
        }
    }

    void $init$() {
        this.insightState = 0;
        this.delayTimer = null;
        this.matchingTimer = null;
        this.dataChanged = false;
        this.inComplete = false;
        this.insightWindow = null;
        this.insightProvider = null;
        this.smartInsightProvider = null;
        this.insightUseSmart = false;
        this.insightView = null;
        this.displayComponent = null;
        this.insightData = null;
        this.editorPane = null;
    }

    private boolean checkCompleteSingleMatching(String string) {
        boolean bl;
        boolean bl2 = bl = this.getInsightType() == 1;
        if (!bl) {
            return false;
        }
        boolean bl3 = this.getEditorPane().getBooleanProperty(string);
        if (bl3 && this.insightData != null) {
            return this.isExactMatchSupported(this.insightData) && this.isExactMatch(this.insightData);
        }
        return false;
    }

    private boolean performCompleteSingleMatching(String string) {
        boolean bl = this.checkCompleteSingleMatching(string);
        if (bl) {
            this.inComplete = true;
            this.insightView.selectDefault();
            boolean bl2 = this.insightView.complete(this);
            this.inComplete = false;
            if (bl2) {
                this.hideInsight();
            }
            return bl2;
        }
        return false;
    }

    private String getAutopopupPropertyName() {
        int n = this.getInsightType();
        switch (n) {
            case 1: {
                return "completion-enable-autopopup";
            }
            case 2: {
                return "parameter-enable-autopopup";
            }
        }
        throw new IllegalStateException("Unknown type: " + n);
    }

    private String getDelayPropertyName() {
        int n = this.getInsightType();
        switch (n) {
            case 1: {
                return "completion-popup-delay";
            }
            case 2: {
                return "parameter-popup-delay";
            }
        }
        throw new IllegalStateException("Unknown type: " + n);
    }

    private void checkAutopopupProperty() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        String string = this.getAutopopupPropertyName();
        Boolean bl = (Boolean)basicEditorPane.getProperty(string);
        this.insightAutopopup = bl;
    }

    private void checkDelayProperty() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        String string = this.getDelayPropertyName();
        Integer n = (Integer)basicEditorPane.getProperty(string);
        this.insightDelay = n;
        this.delayTimer.setInitialDelay(this.insightDelay);
        this.delayTimer.setDelay(this.insightDelay);
    }

    protected void updateInsight() {
        if (this.insightState == 1 && !this.inComplete) {
            Object[] objectArray;
            InsightData insightData;
            boolean bl = this.getInsightType() == 1;
            InsightProvider insightProvider = this.insightProvider;
            if (bl && this.insightUseSmart && this.smartInsightProvider != null) {
                insightProvider = this.smartInsightProvider;
            }
            BasicDocument basicDocument = (BasicDocument)this.editorPane.getDocument();
            basicDocument.readLock();
            try {
                insightData = insightProvider.updateInsightData(this.editorPane, this.insightData);
            }
            finally {
                basicDocument.readUnlock();
            }
            boolean bl2 = true;
            if (insightData != null && (objectArray = insightData.getData()) != null && objectArray.length != 0) {
                this.matchingTimer.stop();
                Class<?> clazz = this.insightData.getClass();
                Class<?> clazz2 = insightData.getClass();
                Dimension dimension = this.displayComponent.getPreferredSize();
                this.insightData = insightData;
                this.insightView.setData(this.insightData);
                bl2 = false;
                if (!clazz.equals(clazz2) && this.checkCompleteSingleMatching("insight-newdata-complete-single")) {
                    this.dataChanged = true;
                    this.matchingTimer.restart();
                }
                if (this.checkCompleteSingleMatching("insight-typed-complete-single")) {
                    this.matchingTimer.restart();
                }
                this.displayComponent.validate();
                Dimension dimension2 = this.displayComponent.getPreferredSize();
                if (!dimension.equals(dimension2)) {
                    Rectangle rectangle = this.getShowRectangle();
                    if (rectangle == null) {
                        rectangle = new Rectangle();
                    }
                    PopupWindowManager popupWindowManager = PopupWindowManager.getPopupWindowManager(this.editorPane);
                    popupWindowManager.changePopupContent(this.insightWindow, this.displayComponent, false);
                    popupWindowManager.positionPopup(this.insightWindow, rectangle, this.getPreferredLocations());
                }
                if (bl) {
                    this.insightView.selectDefault();
                }
            }
            if (bl2) {
                this.hideInsight();
            }
        }
    }

    protected int[] getPreferredLocations() {
        int[] nArray;
        int n = this.getInsightType();
        switch (n) {
            case 1: {
                nArray = COMPLETION_LOCATIONS;
                break;
            }
            case 2: {
                nArray = TOOLTIP_LOCATIONS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + n);
            }
        }
        return nArray;
    }

    private void redirectActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        boolean bl = this.getInsightType() == 1;
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ESCAPE");
        String string = "cancel";
        ActionWrapper actionWrapper = new ActionWrapper(this, string, null);
        inputMap.put(keyStroke, string);
        actionMap.put(string, actionWrapper);
        if (bl) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke("ENTER");
            String string2 = "insert-break";
            ActionWrapper actionWrapper2 = new ActionWrapper(this, string2, null);
            inputMap.put(keyStroke2, string2);
            actionMap.put(string2, actionWrapper2);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke("TAB");
            String string3 = "insert-tab";
            ActionWrapper actionWrapper3 = new ActionWrapper(this, string3, null);
            inputMap.put(keyStroke3, string3);
            actionMap.put(string3, actionWrapper3);
            DoubleClicker doubleClicker = new DoubleClicker(this, string2, null);
            jComponent.addMouseListener(doubleClicker);
        }
    }

    protected static int lookupCommand(String string) {
        Integer n = (Integer)commandMap.get(string);
        return n == null ? 0 : n;
    }

    private static void initializeCommandMap() {
        if (commandMap == null) {
            commandMap = new HashMap(10);
            Integer n = new Integer(1);
            commandMap.put("caret-up", n);
            commandMap.put("selection-up", n);
            Integer n2 = new Integer(2);
            commandMap.put("caret-down", n2);
            commandMap.put("selection-down", n2);
            Integer n3 = new Integer(3);
            commandMap.put("caret-backward", n3);
            commandMap.put("selection-backward", n3);
            Integer n4 = new Integer(4);
            commandMap.put("caret-forward", n4);
            commandMap.put("selection-forward", n4);
            Integer n5 = new Integer(5);
            commandMap.put("page-up", n5);
            commandMap.put("selection-page-up", n5);
            Integer n6 = new Integer(6);
            commandMap.put("page-down", n6);
            commandMap.put("selection-page-down", n6);
            Integer n7 = new Integer(7);
            commandMap.put("caret-begin", n7);
            commandMap.put("selection-begin", n7);
            commandMap.put("caret-begin-line", n7);
            commandMap.put("selection-begin-line", n7);
            Integer n8 = new Integer(8);
            commandMap.put("caret-end", n8);
            commandMap.put("selection-end", n8);
            commandMap.put("caret-end-line", n8);
            commandMap.put("selection-end-line", n8);
            Integer n9 = new Integer(9);
            commandMap.put("insert-break", n9);
            Integer n10 = new Integer(10);
            commandMap.put("insert-tab", n10);
            Integer n11 = new Integer(11);
            commandMap.put("cancel", n11);
            Integer n12 = new Integer(12);
            commandMap.put("completion-insight", n12);
            Integer n13 = new Integer(14);
            commandMap.put("smart-completion-insight", n13);
            Integer n14 = new Integer(13);
            commandMap.put("tooltip-insight", n14);
        }
    }

    public AbstractInsight() {
        this.$init$();
    }

    private static final class ActionWrapper
    extends AbstractAction {
        private ActionHookInvoker invoker;

        private ActionWrapper(ActionHookInvoker actionHookInvoker, String string) {
            super(string);
            this.invoker = actionHookInvoker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.getValue("Name");
            this.invoker.invokeAction(string);
        }

        ActionWrapper(ActionHookInvoker actionHookInvoker, String string, 1 var3_3) {
            this(actionHookInvoker, string);
        }

        public final class 1 {
        }
    }

    private static final class DoubleClicker
    extends MouseAdapter {
        private ActionHookInvoker invoker;
        private String commandName;

        private DoubleClicker(ActionHookInvoker actionHookInvoker, String string) {
            this.invoker = actionHookInvoker;
            this.commandName = string;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
                this.invoker.invokeAction(this.commandName);
            }
        }

        DoubleClicker(ActionHookInvoker actionHookInvoker, String string, 1 var3_3) {
            this(actionHookInvoker, string);
        }

        public final class 1 {
        }
    }
}

