/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.PrototypeCellProvider;

public class ListDataItemCellRenderer
extends DefaultListCellRenderer
implements PrototypeCellProvider {
    public ListDataItemCellRenderer() {
        this.setIconTextGap(8);
    }

    public Dimension getPreferredSize() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n = editorProperties.getIntegerProperty("insight-max-popup-width");
        Dimension dimension = this.getToolkit().getScreenSize();
        n = Math.min(dimension.width / 2 - 5, n);
        Dimension dimension2 = super.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.min(n, dimension2.width), dimension2.height);
        return dimension3;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        JLabel jLabel = (JLabel)component;
        if (object instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)object;
            String string = listDataItem.getDisplayText();
            Icon icon = listDataItem.getIcon();
            jLabel.setIcon(icon);
            jLabel.setText(string);
        }
        return jLabel;
    }

    public Object getPrototypeCell(JList jList, ListModel listModel) {
        Icon icon = null;
        String string = "";
        int n = 0;
        Font font = jList.getFont();
        FontMetrics fontMetrics = jList.getFontMetrics(font);
        int n2 = listModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            Object e = listModel.getElementAt(n3);
            if (e instanceof ListDataItem) {
                ListDataItem listDataItem = (ListDataItem)e;
                string2 = listDataItem.getDisplayText();
                if (icon == null) {
                    icon = listDataItem.getIcon();
                }
            } else {
                string2 = e.toString();
            }
            int n4 = fontMetrics.stringWidth(string2);
            if (n4 > n) {
                n = n4;
                string = string2;
            }
            ++n3;
        }
        DummyItem dummyItem = new DummyItem(icon, string);
        return dummyItem;
    }

    private static final class DummyItem
    extends ListDataItem {
        private Icon icon;
        private String name;

        DummyItem(Icon icon, String string) {
            this.icon = icon;
            this.name = string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDisplayText() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

