/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.util.Arrays;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import oracle.javatools.editor.insight.ListDataItem;

public class ListDataItemListModel
implements ListModel {
    private ListDataItem[] dataList;
    public static final ListDataItem[] EMPTY_LIST = new ListDataItem[0];

    public ListDataItemListModel(ListDataItem[] listDataItemArray) {
        int n = listDataItemArray.length;
        this.dataList = new ListDataItem[n];
        System.arraycopy(listDataItemArray, 0, this.dataList, 0, n);
        this.sortData(this.dataList);
    }

    protected void sortData(ListDataItem[] listDataItemArray) {
        Arrays.sort(listDataItemArray);
    }

    private int getMatchingLength(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public ListDataItem findClosestDataItem(String string) {
        int n = this.dataList.length;
        if (string == null || string.length() == 0) {
            return n > 0 ? this.dataList[0] : null;
        }
        String string2 = this.findCommonPrefix(string);
        int n2 = string2.length();
        if (n2 > 0) {
            n2 = Math.min(n2, string.length());
            ListDataItem listDataItem = null;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5;
                ListDataItem listDataItem2 = this.dataList[n4];
                String string3 = listDataItem2.getName();
                if (string3.regionMatches(true, 0, string, 0, n2) && (n5 = this.getMatchingLength(string3, string)) > n3) {
                    n3 = n5;
                    listDataItem = listDataItem2;
                }
                ++n4;
            }
            if (listDataItem != null) {
                return listDataItem;
            }
        }
        int n6 = 0;
        while (n6 < n) {
            ListDataItem listDataItem = this.dataList[n6];
            String string4 = listDataItem.getName();
            int n7 = string.compareToIgnoreCase(string4);
            if (n7 <= 0) {
                return listDataItem;
            }
            ++n6;
        }
        return n > 0 ? this.dataList[n - 1] : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String findCommonPrefix(String string) {
        int n;
        if (string == null) return "";
        if (string.length() == 0) {
            return "";
        }
        int n2 = n = this.dataList.length;
        int n3 = n;
        int n4 = -1;
        boolean bl = true;
        int n5 = 2;
        int n6 = 1;
        int n7 = 0;
        block4: while (n7 < n) {
            ListDataItem listDataItem = this.dataList[n7];
            String string2 = listDataItem.getName();
            switch (n6) {
                case 1: {
                    if (!ListDataItemListModel.startsWithIgnoreCase(string2, string)) break;
                    n2 = n7;
                    n6 = 2;
                    n4 = string2.length();
                    break;
                }
                case 2: {
                    if (!ListDataItemListModel.startsWithIgnoreCase(string2, string)) {
                        n3 = n7;
                        break block4;
                    }
                    n4 = Math.min(n4, string2.length());
                }
            }
            ++n7;
        }
        if (n2 == n3) {
            return "";
        }
        int n8 = string.length();
        ListDataItem listDataItem = this.dataList[n2];
        String string3 = listDataItem.getName();
        int n9 = n4;
        while (n9 > n8) {
            boolean bl2 = true;
            int n10 = n2 + 1;
            while (n10 < n3) {
                ListDataItem listDataItem2 = this.dataList[n10];
                String string4 = listDataItem2.getName();
                if (!string4.regionMatches(true, 0, string3, 0, n9)) {
                    bl2 = false;
                    break;
                }
                ++n10;
            }
            if (bl2) {
                return string3.substring(0, n9);
            }
            --n9;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ListDataItem[] getMatchingData(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        int n2 = n = this.dataList.length;
        int n3 = n;
        boolean bl = true;
        int n4 = 2;
        int n5 = 1;
        int n6 = 0;
        block4: while (n6 < n) {
            ListDataItem listDataItem = this.dataList[n6];
            String string2 = listDataItem.getName();
            switch (n5) {
                case 1: {
                    if (!ListDataItemListModel.startsWithIgnoreCase(string2, string)) break;
                    n2 = n6;
                    n5 = 2;
                    break;
                }
                case 2: {
                    if (ListDataItemListModel.startsWithIgnoreCase(string2, string)) break;
                    n3 = n6;
                    break block4;
                }
            }
            ++n6;
        }
        if (n2 == n3) {
            return EMPTY_LIST;
        }
        int n7 = n3 - n2;
        ListDataItem[] listDataItemArray = new ListDataItem[n7];
        System.arraycopy(this.dataList, n2, listDataItemArray, 0, n7);
        return listDataItemArray;
    }

    public Object getPrototypeCellValue() {
        return null;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public int getSize() {
        return this.dataList.length;
    }

    public Object getElementAt(int n) {
        return this.dataList[n];
    }

    public void addListDataListener(ListDataListener listDataListener) {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
    }
}

