/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ListUI;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.popup.PopupWindow;

public class ListInsightView
extends JList
implements InsightView {
    private ListInsightData insightData;
    private PopupWindow popupWindow;

    public ListInsightView() {
        this(new ListDataItemCellRenderer());
    }

    public ListInsightView(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this.setCellRenderer(listCellRenderer);
        }
        this.insightData = null;
        this.setSelectionMode(0);
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        Color color = this.getBackground();
        Color color2 = this.getSelectionBackground();
        if (color.equals(color2)) {
            this.setSelectionBackground(this.getForeground());
            this.setSelectionForeground(this.getBackground());
        }
        EditorProperties editorProperties = EditorProperties.getProperties();
        String string = (String)editorProperties.getProperty("insight-font-family");
        int n = editorProperties.getIntegerProperty("insight-font-size");
        Font font = new Font(string, 0, n);
        this.setFont(font);
    }

    public int getVisibleRowCount() {
        int n = super.getVisibleRowCount();
        ListModel listModel = this.getModel();
        int n2 = listModel.getSize();
        return Math.min(n2, n);
    }

    public void setSelectionInterval(int n, int n2) {
        Object e;
        super.setSelectionInterval(n, n2);
        if (this.popupWindow != null && (e = this.getModel().getElementAt(n)) instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)e;
            this.popupWindow.setAccessibleName(listDataItem.getAccessibleText());
        }
    }

    public void setPopupWindow(PopupWindow popupWindow) {
        this.popupWindow = popupWindow;
    }

    public void setData(InsightData insightData) {
        if (insightData instanceof ListInsightData) {
            PrototypeCellProvider prototypeCellProvider;
            Object object;
            this.insightData = (ListInsightData)insightData;
            ListModel listModel = this.getListModel(this.insightData);
            this.setModel(listModel);
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer instanceof PrototypeCellProvider && (object = (prototypeCellProvider = (PrototypeCellProvider)((Object)listCellRenderer)).getPrototypeCell(this, listModel)) != null) {
                this.setPrototypeCellValue(object);
            }
        } else {
            throw new IllegalArgumentException("newData not ListInsightData.");
        }
    }

    protected ListModel getListModel(ListInsightData listInsightData) {
        Object[] objectArray;
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorProperties.getBooleanProperty("insight-filter-matching");
        if (bl && (objectArray = listInsightData.getMatchingData()) != null && objectArray.length > 0) {
            int n = objectArray.length;
            ListDataItem[] listDataItemArray = new ListDataItem[n];
            System.arraycopy(objectArray, 0, listDataItemArray, 0, n);
            ListDataItemListModel listDataItemListModel = new ListDataItemListModel(listDataItemArray);
            return listDataItemListModel;
        }
        ListModel listModel = listInsightData.getListModel();
        return listModel;
    }

    public void selectDefault() {
        Object object = this.insightData.getDefault();
        int n = 0;
        if (object != null) {
            ListModel listModel = this.getModel();
            int n2 = listModel.getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (listModel.getElementAt(n3) == object) {
                    n = n3;
                    break;
                }
                ++n3;
            }
        }
        this.centerIndexIfNotVisible(n);
        this.setSelectionInterval(n, n);
    }

    private void centerIndexIfNotVisible(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            Rectangle rectangle2 = new Rectangle();
            this.computeVisibleRect(rectangle2);
            if (rectangle2.y <= rectangle.y && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height) {
                return;
            }
            rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height >> 1);
            int n2 = this.getHeight();
            if (rectangle2.y < 0) {
                rectangle2.y = 0;
            }
            if (rectangle2.y + rectangle2.height > n2) {
                rectangle2.y = n2 - rectangle2.height;
            }
            this.scrollRectToVisible(rectangle2);
        }
    }

    public InsightData getData() {
        return this.insightData;
    }

    public JComponent getComponent() {
        return this;
    }

    protected boolean supportWrapping() {
        return true;
    }

    protected boolean isAtBeginList() {
        int n = 0;
        return this.getSelectedIndex() == n;
    }

    protected boolean isAtEndList() {
        int n = this.getModel().getSize() - 1;
        return this.getSelectedIndex() == n;
    }

    public boolean up() {
        if (this.supportWrapping() && this.isAtBeginList()) {
            this.end();
        } else {
            int n = Math.max(this.getSelectedIndex() - 1, 0);
            this.ensureIndexIsVisible(n);
            this.setSelectionInterval(n, n);
        }
        return true;
    }

    public boolean down() {
        if (this.supportWrapping() && this.isAtEndList()) {
            this.begin();
        } else {
            int n = this.getModel().getSize() - 1;
            int n2 = Math.min(this.getSelectedIndex() + 1, n);
            this.ensureIndexIsVisible(n2);
            this.setSelectionInterval(n2, n2);
        }
        return true;
    }

    public boolean right() {
        return false;
    }

    public boolean left() {
        return false;
    }

    public boolean pageUp() {
        if (this.supportWrapping() && this.isAtBeginList()) {
            this.end();
        } else {
            int n = this.getSelectedIndex();
            int n2 = this.getFirstVisibleIndex();
            if (n2 == -1) {
                return false;
            }
            Point point = this.indexToLocation(n);
            Point point2 = this.indexToLocation(n2);
            Rectangle rectangle = this.getVisibleRect();
            point.y -= rectangle.height;
            point2.y -= rectangle.height;
            int n3 = Math.max(this.locationToIndex(point), 0);
            int n4 = Math.max(this.locationToIndex(point2), 0);
            this.ensureIndexIsVisible(n4);
            this.ensureIndexIsVisible(n3);
            this.setSelectionInterval(n3, n3);
        }
        return true;
    }

    public boolean pageDown() {
        if (this.supportWrapping() && this.isAtEndList()) {
            this.begin();
        } else {
            int n = this.getSelectedIndex();
            int n2 = this.getLastVisibleIndex();
            if (n2 == -1) {
                return false;
            }
            Point point = this.indexToLocation(n);
            Point point2 = this.indexToLocation(n2);
            Rectangle rectangle = this.getVisibleRect();
            point.y += rectangle.height;
            point2.y += rectangle.height;
            int n3 = this.getModel().getSize() - 1;
            int n4 = this.locationToIndex(point);
            int n5 = this.locationToIndex(point2);
            if (n4 == -1) {
                n4 = n3;
            }
            if (n5 == -1) {
                n5 = n3;
            }
            this.ensureIndexIsVisible(n5);
            this.ensureIndexIsVisible(n4);
            this.setSelectionInterval(n4, n4);
        }
        return true;
    }

    public boolean begin() {
        this.ensureIndexIsVisible(0);
        this.setSelectionInterval(0, 0);
        return true;
    }

    public boolean end() {
        int n = this.getModel().getSize() - 1;
        this.ensureIndexIsVisible(n);
        this.setSelectionInterval(n, n);
        return true;
    }

    public boolean complete(Insight insight) {
        int n = this.getSelectedIndex();
        ListModel listModel = this.getModel();
        if (n < 0 || n >= listModel.getSize()) {
            System.err.println("selected index out of bounds: " + n);
        } else {
            Object e = listModel.getElementAt(n);
            boolean bl = this.insightData.complete(e);
            insight.hideInsight();
            if (bl) {
                insight.restartPopupTimer();
            }
        }
        return true;
    }

    public boolean partialComplete() {
        this.insightData.partialComplete();
        return true;
    }
}

