/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItem;

public class TooltipDataItemCellRenderer
extends DefaultListCellRenderer
implements PrototypeCellProvider {
    public Dimension getPreferredSize() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n = editorProperties.getIntegerProperty("insight-max-popup-width");
        Dimension dimension = this.getToolkit().getScreenSize();
        n = Math.min(dimension.width / 2 - 5, n);
        Dimension dimension2 = super.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.min(n, dimension2.width), dimension2.height);
        return dimension3;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, false, false);
        JLabel jLabel = (JLabel)component;
        if (object instanceof TooltipDataItem) {
            TooltipDataItem tooltipDataItem = (TooltipDataItem)object;
            String string = tooltipDataItem.getDisplayText();
            jLabel.setText(string);
        }
        return jLabel;
    }

    public Object getPrototypeCell(JList jList, ListModel listModel) {
        String string = "";
        int n = 0;
        Font font = jList.getFont();
        FontMetrics fontMetrics = jList.getFontMetrics(font);
        int n2 = listModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            Object e = listModel.getElementAt(n3);
            if (e instanceof TooltipDataItem) {
                TooltipDataItem tooltipDataItem = (TooltipDataItem)e;
                string2 = tooltipDataItem.getDisplayText();
            } else {
                string2 = e.toString();
            }
            int n4 = fontMetrics.stringWidth(string2);
            if (n4 > n) {
                n = n4;
                string = string2;
            }
            ++n3;
        }
        DummyItem dummyItem = new DummyItem(string);
        return dummyItem;
    }

    private static final class DummyItem
    extends TooltipDataItem {
        private String name;

        DummyItem(String string) {
            this.name = string;
        }

        public String getDisplayText() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

