/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.insight;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ListUI;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.PrototypeCellProvider;
import oracle.javatools.editor.insight.TooltipDataItemCellRenderer;
import oracle.javatools.editor.popup.PopupWindow;

public class TooltipInsightView
extends JList
implements InsightView {
    private ListInsightData insightData;
    private PopupWindow popupWindow;

    public TooltipInsightView() {
        this(new TooltipDataItemCellRenderer());
    }

    public TooltipInsightView(ListCellRenderer listCellRenderer) {
        if (listCellRenderer != null) {
            this.setCellRenderer(listCellRenderer);
        }
        this.insightData = null;
        this.setSelectionMode(0);
    }

    public TooltipInsightView(ListInsightData listInsightData) {
        this(listInsightData, null);
    }

    public TooltipInsightView(ListInsightData listInsightData, ListCellRenderer listCellRenderer) {
        super(listInsightData.getListModel());
        this.insightData = listInsightData;
        if (listCellRenderer != null) {
            this.setCellRenderer(listCellRenderer);
        }
        this.setSelectionMode(0);
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
        LookAndFeel.installColorsAndFont(this, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(this, "ToolTip.border");
        EditorProperties editorProperties = EditorProperties.getProperties();
        String string = (String)editorProperties.getProperty("insight-font-family");
        int n = editorProperties.getIntegerProperty("insight-font-size");
        Font font = new Font(string, 0, n);
        this.setFont(font);
    }

    public void setPopupWindow(PopupWindow popupWindow) {
        this.popupWindow = popupWindow;
    }

    public void setData(InsightData insightData) {
        if (insightData instanceof ListInsightData) {
            PrototypeCellProvider prototypeCellProvider;
            Object object;
            this.insightData = (ListInsightData)insightData;
            ListModel listModel = this.insightData.getListModel();
            this.setModel(listModel);
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer instanceof PrototypeCellProvider && (object = (prototypeCellProvider = (PrototypeCellProvider)((Object)listCellRenderer)).getPrototypeCell(this, listModel)) != null) {
                this.setPrototypeCellValue(object);
            }
        } else {
            throw new IllegalArgumentException("newData not ListInsightData.");
        }
    }

    public void selectDefault() {
    }

    public InsightData getData() {
        return this.insightData;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean up() {
        return false;
    }

    public boolean down() {
        return false;
    }

    public boolean right() {
        return false;
    }

    public boolean left() {
        return false;
    }

    public boolean pageUp() {
        return false;
    }

    public boolean pageDown() {
        return false;
    }

    public boolean begin() {
        return false;
    }

    public boolean end() {
        return false;
    }

    public boolean complete(Insight insight) {
        return false;
    }

    public boolean partialComplete() {
        return false;
    }
}

