/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;

public final class KeyHandlerFactory {
    public static final String defaultHandlerName = "Default";
    private static final String[] availableHandlers = new String[]{"Default"};
    private static MultiKeymap defaultKeymap;

    static {
        try {
            KeyHandlerFactory.loadDefaultKeymap();
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Could not load keymap: " + missingResourceException);
            System.exit(1);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Could not load keymap: " + runtimeException);
            System.exit(1);
        }
    }

    public static MultiKeyHandler createHandler(String string) {
        if (string.equals(defaultHandlerName)) {
            return new MultiKeyHandler(defaultKeymap);
        }
        return null;
    }

    public static String[] getAvailableHandlers() {
        return availableHandlers;
    }

    public static MultiKeymap loadKeymap(String string) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        String string2 = resourceBundle.getString("DELIMITER");
        if (string2 == null || string2.length() <= 0) {
            string2 = "|";
        }
        MultiKeymap multiKeymap = new MultiKeymap();
        KeyStroke[] keyStrokeArray = new KeyStroke[5];
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string3;
            StringTokenizer stringTokenizer;
            String string4 = enumeration.nextElement();
            if (string4.equals("DELIMITER") || !(stringTokenizer = new StringTokenizer(string3 = resourceBundle.getString(string4), string2)).hasMoreTokens()) continue;
            String string5 = stringTokenizer.nextToken().trim();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken().trim();
                KeyStroke keyStroke = KeyStroke.getKeyStroke(string6);
                if (keyStroke == null) {
                    throw new IllegalStateException("No keystroke for: " + string5 + " keyname: " + string6);
                }
                if (n >= 5) {
                    throw new IllegalStateException("Too many keys in the sequence (max is 5) for: " + string5 + "=" + string3);
                }
                keyStrokeArray[n++] = keyStroke;
            }
            multiKeymap.put(keyStrokeArray, n, string5);
        }
        return multiKeymap;
    }

    private static void loadDefaultKeymap() throws MissingResourceException {
        defaultKeymap = KeyHandlerFactory.loadKeymap("oracle.javatools.editor.keys.DefaultKeymapping");
    }

    public static void initialize() {
    }
}

