/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.resource.BundleHelper;

public final class KeyRecorder
implements Runnable,
KeyListener,
FocusListener,
ActionHookInvoker {
    private static final int FEEDBACK_LENGTH = 3000;
    private static final String RECORDING_STARTED;
    private static final String RECORDING_CANCELLED;
    private static final String RECORDING_ENDED;
    private static final String PLAYBACK_STARTED;
    private static final String PLAYBACK_CANCELLED;
    private static final String PLAYBACK_ENDED;
    private static final String NOTHING_RECORDED;
    public static final String MACRO_PLAYBACK_DELAY = "macro-playback-delay";
    private MultiKeyHandler keyHandler;
    private boolean shutdown;
    private boolean finished;
    private Thread playbackThread;
    private List macroList;
    private boolean recording;
    private boolean playing;
    private BasicEditorPane editorPane;

    public KeyRecorder() {
        this.$init$();
    }

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        RECORDING_STARTED = bundleHelper.getString("MACRO_RECORDING_STARTED");
        RECORDING_CANCELLED = bundleHelper.getString("MACRO_RECORDING_CANCELLED");
        RECORDING_ENDED = bundleHelper.getString("MACRO_RECORDING_ENDED");
        PLAYBACK_STARTED = bundleHelper.getString("MACRO_PLAYBACK_STARTED");
        PLAYBACK_CANCELLED = bundleHelper.getString("MACRO_PLAYBACK_CANCELLED");
        PLAYBACK_ENDED = bundleHelper.getString("MACRO_PLAYBACK_ENDED");
        NOTHING_RECORDED = bundleHelper.getString("MACRO_NOTHING_RECORDED");
    }

    void $init$() {
        this.keyHandler = null;
        this.shutdown = false;
        this.finished = true;
        this.playbackThread = null;
        this.macroList = null;
        this.recording = false;
        this.playing = false;
        this.editorPane = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private synchronized void install(BasicEditorPane basicEditorPane) {
        this.shutdown = false;
        this.editorPane = basicEditorPane;
        this.recording = false;
        this.playing = false;
        this.finished = true;
        this.playbackThread = null;
        this.keyHandler = MultiKeyHandler.getInstalledHandler(this.editorPane);
        this.keyHandler.addKeyFilter(this);
        basicEditorPane.addFocusListener(this);
    }

    private synchronized void deinstall(BasicEditorPane basicEditorPane) {
        basicEditorPane.removeFocusListener(this);
        this.keyHandler.removeKeyFilter(this);
        this.keyHandler = null;
        this.shutdown = true;
        this.finished = true;
        this.editorPane = null;
        this.recording = false;
        this.playing = false;
        this.playbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void toggleRecording(BasicEditorPane basicEditorPane) {
        if (this.playing) {
            Thread thread = null;
            KeyRecorder keyRecorder = this;
            synchronized (keyRecorder) {
                thread = this.playbackThread;
                this.finished = true;
            }
            if (thread != null) {
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.notify();
                }
            }
            return;
        }
        if (this.recording) {
            if (basicEditorPane != this.editorPane) {
                throw new IllegalStateException("toggle in wrong editor");
            }
            this.showFeedback(this.shutdown ? RECORDING_CANCELLED : RECORDING_ENDED);
            this.deinstall(basicEditorPane);
        } else {
            this.install(basicEditorPane);
            this.recording = true;
            if (this.macroList == null) {
                this.macroList = new ArrayList();
            }
            this.macroList.clear();
            this.showFeedback(RECORDING_STARTED);
        }
    }

    public synchronized void playbackRecording(BasicEditorPane basicEditorPane) {
        if (this.recording) {
            return;
        }
        if (this.playing) {
            return;
        }
        if (this.macroList == null || this.macroList.size() == 0) {
            this.showFeedback(basicEditorPane, NOTHING_RECORDED);
            return;
        }
        this.install(basicEditorPane);
        this.playing = true;
        this.finished = false;
        this.shutdown = false;
        this.showFeedback(PLAYBACK_STARTED);
        this.playbackThread = new Thread((Runnable)this, "Macro Playback Thread");
        this.playbackThread.start();
    }

    private synchronized void handleKeyEvent(KeyEvent keyEvent) {
        if (this.recording) {
            RecordedEvent recordedEvent = new RecordedEvent(keyEvent, null);
            this.macroList.add(recordedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelOperation() {
        if (this.recording) {
            this.shutdown = true;
            this.toggleRecording(this.editorPane);
        } else if (this.playing) {
            Thread thread = null;
            KeyRecorder keyRecorder = this;
            synchronized (keyRecorder) {
                thread = this.playbackThread;
                this.shutdown = true;
                this.finished = true;
            }
            if (thread != null) {
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.notify();
                }
            }
        } else {
            throw new IllegalStateException("nothing to cancel");
        }
    }

    private synchronized void handleFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.cancelOperation();
        }
    }

    private synchronized void showFeedback(String string) {
        this.showFeedback(this.editorPane, string);
    }

    private synchronized void showFeedback(BasicEditorPane basicEditorPane, String string) {
        if (basicEditorPane != null) {
            FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
            feedbackManager.showFeedback(this.editorPane, string, 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = this.playbackThread;
        synchronized (thread) {
            this.sleep(this.playbackThread, 10);
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int n = this.macroList.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.shutdown) break;
                RecordedEvent recordedEvent = (RecordedEvent)this.macroList.get(n2);
                KeyEvent keyEvent = RecordedEvent.mav$getKeyEvent(recordedEvent, this.editorPane);
                eventQueue.postEvent(keyEvent);
                ++n2;
            }
            while (!this.shutdown && !this.finished) {
                this.sleep(this.playbackThread, 1000L);
            }
        }
        String string = this.shutdown ? PLAYBACK_CANCELLED : PLAYBACK_ENDED;
        1 var7_8 = new 1(this, string);
        SwingUtilities.invokeLater(var7_8);
    }

    private void sleep(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean invokeAction(String string) {
        if (string.equals("cancel")) {
            this.cancelOperation();
            return true;
        }
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleFocusEvent(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleFocusEvent(focusEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.handleKeyEvent(keyEvent);
    }

    static void mav$showFeedback(KeyRecorder keyRecorder, String string) {
        keyRecorder.showFeedback(string);
    }

    static BasicEditorPane ra$editorPane(KeyRecorder keyRecorder) {
        return keyRecorder.editorPane;
    }

    static void mav$deinstall(KeyRecorder keyRecorder, BasicEditorPane basicEditorPane) {
        keyRecorder.deinstall(basicEditorPane);
    }

    static void wa$playing(KeyRecorder keyRecorder, boolean bl) {
        keyRecorder.playing = bl;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ String v$message;
        final /* synthetic */ KeyRecorder this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            KeyRecorder keyRecorder = this.this$0;
            synchronized (keyRecorder) {
                KeyRecorder.mav$showFeedback(this.this$0, this.v$message);
                KeyRecorder.mav$deinstall(this.this$0, KeyRecorder.ra$editorPane(this.this$0));
                KeyRecorder.wa$playing(this.this$0, false);
            }
        }

        public 1(KeyRecorder keyRecorder, String string) {
            this.v$message = string;
            this.this$0 = keyRecorder;
        }
    }

    private static final class RecordedEvent {
        int id;
        long when;
        int modifiers;
        int keyCode;
        char keyChar;

        private RecordedEvent(KeyEvent keyEvent) {
            this.id = keyEvent.getID();
            this.when = keyEvent.getWhen();
            this.modifiers = keyEvent.getModifiers();
            this.keyCode = keyEvent.getKeyCode();
            this.keyChar = keyEvent.getKeyChar();
        }

        private KeyEvent getKeyEvent(Component component) {
            return new KeyEvent(component, this.id, System.currentTimeMillis(), this.modifiers, this.keyCode, this.keyChar);
        }

        static KeyEvent mav$getKeyEvent(RecordedEvent recordedEvent, Component component) {
            return recordedEvent.getKeyEvent(component);
        }

        RecordedEvent(KeyEvent keyEvent, 1 var2_2) {
            this(keyEvent);
        }

        public final class 1 {
        }
    }
}

