/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.keys.MultiKeymap;
import oracle.javatools.editor.resource.BundleHelper;

public class MultiKeyHandler
implements FocusListener,
KeyListener {
    private ActionInvoker actionInvoker = null;
    private MultiKeymap multiKeymap;
    private KeyStroke[] partialKeys;
    private int numPartialKeys;
    private Component component = null;
    private char charToEat;
    private int modifierToEat;
    private KeyListener keyFilter;
    private static final String INSTALLED_HANDLER = "*installed-handler*";
    protected static final String ACCELERATOR_PENDING;
    protected static final String ACCELERATOR_UNKNOWN;

    public MultiKeyHandler(MultiKeymap multiKeymap) {
        this.multiKeymap = multiKeymap;
        this.partialKeys = new KeyStroke[10];
        this.numPartialKeys = 0;
        this.charToEat = (char)65535;
    }

    public void install(Component component, ActionInvoker actionInvoker) {
        if (this.component != null) {
            throw new IllegalStateException("cannot install a second time");
        }
        this.component = component;
        this.actionInvoker = actionInvoker;
        component.addKeyListener(this);
        component.addFocusListener(this);
        this.keyFilter = null;
        if (component instanceof BasicEditorPane) {
            BasicEditorPane basicEditorPane = (BasicEditorPane)component;
            basicEditorPane.putProperty(INSTALLED_HANDLER, this);
        }
    }

    public void deinstall() {
        if (this.component == null) {
            throw new IllegalStateException("cannot deinstall, not installed");
        }
        if (this.component instanceof BasicEditorPane) {
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.component;
            basicEditorPane.putProperty(INSTALLED_HANDLER, null);
        }
        this.keyFilter = null;
        if (this.numPartialKeys > 0) {
            this.hideFeedback();
        }
        this.numPartialKeys = 0;
        this.component.removeKeyListener(this);
        this.component.removeFocusListener(this);
        this.component = null;
        this.actionInvoker = null;
    }

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        ACCELERATOR_PENDING = bundleHelper.getString("ACCELERATOR_PENDING");
        ACCELERATOR_UNKNOWN = bundleHelper.getString("ACCELERATOR_UNKNOWN");
    }

    public static MultiKeyHandler getInstalledHandler(BasicEditorPane basicEditorPane) {
        return (MultiKeyHandler)basicEditorPane.getProperty(INSTALLED_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyFilter(KeyListener keyListener) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            this.keyFilter = keyListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyFilter(KeyListener keyListener) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter == keyListener) {
                this.keyFilter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyPressed(keyEvent);
            }
        }
        switch (keyEvent.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return;
            }
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        this.partialKeys[this.numPartialKeys++] = keyStroke;
        String string = this.multiKeymap.get(this.partialKeys, this.numPartialKeys);
        if (string != null) {
            this.consumePressedEvent(keyEvent);
            if (string != "partial") {
                if (this.numPartialKeys > 1) {
                    this.hideFeedback();
                }
                try {
                    this.actionInvoker.invokeAction(string);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Exception invoking action: " + string);
                    runtimeException.printStackTrace();
                }
                this.numPartialKeys = 0;
            } else {
                String string2 = MultiKeyHandler.buildMessage(ACCELERATOR_PENDING, this.partialKeys, this.numPartialKeys);
                this.showFeedback(string2);
            }
        } else {
            if (this.numPartialKeys > 1) {
                this.consumePressedEvent(keyEvent);
                String string3 = MultiKeyHandler.buildMessage(ACCELERATOR_UNKNOWN, this.partialKeys, this.numPartialKeys);
                this.showTemporaryFeedback(string3);
            }
            this.numPartialKeys = 0;
        }
    }

    private void consumePressedEvent(KeyEvent keyEvent) {
        keyEvent.consume();
        this.charToEat = keyEvent.getKeyChar();
        this.modifierToEat = keyEvent.getModifiers();
        if (this.modifierToEat == 1) {
            this.modifierToEat = 0;
        }
        if (this.charToEat == ' ') {
            this.modifierToEat = 0;
        }
        if (this.modifierToEat == 2 && this.charToEat == '[') {
            this.charToEat = (char)27;
        }
    }

    private void eatTypedEvent(KeyEvent keyEvent) {
        if (this.charToEat != '\uffff' && this.charToEat == keyEvent.getKeyChar()) {
            keyEvent.consume();
        }
        this.charToEat = (char)65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyTyped(keyEvent);
            }
        }
        this.eatTypedEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent keyEvent) {
        MultiKeyHandler multiKeyHandler = this;
        synchronized (multiKeyHandler) {
            if (this.keyFilter != null) {
                this.keyFilter.keyReleased(keyEvent);
            }
        }
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorProperties.getBooleanProperty("consume-key-release");
        if (bl) {
            keyEvent.consume();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.numPartialKeys != 0) {
            this.hideFeedback();
        }
        this.numPartialKeys = 0;
    }

    protected static String buildMessage(String string, KeyStroke[] keyStrokeArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(" ");
            MultiKeyHandler.appendKeyText(stringBuffer, keyStrokeArray[n2]);
            ++n2;
        }
        String string2 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(string);
        int n3 = string.indexOf("{0}");
        if (n3 != -1) {
            stringBuffer.replace(n3, n3 + 3, string2);
        }
        return stringBuffer.toString();
    }

    protected static void appendKeyText(StringBuffer stringBuffer, KeyStroke keyStroke) {
        int n;
        String string;
        int n2 = keyStroke.getKeyCode();
        if (n2 == 0) {
            stringBuffer.append("<unknown>");
        }
        if ((string = UIManager.getString("MenuItem.acceleratorDelimiter")) == null || string.length() == 0) {
            string = "+";
        }
        if (((n = keyStroke.getModifiers()) & 4) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuffer.append(string);
        }
        if ((n & 2) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuffer.append(string);
        }
        if ((n & 8) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuffer.append(string);
        }
        if ((n & 1) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuffer.append(string);
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            stringBuffer.append(string);
        }
        stringBuffer.append(KeyEvent.getKeyText(n2));
    }

    protected void showFeedback(String string) {
        BasicEditorPane basicEditorPane;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (basicEditorPane = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.showFeedback(basicEditorPane, string);
        }
    }

    protected void showTemporaryFeedback(String string) {
        BasicEditorPane basicEditorPane;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (basicEditorPane = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.showFeedback(basicEditorPane, string, 4000);
        }
    }

    protected void hideFeedback() {
        BasicEditorPane basicEditorPane;
        FeedbackManager feedbackManager;
        if (this.component instanceof BasicEditorPane && (feedbackManager = (basicEditorPane = (BasicEditorPane)this.component).getFeedbackManager()) != null) {
            feedbackManager.hideFeedback(basicEditorPane);
        }
    }
}

