/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.util.HashMap;
import javax.swing.KeyStroke;

public class MultiKeymap {
    public static final String PARTIAL_MAPPING = "partial";
    private HashMap map = new HashMap(7);
    private MultiKeymap parent = null;

    public void setParent(MultiKeymap multiKeymap) {
        this.parent = multiKeymap;
    }

    public MultiKeymap getParent() {
        return this.parent;
    }

    public void put(KeyStroke keyStroke, String string) {
        Object v = this.map.get(keyStroke);
        if (v != null && v instanceof MultiKeymap) {
            throw new IllegalArgumentException("Partial mapping exists: " + keyStroke);
        }
        this.map.put(keyStroke, string);
    }

    public void put(KeyStroke[] keyStrokeArray, int n, String string) {
        this.put(keyStrokeArray, 0, n, string);
    }

    protected void put(KeyStroke[] keyStrokeArray, int n, int n2, String string) {
        if (n2 == 1) {
            this.put(keyStrokeArray[n], string);
        } else {
            Object object = this.map.get(keyStrokeArray[n]);
            if (object == null) {
                object = new MultiKeymap();
                this.map.put(keyStrokeArray[n], object);
            } else if (!(object instanceof MultiKeymap)) {
                throw new IllegalArgumentException("Full mapping exists: " + n);
            }
            ((MultiKeymap)object).put(keyStrokeArray, n + 1, n2 - 1, string);
        }
    }

    public String get(KeyStroke keyStroke) {
        Object object = this.map.get(keyStroke);
        if (object != null && object instanceof MultiKeymap) {
            return PARTIAL_MAPPING;
        }
        if (object == null && this.parent != null) {
            object = this.parent.get(keyStroke);
        }
        return (String)object;
    }

    public String get(KeyStroke[] keyStrokeArray, int n) {
        String string = this.get(keyStrokeArray, 0, n);
        if (string == null && this.parent != null) {
            string = this.parent.get(keyStrokeArray, n);
        }
        return string;
    }

    protected String get(KeyStroke[] keyStrokeArray, int n, int n2) {
        if (n2 == 1) {
            return this.get(keyStrokeArray[n]);
        }
        Object v = this.map.get(keyStrokeArray[n]);
        if (v != null) {
            if (v instanceof MultiKeymap) {
                return ((MultiKeymap)v).get(keyStrokeArray, n + 1, n2 - 1);
            }
            throw new IllegalArgumentException("State error, count left: " + n2);
        }
        return null;
    }

    public void remove(KeyStroke keyStroke) {
        throw new RuntimeException("Not implemented.");
    }

    public void remove(KeyStroke[] keyStrokeArray, int n) {
        this.remove(keyStrokeArray, 0, n);
    }

    protected void remove(KeyStroke[] keyStrokeArray, int n, int n2) {
        throw new RuntimeException("Not implemented.");
    }

    public void clear() {
        this.map.clear();
    }
}

