/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.lang.ref.SoftReference;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.BraceHelper;

public abstract class AbstractBraceProvider
implements BraceProvider {
    private static final int AVERAGE_TOKEN_SIZE = 8;
    private static final float BRACE_OCCURRENCE = 0.12f;
    private static final int MINIMUM_BRACE_ENTRIES = 20;
    private static final float EXPANSION_FACTOR = 1.25f;
    protected int[] braceArray;
    protected int braceCount;
    private SoftReference braceArrayRef;
    private int bufferChangeId;

    protected abstract TextBuffer getTextBuffer();

    protected abstract BraceHelper getBraceHelper();

    protected abstract Lexer getLexer();

    protected abstract boolean isBraceToken(int var1);

    protected abstract String getBraceCharacters();

    public synchronized int isPartOfBrace(int n, NumberRange numberRange) {
        TextBuffer textBuffer = this.getTextBuffer();
        char c = textBuffer.getChar(n);
        String string = this.getBraceCharacters();
        if (string.indexOf(c) == -1) {
            return -1;
        }
        try {
            this.buildBraceArray();
            int n2 = this.findEntryForOffset(n);
            if (n2 != -1) {
                numberRange.start = this.braceArray[n2];
                numberRange.end = this.braceArray[n2 + 1];
                int n3 = this.braceArray[n2 + 2];
                this.releaseBraceArray();
                return n3;
            }
        }
        finally {
            this.releaseBraceArray();
        }
        return -1;
    }

    public synchronized int findMatchingBrace(int n, NumberRange numberRange, NumberRange numberRange2) {
        int n2;
        BraceHelper braceHelper = this.getBraceHelper();
        TextBuffer textBuffer = this.getTextBuffer();
        int n3 = braceHelper.getBracePairsCount();
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = 0;
            ++n4;
        }
        int n5 = braceHelper.getMatchingBraceIndex(n);
        boolean bl = braceHelper.isOpenIndex(n);
        int n6 = n2 = bl ? n : n5;
        if (n == -1) {
            throw new IllegalStateException("invalid brace type: " + n);
        }
        if (n5 == -1) {
            throw new IllegalStateException("invalid match type: " + n);
        }
        int n7 = numberRange.start;
        if (n7 < 0 || n7 >= textBuffer.getLength()) {
            throw new IllegalStateException("brace not in buffer");
        }
        try {
            this.buildBraceArray();
            int n8 = this.findEntryForOffset(n7);
            if (n8 == -1) {
                int n9 = 3;
                this.releaseBraceArray();
                return n9;
            }
            int n10 = bl ? 3 : -3;
            int n11 = this.braceCount * 3;
            for (int i = n8; i >= 0; i += n10) {
                if (i >= n11) {
                    break;
                }
                int n12 = this.braceArray[i + 2];
                if (n12 == -1) {
                    throw new IllegalStateException("bad check: " + n12);
                }
                int n13 = braceHelper.getMatchingBraceIndex(n12);
                if (n13 == -1) {
                    throw new IllegalStateException("bad match: " + n13);
                }
                if (braceHelper.isOpenIndex(n12)) {
                    int n14 = n12;
                    nArray[n14] = nArray[n14] + 1;
                } else {
                    int n15 = n13;
                    nArray[n15] = nArray[n15] - 1;
                }
                if (nArray[n2] != 0) continue;
                numberRange2.start = this.braceArray[i];
                numberRange2.end = this.braceArray[i + 1];
                int n16 = 0;
                while (n16 < n3) {
                    if (nArray[n16] != 0) {
                        int n17 = 2;
                        this.releaseBraceArray();
                        return n17;
                    }
                    ++n16;
                }
                int n18 = 1;
                this.releaseBraceArray();
                return n18;
            }
        }
        finally {
            this.releaseBraceArray();
        }
        return 3;
    }

    protected int guessBraceCount(int n) {
        return (int)((float)(n / 8) * 0.12f);
    }

    protected int[] expandBraceArray(int[] nArray) {
        int n = nArray.length;
        int n2 = (int)((float)n * 1.25f);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    protected void fillBraceArray() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = textBuffer.getLength();
        Lexer lexer = this.getLexer();
        lexer.setTextBuffer(textBuffer);
        lexer.setPosition(0);
        LexerToken lexerToken = lexer.createLexerToken();
        BraceHelper braceHelper = this.getBraceHelper();
        while (true) {
            int n2;
            int n3 = lexer.lex(lexerToken);
            if (lexerToken.getStartOffset() >= n || n3 == 0) break;
            if (!this.isBraceToken(n3)) continue;
            int n4 = lexerToken.getStartOffset();
            int n5 = lexerToken.getEndOffset();
            int n6 = braceHelper.getBraceIndex(textBuffer, n4, n5);
            if ((n2 = this.braceCount++ * 3) + 2 >= this.braceArray.length) {
                this.braceArray = this.expandBraceArray(this.braceArray);
            }
            this.braceArray[n2++] = n4;
            this.braceArray[n2++] = n5;
            this.braceArray[n2] = n6;
        }
    }

    private void buildBraceArray() {
        TextBuffer textBuffer = this.getTextBuffer();
        if (this.braceArrayRef != null) {
            this.braceArray = (int[])this.braceArrayRef.get();
        }
        if (this.braceArray == null || this.bufferChangeId != textBuffer.getChangeId()) {
            int n = textBuffer.getLength();
            int n2 = Math.max(this.guessBraceCount(n), 20);
            if (this.braceArray == null) {
                this.braceArray = new int[n2 * 3];
            }
            this.bufferChangeId = textBuffer.getChangeId();
            this.braceCount = 0;
            this.fillBraceArray();
            this.braceArrayRef = new SoftReference<int[]>(this.braceArray);
        }
    }

    private void releaseBraceArray() {
        this.braceArray = null;
    }

    private int findEntryForOffset(int n) {
        if (this.braceArray == null || this.braceArray.length == 0 || this.braceCount == 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = this.braceCount * 3;
        if (n < this.braceArray[n2]) {
            return -1;
        }
        if (n >= this.braceArray[n3 - 3 + 1]) {
            return -1;
        }
        while (true) {
            int n4;
            if ((n4 = n3 - n2) <= 3) {
                if (n4 <= 0) {
                    return -1;
                }
                if (n < this.braceArray[n2 + 1]) {
                    return n2;
                }
                return -1;
            }
            int n5 = n3 + n2 >> 1;
            if (n < this.braceArray[n5 = n5 / 3 * 3]) {
                n3 = n5;
                continue;
            }
            n2 = n5;
        }
    }
}

