/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyledFragmentsList;

public abstract class AbstractDocumentRenderer
implements DocumentRenderer {
    private static final boolean DEBUG = false;
    private LanguageSupport support;
    private static int fragListAllocCounter = 0;
    private static final int FRAGLIST_ALLOC_WARNING_LEVEL = 100;
    private static StyledFragmentsList cachedList = null;
    private static String listLock = "fragment-list-lock";

    public AbstractDocumentRenderer(LanguageSupport languageSupport) {
        this.support = languageSupport;
    }

    public final BasicDocument getDocument() {
        BasicDocument basicDocument = this.support.getDocument();
        return basicDocument;
    }

    public final TextBuffer getTextBuffer() {
        BasicDocument basicDocument = this.support.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    public final LineMap getLineMap() {
        BasicDocument basicDocument = this.support.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        return lineMap;
    }

    public StyledFragmentsList renderLines(int n, int n2) {
        if (n > n2) {
            return null;
        }
        StyledFragmentsList styledFragmentsList = this.allocateFragmentsList();
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int n3 = lineMap.getLineStartOffset(n);
        int n4 = lineMap.getLineEndOffset(n2);
        this.renderRegion(styledFragmentsList, n3, n4);
        return styledFragmentsList;
    }

    public abstract void renderRegion(StyledFragmentsList var1, int var2, int var3);

    public void calculateDamage(DocumentEvent documentEvent, NumberRange numberRange) {
        LineMap lineMap = this.getLineMap();
        int n = lineMap.getLineCount();
        numberRange.start = 0;
        numberRange.end = n - 1;
    }

    public void notifyUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recycleFragmentsList(StyledFragmentsList styledFragmentsList) {
        String string = listLock;
        synchronized (string) {
            styledFragmentsList.clear();
            cachedList = styledFragmentsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StyledFragmentsList allocateFragmentsList() {
        StyledFragmentsList styledFragmentsList = null;
        String string = listLock;
        synchronized (string) {
            if (cachedList == null) {
                cachedList = new StyledFragmentsList();
                if (++fragListAllocCounter >= 100) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = editorProperties.getBooleanProperty("check-fraglist-recycling");
                    if (bl) {
                        System.err.println("StyledFragmentsList allocation at: " + fragListAllocCounter);
                    }
                    fragListAllocCounter = 0;
                }
            }
            styledFragmentsList = cachedList;
            cachedList = null;
        }
        return styledFragmentsList;
    }
}

