/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.DefaultWordLocator;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.WordLocator;

public abstract class AbstractLanguageSupport
implements LanguageSupport {
    private BasicDocument document;
    private DocumentRenderer documentRenderer;
    private BraceProvider braceProvider;
    private WordLocator wordLocator;
    private SmartIndentProvider smartIndentProvider;

    public void install(BasicDocument basicDocument) {
        this.document = basicDocument;
        this.documentRenderer = null;
    }

    public void deinstall() {
        this.document = null;
    }

    public final BasicDocument getDocument() {
        return this.document;
    }

    public final Object getProperty(String string) {
        if (string != null) {
            return this.getPropertyImpl(string);
        }
        return null;
    }

    protected Object getPropertyImpl(String string) {
        return null;
    }

    public final DocumentRenderer getDocumentRenderer() {
        if (this.documentRenderer == null) {
            this.documentRenderer = this.createDocumentRenderer();
            if (this.documentRenderer == null) {
                throw new IllegalStateException("Document renderer missing");
            }
        }
        return this.documentRenderer;
    }

    public final BraceProvider getBraceProvider() {
        if (this.braceProvider == null) {
            this.braceProvider = this.createBraceProvider();
        }
        return this.braceProvider;
    }

    public WordLocator getWordLocator() {
        if (this.wordLocator == null) {
            this.wordLocator = this.createWordLocator();
        }
        return this.wordLocator;
    }

    public SmartIndentProvider getSmartIndentProvider() {
        if (this.smartIndentProvider == null) {
            this.smartIndentProvider = this.createSmartIndentProvider();
        }
        return this.smartIndentProvider;
    }

    protected abstract DocumentRenderer createDocumentRenderer();

    protected BraceProvider createBraceProvider() {
        return null;
    }

    protected WordLocator createWordLocator() {
        return new DefaultWordLocator(this);
    }

    protected SmartIndentProvider createSmartIndentProvider() {
        return null;
    }
}

