/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.awt.Color;

public final class BaseStyle {
    private String name;
    private String presentationName;
    private BaseStyle parentStyle;
    private Color fgColor;
    private boolean useParentFG;
    private Color bgColor;
    private boolean useParentBG;
    private int fontStyle;
    private boolean useParentFontStyle;

    BaseStyle(String string, String string2, Color color, Color color2) {
        this.name = string;
        this.presentationName = string2;
        this.parentStyle = null;
        this.fgColor = color;
        this.useParentFG = false;
        this.bgColor = color2;
        this.useParentBG = false;
        this.fontStyle = 0;
        this.useParentFontStyle = false;
    }

    BaseStyle(String string, String string2, BaseStyle baseStyle, boolean bl, Color color, boolean bl2, Color color2, boolean bl3, int n) {
        this.name = string;
        this.presentationName = string2;
        this.parentStyle = baseStyle;
        this.fgColor = color;
        this.useParentFG = bl;
        this.bgColor = color2;
        this.useParentBG = bl2;
        this.fontStyle = n;
        this.useParentFontStyle = bl3;
    }

    public String getName() {
        return this.name;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String toString() {
        return this.presentationName;
    }

    public boolean getHasParent() {
        return this.parentStyle != null;
    }

    public String getParentName() {
        if (this.parentStyle != null) {
            return this.parentStyle.getName();
        }
        return null;
    }

    public Color getForegroundColor() {
        if (this.useParentFG) {
            return this.parentStyle.getForegroundColor();
        }
        return this.fgColor;
    }

    void setForegroundColor(Color color) {
        this.fgColor = color;
    }

    public boolean getUsesParentForegroundColor() {
        return this.useParentFG;
    }

    void setUsesParentForegroundColor(boolean bl) {
        if (this.getHasParent()) {
            this.useParentFG = bl;
        }
    }

    public Color getBackgroundColor() {
        if (this.useParentBG) {
            return this.parentStyle.getBackgroundColor();
        }
        return this.bgColor;
    }

    void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    public boolean getUsesParentBackgroundColor() {
        return this.useParentBG;
    }

    void setUsesParentBackgroundColor(boolean bl) {
        if (this.getHasParent()) {
            this.useParentBG = bl;
        }
    }

    public int getFontStyle() {
        if (this.useParentFontStyle) {
            return this.parentStyle.getFontStyle();
        }
        return this.fontStyle;
    }

    void setFontStyle(int n) {
        if (this.getHasParent()) {
            this.fontStyle = n;
        }
    }

    public boolean getUsesParentFontStyle() {
        return this.useParentFontStyle;
    }

    void setUsesParentFontStyle(boolean bl) {
        if (this.getHasParent()) {
            this.useParentFontStyle = bl;
        }
    }
}

