/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

public final class BooleanBitmap {
    private static final int[] EMPTY_BITMAP = new int[0];
    private static final int[] FILL_HELPER = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int[] bitmap = EMPTY_BITMAP;
    private int userSize;
    private boolean userFill;
    private boolean doInitialize;

    public BooleanBitmap(int n) {
        this.userFill = false;
        this.userSize = 0;
        this.doInitialize = false;
        this.setSize(n);
    }

    public BooleanBitmap(int n, boolean bl) {
        this.userFill = bl;
        this.userSize = 0;
        this.doInitialize = true;
        this.setSize(n);
    }

    public int getSize() {
        return this.userSize;
    }

    public void setSize(int n) {
        if (n > this.userSize) {
            int n2 = this.bitmap.length;
            int n3 = n / 32 + 1;
            if (n2 != n3) {
                int[] nArray = new int[n3];
                System.arraycopy(this.bitmap, 0, nArray, 0, n2);
                if (this.doInitialize && n3 > n2) {
                    int n4 = this.userFill ? -1 : 0;
                    int n5 = n2;
                    while (n5 < n3) {
                        nArray[n5] = n4;
                        ++n5;
                    }
                }
                this.bitmap = nArray;
            }
            this.userSize = n;
        } else if (n < this.userSize) {
            int n6 = this.bitmap.length;
            int n7 = n / 32 + 1;
            if (n6 != n7) {
                int[] nArray = new int[n7];
                System.arraycopy(this.bitmap, 0, nArray, 0, n7);
                this.bitmap = nArray;
            }
            if (this.doInitialize) {
                int n8 = n % 32;
                int n9 = n7 - 1;
                this.bitmap[n9] = this.userFill ? this.bitmap[n9] | ~FILL_HELPER[n8 - 1] : this.bitmap[n9] & FILL_HELPER[n8 - 1];
            }
            this.userSize = n;
        }
    }

    public boolean get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.userSize) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        int n2 = n / 32;
        int n3 = n - n2 * 32;
        int n4 = 1 << n3;
        int n5 = this.bitmap[n2] & n4;
        return n5 != 0;
    }

    public void set(int n, boolean bl) {
        if (n < 0 || n >= this.userSize) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        int n2 = n / 32;
        int n3 = n - n2 * 32;
        int n4 = 1 << n3;
        this.bitmap[n2] = bl ? this.bitmap[n2] | n4 : this.bitmap[n2] & ~n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1];
        int n = this.getSize();
        int n2 = 0;
        while (n2 < n) {
            cArray[0] = this.get(n2) ? 49 : 48;
            stringBuffer.append(cArray);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

