/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class DefaultWordLocator
implements WordLocator {
    private LanguageSupport support;
    private static final int IS_WORD = 1;
    private static final int IS_SYMBOL = 2;
    private static final int IS_SPACE = 3;

    private ReadTextBuffer getTextBuffer() {
        BasicDocument basicDocument = this.support.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    public DefaultWordLocator(LanguageSupport languageSupport) {
        this.support = languageSupport;
    }

    private int getTypeOf(char c) {
        if (Character.isWhitespace(c)) {
            return 3;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return 1;
        }
        return 2;
    }

    public int getWordStart(int n) {
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n2 = readTextBuffer.getLength();
        if (n2 == 0 || n == 0) {
            return 0;
        }
        int n3 = n < n2 ? n + 1 : n;
        char c = readTextBuffer.getChar(n3 - 1);
        int n4 = this.getTypeOf(c);
        switch (n4) {
            case 3: {
                int n5 = n - 1;
                while (n5 >= 0) {
                    c = readTextBuffer.getChar(n5);
                    if (c == '\n' || !Character.isWhitespace(c)) {
                        return n5 + 1;
                    }
                    --n5;
                }
                return n5;
            }
            case 2: {
                return n;
            }
            case 1: {
                int n6 = n - 1;
                while (n6 >= 0) {
                    c = readTextBuffer.getChar(n6);
                    if (!Character.isJavaIdentifierPart(c)) {
                        return n6 + 1;
                    }
                    --n6;
                }
                return n6;
            }
        }
        throw new IllegalStateException("unknown type: " + n4);
    }

    public int getWordEnd(int n) {
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n2 = readTextBuffer.getLength();
        if (n2 == 0 || n == n2) {
            return n2;
        }
        char c = readTextBuffer.getChar(n);
        int n3 = this.getTypeOf(c);
        switch (n3) {
            case 3: {
                int n4 = n;
                while (n4 < n2) {
                    c = readTextBuffer.getChar(n4);
                    if (c == '\n') {
                        return n4 + 1;
                    }
                    if (!Character.isWhitespace(c)) {
                        return n4;
                    }
                    ++n4;
                }
                return n4;
            }
            case 2: {
                return n + 1;
            }
            case 1: {
                int n5 = n;
                while (n5 < n2) {
                    c = readTextBuffer.getChar(n5);
                    if (!Character.isJavaIdentifierPart(c)) {
                        return n5;
                    }
                    ++n5;
                }
                return n5;
            }
        }
        throw new IllegalStateException("unknown type: " + n3);
    }

    /*
     * Unable to fully structure code
     */
    public int getNextWordStart(int var1_1) {
        var2_2 = this.getTextBuffer();
        var3_3 = var2_2.getLength();
        if (var3_3 != 0 && var1_1 != var3_3) ** GOTO lbl7
        return var3_3;
        while (Character.isJavaIdentifierPart(var4_4 = var2_2.getChar(var1_1))) {
            ++var1_1;
lbl7:
            // 2 sources

            if (var1_1 < var3_3) continue;
        }
        while (var1_1 < var3_3) {
            var5_5 = var2_2.getChar(var1_1);
            if (Character.isJavaIdentifierPart(var5_5)) break;
            ++var1_1;
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public int getNextWordEnd(int var1_1) {
        var2_2 = this.getTextBuffer();
        var3_3 = var2_2.getLength();
        if (var3_3 != 0 && var1_1 != var3_3) ** GOTO lbl7
        return var3_3;
        while (!Character.isJavaIdentifierPart(var4_4 = var2_2.getChar(var1_1))) {
            ++var1_1;
lbl7:
            // 2 sources

            if (var1_1 < var3_3) continue;
        }
        while (var1_1 < var3_3) {
            var5_5 = var2_2.getChar(var1_1);
            if (!Character.isJavaIdentifierPart(var5_5)) break;
            ++var1_1;
        }
        return var1_1;
    }

    public int getPreviousWordStart(int n) {
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n2 = readTextBuffer.getLength();
        if (n2 == 0 || n == 0) {
            return 0;
        }
        --n;
        while (n >= 0) {
            char c = readTextBuffer.getChar(n);
            if (Character.isJavaIdentifierPart(c)) break;
            --n;
        }
        while (n >= 0) {
            char c = readTextBuffer.getChar(n);
            if (!Character.isJavaIdentifierPart(c)) {
                return n + 1;
            }
            --n;
        }
        n = Math.max(0, n);
        return n;
    }

    public int getPreviousWordEnd(int n) {
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n2 = readTextBuffer.getLength();
        if (n2 == 0 || n == 0) {
            return 0;
        }
        --n;
        while (n >= 0) {
            char c = readTextBuffer.getChar(n);
            if (!Character.isJavaIdentifierPart(c)) break;
            --n;
        }
        while (n >= 0) {
            char c = readTextBuffer.getChar(n);
            if (Character.isJavaIdentifierPart(c)) {
                return n + 1;
            }
            --n;
        }
        n = Math.max(0, n);
        return n;
    }
}

