/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.AbstractBraceProvider;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.BraceHelper;
import oracle.javatools.parser.generic.GenericLexer;
import oracle.javatools.parser.generic.Language;

public class GenericBraceProvider
extends AbstractBraceProvider
implements BraceProvider {
    protected TextBuffer textBuffer;
    protected BraceHelper braceHelper;
    protected GenericLexer lexer;
    protected LexerToken lexerToken;
    protected String braceCharacters;

    public GenericBraceProvider(LanguageSupport languageSupport, Language language) {
        this(languageSupport, language, new GenericLexer(language));
    }

    public GenericBraceProvider(LanguageSupport languageSupport, Language language, GenericLexer genericLexer) {
        BasicDocument basicDocument = languageSupport.getDocument();
        this.textBuffer = basicDocument.getTextBuffer();
        this.braceHelper = language.getBraceHelper();
        this.lexer = genericLexer;
        this.lexer.setSkipComments(true);
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = language.getBraces();
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            try {
                String[] stringArray2 = stringArray[n2];
                if (stringArray2[0] != null) {
                    stringBuffer.append(stringArray2[0]);
                }
                if (stringArray2[1] != null) {
                    stringBuffer.append(stringArray2[1]);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
        this.braceCharacters = stringBuffer.toString();
    }

    protected TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected BraceHelper getBraceHelper() {
        return this.braceHelper;
    }

    protected Lexer getLexer() {
        return this.lexer;
    }

    protected boolean isBraceToken(int n) {
        return false;
    }

    protected String getBraceCharacters() {
        return this.braceCharacters;
    }
}

