/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;

public final class HistoryReadTextBuffer
implements ReadTextBuffer {
    private static HistoryReadTextBuffer singleton = new HistoryReadTextBuffer();
    private ReadTextBuffer buffer;
    private char[] changedData;
    private int changedOffset;
    private int changedLength;
    private boolean isInsert;

    public static synchronized HistoryReadTextBuffer acquireReadTextBuffer(ReadTextBuffer readTextBuffer, BasicDocumentEvent basicDocumentEvent) {
        HistoryReadTextBuffer historyReadTextBuffer = singleton;
        singleton = null;
        if (historyReadTextBuffer == null) {
            historyReadTextBuffer = new HistoryReadTextBuffer();
        }
        historyReadTextBuffer.setBuffer(readTextBuffer, basicDocumentEvent);
        return historyReadTextBuffer;
    }

    public static synchronized void releaseReadTextBuffer(HistoryReadTextBuffer historyReadTextBuffer) {
        historyReadTextBuffer.clearBuffer();
        if (historyReadTextBuffer != null) {
            singleton = historyReadTextBuffer;
        }
    }

    private HistoryReadTextBuffer() {
    }

    private void setBuffer(ReadTextBuffer readTextBuffer, BasicDocumentEvent basicDocumentEvent) {
        this.isInsert = basicDocumentEvent.getType() == DocumentEvent.EventType.INSERT;
        this.changedLength = basicDocumentEvent.getLength();
        this.changedOffset = basicDocumentEvent.getOffset();
        this.changedData = basicDocumentEvent.getData();
        this.buffer = readTextBuffer;
    }

    private void clearBuffer() {
        this.buffer = null;
        this.changedData = null;
    }

    public int getLength() {
        return this.isInsert ? this.buffer.getLength() - this.changedLength : this.buffer.getLength() + this.changedLength;
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        if (this.isInsert) {
            if (n < this.changedOffset) {
                return this.buffer.getChar(n);
            }
            return this.buffer.getChar(n + this.changedLength);
        }
        if (n < this.changedOffset) {
            return this.buffer.getChar(n);
        }
        if (n < this.changedOffset + this.changedLength) {
            return this.changedData[n - this.changedOffset];
        }
        return this.buffer.getChar(n - this.changedLength);
    }

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        throw new IllegalStateException("not implemented");
    }

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        throw new IllegalStateException("not implemented");
    }

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        throw new IllegalStateException("not implemented");
    }

    public void readLock() {
        this.buffer.readLock();
    }

    public boolean tryReadLock() {
        return this.buffer.tryReadLock();
    }

    public void readUnlock() {
        this.buffer.readUnlock();
    }

    public int getLockStatus() {
        return this.buffer.getLockStatus();
    }
}

