/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.plain.PlainLanguageModule;

public abstract class LanguageModule {
    public static final String FILETYPE_TXT = "txt";
    public static final String FILETYPE_TEXT = "text";
    public static final String FILETYPE_LOG = "log";
    public static final String FILETYPE_JAVA = "java";
    public static final String FILETYPE_JSP = "jsp";
    public static final String FILETYPE_PHP = "php";
    public static final String FILETYPE_PHP3 = "php3";
    public static final String FILETYPE_PHP4 = "php4";
    public static final String FILETYPE_HTML = "html";
    public static final String FILETYPE_HTM = "htm";
    public static final String FILETYPE_SQLJ = "sqlj";
    public static final String FILETYPE_SQL = "sql";
    public static final String FILETYPE_PLS = "pls";
    public static final String FILETYPE_PLSQL = "plsql";
    public static final String FILETYPE_PROPERTIES = "properties";
    public static final String FILETYPE_RTS = "rts";
    public static final String FILETYPE_XML = "xml";
    public static final String FILETYPE_DTD = "dtd";
    public static final String FILETYPE_XSL = "xsl";
    public static final String FILETYPE_IDL = "idl";
    public static final String FILETYPE_C = "c";
    public static final String FILETYPE_CPP2 = "c++";
    public static final String FILETYPE_CPP = "cpp";
    public static final String FILETYPE_CPLUSPLUS = "cplusplus";
    public static final String FILETYPE_CSS = "css";
    public static final String FILETYPE_H = "h";
    public static final String FILETYPE_JS = "js";
    public static final String FILETYPE_DIFF = "diff";
    public static final String FILETYPE_PATCH = "patch";
    private static HashMap fileTypeMap = new HashMap();
    private static HashMap supportClassMap = new HashMap();
    private static List moduleList = new ArrayList();
    private static LanguageModule defaultModule = null;

    static {
        defaultModule = new PlainLanguageModule();
        String[] stringArray = new String[]{"oracle.javatools.editor.language.java.JavaLanguageModule", "oracle.javatools.editor.language.html.HTMLLanguageModule", "oracle.javatools.editor.language.css.CSSLanguageModule", "oracle.javatools.editor.language.jsp.JSPLanguageModule", "oracle.javatools.editor.language.plsql.PLSQLLanguageModule", "oracle.javatools.editor.language.properties.PropertiesLanguageModule", "oracle.javatools.editor.language.idl.IDLLanguageModule", "oracle.javatools.editor.language.cpp.CppLanguageModule", "oracle.javatools.editor.language.diff.DiffLanguageModule"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                Class<?> clazz = Class.forName(stringArray[n2]);
                clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static LanguageSupport createDefaultSupport() {
        return LanguageModule.getDefaultModule().createLanguageSupport();
    }

    public static LanguageModule getDefaultModule() {
        return defaultModule;
    }

    public static LanguageSupport createSupportForFileType(String string) {
        String string2 = LanguageModule.getFileType(string);
        LanguageModule languageModule = LanguageModule.getModuleForFileType(string2);
        LanguageSupport languageSupport = languageModule.createLanguageSupport();
        Class<?> clazz = languageSupport.getClass();
        supportClassMap.put(clazz, string2);
        return languageSupport;
    }

    public static LanguageSupport createSupportForFileType(Class clazz) {
        String string = (String)supportClassMap.get(clazz);
        LanguageModule languageModule = LanguageModule.getModuleForFileType(string);
        return languageModule != null ? languageModule.createLanguageSupport() : null;
    }

    public static BlockRenderer createBlockRendererForFileType(String string, TextBuffer textBuffer) {
        LanguageModule languageModule = LanguageModule.getModuleForFileType(string);
        return languageModule.createBlockRenderer(textBuffer);
    }

    public static LanguageModule getModuleForFileType(String string) {
        String string2 = LanguageModule.getFileType(string);
        LanguageModule languageModule = (LanguageModule)fileTypeMap.get(string2);
        if (languageModule != null) {
            return languageModule;
        }
        int n = moduleList.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            languageModule = (LanguageModule)moduleList.get(n2);
            String[] stringArray = languageModule.getSupportedFileTypes();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = LanguageModule.getFileType(stringArray[n4]);
                if (string2.equals(string3)) {
                    return languageModule;
                }
                ++n4;
            }
            --n2;
        }
        return defaultModule;
    }

    public static void registerModuleForFileType(LanguageModule languageModule, String string) {
        String string2 = LanguageModule.getFileType(string);
        if (string2 != null && string2.length() > 0) {
            fileTypeMap.put(string2, languageModule);
        }
    }

    public static String getFileType(String string) {
        if (string == null) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string.toLowerCase();
        }
        String string2 = string.substring(n + 1);
        return string2.toLowerCase();
    }

    public static StyleRegistry getGlobalStyleRegistry() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        return styleRegistry;
    }

    public void registerModule(LanguageModule languageModule) {
        StyleRegistry styleRegistry = LanguageModule.getGlobalStyleRegistry();
        languageModule.registerStyles(styleRegistry);
        languageModule.initializeModule();
        Class<?> clazz = languageModule.getClass();
        int n = moduleList.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = moduleList.get(n2);
            Class<?> clazz2 = e.getClass();
            if (clazz == clazz2) {
                // empty if block
            }
            ++n2;
        }
        moduleList.add(languageModule);
        String[] stringArray = languageModule.getSupportedFileTypes();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray[n4];
            LanguageModule.registerModuleForFileType(languageModule, string);
            ++n4;
        }
    }

    public static Iterator getLanguageIterator() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(moduleList);
        return arrayList.iterator();
    }

    protected LanguageModule() {
        this.registerModule(this);
    }

    protected void initializeModule() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public abstract String getPresentationName();

    public String toString() {
        return this.getPresentationName();
    }

    public abstract String[] getSupportedFileTypes();

    public abstract String[] getStyleNames();

    public abstract String getContentSample();

    public abstract void registerStyles(StyleRegistry var1);

    public abstract LanguageSupport createLanguageSupport();

    public abstract BlockRenderer createBlockRenderer(TextBuffer var1);
}

