/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerBlockRenderer
implements BlockRenderer {
    protected TextBuffer textBuffer;
    protected Lexer lexer;
    protected LexerToken lexerToken;

    public LexerBlockRenderer(TextBuffer textBuffer) {
        this.textBuffer = textBuffer;
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected abstract Lexer createLexer();

    protected final Lexer getLexer() {
        if (this.lexer == null) {
            this.lexer = this.createLexer();
        }
        return this.lexer;
    }

    protected final LexerToken getLexerToken() {
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.createLexerToken();
        }
        return this.lexerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderBlock(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4) {
        TextBuffer textBuffer = this.getTextBuffer();
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        Lexer lexer2 = lexer;
        synchronized (lexer2) {
            lexer.setTextBuffer(textBuffer);
            lexer.setPosition(n);
            int n5 = n3;
            while (n5 < n4) {
                int n6 = lexer.lex(lexerToken);
                int n7 = lexerToken.getStartOffset();
                int n8 = lexerToken.getEndOffset();
                if (n8 <= n3) continue;
                if (n7 > n5) {
                    int n9 = Math.min(n7, n4);
                    styledFragmentsList.add(this.getDefaultStyleName(), n5, n9);
                }
                this.renderToken(styledFragmentsList, n6, n7, n8, n3, n4);
                n5 = n8;
            }
            lexer.setTextBuffer(null);
        }
    }

    protected void renderToken(StyledFragmentsList styledFragmentsList, int n, int n2, int n3, int n4, int n5) {
        String string = this.mapTokenToStyleName(n);
        if ((n2 = Math.max(n4, n2)) < (n3 = Math.min(n5, n3))) {
            styledFragmentsList.add(string, n2, n3);
        }
    }

    protected abstract String mapTokenToStyleName(int var1);

    protected String getDefaultStyleName() {
        return "base-plain-style";
    }
}

