/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.BooleanBitmap;
import oracle.javatools.editor.language.HistoryReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerDocumentRenderer
extends AbstractDocumentRenderer {
    protected LexerOffsetsCache offsetsCache = null;
    protected BlockRenderer blockRenderer;
    protected Lexer lexer = null;
    protected LexerToken lexerToken = null;

    public LexerDocumentRenderer(LanguageSupport languageSupport) {
        super(languageSupport);
    }

    protected abstract BlockRenderer createBlockRenderer();

    protected final BlockRenderer getBlockRenderer() {
        if (this.blockRenderer == null) {
            this.blockRenderer = this.createBlockRenderer();
        }
        return this.blockRenderer;
    }

    protected abstract Lexer createLexer();

    protected final Lexer getLexer() {
        if (this.lexer == null) {
            this.lexer = this.createLexer();
        }
        return this.lexer;
    }

    protected final LexerToken getLexerToken() {
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.createLexerToken();
        }
        return this.lexerToken;
    }

    public LexerOffsetsCache getOffsetsCache() {
        if (this.offsetsCache == null) {
            this.offsetsCache = new LexerOffsetsCache(this);
        }
        return this.offsetsCache;
    }

    public abstract boolean isMultiLineToken(int var1);

    public void renderRegion(StyledFragmentsList styledFragmentsList, int n, int n2) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        LexerOffsetsCache lexerOffsetsCache = this.getOffsetsCache();
        int n3 = lexerOffsetsCache.findClosestOffset(lexer, lexerToken, n);
        lexer.setTextBuffer(null);
        BlockRenderer blockRenderer = this.getBlockRenderer();
        blockRenderer.renderBlock(styledFragmentsList, n3, n2, n, n2);
    }

    public void calculateDamage(DocumentEvent documentEvent, NumberRange numberRange) {
        int n;
        int n2;
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int n3 = lineMap.getLineCount();
        boolean bl = documentEvent.getType() == DocumentEvent.EventType.INSERT;
        int n4 = documentEvent.getLength();
        int n5 = documentEvent.getOffset();
        int n6 = bl ? n4 + n5 : n5;
        int n7 = bl ? n5 : n4 + n5;
        int n8 = lineMap.getLineFromOffset(n5);
        if (n8 >= n3 - 2) {
            numberRange.start = n8;
            numberRange.end = n3 - 1;
            return;
        }
        int n9 = lineMap.getLineEndOffset(n8);
        int n10 = bl ? n9 - n4 : n9 + n4;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        int n14 = -1;
        int n15 = -1;
        int n16 = 0;
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        int n17 = this.getOffsetsCache().findClosestOffset(lexer, lexerToken, n5);
        HistoryReadTextBuffer historyReadTextBuffer = HistoryReadTextBuffer.acquireReadTextBuffer(textBuffer, (BasicDocumentEvent)documentEvent);
        lexer.setTextBuffer(historyReadTextBuffer);
        lexer.setPosition(n17);
        while ((n2 = lexer.lex(lexerToken)) != 0) {
            int n18 = lexerToken.getStartOffset();
            int n19 = lexerToken.getEndOffset();
            if (n18 < n7 || n19 <= n10) continue;
            n11 = lexerToken.getStartOffset();
            n12 = lexerToken.getEndOffset() - n11;
            n13 = n2;
            break;
        }
        lexer.setTextBuffer(null);
        HistoryReadTextBuffer.releaseReadTextBuffer(historyReadTextBuffer);
        lexer.setTextBuffer(textBuffer);
        lexer.setPosition(n17);
        while ((n = lexer.lex(lexerToken)) != 0) {
            int n20 = lexerToken.getStartOffset();
            int n21 = lexerToken.getEndOffset();
            if (n20 < n6 || n21 <= n9) continue;
            n14 = lexerToken.getStartOffset();
            n15 = lexerToken.getEndOffset() - n14;
            n16 = n;
            break;
        }
        lexer.setTextBuffer(null);
        if (n16 != 0 && n13 != 0) {
            int n22;
            int n23 = n22 = bl ? n11 + n4 : n11 - n4;
            if (n22 == n14 && n12 == n15 && n13 == n16) {
                int n24 = lineMap.getLineFromOffset(n14);
                numberRange.start = n8;
                numberRange.end = Math.max(n8, n24 - 1);
                return;
            }
        }
        numberRange.start = n8;
        numberRange.end = n3 - 1;
    }

    public void notifyUpdate(DocumentEvent documentEvent) {
        if (this.offsetsCache != null) {
            int n = documentEvent.getOffset();
            this.offsetsCache.invalidateOffsets(n);
        }
    }

    public static final class LexerOffsetsCache {
        private BooleanBitmap bitmap;
        private LexerDocumentRenderer documentRenderer;
        private int lastValidatedLine;

        public LexerOffsetsCache(LexerDocumentRenderer lexerDocumentRenderer) {
            this.documentRenderer = lexerDocumentRenderer;
            LineMap lineMap = lexerDocumentRenderer.getLineMap();
            int n = lineMap.getLineCount();
            this.bitmap = new BooleanBitmap(n);
            this.lastValidatedLine = 0;
        }

        public synchronized int findClosestOffset(Lexer lexer, LexerToken lexerToken, int n) {
            int n2 = 0;
            try {
                n2 = this.findClosestOffsetInternal(lexer, lexerToken, n);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Warning: lexer cache exception: " + runtimeException.toString());
                runtimeException.printStackTrace();
                try {
                    this.invalidateOffsets(0);
                    n2 = this.findClosestOffsetInternal(lexer, lexerToken, n);
                }
                catch (RuntimeException runtimeException2) {
                    System.err.println("Warning: lexer cache irrecoverable: " + runtimeException2.toString());
                    runtimeException2.printStackTrace();
                    n2 = 0;
                }
            }
            return n2;
        }

        private int findClosestOffsetInternal(Lexer lexer, LexerToken lexerToken, int n) {
            int n2;
            TextBuffer textBuffer = this.documentRenderer.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int n3 = lineMap.getLineFromOffset(n);
            if (this.lastValidatedLine < n3) {
                int n4;
                for (n4 = this.lastValidatedLine - 1; n4 > 0; --n4) {
                    if (this.bitmap.get(n4)) {
                        continue;
                    }
                    ++n4;
                    break;
                }
                n4 = Math.max(0, n4);
                int n5 = lineMap.getLineStartOffset(n4);
                int n6 = n3 - 1;
                int n7 = lineMap.getLineEndOffset(n6);
                int n8 = n5;
                int n9 = n4;
                lexer.setTextBuffer(textBuffer);
                lexer.setPosition(n5);
                while (n8 < n7) {
                    int n10;
                    int n11;
                    int n12 = lexer.lex(lexerToken);
                    if (n12 == 0) break;
                    int n13 = lexerToken.getStartOffset();
                    int n14 = lexerToken.getEndOffset();
                    if (this.documentRenderer.isMultiLineToken(n12) && (n11 = lineMap.getLineFromOffset(n13)) != (n10 = lineMap.getLineFromOffset(n14))) {
                        this.markBitmap(n9, n11, false);
                        this.markBitmap(n11, n10, true);
                        n9 = n10 + 1;
                    }
                    n8 = n14;
                }
                this.markBitmap(n9, n6, false);
                this.lastValidatedLine = n3;
            }
            for (n2 = n3 - 1; n2 > 0; --n2) {
                if (this.bitmap.get(n2)) {
                    continue;
                }
                ++n2;
                break;
            }
            n2 = Math.max(0, n2);
            int n15 = lineMap.getLineStartOffset(n2);
            return n15;
        }

        public synchronized void invalidateOffsets(int n) {
            LineMap lineMap = this.documentRenderer.getLineMap();
            int n2 = lineMap.getLineFromOffset(n);
            if (this.lastValidatedLine >= n2) {
                this.lastValidatedLine = Math.max(0, n2 - 1);
            }
            int n3 = lineMap.getLineCount();
            this.bitmap.setSize(n3);
        }

        private void markBitmap(int n, int n2, boolean bl) {
            int n3 = n;
            while (n3 < n2) {
                this.bitmap.set(n3, bl);
                ++n3;
            }
        }
    }
}

