/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.WordLocator;

public final class NaturalWordLocator
implements WordLocator {
    private LanguageSupport support;

    private ReadTextBuffer getTextBuffer() {
        BasicDocument basicDocument = this.support.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    public NaturalWordLocator(LanguageSupport languageSupport) {
        this.support = languageSupport;
    }

    private BreakIterator getWordIterator(ReadTextBuffer readTextBuffer) {
        CharacterIterator characterIterator = TextBufferFactory.createCharacterIterator(readTextBuffer);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(characterIterator);
        return breakIterator;
    }

    public int getWordStart(int n) {
        int n2;
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n3 = readTextBuffer.getLength();
        if (n3 == 0 || n == 0) {
            return 0;
        }
        BreakIterator breakIterator = this.getWordIterator(readTextBuffer);
        try {
            if (n == n3) {
                breakIterator.last();
            } else {
                breakIterator.following(n);
            }
            n2 = breakIterator.previous();
            if (n2 == -1) {
                n2 = 0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Got IllegalArgumentException");
            n2 = 0;
        }
        return n2;
    }

    public int getWordEnd(int n) {
        int n2;
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n3 = readTextBuffer.getLength();
        if (n3 == 0 || n == n3) {
            return n3;
        }
        BreakIterator breakIterator = this.getWordIterator(readTextBuffer);
        try {
            n2 = breakIterator.following(n);
            if (n2 == -1) {
                n2 = readTextBuffer.getLength();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Got IllegalArgumentException");
            n2 = readTextBuffer.getLength();
        }
        return n2;
    }

    public int getNextWordStart(int n) {
        int n2;
        block4: {
            ReadTextBuffer readTextBuffer = this.getTextBuffer();
            int n3 = readTextBuffer.getLength();
            if (n3 == 0 || n == n3) {
                return n3;
            }
            BreakIterator breakIterator = this.getWordIterator(readTextBuffer);
            try {
                char c;
                int n4 = n;
                do {
                    if ((n4 = breakIterator.following(n4)) != n3) continue;
                    n2 = n4;
                    break block4;
                } while (Character.isWhitespace(c = readTextBuffer.getChar(n4)));
                n2 = n4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Got IllegalArgumentException");
                n2 = breakIterator.last();
            }
        }
        return n2;
    }

    public int getNextWordEnd(int n) {
        int n2;
        char c;
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n3 = readTextBuffer.getLength();
        if (n3 == 0 || n == n3) {
            return n3;
        }
        int n4 = this.getPreviousWordStart(n);
        boolean bl = false;
        if (n4 == 0 && Character.isWhitespace(c = readTextBuffer.getChar(0))) {
            bl = true;
        }
        if (!bl && (n2 = this.getWordEnd(n4)) > n) {
            return n2;
        }
        int n5 = this.getNextWordStart(n4);
        int n6 = this.getWordEnd(n5);
        return n6;
    }

    public int getPreviousWordStart(int n) {
        int n2;
        block9: {
            ReadTextBuffer readTextBuffer = this.getTextBuffer();
            int n3 = readTextBuffer.getLength();
            if (n3 == 0 || n == 0) {
                return 0;
            }
            BreakIterator breakIterator = this.getWordIterator(readTextBuffer);
            try {
                char c;
                int n4 = n;
                if (n == n3) {
                    breakIterator.last();
                } else {
                    breakIterator.following(n);
                }
                do {
                    if ((n4 = breakIterator.previous()) == 0) {
                        n2 = n4;
                    } else {
                        if (n4 == n) {
                            n4 = breakIterator.previous();
                        }
                        if (n4 != -1) continue;
                        n2 = 0;
                    }
                    break block9;
                } while (Character.isWhitespace(c = readTextBuffer.getChar(n4)));
                n2 = n4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Got IllegalArgumentException");
                n2 = 0;
            }
        }
        return n2;
    }

    public int getPreviousWordEnd(int n) {
        char c;
        char c2;
        ReadTextBuffer readTextBuffer = this.getTextBuffer();
        int n2 = readTextBuffer.getLength();
        if (n2 == 0 || n == 0) {
            return 0;
        }
        int n3 = this.getPreviousWordStart(n);
        if (n3 == 0 && Character.isWhitespace(c2 = readTextBuffer.getChar(0))) {
            return 0;
        }
        int n4 = this.getWordEnd(n3);
        if (n4 < n) {
            return n4;
        }
        int n5 = this.getPreviousWordStart(n3);
        if (n5 == 0 && Character.isWhitespace(c = readTextBuffer.getChar(0))) {
            return 0;
        }
        n4 = this.getWordEnd(n5);
        return n4;
    }
}

