/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageSupport;

public abstract class SmartIndentProvider {
    protected LanguageSupport support;

    protected SmartIndentProvider(LanguageSupport languageSupport) {
        this.support = languageSupport;
    }

    protected final TextBuffer getTextBuffer() {
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        return textBuffer;
    }

    protected final BasicDocument getDocument() {
        BasicDocument basicDocument = this.support.getDocument();
        return basicDocument;
    }

    protected final String getUseSmartIndentPropertyName() {
        return "use-smart-indent";
    }

    public final boolean isSmartIndentEnabled(BasicEditorPane basicEditorPane) {
        String string = this.getUseSmartIndentPropertyName();
        Object object = basicEditorPane.getProperty(string);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean shouldAutoReindentOldLine() {
        return false;
    }

    public boolean shouldAutoIndentNewLine() {
        return true;
    }

    public abstract boolean isAutoReindentTriggerChar(char var1);

    public abstract int getIndentForLine(int var1, int var2);
}

