/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.language.BaseStyle;

public final class StyleRegistry {
    private transient WeakPropertyChangeSupport changeSupport;
    public static final String PROPERTY_STYLE_CHANGED = "style-changed";
    private HashMap registryMap = new HashMap(30);
    private ArrayList registryList = new ArrayList(30);
    private ArrayList pendingList = new ArrayList();

    public StyleRegistry() {
        this.changeSupport = new WeakPropertyChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    private void fireStyleChangedEvent() {
        this.changeSupport.firePropertyChange(PROPERTY_STYLE_CHANGED, Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized Iterator getStyleIterator() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.registryList);
        arrayList.addAll(this.pendingList);
        return arrayList.iterator();
    }

    public synchronized Object clone() {
        StyleRegistry styleRegistry = new StyleRegistry();
        for (BaseStyle baseStyle : this.registryList) {
            if (baseStyle.getHasParent()) {
                styleRegistry.createStyle(baseStyle.getName(), baseStyle.getPresentationName(), baseStyle.getParentName(), baseStyle.getUsesParentForegroundColor(), baseStyle.getForegroundColor(), baseStyle.getUsesParentBackgroundColor(), baseStyle.getBackgroundColor(), baseStyle.getUsesParentFontStyle(), baseStyle.getFontStyle());
                continue;
            }
            styleRegistry.createStyle(baseStyle.getName(), baseStyle.getPresentationName(), baseStyle.getForegroundColor(), baseStyle.getBackgroundColor());
        }
        for (BaseStyle baseStyle : this.pendingList) {
            styleRegistry.modifyStyle(baseStyle.getName(), baseStyle.getUsesParentForegroundColor(), baseStyle.getForegroundColor(), baseStyle.getUsesParentBackgroundColor(), baseStyle.getBackgroundColor(), baseStyle.getUsesParentFontStyle(), baseStyle.getFontStyle());
        }
        return styleRegistry;
    }

    private void addStyle(BaseStyle baseStyle) {
        this.registryMap.put(baseStyle.getName(), baseStyle);
        this.registryList.add(baseStyle);
        BaseStyle baseStyle2 = this.lookupPendingStyle(baseStyle.getName());
        if (baseStyle2 != null) {
            int n = this.pendingList.indexOf(baseStyle2);
            this.pendingList.remove(n);
            this.modifyStyle(baseStyle, baseStyle2.getUsesParentForegroundColor(), baseStyle2.getForegroundColor(), baseStyle2.getUsesParentBackgroundColor(), baseStyle2.getBackgroundColor(), baseStyle2.getUsesParentFontStyle(), baseStyle2.getFontStyle());
        }
    }

    synchronized BaseStyle createStyle(String string, String string2, Color color, Color color2) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle == null) {
            baseStyle = new BaseStyle(string, string2, color, color2);
            this.addStyle(baseStyle);
        }
        return baseStyle;
    }

    public synchronized BaseStyle createStyle(String string, String string2, String string3) {
        return this.createStyle(string, string2, string3, true, null, true, null, true, 0);
    }

    public synchronized BaseStyle createStyle(String string, String string2, String string3, Color color) {
        return this.createStyle(string, string2, string3, false, color, true, null, true, 0);
    }

    public synchronized BaseStyle createStyle(String string, String string2, String string3, int n) {
        return this.createStyle(string, string2, string3, true, null, true, null, false, n);
    }

    public synchronized BaseStyle createStyle(String string, String string2, String string3, Color color, int n) {
        return this.createStyle(string, string2, string3, false, color, true, null, false, n);
    }

    public synchronized BaseStyle createStyle(String string, String string2, String string3, Color color, Color color2, int n) {
        return this.createStyle(string, string2, string3, false, color, false, color2, false, n);
    }

    private BaseStyle createStyle(String string, String string2, String string3, boolean bl, Color color, boolean bl2, Color color2, boolean bl3, int n) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle == null) {
            BaseStyle baseStyle2 = this.lookupStyle(string3);
            if (baseStyle2 == null) {
                throw new IllegalStateException("parent does not exist: " + string3);
            }
            if (bl) {
                color = baseStyle2.getForegroundColor();
            }
            if (bl2) {
                color2 = baseStyle2.getBackgroundColor();
            }
            if (bl3) {
                n = baseStyle2.getFontStyle();
            }
            baseStyle = new BaseStyle(string, string2, baseStyle2, bl, color, bl2, color2, bl3, n);
            this.addStyle(baseStyle);
        }
        return baseStyle;
    }

    public synchronized BaseStyle lookupStyle(String string) {
        BaseStyle baseStyle = (BaseStyle)this.registryMap.get(string);
        return baseStyle;
    }

    private BaseStyle lookupPendingStyle(String string) {
        int n = this.pendingList.size();
        int n2 = 0;
        while (n2 < n) {
            BaseStyle baseStyle = (BaseStyle)this.pendingList.get(n2);
            if (baseStyle.getName().equals(string)) {
                return baseStyle;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void modifyStyleForeground(String string, boolean bl, Color color) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle != null) {
            baseStyle.setForegroundColor(color);
            baseStyle.setUsesParentForegroundColor(bl);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleBackground(String string, boolean bl, Color color) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle != null) {
            baseStyle.setBackgroundColor(color);
            baseStyle.setUsesParentBackgroundColor(bl);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyleFontStyle(String string, boolean bl, int n) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle != null) {
            baseStyle.setFontStyle(n);
            baseStyle.setUsesParentFontStyle(bl);
            this.fireStyleChangedEvent();
        }
    }

    public synchronized void modifyStyle(String string, boolean bl, Color color, boolean bl2, Color color2, boolean bl3, int n) {
        BaseStyle baseStyle = this.lookupStyle(string);
        if (baseStyle != null) {
            this.modifyStyle(baseStyle, bl, color, bl2, color2, bl3, n);
            this.fireStyleChangedEvent();
        } else {
            BaseStyle baseStyle2 = this.lookupPendingStyle(string);
            if (baseStyle2 != null) {
                this.modifyStyle(baseStyle2, bl, color, bl2, color2, bl3, n);
            } else {
                BaseStyle baseStyle3 = this.lookupStyle("base-plain-style");
                baseStyle2 = new BaseStyle(string, "<" + string + ">", baseStyle3, bl, color, bl2, color2, bl3, n);
                this.pendingList.add(baseStyle2);
            }
        }
    }

    private void modifyStyle(BaseStyle baseStyle, boolean bl, Color color, boolean bl2, Color color2, boolean bl3, int n) {
        if (baseStyle != null) {
            baseStyle.setForegroundColor(color);
            baseStyle.setUsesParentForegroundColor(bl);
            baseStyle.setBackgroundColor(color2);
            baseStyle.setUsesParentBackgroundColor(bl2);
            baseStyle.setFontStyle(n);
            baseStyle.setUsesParentFontStyle(bl3);
        }
    }
}

