/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.editor.language.StyledFragment;

public final class StyledFragmentsList {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LIST_SIZE = 64;
    private static final int MAXIMUM_INCREMENT = 100;
    private static final int MINIMUM_INCREMENT = 10;
    private static final float INCREMENT_RATE = 0.1f;
    private String[] tokenStyleNameList;
    private int[] tokenStartList;
    private int lastTokenEnd;
    private int numTokens;
    private int preferredSize;
    private StyledFragment cachedFragment;

    public StyledFragmentsList() {
        this(64);
    }

    public StyledFragmentsList(int n) {
        if (n < 1) {
            n = 1;
        }
        this.tokenStyleNameList = null;
        this.tokenStartList = null;
        this.lastTokenEnd = -1;
        this.numTokens = 0;
        this.preferredSize = n;
        this.cachedFragment = new StyledFragment(null, -1, -1);
        this.ensureCapacity(n);
    }

    private void ensureCapacity(int n) {
        int n2;
        int n3 = n2 = this.tokenStartList == null ? 0 : this.tokenStartList.length;
        if (n2 >= n) {
            return;
        }
        if (this.tokenStyleNameList != null) {
            int n4 = (int)((float)n * 0.1f);
            n4 = Math.min(100, n4);
            n4 = Math.max(10, n4);
            n += n4;
        }
        String[] stringArray = null;
        int[] nArray = null;
        stringArray = new String[n];
        nArray = new int[n];
        if (this.numTokens > 0) {
            System.arraycopy(this.tokenStyleNameList, 0, stringArray, 0, n2);
            System.arraycopy(this.tokenStartList, 0, nArray, 0, n2);
        }
        this.tokenStyleNameList = stringArray;
        this.tokenStartList = nArray;
    }

    public void add(String string, int n, int n2) {
        int n3 = this.numTokens - 1;
        if (this.numTokens > 0 && this.lastTokenEnd != n) {
            throw new IllegalStateException("Fragments not together.");
        }
        if (this.numTokens > 0 && this.tokenStyleNameList[n3] == string) {
            this.lastTokenEnd = n2;
            return;
        }
        this.ensureCapacity(this.numTokens + 1);
        this.tokenStyleNameList[this.numTokens] = string;
        this.tokenStartList[this.numTokens] = n;
        this.lastTokenEnd = n2;
        ++this.numTokens;
    }

    public void clear() {
        this.numTokens = 0;
    }

    public int size() {
        return this.numTokens;
    }

    public StyledFragment get(int n) {
        if (n < 0 || n >= this.numTokens) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n);
        }
        this.cachedFragment.styleName = this.tokenStyleNameList[n];
        this.cachedFragment.startOffset = this.tokenStartList[n];
        this.cachedFragment.endOffset = n + 1 == this.numTokens ? this.lastTokenEnd : this.tokenStartList[n + 1];
        return this.cachedFragment;
    }
}

